/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzabs;
import com.google.android.gms.internal.zzabv;
import com.google.android.gms.internal.zzblt;
import com.google.android.gms.internal.zzblv;
import com.google.android.gms.internal.zzbly;
import com.google.android.gms.internal.zzbma;
import com.google.android.gms.internal.zzbmc;
import com.google.android.gms.internal.zzbmd;
import com.google.android.gms.internal.zzbmj;
import com.google.android.gms.internal.zzbmp;
import com.google.android.gms.internal.zzbmx;
import com.google.android.gms.internal.zzbmz;
import com.google.android.gms.internal.zzbna;
import com.google.android.gms.internal.zzbnb;
import com.google.android.gms.internal.zzbnc;
import com.google.android.gms.internal.zzbnd;
import com.google.android.gms.internal.zzbnf;
import com.google.android.gms.internal.zzbng;
import com.google.android.gms.internal.zzbnh;
import com.google.android.gms.internal.zzbni;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import java.util.ArrayList;
import java.util.List;

public class zzbls
extends com.google.android.gms.common.api.zzc<zzbma.zza> {
    zzbls(@NonNull Context context, @NonNull zzbma.zza zza2) {
        super(context, zzbma.zzbYg, (Api.ApiOptions)zza2, (zzabs)new com.google.firebase.zza());
    }

    public Task<GetTokenResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzbmz zzbmz2) {
        return this.doRead(this.zza(new zzg(string).zze(firebaseApp).zze(firebaseUser).zzad(zzbmz2)));
    }

    public Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull zzbmz zzbmz2) {
        return this.doWrite(this.zza(new zzr(string).zze(firebaseApp).zzad(zzbmz2)));
    }

    public Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull AuthCredential authCredential, @NonNull zzbmz zzbmz2) {
        return this.doWrite(this.zza(new zzq(authCredential).zze(firebaseApp).zzad(zzbmz2)));
    }

    public Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential, @NonNull zzbmz zzbmz2) {
        return this.doWrite(this.zza(new zzk(authCredential).zze(firebaseApp).zze(firebaseUser).zzad(zzbmz2)));
    }

    public Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull zzbmz zzbmz2) {
        return this.doWrite(this.zza(new zzp().zze(firebaseApp).zzad(zzbmz2)));
    }

    public Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest, @NonNull zzbmz zzbmz2) {
        return this.doWrite(this.zza(new zzx(userProfileChangeRequest).zze(firebaseApp).zze(firebaseUser).zzad(zzbmz2)));
    }

    public Task<Void> zzb(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzbmz zzbmz2) {
        return this.doWrite(this.zza(new zzv(string).zze(firebaseApp).zze(firebaseUser).zzad(zzbmz2)));
    }

    public Task<Void> zzc(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzbmz zzbmz2) {
        return this.doWrite(this.zza(new zzw(string).zze(firebaseApp).zze(firebaseUser).zzad(zzbmz2)));
    }

    public Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull String string2, @NonNull zzbmz zzbmz2) {
        return this.doWrite(this.zza(new zzd(string, string2).zze(firebaseApp).zzad(zzbmz2)));
    }

    public Task<AuthResult> zzb(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull String string2, @NonNull zzbmz zzbmz2) {
        return this.doWrite(this.zza(new zzs(string, string2).zze(firebaseApp).zzad(zzbmz2)));
    }

    public Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull String string2, @NonNull zzbmz zzbmz2) {
        return this.doWrite(this.zza(new zzl(string, string2).zze(firebaseApp).zze(firebaseUser).zzad(zzbmz2)));
    }

    public Task<ProviderQueryResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.doRead(this.zza(new zzf(string).zze(firebaseApp)));
    }

    public Task<Void> zzb(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.doWrite(this.zza(new zzo(string).zze(firebaseApp)));
    }

    public Task<Void> zzc(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.doWrite(this.zza(new zzn(string).zze(firebaseApp)));
    }

    public Task<ActionCodeResult> zzd(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.doWrite(this.zza(new zzb(string).zze(firebaseApp)));
    }

    public Task<Void> zze(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.doWrite(this.zza(new zza(string).zze(firebaseApp)));
    }

    public Task<String> zzf(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.doWrite(this.zza(new zzy(string).zze(firebaseApp)));
    }

    public Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull String string2) {
        return this.doWrite(this.zza(new zzc(string, string2).zze(firebaseApp)));
    }

    public Task<AuthResult> zzb(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential, @NonNull zzbmz zzbmz2) {
        zzac.zzw((Object)firebaseApp);
        zzac.zzw((Object)authCredential);
        zzac.zzw((Object)firebaseUser);
        zzac.zzw((Object)zzbmz2);
        if (EmailAuthCredential.class.isAssignableFrom(authCredential.getClass())) {
            return this.zza(firebaseApp, (EmailAuthCredential)authCredential, firebaseUser, zzbmz2);
        }
        return this.zza(firebaseApp, authCredential, firebaseUser, zzbmz2);
    }

    @NonNull
    private Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull EmailAuthCredential emailAuthCredential, @NonNull FirebaseUser firebaseUser, @NonNull zzbmz zzbmz2) {
        return this.doWrite(this.zza(new zzh(emailAuthCredential).zze(firebaseApp).zze(firebaseUser).zzad(zzbmz2)));
    }

    @NonNull
    private Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull AuthCredential authCredential, @NonNull FirebaseUser firebaseUser, @NonNull zzbmz zzbmz2) {
        zzac.zzw((Object)firebaseApp);
        zzac.zzw((Object)authCredential);
        zzac.zzw((Object)firebaseUser);
        zzac.zzw((Object)zzbmz2);
        List<String> list = firebaseUser.getProviders();
        if (list != null && list.contains(authCredential.getProvider())) {
            return Tasks.forException((Exception)zzblv.zzce(new Status(17015)));
        }
        return this.doWrite(this.zza(new zzi(authCredential).zze(firebaseApp).zze(firebaseUser).zzad(zzbmz2)));
    }

    public Task<AuthResult> zzd(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzbmz zzbmz2) {
        zzac.zzw((Object)firebaseApp);
        zzac.zzdr((String)string);
        zzac.zzw((Object)firebaseUser);
        zzac.zzw((Object)zzbmz2);
        List<String> list = firebaseUser.getProviders();
        if (list != null && !list.contains(string) || firebaseUser.isAnonymous()) {
            return Tasks.forException((Exception)zzblv.zzce(new Status(17016, string)));
        }
        switch (string) {
            case "password": {
                return this.zza(firebaseApp, firebaseUser, zzbmz2);
            }
        }
        return this.zza(firebaseApp, string, firebaseUser, zzbmz2);
    }

    @NonNull
    private Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull zzbmz zzbmz2) {
        return this.doWrite(this.zza(new zzt().zze(firebaseApp).zze(firebaseUser).zzad(zzbmz2)));
    }

    @NonNull
    private Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull FirebaseUser firebaseUser, @NonNull zzbmz zzbmz2) {
        return this.doWrite(this.zza(new zzu(string).zze(firebaseApp).zze(firebaseUser).zzad(zzbmz2)));
    }

    @NonNull
    public Task<Void> zzb(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull zzbmz zzbmz2) {
        return this.doRead(this.zza(new zzm().zze(firebaseApp).zze(firebaseUser).zzad(zzbmz2)));
    }

    @NonNull
    public Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull zzbni zzbni2) {
        return this.doWrite(this.zza(new zze().zze(firebaseUser).zzad(zzbni2)));
    }

    @NonNull
    private static zzbnf zza(@NonNull FirebaseApp firebaseApp, @NonNull zzbmj zzbmj2) {
        return zzbls.zza(firebaseApp, zzbmj2, false);
    }

    @NonNull
    private static zzbnf zza(@NonNull FirebaseApp firebaseApp, @NonNull zzbmj zzbmj2, boolean bl) {
        zzac.zzw((Object)firebaseApp);
        zzac.zzw((Object)((Object)zzbmj2));
        ArrayList<zzbnd> arrayList = new ArrayList<zzbnd>();
        zzbnd zzbnd2 = new zzbnd(zzbmj2, "firebase");
        arrayList.add(zzbnd2);
        List<zzbmp> list = zzbmj2.zzVZ();
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add(new zzbnd(list.get(i)));
            }
        }
        zzbnf zzbnf2 = new zzbnf(firebaseApp, arrayList);
        zzbnf2.zzaY(bl);
        return zzbnf2;
    }

    private <ResultT, CallbackT> zzj<ResultT, CallbackT> zza(zzbmd<ResultT, CallbackT> zzbmd2) {
        return new zzj<ResultT, CallbackT>(zzbmd2);
    }

    private static class zzj<ResultT, CallbackT>
    extends zzabv<zzblt, ResultT>
    implements zzbmc<ResultT> {
        private zzbmd<ResultT, CallbackT> zzbXZ;
        private TaskCompletionSource<ResultT> zzazE;

        public zzj(zzbmd<ResultT, CallbackT> zzbmd2) {
            this.zzbXZ = zzbmd2;
            this.zzbXZ.zza(this);
        }

        protected void zza(zzblt zzblt2, TaskCompletionSource<ResultT> taskCompletionSource) throws RemoteException {
            this.zzazE = taskCompletionSource;
            this.zzbXZ.zza(zzblt2.zzVP());
        }

        @Override
        public final void zza(ResultT ResultT, Status status) {
            zzac.zzb(this.zzazE, (Object)"doExecute must be called before onComplete");
            if (status != null) {
                this.zzazE.setException((Exception)zzblv.zzce(status));
            } else {
                this.zzazE.setResult(ResultT);
            }
        }
    }

    static final class zze
    extends zzbmd<Void, zzbni> {
        public zze() {
            super(5);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYk.zzg(this.zzbYj.zzVH(), this.zzbYi);
        }

        @Override
        public void zzVO() {
            ((zzbni)this.zzbYl).zzVE();
            this.zzae(null);
        }
    }

    static final class zzm
    extends zzbmd<Void, zzbmz> {
        public zzm() {
            super(2);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYk.zzf(this.zzbYj.zzVH(), this.zzbYi);
        }

        @Override
        public void zzVO() {
            zzbnf zzbnf2 = zzbls.zza(this.zzbXF, this.zzbYo, this.zzbYj.isAnonymous());
            ((zzbmz)this.zzbYl).zza(this.zzbYn, zzbnf2);
            this.zzae(null);
        }
    }

    static final class zzu
    extends zzbmd<AuthResult, zzbmz> {
        @NonNull
        private String zzbYa;

        public zzu(@NonNull String string) {
            super(2);
            this.zzbYa = zzac.zzh((String)string, (Object)"provider cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYk.zze(this.zzbYa, this.zzbYj.zzVH(), this.zzbYi);
        }

        @Override
        public void zzVO() {
            zzbnf zzbnf2 = zzbls.zza(this.zzbXF, this.zzbYo);
            ((zzbmz)this.zzbYl).zza(this.zzbYn, zzbnf2);
            this.zzae(new zzbnc(zzbnf2));
        }
    }

    static final class zzt
    extends zzbmd<AuthResult, zzbmz> {
        public zzt() {
            super(2);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYk.zze(this.zzbYj.zzVH(), this.zzbYi);
        }

        @Override
        public void zzVO() {
            zzbnf zzbnf2 = zzbls.zza(this.zzbXF, this.zzbYo);
            ((zzbmz)this.zzbYl).zza(this.zzbYn, zzbnf2);
            this.zzae(new zzbnc(zzbnf2));
        }
    }

    static final class zzi
    extends zzbmd<AuthResult, zzbmz> {
        @NonNull
        private final zzbmx zzbXY;

        public zzi(@NonNull AuthCredential authCredential) {
            super(2);
            zzac.zzb((Object)authCredential, (Object)"credential cannot be null");
            this.zzbXY = zzbna.zza(authCredential);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYk.zza(this.zzbYj.zzVH(), this.zzbXY, (zzbly)this.zzbYi);
        }

        @Override
        public void zzVO() {
            zzbnf zzbnf2 = zzbls.zza(this.zzbXF, this.zzbYo);
            ((zzbmz)this.zzbYl).zza(this.zzbYn, zzbnf2);
            this.zzae(new zzbnc(zzbnf2));
        }
    }

    static final class zzh
    extends zzbmd<AuthResult, zzbmz> {
        @NonNull
        private final EmailAuthCredential zzbXX;

        public zzh(@NonNull EmailAuthCredential emailAuthCredential) {
            super(2);
            this.zzbXX = (EmailAuthCredential)zzac.zzb((Object)emailAuthCredential, (Object)"credential cannot be null");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYk.zza(this.zzbXX.getEmail(), this.zzbXX.getPassword(), this.zzbYj.zzVH(), this.zzbYi);
        }

        @Override
        public void zzVO() {
            zzbnf zzbnf2 = zzbls.zza(this.zzbXF, this.zzbYo);
            ((zzbmz)this.zzbYl).zza(this.zzbYn, zzbnf2);
            this.zzae(new zzbnc(zzbnf2));
        }
    }

    static final class zzc
    extends zzbmd<Void, zzbmz> {
        @NonNull
        private final String zzaZU;
        @NonNull
        private final String zzbXV;

        public zzc(@NonNull String string, @NonNull String string2) {
            super(4);
            this.zzaZU = zzac.zzh((String)string, (Object)"code cannot be null or empty");
            this.zzbXV = zzac.zzh((String)string2, (Object)"new password cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYk.zzf(this.zzaZU, this.zzbXV, this.zzbYi);
        }

        @Override
        public void zzVO() {
            this.zzVU();
        }
    }

    static final class zzy
    extends zzbmd<String, zzbmz> {
        @NonNull
        private final String zzaZU;

        public zzy(@NonNull String string) {
            super(4);
            this.zzaZU = zzac.zzh((String)string, (Object)"code cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYk.zzi(this.zzaZU, this.zzbYi);
        }

        @Override
        public void zzVO() {
            zzbnb zzbnb2 = new zzbnb(this.zzbYq);
            if (0 != zzbnb2.getOperation()) {
                this.zzcf(new Status(17499));
            } else {
                this.zzae(this.zzbYq.getEmail());
            }
        }
    }

    static final class zza
    extends zzbmd<Void, zzbmz> {
        @NonNull
        private final String zzaZU;

        public zza(@NonNull String string) {
            super(7);
            this.zzaZU = zzac.zzh((String)string, (Object)"code cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYk.zzj(this.zzaZU, this.zzbYi);
        }

        @Override
        public void zzVO() {
            this.zzVU();
        }
    }

    static final class zzb
    extends zzbmd<ActionCodeResult, zzbmz> {
        @NonNull
        private final String zzaZU;

        public zzb(@NonNull String string) {
            super(4);
            this.zzaZU = zzac.zzh((String)string, (Object)"code cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYk.zzi(this.zzaZU, this.zzbYi);
        }

        @Override
        public void zzVO() {
            this.zzae(new zzbnb(this.zzbYq));
        }
    }

    static final class zzn
    extends zzbmd<Void, zzbmz> {
        @NonNull
        private String zzaiJ;

        public zzn(@NonNull String string) {
            super(6);
            this.zzaiJ = zzac.zzh((String)string, (Object)"token cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYk.zzh(this.zzaiJ, this.zzbYi);
        }

        @Override
        public void zzVO() {
            this.zzVU();
        }
    }

    static final class zzo
    extends zzbmd<Void, zzbmz> {
        @NonNull
        private String zzaka;

        public zzo(@NonNull String string) {
            super(4);
            this.zzaka = zzac.zzh((String)string, (Object)"email cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYk.zzd(this.zzaka, this.zzbYi);
        }

        @Override
        public void zzVO() {
            this.zzVU();
        }
    }

    static final class zzf
    extends zzbmd<ProviderQueryResult, zzbmz> {
        @NonNull
        private final String zzaka;

        public zzf(@NonNull String string) {
            super(3);
            this.zzaka = zzac.zzh((String)string, (Object)"email cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYk.zzc(this.zzaka, this.zzbYi);
        }

        @Override
        public void zzVO() {
            this.zzae(new zzbng(this.zzbYp));
        }
    }

    static final class zzl
    extends zzbmd<Void, zzbmz> {
        @NonNull
        private final String zzaka;
        @NonNull
        private final String zzajh;

        public zzl(@NonNull String string, @NonNull String string2) {
            super(2);
            this.zzaka = zzac.zzh((String)string, (Object)"email cannot be null or empty");
            this.zzajh = zzac.zzh((String)string2, (Object)"password cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYk.zzd(this.zzaka, this.zzajh, this.zzbYi);
        }

        @Override
        public void zzVO() {
            zzbnf zzbnf2 = zzbls.zza(this.zzbXF, this.zzbYo);
            if (this.zzbYj.getUid().equalsIgnoreCase(zzbnf2.getUid())) {
                ((zzbmz)this.zzbYl).zza(this.zzbYn, zzbnf2);
                this.zzVU();
            } else {
                this.zzcf(zzbnh.zzWr());
            }
        }
    }

    static final class zzs
    extends zzbmd<AuthResult, zzbmz> {
        @NonNull
        private String zzaka;
        @NonNull
        private String zzajh;

        public zzs(String string, String string2) {
            super(2);
            this.zzaka = zzac.zzh((String)string, (Object)"email cannot be null or empty");
            this.zzajh = zzac.zzh((String)string2, (Object)"password cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYk.zzd(this.zzaka, this.zzajh, this.zzbYi);
        }

        @Override
        public void zzVO() {
            zzbnf zzbnf2 = zzbls.zza(this.zzbXF, this.zzbYo);
            ((zzbmz)this.zzbYl).zza(this.zzbYn, zzbnf2);
            this.zzae(new zzbnc(zzbnf2));
        }
    }

    static final class zzd
    extends zzbmd<AuthResult, zzbmz> {
        @NonNull
        private String zzaka;
        @NonNull
        private String zzajh;

        public zzd(@NonNull String string, @NonNull String string2) {
            super(2);
            this.zzaka = zzac.zzh((String)string, (Object)"email cannot be null or empty");
            this.zzajh = zzac.zzh((String)string2, (Object)"password cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYk.zzc(this.zzaka, this.zzajh, this.zzbYi);
        }

        @Override
        public void zzVO() {
            zzbnf zzbnf2 = zzbls.zza(this.zzbXF, this.zzbYo);
            ((zzbmz)this.zzbYl).zza(this.zzbYn, zzbnf2);
            this.zzae(new zzbnc(zzbnf2));
        }
    }

    static final class zzw
    extends zzbmd<Void, zzbmz> {
        @NonNull
        private final String zzajh;

        public zzw(@NonNull String string) {
            super(2);
            this.zzajh = zzac.zzh((String)string, (Object)"password cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYk.zzb(this.zzbYj.zzVH(), this.zzajh, this.zzbYi);
        }

        @Override
        public void zzVO() {
            ((zzbmz)this.zzbYl).zza(this.zzbYn, zzbls.zza(this.zzbXF, this.zzbYo));
            this.zzVU();
        }
    }

    static final class zzv
    extends zzbmd<Void, zzbmz> {
        @NonNull
        private final String zzaka;

        public zzv(String string) {
            super(2);
            this.zzaka = zzac.zzh((String)string, (Object)"email cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYk.zza(this.zzbYj.zzVH(), this.zzaka, (zzbly)this.zzbYi);
        }

        @Override
        public void zzVO() {
            ((zzbmz)this.zzbYl).zza(this.zzbYn, zzbls.zza(this.zzbXF, this.zzbYo));
            this.zzVU();
        }
    }

    static final class zzx
    extends zzbmd<Void, zzbmz> {
        @NonNull
        private final UserProfileChangeRequest zzbYb;

        public zzx(UserProfileChangeRequest userProfileChangeRequest) {
            super(2);
            this.zzbYb = (UserProfileChangeRequest)((Object)zzac.zzb((Object)((Object)userProfileChangeRequest), (Object)"request cannot be null"));
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYk.zza(this.zzbYj.zzVH(), this.zzbYb, (zzbly)this.zzbYi);
        }

        @Override
        public void zzVO() {
            ((zzbmz)this.zzbYl).zza(this.zzbYn, zzbls.zza(this.zzbXF, this.zzbYo));
            this.zzVU();
        }
    }

    static final class zzp
    extends zzbmd<AuthResult, zzbmz> {
        public zzp() {
            super(2);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYk.zza(this.zzbYi);
        }

        @Override
        public void zzVO() {
            zzbnf zzbnf2 = zzbls.zza(this.zzbXF, this.zzbYo, true);
            ((zzbmz)this.zzbYl).zza(this.zzbYn, zzbnf2);
            this.zzae(new zzbnc(zzbnf2));
        }
    }

    static final class zzk
    extends zzbmd<Void, zzbmz> {
        @NonNull
        private final zzbmx zzbXY;

        public zzk(@NonNull AuthCredential authCredential) {
            super(2);
            zzac.zzb((Object)authCredential, (Object)"credential cannot be null");
            this.zzbXY = zzbna.zza(authCredential);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYk.zza(this.zzbXY, (zzbly)this.zzbYi);
        }

        @Override
        public void zzVO() {
            zzbnf zzbnf2 = zzbls.zza(this.zzbXF, this.zzbYo);
            if (this.zzbYj.getUid().equalsIgnoreCase(zzbnf2.getUid())) {
                ((zzbmz)this.zzbYl).zza(this.zzbYn, zzbnf2);
                this.zzVU();
            } else {
                this.zzcf(zzbnh.zzWr());
            }
        }
    }

    static final class zzq
    extends zzbmd<AuthResult, zzbmz> {
        @NonNull
        private final zzbmx zzbXY;

        public zzq(@NonNull AuthCredential authCredential) {
            super(2);
            zzac.zzb((Object)authCredential, (Object)"credential cannot be null");
            this.zzbXY = zzbna.zza(authCredential);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYk.zza(this.zzbXY, (zzbly)this.zzbYi);
        }

        @Override
        public void zzVO() {
            zzbnf zzbnf2 = zzbls.zza(this.zzbXF, this.zzbYo);
            ((zzbmz)this.zzbYl).zza(this.zzbYn, zzbnf2);
            this.zzae(new zzbnc(zzbnf2));
        }
    }

    static final class zzr
    extends zzbmd<AuthResult, zzbmz> {
        @NonNull
        private final String zzaiJ;

        public zzr(@NonNull String string) {
            super(2);
            this.zzaiJ = zzac.zzh((String)string, (Object)"token cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYk.zzb(this.zzaiJ, this.zzbYi);
        }

        @Override
        public void zzVO() {
            zzbnf zzbnf2 = zzbls.zza(this.zzbXF, this.zzbYo);
            ((zzbmz)this.zzbYl).zza(this.zzbYn, zzbnf2);
            this.zzae(new zzbnc(zzbnf2));
        }
    }

    static final class zzg
    extends zzbmd<GetTokenResult, zzbmz> {
        @NonNull
        private final String zzbXW;

        public zzg(@NonNull String string) {
            super(1);
            this.zzbXW = zzac.zzh((String)string, (Object)"refresh token cannot be null");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYk.zza(this.zzbXW, (zzbly)this.zzbYi);
        }

        @Override
        public void zzVO() {
            this.zzbYn.zziy(this.zzbXW);
            ((zzbmz)this.zzbYl).zza(this.zzbYn, this.zzbYj);
            this.zzae(new GetTokenResult(this.zzbYn.getAccessToken()));
        }
    }
}

