/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzbvc;
import com.google.android.gms.internal.zzbvh;
import com.google.android.gms.internal.zzbwe;
import com.google.android.gms.internal.zzbwf;
import com.google.android.gms.internal.zzbwi;
import com.google.android.gms.internal.zzbww;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class zzbwa {
    private final Map<Type, zzbvc<?>> zzcri;

    public zzbwa(Map<Type, zzbvc<?>> map) {
        this.zzcri = map;
    }

    public <T> zzbwf<T> zzb(zzbww<T> zzbww2) {
        final Type type = zzbww2.zzaez();
        Class<T> clazz = zzbww2.zzaey();
        final zzbvc<?> zzbvc2 = this.zzcri.get(type);
        if (zzbvc2 != null) {
            return new zzbwf<T>(){

                @Override
                public T zzaeg() {
                    return zzbvc2.zza(type);
                }
            };
        }
        final zzbvc<?> zzbvc3 = this.zzcri.get(clazz);
        if (zzbvc3 != null) {
            return new zzbwf<T>(){

                @Override
                public T zzaeg() {
                    return zzbvc3.zza(type);
                }
            };
        }
        zzbwf<T> zzbwf2 = this.zzk(clazz);
        if (zzbwf2 != null) {
            return zzbwf2;
        }
        zzbwf<T> zzbwf3 = this.zzc(type, clazz);
        if (zzbwf3 != null) {
            return zzbwf3;
        }
        return this.zzd(type, clazz);
    }

    private <T> zzbwf<T> zzk(Class<? super T> clazz) {
        try {
            final Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return new zzbwf<T>(){

                @Override
                public T zzaeg() {
                    try {
                        return constructor.newInstance(null);
                    }
                    catch (InstantiationException instantiationException) {
                        String string = String.valueOf(constructor);
                        throw new RuntimeException(new StringBuilder(30 + String.valueOf(string).length()).append("Failed to invoke ").append(string).append(" with no args").toString(), instantiationException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        String string = String.valueOf(constructor);
                        throw new RuntimeException(new StringBuilder(30 + String.valueOf(string).length()).append("Failed to invoke ").append(string).append(" with no args").toString(), invocationTargetException.getTargetException());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new AssertionError((Object)illegalAccessException);
                    }
                }
            };
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private <T> zzbwf<T> zzc(final Type type, Class<? super T> clazz) {
        if (Collection.class.isAssignableFrom(clazz)) {
            if (SortedSet.class.isAssignableFrom(clazz)) {
                return new zzbwf<T>(){

                    @Override
                    public T zzaeg() {
                        return new TreeSet();
                    }
                };
            }
            if (EnumSet.class.isAssignableFrom(clazz)) {
                return new zzbwf<T>(){

                    @Override
                    public T zzaeg() {
                        if (type instanceof ParameterizedType) {
                            Type type2 = ((ParameterizedType)type).getActualTypeArguments()[0];
                            if (type2 instanceof Class) {
                                return EnumSet.noneOf((Class)type2);
                            }
                            String string = String.valueOf(type.toString());
                            throw new zzbvh(string.length() != 0 ? "Invalid EnumSet type: ".concat(string) : new String("Invalid EnumSet type: "));
                        }
                        String string = String.valueOf(type.toString());
                        throw new zzbvh(string.length() != 0 ? "Invalid EnumSet type: ".concat(string) : new String("Invalid EnumSet type: "));
                    }
                };
            }
            if (Set.class.isAssignableFrom(clazz)) {
                return new zzbwf<T>(){

                    @Override
                    public T zzaeg() {
                        return new LinkedHashSet();
                    }
                };
            }
            if (Queue.class.isAssignableFrom(clazz)) {
                return new zzbwf<T>(){

                    @Override
                    public T zzaeg() {
                        return new LinkedList();
                    }
                };
            }
            return new zzbwf<T>(){

                @Override
                public T zzaeg() {
                    return new ArrayList();
                }
            };
        }
        if (Map.class.isAssignableFrom(clazz)) {
            if (SortedMap.class.isAssignableFrom(clazz)) {
                return new zzbwf<T>(){

                    @Override
                    public T zzaeg() {
                        return new TreeMap();
                    }
                };
            }
            if (type instanceof ParameterizedType && !String.class.isAssignableFrom(zzbww.zzl(((ParameterizedType)type).getActualTypeArguments()[0]).zzaey())) {
                return new zzbwf<T>(){

                    @Override
                    public T zzaeg() {
                        return new LinkedHashMap();
                    }
                };
            }
            return new zzbwf<T>(){

                @Override
                public T zzaeg() {
                    return new zzbwe();
                }
            };
        }
        return null;
    }

    private <T> zzbwf<T> zzd(final Type type, final Class<? super T> clazz) {
        return new zzbwf<T>(){
            private final zzbwi zzcrL = zzbwi.zzael();

            @Override
            public T zzaeg() {
                try {
                    Object t = this.zzcrL.zze(clazz);
                    return t;
                }
                catch (Exception exception) {
                    String string = String.valueOf(type);
                    throw new RuntimeException(new StringBuilder(116 + String.valueOf(string).length()).append("Unable to invoke no-args constructor for ").append(string).append(". ").append("Register an InstanceCreator with Gson for this type may fix this problem.").toString(), exception);
                }
            }
        };
    }

    public String toString() {
        return this.zzcri.toString();
    }
}

