/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzbcw;
import com.google.android.gms.internal.zzdiu;
import com.google.android.gms.internal.zzdlc;
import com.google.android.gms.internal.zzdlv;
import com.google.android.gms.internal.zzdlx;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.FirebaseUser;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzdmd {
    private Context mContext;
    private String zzljr;
    private SharedPreferences zzbfr;
    private zzbcw zzecu;

    public zzdmd(@NonNull Context context, @NonNull String string) {
        zzbp.zzu((Object)context);
        this.zzljr = zzbp.zzgf((String)string);
        this.mContext = context.getApplicationContext();
        String string2 = String.format("com.google.firebase.auth.api.Store.%s", this.zzljr);
        this.zzbfr = this.mContext.getSharedPreferences(string2, 0);
        this.zzecu = new zzbcw("StorageHelpers", new String[0]);
    }

    public final void zzg(@NonNull FirebaseUser firebaseUser) {
        zzbp.zzu((Object)firebaseUser);
        String string = this.zzi(firebaseUser);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            String string2 = string;
            String string3 = "com.google.firebase.auth.FIREBASE_USER";
            this.zzbfr.edit().putString(string3, string2).apply();
        }
    }

    @Nullable
    public final FirebaseUser zzbou() {
        String string = "com.google.firebase.auth.FIREBASE_USER";
        String string2 = this.zzbfr.getString(string, null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        try {
            String string3;
            JSONObject jSONObject = new JSONObject(string2);
            if (jSONObject.has("type") && "com.google.firebase.auth.internal.DefaultFirebaseUser".equalsIgnoreCase(string3 = jSONObject.optString("type"))) {
                return this.zzr(jSONObject);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public final void zza(@NonNull FirebaseUser firebaseUser, @NonNull zzdlc zzdlc2) {
        zzbp.zzu((Object)firebaseUser);
        zzbp.zzu((Object)((Object)zzdlc2));
        this.zzbfr.edit().putString(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()), zzdlc2.zzaag()).apply();
    }

    public final zzdlc zzh(@NonNull FirebaseUser firebaseUser) {
        zzbp.zzu((Object)firebaseUser);
        String string = this.zzbfr.getString(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()), null);
        if (string != null) {
            return zzdlc.zzof(string);
        }
        return null;
    }

    public final void clear(String string) {
        this.zzbfr.edit().remove(string).apply();
    }

    @Nullable
    private final String zzi(@NonNull FirebaseUser firebaseUser) {
        JSONObject jSONObject = new JSONObject();
        if (zzdlx.class.isAssignableFrom(firebaseUser.getClass())) {
            zzdlx zzdlx2 = (zzdlx)firebaseUser;
            try {
                jSONObject.put("cachedTokenState", (Object)((FirebaseUser)zzdlx2).zzbob());
                jSONObject.put("applicationName", (Object)((FirebaseUser)zzdlx2).zzbnz().getName());
                jSONObject.put("type", (Object)"com.google.firebase.auth.internal.DefaultFirebaseUser");
                if (zzdlx2.zzbos() != null) {
                    JSONArray jSONArray = new JSONArray();
                    List<zzdlv> list = zzdlx2.zzbos();
                    for (int i = 0; i < list.size(); ++i) {
                        zzdlv zzdlv2 = list.get(i);
                        jSONArray.put((Object)zzdlv2.zzaag());
                    }
                    jSONObject.put("userInfos", (Object)jSONArray);
                }
                jSONObject.put("anonymous", ((FirebaseUser)zzdlx2).isAnonymous());
                jSONObject.put("version", (Object)"2");
                return jSONObject.toString();
            }
            catch (Exception exception) {
                this.zzecu.zza("Failed to turn object into JSON", (Throwable)exception, new Object[0]);
                throw new zzdiu(exception);
            }
        }
        return null;
    }

    private final zzdlx zzr(@NonNull JSONObject jSONObject) {
        try {
            String string = jSONObject.getString("cachedTokenState");
            String string2 = jSONObject.getString("applicationName");
            boolean bl = jSONObject.getBoolean("anonymous");
            String string3 = "2";
            String string4 = jSONObject.getString("version");
            if (string4 != null) {
                string3 = string4;
            }
            JSONArray jSONArray = jSONObject.getJSONArray("userInfos");
            int n = jSONArray.length();
            ArrayList<zzdlv> arrayList = new ArrayList<zzdlv>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(zzdlv.zzog(jSONArray.getString(i)));
            }
            FirebaseApp firebaseApp = FirebaseApp.getInstance((String)string2);
            zzdlx zzdlx2 = new zzdlx(firebaseApp, arrayList);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                zzdlc zzdlc2 = zzdlc.zzof(string);
                ((FirebaseUser)zzdlx2).zza(zzdlc2);
            }
            ((zzdlx)((FirebaseUser)zzdlx2).zzbz(bl)).zzoh(string3);
            return zzdlx2;
        }
        catch (zzdiu | ArrayIndexOutOfBoundsException | IllegalArgumentException | JSONException throwable) {
            this.zzecu.zzc(throwable);
            return null;
        }
    }
}

