/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.telephony.PhoneNumberUtils;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.internal.zzdja;
import com.google.android.gms.internal.zzdkj;
import com.google.android.gms.internal.zzdko;
import com.google.android.gms.internal.zzdkq;
import com.google.android.gms.internal.zzdkr;
import com.google.android.gms.internal.zzdks;
import com.google.android.gms.internal.zzdli;
import com.google.android.gms.internal.zzdlq;
import com.google.android.gms.internal.zzdlw;
import com.google.android.gms.internal.zzdma;
import com.google.android.gms.internal.zzdmc;
import com.google.android.gms.internal.zzdmd;
import com.google.android.gms.internal.zzdmh;
import com.google.android.gms.internal.zzdmj;
import com.google.android.gms.internal.zzdmk;
import com.google.android.gms.internal.zzdml;
import com.google.android.gms.internal.zzeao;
import com.google.android.gms.internal.zzeap;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.zzh;
import com.google.firebase.auth.zzi;
import com.google.firebase.auth.zzj;
import com.google.firebase.auth.zzk;
import com.google.firebase.auth.zzl;
import com.google.firebase.auth.zzm;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class FirebaseAuth
implements zzeao {
    private FirebaseApp zzlii;
    private List<IdTokenListener> zzlgh;
    private List<AuthStateListener> zzlij;
    private zzdja zzlik;
    private FirebaseUser zzlil;
    private final Object zzlim;
    private String zzlin;
    private zzdmj zzlio;
    private zzdmk zzlip;
    private static Map<String, FirebaseAuth> zzhtm = new ArrayMap();
    private static FirebaseAuth zzliq;

    @Keep
    public static FirebaseAuth getInstance() {
        return FirebaseAuth.zzb(FirebaseApp.getInstance());
    }

    @Keep
    public static FirebaseAuth getInstance(@NonNull FirebaseApp firebaseApp) {
        return FirebaseAuth.zzb(firebaseApp);
    }

    public FirebaseAuth(FirebaseApp firebaseApp) {
        FirebaseApp firebaseApp2 = firebaseApp;
        zzdkq zzdkq2 = new zzdkr(firebaseApp2.getOptions().getApiKey()).zzbol();
        this(firebaseApp, zzdko.zza(firebaseApp2.getApplicationContext(), zzdkq2), new zzdmj(firebaseApp.getApplicationContext(), firebaseApp.zzbno()));
    }

    private FirebaseAuth(FirebaseApp firebaseApp, zzdja zzdja2, zzdmj zzdmj2) {
        zzdli zzdli2;
        this.zzlim = new Object();
        this.zzlii = (FirebaseApp)zzbp.zzu((Object)firebaseApp);
        this.zzlik = (zzdja)((Object)zzbp.zzu((Object)((Object)zzdja2)));
        this.zzlio = (zzdmj)zzbp.zzu((Object)zzdmj2);
        this.zzlgh = new CopyOnWriteArrayList<IdTokenListener>();
        this.zzlij = new CopyOnWriteArrayList<AuthStateListener>();
        this.zzlip = zzdmk.zzboy();
        FirebaseAuth firebaseAuth = this;
        firebaseAuth.zzlil = firebaseAuth.zzlio.zzbox();
        if (firebaseAuth.zzlil != null && (zzdli2 = firebaseAuth.zzlio.zzg(firebaseAuth.zzlil)) != null) {
            firebaseAuth.zza(firebaseAuth.zzlil, zzdli2, false);
        }
    }

    @Nullable
    public FirebaseUser getCurrentUser() {
        return this.zzlil;
    }

    public final void zza(@NonNull FirebaseUser firebaseUser, @NonNull zzdli zzdli2, boolean bl) {
        boolean bl2;
        boolean bl3;
        zzbp.zzu((Object)firebaseUser);
        zzbp.zzu((Object)((Object)zzdli2));
        if (this.zzlil == null) {
            bl3 = true;
            bl2 = true;
        } else {
            String string;
            String string2 = this.zzlil.zzbod().getAccessToken();
            boolean bl4 = !string2.equals(string = zzdli2.getAccessToken());
            boolean bl5 = this.zzlil.getUid().equals(firebaseUser.getUid());
            bl3 = !bl5 || bl4;
            bl2 = !bl5;
        }
        boolean bl6 = bl2;
        boolean bl7 = bl;
        FirebaseUser firebaseUser2 = firebaseUser;
        FirebaseAuth firebaseAuth = this;
        zzbp.zzu((Object)firebaseUser2);
        if (firebaseAuth.zzlil == null) {
            firebaseAuth.zzlil = firebaseUser2;
        } else {
            firebaseAuth.zzlil.zzcb(firebaseUser2.isAnonymous());
            firebaseAuth.zzlil.zzan(firebaseUser2.getProviderData());
        }
        if (bl7) {
            firebaseAuth.zzlio.zzf(firebaseAuth.zzlil);
        }
        if (bl3) {
            if (this.zzlil != null) {
                this.zzlil.zza(zzdli2);
            }
            this.zza(this.zzlil);
        }
        if (bl6) {
            this.zzb(this.zzlil);
        }
        if (bl) {
            this.zzlio.zza(firebaseUser, zzdli2);
        }
    }

    public final void zzboa() {
        if (this.zzlil != null) {
            FirebaseUser firebaseUser = this.zzlil;
            zzdmj zzdmj2 = this.zzlio;
            zzbp.zzu((Object)firebaseUser);
            zzdmj2.clear(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()));
            this.zzlil = null;
        }
        this.zzlio.clear("com.google.firebase.auth.FIREBASE_USER");
        this.zza(null);
        this.zzb(null);
    }

    private static synchronized FirebaseAuth zzb(@NonNull FirebaseApp firebaseApp) {
        FirebaseAuth firebaseAuth = zzhtm.get(firebaseApp.zzbno());
        if (firebaseAuth == null) {
            firebaseAuth = new zzdmc(firebaseApp);
            firebaseApp.zza((zzeao)firebaseAuth);
            if (zzliq == null) {
                zzliq = firebaseAuth;
            }
            zzhtm.put(firebaseApp.zzbno(), firebaseAuth);
            return firebaseAuth;
        }
        return firebaseAuth;
    }

    public void addIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzlgh.add(idTokenListener);
        this.zzlip.execute(new zzh(this, idTokenListener));
    }

    public void removeIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzlgh.remove(idTokenListener);
    }

    public void addAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzlij.add(authStateListener);
        this.zzlip.execute(new zzi(this, authStateListener));
    }

    public void removeAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzlij.remove(authStateListener);
    }

    private final void zza(@Nullable FirebaseUser firebaseUser) {
        String string;
        if (firebaseUser != null) {
            string = firebaseUser.getUid();
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(45 + String.valueOf(string).length()).append("Notifying id token listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying id token listeners about a sign-out event.");
        }
        string = firebaseUser != null ? firebaseUser.zzbof() : null;
        zzeap zzeap2 = new zzeap(string);
        this.zzlip.execute(new zzj(this, zzeap2));
    }

    private final void zzb(@Nullable FirebaseUser firebaseUser) {
        if (firebaseUser != null) {
            String string = firebaseUser.getUid();
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(47 + String.valueOf(string).length()).append("Notifying auth state listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying auth state listeners about a sign-out event.");
        }
        this.zzlip.execute(new zzk(this));
    }

    @NonNull
    public final Task<GetTokenResult> zzca(boolean bl) {
        return this.zza(this.zzlil, bl);
    }

    @NonNull
    public final Task<GetTokenResult> zza(@Nullable FirebaseUser firebaseUser, boolean bl) {
        if (firebaseUser == null) {
            return Tasks.forException((Exception)zzdkj.zzak(new Status(17495)));
        }
        zzdli zzdli2 = this.zzlil.zzbod();
        if (zzdli2.isValid() && !bl) {
            return Tasks.forResult((Object)new GetTokenResult(zzdli2.getAccessToken()));
        }
        return this.zzlik.zza(this.zzlii, firebaseUser, zzdli2.zzbop(), (zzdlw)new zzl(this));
    }

    @NonNull
    public Task<AuthResult> signInWithCredential(@NonNull AuthCredential authCredential) {
        zzbp.zzu((Object)((Object)authCredential));
        if (authCredential instanceof EmailAuthCredential) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzlik.zzb(this.zzlii, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), new zza(this));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            PhoneAuthCredential phoneAuthCredential = (PhoneAuthCredential)authCredential;
            return this.zzlik.zza(this.zzlii, phoneAuthCredential, (zzdlw)new zza(this));
        }
        return this.zzlik.zza(this.zzlii, authCredential, (zzdlw)new zza(this));
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzbp.zzu((Object)firebaseUser);
        zzbp.zzu((Object)((Object)authCredential));
        if (EmailAuthCredential.class.isAssignableFrom(((Object)((Object)authCredential)).getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzlik.zza(this.zzlii, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (zzdml)((Object)new zzb(this)));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zzlik.zzb(this.zzlii, firebaseUser, (PhoneAuthCredential)authCredential, (zzdml)((Object)new zzb(this)));
        }
        return this.zzlik.zza(this.zzlii, firebaseUser, authCredential, (zzdml)((Object)new zzb(this)));
    }

    public final Task<AuthResult> zzb(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzbp.zzu((Object)firebaseUser);
        zzbp.zzu((Object)((Object)authCredential));
        if (EmailAuthCredential.class.isAssignableFrom(((Object)((Object)authCredential)).getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzlik.zzb(this.zzlii, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (zzdml)((Object)new zzb(this)));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zzlik.zzc(this.zzlii, firebaseUser, authCredential, (zzdml)((Object)new zzb(this)));
        }
        return this.zzlik.zzb(this.zzlii, firebaseUser, authCredential, (zzdml)((Object)new zzb(this)));
    }

    @NonNull
    public Task<AuthResult> signInWithCustomToken(@NonNull String string) {
        zzbp.zzgg((String)string);
        return this.zzlik.zza(this.zzlii, string, (zzdlw)new zza(this));
    }

    @NonNull
    public Task<AuthResult> signInWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzbp.zzgg((String)string);
        zzbp.zzgg((String)string2);
        return this.zzlik.zzb(this.zzlii, string, string2, new zza(this));
    }

    @NonNull
    public Task<AuthResult> signInAnonymously() {
        if (this.zzlil != null && this.zzlil.isAnonymous()) {
            zzdmd zzdmd2 = (zzdmd)this.zzlil;
            return Tasks.forResult((Object)new zzdma(zzdmd2));
        }
        return this.zzlik.zza(this.zzlii, new zza(this));
    }

    /*
     * Unable to fully structure code
     */
    @NonNull
    public final void zza(@NonNull String var1_1, long var2_2, TimeUnit var4_3, @NonNull PhoneAuthProvider.OnVerificationStateChangedCallbacks var5_4, @Nullable Activity var6_5, @NonNull Executor var7_6, boolean var8_7) {
        block7: {
            block8: {
                block9: {
                    block6: {
                        var14_8 = var1_1;
                        var13_9 = this.zzlii.getApplicationContext();
                        zzbp.zzu((Object)var13_9);
                        zzbp.zzgg((String)var14_8);
                        var21_10 = (TelephonyManager)var13_9.getSystemService("phone");
                        var19_11 = var21_10 != null ? var21_10.getSimCountryIso() : null;
                        if (TextUtils.isEmpty((CharSequence)var19_11)) {
                            var20_13 = Locale.getDefault();
                            var19_11 = var20_13 != null ? var20_13.getCountry() : null;
                        }
                        var15_14 = TextUtils.isEmpty((CharSequence)var19_11) != false ? "US" : var19_11.toUpperCase(Locale.US);
                        var17_16 = var16_15 = PhoneNumberUtils.stripSeparators((String)var14_8);
                        if (!zzp.zzalk()) break block6;
                        if (!TextUtils.isEmpty((CharSequence)(var17_16 = PhoneNumberUtils.formatNumberToE164((String)var17_16, (String)var15_14)))) break block7;
                        v0 = var16_15;
                        break block8;
                    }
                    if (!"US".equals(var15_14)) break block7;
                    var18_17 = var17_16;
                    if (var18_17 != null) break block9;
                    v0 = null;
                    break block8;
                }
                var19_12 = var18_17.length();
                if (var18_17.startsWith("+")) ** GOTO lbl-1000
                if (var19_12 == 11 && var18_17.startsWith("1")) {
                    v0 = "+".concat(var18_17);
                } else if (var19_12 == 10) {
                    v0 = "+1".concat(var18_17);
                } else lbl-1000:
                // 2 sources

                {
                    v0 = var18_17;
                }
            }
            var17_16 = v0;
        }
        var9_18 = var17_16;
        var10_19 = TimeUnit.SECONDS.convert(var2_2, var4_3);
        if (var10_19 < 0L || var10_19 > 120L) {
            throw new IllegalArgumentException("We only support 0-120 seconds for sms-auto-retrieval timeout");
        }
        var12_20 = new zzdlq(var9_18, var10_19, var8_7, this.zzlin);
        this.zzlik.zza(this.zzlii, var12_20, var5_4, var6_5, var7_6);
    }

    @NonNull
    public final Task<Void> zzc(@NonNull FirebaseUser firebaseUser) {
        zzbp.zzu((Object)firebaseUser);
        return this.zzlik.zza(this.zzlii, firebaseUser, (zzdml)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<AuthResult> zzc(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzbp.zzu((Object)((Object)authCredential));
        zzbp.zzu((Object)firebaseUser);
        return this.zzlik.zzd(this.zzlii, firebaseUser, authCredential, (zzdml)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<AuthResult> zza(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzbp.zzgg((String)string);
        zzbp.zzu((Object)firebaseUser);
        return this.zzlik.zzc(this.zzlii, firebaseUser, string, (zzdml)((Object)new zzb(this)));
    }

    @NonNull
    public Task<AuthResult> createUserWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzbp.zzgg((String)string);
        zzbp.zzgg((String)string2);
        return this.zzlik.zza(this.zzlii, string, string2, (zzdlw)new zza(this));
    }

    @NonNull
    public Task<ProviderQueryResult> fetchProvidersForEmail(@NonNull String string) {
        zzbp.zzgg((String)string);
        return this.zzlik.zza(this.zzlii, string);
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest) {
        zzbp.zzu((Object)firebaseUser);
        zzbp.zzu((Object)((Object)userProfileChangeRequest));
        return this.zzlik.zza(this.zzlii, firebaseUser, userProfileChangeRequest, (zzdml)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<Void> zzb(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzbp.zzu((Object)firebaseUser);
        zzbp.zzgg((String)string);
        return this.zzlik.zza(this.zzlii, firebaseUser, string, (zzdml)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull PhoneAuthCredential phoneAuthCredential) {
        zzbp.zzu((Object)firebaseUser);
        zzbp.zzu((Object)((Object)phoneAuthCredential));
        return this.zzlik.zza(this.zzlii, firebaseUser, phoneAuthCredential, (zzdml)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<Void> zzc(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzbp.zzu((Object)firebaseUser);
        zzbp.zzgg((String)string);
        return this.zzlik.zzb(this.zzlii, firebaseUser, string, (zzdml)((Object)new zzb(this)));
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string) {
        zzbp.zzgg((String)string);
        return this.sendPasswordResetEmail(string, null);
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string, @Nullable ActionCodeSettings actionCodeSettings) {
        zzbp.zzgg((String)string);
        if (this.zzlin != null) {
            if (actionCodeSettings == null) {
                actionCodeSettings = ActionCodeSettings.newBuilder().build();
            }
            actionCodeSettings.zzoj(this.zzlin);
        }
        return this.zzlik.zza(this.zzlii, string, actionCodeSettings);
    }

    @NonNull
    public final Task<Void> zzok(@NonNull String string) {
        zzbp.zzgg((String)string);
        String string2 = string;
        FirebaseApp firebaseApp = this.zzlii;
        return this.zzlik.zza(firebaseApp, (ActionCodeSettings)null, string2);
    }

    @NonNull
    public final Task<Void> zza(@NonNull ActionCodeSettings actionCodeSettings, @NonNull String string) {
        zzbp.zzgg((String)string);
        if (this.zzlin != null) {
            if (actionCodeSettings == null) {
                actionCodeSettings = ActionCodeSettings.newBuilder().build();
            }
            actionCodeSettings.zzoj(this.zzlin);
        }
        return this.zzlik.zza(this.zzlii, actionCodeSettings, string);
    }

    @NonNull
    public Task<ActionCodeResult> checkActionCode(@NonNull String string) {
        zzbp.zzgg((String)string);
        return this.zzlik.zzb(this.zzlii, string);
    }

    @NonNull
    public Task<Void> applyActionCode(@NonNull String string) {
        zzbp.zzgg((String)string);
        return this.zzlik.zzc(this.zzlii, string);
    }

    @NonNull
    public Task<String> verifyPasswordResetCode(@NonNull String string) {
        zzbp.zzgg((String)string);
        return this.zzlik.zzd(this.zzlii, string);
    }

    @NonNull
    public Task<Void> confirmPasswordReset(@NonNull String string, @NonNull String string2) {
        zzbp.zzgg((String)string);
        zzbp.zzgg((String)string2);
        return this.zzlik.zza(this.zzlii, string, string2);
    }

    @NonNull
    public final Task<Void> zzd(@NonNull FirebaseUser firebaseUser) {
        zzbp.zzu((Object)firebaseUser);
        return this.zzlik.zza(firebaseUser, new zzm(this, firebaseUser));
    }

    public void signOut() {
        this.zzboa();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLanguageCode(@NonNull String string) {
        zzbp.zzgg((String)string);
        Object object = this.zzlim;
        synchronized (object) {
            this.zzlin = string;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getLanguageCode() {
        Object object = this.zzlim;
        synchronized (object) {
            return this.zzlin;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useAppLanguage() {
        Object object = this.zzlim;
        synchronized (object) {
            this.zzlin = zzdks.zzbom();
            return;
        }
    }

    static /* synthetic */ FirebaseApp zza(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzlii;
    }

    static /* synthetic */ List zzb(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzlgh;
    }

    static /* synthetic */ List zzc(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzlij;
    }

    static /* synthetic */ FirebaseUser zzd(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzlil;
    }

    final class zzb
    extends zza
    implements zzdlw,
    zzdmh {
        private /* synthetic */ FirebaseAuth zzlis;

        zzb(FirebaseAuth firebaseAuth) {
            this.zzlis = firebaseAuth;
            super(firebaseAuth);
        }

        @Override
        public final void onError(Status status) {
            if (status.getStatusCode() == 17011 || status.getStatusCode() == 17021 || status.getStatusCode() == 17005) {
                this.zzlis.signOut();
            }
        }
    }

    class zza
    implements zzdlw {
        private /* synthetic */ FirebaseAuth zzlis;

        zza(FirebaseAuth firebaseAuth) {
            this.zzlis = firebaseAuth;
        }

        @Override
        public final void zza(@NonNull zzdli zzdli2, @NonNull FirebaseUser firebaseUser) {
            zzbp.zzu((Object)((Object)zzdli2));
            zzbp.zzu((Object)firebaseUser);
            firebaseUser.zza(zzdli2);
            this.zzlis.zza(firebaseUser, zzdli2, true);
        }
    }

    public static interface AuthStateListener {
        public void onAuthStateChanged(@NonNull FirebaseAuth var1);
    }

    public static interface IdTokenListener {
        public void onIdTokenChanged(@NonNull FirebaseAuth var1);
    }
}

