/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzdli;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.UserInfo;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.zzn;
import com.google.firebase.auth.zzo;
import java.util.List;

public abstract class FirebaseUser
implements UserInfo {
    public FirebaseUser() {
    }

    @Override
    @NonNull
    public abstract String getUid();

    @Override
    @NonNull
    public abstract String getProviderId();

    public abstract boolean isAnonymous();

    @Nullable
    public abstract List<String> getProviders();

    @NonNull
    public abstract List<? extends UserInfo> getProviderData();

    @NonNull
    public abstract FirebaseUser zzan(@NonNull List<? extends UserInfo> var1);

    public abstract FirebaseUser zzcb(boolean var1);

    @NonNull
    public abstract FirebaseApp zzboc();

    @Override
    @Nullable
    public abstract String getDisplayName();

    @Override
    @Nullable
    public abstract Uri getPhotoUrl();

    @Override
    @Nullable
    public abstract String getEmail();

    @Override
    @Nullable
    public abstract String getPhoneNumber();

    @NonNull
    public Task<GetTokenResult> getIdToken(boolean bl) {
        return FirebaseAuth.getInstance(this.zzboc()).zza(this, bl);
    }

    @Deprecated
    @NonNull
    public Task<GetTokenResult> getToken(boolean bl) {
        return this.getIdToken(bl);
    }

    @NonNull
    public Task<Void> reload() {
        return FirebaseAuth.getInstance(this.zzboc()).zzc(this);
    }

    public Task<Void> reauthenticate(@NonNull AuthCredential authCredential) {
        zzbp.zzu((Object)((Object)authCredential));
        return FirebaseAuth.getInstance(this.zzboc()).zza(this, authCredential);
    }

    public Task<AuthResult> reauthenticateAndRetrieveData(@NonNull AuthCredential authCredential) {
        zzbp.zzu((Object)((Object)authCredential));
        return FirebaseAuth.getInstance(this.zzboc()).zzb(this, authCredential);
    }

    @NonNull
    public Task<AuthResult> linkWithCredential(@NonNull AuthCredential authCredential) {
        zzbp.zzu((Object)((Object)authCredential));
        return FirebaseAuth.getInstance(this.zzboc()).zzc(this, authCredential);
    }

    public Task<AuthResult> unlink(@NonNull String string) {
        zzbp.zzgg((String)string);
        return FirebaseAuth.getInstance(this.zzboc()).zza(this, string);
    }

    @NonNull
    public Task<Void> updateProfile(@NonNull UserProfileChangeRequest userProfileChangeRequest) {
        zzbp.zzu((Object)((Object)userProfileChangeRequest));
        return FirebaseAuth.getInstance(this.zzboc()).zza(this, userProfileChangeRequest);
    }

    @NonNull
    public Task<Void> updateEmail(@NonNull String string) {
        zzbp.zzgg((String)string);
        return FirebaseAuth.getInstance(this.zzboc()).zzb(this, string);
    }

    public Task<Void> updatePhoneNumber(@NonNull PhoneAuthCredential phoneAuthCredential) {
        return FirebaseAuth.getInstance(this.zzboc()).zza(this, phoneAuthCredential);
    }

    @NonNull
    public Task<Void> updatePassword(@NonNull String string) {
        zzbp.zzgg((String)string);
        return FirebaseAuth.getInstance(this.zzboc()).zzc(this, string);
    }

    @NonNull
    public Task<Void> delete() {
        return FirebaseAuth.getInstance(this.zzboc()).zzd(this);
    }

    @NonNull
    public Task<Void> sendEmailVerification() {
        return FirebaseAuth.getInstance(this.zzboc()).zza(this, false).continueWithTask((Continuation)new zzn(this));
    }

    @NonNull
    public Task<Void> sendEmailVerification(ActionCodeSettings actionCodeSettings) {
        return FirebaseAuth.getInstance(this.zzboc()).zza(this, false).continueWithTask((Continuation)new zzo(this, actionCodeSettings));
    }

    @NonNull
    public abstract zzdli zzbod();

    public abstract void zza(@NonNull zzdli var1);

    @NonNull
    public abstract String zzboe();

    @NonNull
    public abstract String zzbof();
}

