/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.telephony.PhoneNumberUtils;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzdtw;
import com.google.android.gms.internal.zzdvf;
import com.google.android.gms.internal.zzdvk;
import com.google.android.gms.internal.zzdvm;
import com.google.android.gms.internal.zzdvn;
import com.google.android.gms.internal.zzdvo;
import com.google.android.gms.internal.zzdwf;
import com.google.android.gms.internal.zzdwn;
import com.google.android.gms.internal.zzdwt;
import com.google.android.gms.internal.zzdwx;
import com.google.android.gms.internal.zzdwz;
import com.google.android.gms.internal.zzdxa;
import com.google.android.gms.internal.zzdxf;
import com.google.android.gms.internal.zzdxh;
import com.google.android.gms.internal.zzdxi;
import com.google.android.gms.internal.zzdxj;
import com.google.android.gms.internal.zzeuq;
import com.google.android.gms.internal.zzeur;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.zzh;
import com.google.firebase.auth.zzi;
import com.google.firebase.auth.zzj;
import com.google.firebase.auth.zzk;
import com.google.firebase.auth.zzl;
import com.google.firebase.auth.zzm;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class FirebaseAuth
implements zzeuq {
    private FirebaseApp zzlyy;
    private List<IdTokenListener> zzlwx;
    private List<AuthStateListener> zzlyz;
    private zzdtw zzlza;
    private FirebaseUser zzlzb;
    private final Object zzlzc;
    private String zzlzd;
    private zzdxh zzlze;
    private zzdxi zzlzf;
    private static Map<String, FirebaseAuth> zzicu = new ArrayMap();
    private static FirebaseAuth zzlzg;

    @Keep
    public static FirebaseAuth getInstance() {
        return FirebaseAuth.zzb(FirebaseApp.getInstance());
    }

    @Keep
    public static FirebaseAuth getInstance(@NonNull FirebaseApp firebaseApp) {
        return FirebaseAuth.zzb(firebaseApp);
    }

    public FirebaseAuth(FirebaseApp firebaseApp) {
        FirebaseApp firebaseApp2 = firebaseApp;
        zzdvm zzdvm2 = new zzdvn(firebaseApp2.getOptions().getApiKey()).zzbpz();
        this(firebaseApp, zzdvk.zza(firebaseApp2.getApplicationContext(), zzdvm2), new zzdxh(firebaseApp.getApplicationContext(), firebaseApp.zzboz()));
    }

    private FirebaseAuth(FirebaseApp firebaseApp, zzdtw zzdtw2, zzdxh zzdxh2) {
        zzdwf zzdwf2;
        this.zzlzc = new Object();
        this.zzlyy = (FirebaseApp)zzbq.checkNotNull((Object)firebaseApp);
        this.zzlza = (zzdtw)zzbq.checkNotNull((Object)zzdtw2);
        this.zzlze = (zzdxh)zzbq.checkNotNull((Object)zzdxh2);
        this.zzlwx = new CopyOnWriteArrayList<IdTokenListener>();
        this.zzlyz = new CopyOnWriteArrayList<AuthStateListener>();
        this.zzlzf = zzdxi.zzbqm();
        FirebaseAuth firebaseAuth = this;
        firebaseAuth.zzlzb = firebaseAuth.zzlze.zzbql();
        if (firebaseAuth.zzlzb != null && (zzdwf2 = firebaseAuth.zzlze.zzg(firebaseAuth.zzlzb)) != null) {
            firebaseAuth.zza(firebaseAuth.zzlzb, zzdwf2, false);
        }
    }

    @Nullable
    public FirebaseUser getCurrentUser() {
        return this.zzlzb;
    }

    @Nullable
    public final String getUid() {
        if (this.zzlzb == null) {
            return null;
        }
        return this.zzlzb.getUid();
    }

    public final void zza(@NonNull FirebaseUser firebaseUser, @NonNull zzdwf zzdwf2, boolean bl) {
        boolean bl2;
        boolean bl3;
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.checkNotNull((Object)((Object)zzdwf2));
        if (this.zzlzb == null) {
            bl3 = true;
            bl2 = true;
        } else {
            String string;
            String string2 = this.zzlzb.zzbpo().getAccessToken();
            boolean bl4 = !string2.equals(string = zzdwf2.getAccessToken());
            boolean bl5 = this.zzlzb.getUid().equals(firebaseUser.getUid());
            bl3 = !bl5 || bl4;
            bl2 = !bl5;
        }
        boolean bl6 = bl2;
        boolean bl7 = bl;
        FirebaseUser firebaseUser2 = firebaseUser;
        FirebaseAuth firebaseAuth = this;
        zzbq.checkNotNull((Object)firebaseUser2);
        if (firebaseAuth.zzlzb == null) {
            firebaseAuth.zzlzb = firebaseUser2;
        } else {
            firebaseAuth.zzlzb.zzcc(firebaseUser2.isAnonymous());
            firebaseAuth.zzlzb.zzap(firebaseUser2.getProviderData());
        }
        if (bl7) {
            firebaseAuth.zzlze.zzf(firebaseAuth.zzlzb);
        }
        if (bl3) {
            if (this.zzlzb != null) {
                this.zzlzb.zza(zzdwf2);
            }
            this.zza(this.zzlzb);
        }
        if (bl6) {
            this.zzb(this.zzlzb);
        }
        if (bl) {
            this.zzlze.zza(firebaseUser, zzdwf2);
        }
    }

    public final void zzbpl() {
        if (this.zzlzb != null) {
            FirebaseUser firebaseUser = this.zzlzb;
            zzdxh zzdxh2 = this.zzlze;
            zzbq.checkNotNull((Object)firebaseUser);
            zzdxh2.clear(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()));
            this.zzlzb = null;
        }
        this.zzlze.clear("com.google.firebase.auth.FIREBASE_USER");
        this.zza(null);
        this.zzb(null);
    }

    private static synchronized FirebaseAuth zzb(@NonNull FirebaseApp firebaseApp) {
        FirebaseAuth firebaseAuth = zzicu.get(firebaseApp.zzboz());
        if (firebaseAuth == null) {
            firebaseAuth = new zzdwz(firebaseApp);
            firebaseApp.zza((zzeuq)firebaseAuth);
            if (zzlzg == null) {
                zzlzg = firebaseAuth;
            }
            zzicu.put(firebaseApp.zzboz(), firebaseAuth);
            return firebaseAuth;
        }
        return firebaseAuth;
    }

    public void addIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzlwx.add(idTokenListener);
        this.zzlzf.execute(new zzh(this, idTokenListener));
    }

    public void removeIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzlwx.remove(idTokenListener);
    }

    public void addAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzlyz.add(authStateListener);
        this.zzlzf.execute(new zzi(this, authStateListener));
    }

    public void removeAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzlyz.remove(authStateListener);
    }

    private final void zza(@Nullable FirebaseUser firebaseUser) {
        String string;
        if (firebaseUser != null) {
            string = firebaseUser.getUid();
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(45 + String.valueOf(string).length()).append("Notifying id token listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying id token listeners about a sign-out event.");
        }
        string = firebaseUser != null ? firebaseUser.zzbpq() : null;
        zzeur zzeur2 = new zzeur(string);
        this.zzlzf.execute(new zzj(this, zzeur2));
    }

    private final void zzb(@Nullable FirebaseUser firebaseUser) {
        if (firebaseUser != null) {
            String string = firebaseUser.getUid();
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(47 + String.valueOf(string).length()).append("Notifying auth state listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying auth state listeners about a sign-out event.");
        }
        this.zzlzf.execute(new zzk(this));
    }

    @NonNull
    public final Task<GetTokenResult> zzcb(boolean bl) {
        return this.zza(this.zzlzb, bl);
    }

    @NonNull
    public final Task<GetTokenResult> zza(@Nullable FirebaseUser firebaseUser, boolean bl) {
        if (firebaseUser == null) {
            return Tasks.forException((Exception)zzdvf.zzap(new Status(17495)));
        }
        zzdwf zzdwf2 = this.zzlzb.zzbpo();
        if (zzdwf2.isValid() && !bl) {
            return Tasks.forResult((Object)new GetTokenResult(zzdwf2.getAccessToken()));
        }
        return this.zzlza.zza(this.zzlyy, firebaseUser, zzdwf2.zzbqd(), (zzdwt)new zzl(this));
    }

    @NonNull
    public Task<AuthResult> signInWithCredential(@NonNull AuthCredential authCredential) {
        zzbq.checkNotNull((Object)((Object)authCredential));
        if (authCredential instanceof EmailAuthCredential) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzlza.zzb(this.zzlyy, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), new zza(this));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            PhoneAuthCredential phoneAuthCredential = (PhoneAuthCredential)authCredential;
            return this.zzlza.zza(this.zzlyy, phoneAuthCredential, (zzdwt)new zza(this));
        }
        return this.zzlza.zza(this.zzlyy, authCredential, (zzdwt)new zza(this));
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.checkNotNull((Object)((Object)authCredential));
        if (EmailAuthCredential.class.isAssignableFrom(((Object)((Object)authCredential)).getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzlza.zza(this.zzlyy, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (zzdxj)((Object)new zzb(this)));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zzlza.zzb(this.zzlyy, firebaseUser, (PhoneAuthCredential)authCredential, (zzdxj)((Object)new zzb(this)));
        }
        return this.zzlza.zza(this.zzlyy, firebaseUser, authCredential, (zzdxj)((Object)new zzb(this)));
    }

    public final Task<AuthResult> zzb(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.checkNotNull((Object)((Object)authCredential));
        if (EmailAuthCredential.class.isAssignableFrom(((Object)((Object)authCredential)).getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzlza.zzb(this.zzlyy, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (zzdxj)((Object)new zzb(this)));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zzlza.zzc(this.zzlyy, firebaseUser, authCredential, (zzdxj)((Object)new zzb(this)));
        }
        return this.zzlza.zzb(this.zzlyy, firebaseUser, authCredential, (zzdxj)((Object)new zzb(this)));
    }

    @NonNull
    public Task<AuthResult> signInWithCustomToken(@NonNull String string) {
        zzbq.zzgi((String)string);
        return this.zzlza.zza(this.zzlyy, string, (zzdwt)new zza(this));
    }

    @NonNull
    public Task<AuthResult> signInWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzbq.zzgi((String)string);
        zzbq.zzgi((String)string2);
        return this.zzlza.zzb(this.zzlyy, string, string2, new zza(this));
    }

    @NonNull
    public Task<AuthResult> signInAnonymously() {
        if (this.zzlzb != null && this.zzlzb.isAnonymous()) {
            zzdxa zzdxa2 = (zzdxa)this.zzlzb;
            zzdxa2.zzcf(false);
            return Tasks.forResult((Object)new zzdwx(zzdxa2));
        }
        return this.zzlza.zza(this.zzlyy, new zza(this));
    }

    /*
     * Unable to fully structure code
     */
    @NonNull
    public final void zza(@NonNull String var1_1, long var2_2, TimeUnit var4_3, @NonNull PhoneAuthProvider.OnVerificationStateChangedCallbacks var5_4, @Nullable Activity var6_5, @NonNull Executor var7_6, boolean var8_7) {
        block7: {
            block8: {
                block9: {
                    block6: {
                        var14_8 = var1_1;
                        var13_9 = this.zzlyy.getApplicationContext();
                        zzbq.checkNotNull((Object)var13_9);
                        zzbq.zzgi((String)var14_8);
                        var21_10 = (TelephonyManager)var13_9.getSystemService("phone");
                        var19_11 = var21_10 != null ? var21_10.getSimCountryIso() : null;
                        if (TextUtils.isEmpty((CharSequence)var19_11)) {
                            var20_13 = Locale.getDefault();
                            var19_11 = var20_13 != null ? var20_13.getCountry() : null;
                        }
                        var15_14 = TextUtils.isEmpty((CharSequence)var19_11) != false ? "US" : var19_11.toUpperCase(Locale.US);
                        var17_16 = var16_15 = PhoneNumberUtils.stripSeparators((String)var14_8);
                        if (!zzq.zzamc()) break block6;
                        if (!TextUtils.isEmpty((CharSequence)(var17_16 = PhoneNumberUtils.formatNumberToE164((String)var17_16, (String)var15_14)))) break block7;
                        v0 = var16_15;
                        break block8;
                    }
                    if (!"US".equals(var15_14)) break block7;
                    var18_17 = var17_16;
                    if (var18_17 != null) break block9;
                    v0 = null;
                    break block8;
                }
                var19_12 = var18_17.length();
                if (var18_17.startsWith("+")) ** GOTO lbl-1000
                if (var19_12 == 11 && var18_17.startsWith("1")) {
                    v0 = "+".concat(var18_17);
                } else if (var19_12 == 10) {
                    v0 = "+1".concat(var18_17);
                } else lbl-1000:
                // 2 sources

                {
                    v0 = var18_17;
                }
            }
            var17_16 = v0;
        }
        var9_18 = var17_16;
        var10_19 = TimeUnit.SECONDS.convert(var2_2, var4_3);
        if (var10_19 < 0L || var10_19 > 120L) {
            throw new IllegalArgumentException("We only support 0-120 seconds for sms-auto-retrieval timeout");
        }
        var12_20 = new zzdwn(var9_18, var10_19, var8_7, this.zzlzd);
        this.zzlza.zza(this.zzlyy, var12_20, var5_4, var6_5, var7_6);
    }

    @NonNull
    public final Task<Void> zzc(@NonNull FirebaseUser firebaseUser) {
        zzbq.checkNotNull((Object)firebaseUser);
        return this.zzlza.zza(this.zzlyy, firebaseUser, (zzdxj)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<AuthResult> zzc(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzbq.checkNotNull((Object)((Object)authCredential));
        zzbq.checkNotNull((Object)firebaseUser);
        return this.zzlza.zzd(this.zzlyy, firebaseUser, authCredential, (zzdxj)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<AuthResult> zza(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzbq.zzgi((String)string);
        zzbq.checkNotNull((Object)firebaseUser);
        return this.zzlza.zzc(this.zzlyy, firebaseUser, string, (zzdxj)((Object)new zzb(this)));
    }

    @NonNull
    public Task<AuthResult> createUserWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzbq.zzgi((String)string);
        zzbq.zzgi((String)string2);
        return this.zzlza.zza(this.zzlyy, string, string2, (zzdwt)new zza(this));
    }

    @NonNull
    public Task<ProviderQueryResult> fetchProvidersForEmail(@NonNull String string) {
        zzbq.zzgi((String)string);
        return this.zzlza.zza(this.zzlyy, string);
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest) {
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.checkNotNull((Object)((Object)userProfileChangeRequest));
        return this.zzlza.zza(this.zzlyy, firebaseUser, userProfileChangeRequest, (zzdxj)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<Void> zzb(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.zzgi((String)string);
        return this.zzlza.zza(this.zzlyy, firebaseUser, string, (zzdxj)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull PhoneAuthCredential phoneAuthCredential) {
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.checkNotNull((Object)phoneAuthCredential);
        return this.zzlza.zza(this.zzlyy, firebaseUser, phoneAuthCredential, (zzdxj)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<Void> zzc(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.zzgi((String)string);
        return this.zzlza.zzb(this.zzlyy, firebaseUser, string, (zzdxj)((Object)new zzb(this)));
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string) {
        zzbq.zzgi((String)string);
        return this.sendPasswordResetEmail(string, null);
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string, @Nullable ActionCodeSettings actionCodeSettings) {
        zzbq.zzgi((String)string);
        if (this.zzlzd != null) {
            if (actionCodeSettings == null) {
                actionCodeSettings = ActionCodeSettings.newBuilder().build();
            }
            actionCodeSettings.zzof(this.zzlzd);
        }
        return this.zzlza.zza(this.zzlyy, string, actionCodeSettings);
    }

    @NonNull
    public final Task<Void> zzog(@NonNull String string) {
        zzbq.zzgi((String)string);
        String string2 = string;
        FirebaseApp firebaseApp = this.zzlyy;
        return this.zzlza.zza(firebaseApp, (ActionCodeSettings)null, string2);
    }

    @NonNull
    public final Task<Void> zza(@NonNull ActionCodeSettings actionCodeSettings, @NonNull String string) {
        zzbq.zzgi((String)string);
        if (this.zzlzd != null) {
            if (actionCodeSettings == null) {
                actionCodeSettings = ActionCodeSettings.newBuilder().build();
            }
            actionCodeSettings.zzof(this.zzlzd);
        }
        return this.zzlza.zza(this.zzlyy, actionCodeSettings, string);
    }

    @NonNull
    public Task<ActionCodeResult> checkActionCode(@NonNull String string) {
        zzbq.zzgi((String)string);
        return this.zzlza.zzb(this.zzlyy, string);
    }

    @NonNull
    public Task<Void> applyActionCode(@NonNull String string) {
        zzbq.zzgi((String)string);
        return this.zzlza.zzc(this.zzlyy, string);
    }

    @NonNull
    public Task<String> verifyPasswordResetCode(@NonNull String string) {
        zzbq.zzgi((String)string);
        return this.zzlza.zzd(this.zzlyy, string);
    }

    @NonNull
    public Task<Void> confirmPasswordReset(@NonNull String string, @NonNull String string2) {
        zzbq.zzgi((String)string);
        zzbq.zzgi((String)string2);
        return this.zzlza.zza(this.zzlyy, string, string2);
    }

    @NonNull
    public final Task<Void> zzd(@NonNull FirebaseUser firebaseUser) {
        zzbq.checkNotNull((Object)firebaseUser);
        return this.zzlza.zza(firebaseUser, new zzm(this, firebaseUser));
    }

    public void signOut() {
        this.zzbpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLanguageCode(@NonNull String string) {
        zzbq.zzgi((String)string);
        Object object = this.zzlzc;
        synchronized (object) {
            this.zzlzd = string;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getLanguageCode() {
        Object object = this.zzlzc;
        synchronized (object) {
            return this.zzlzd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useAppLanguage() {
        Object object = this.zzlzc;
        synchronized (object) {
            this.zzlzd = zzdvo.zzbqa();
            return;
        }
    }

    static /* synthetic */ FirebaseApp zza(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzlyy;
    }

    static /* synthetic */ List zzb(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzlwx;
    }

    static /* synthetic */ List zzc(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzlyz;
    }

    static /* synthetic */ FirebaseUser zzd(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzlzb;
    }

    final class zzb
    extends zza
    implements zzdwt,
    zzdxf {
        private /* synthetic */ FirebaseAuth zzlzi;

        zzb(FirebaseAuth firebaseAuth) {
            this.zzlzi = firebaseAuth;
            super(firebaseAuth);
        }

        @Override
        public final void onError(Status status) {
            if (status.getStatusCode() == 17011 || status.getStatusCode() == 17021 || status.getStatusCode() == 17005) {
                this.zzlzi.signOut();
            }
        }
    }

    class zza
    implements zzdwt {
        private /* synthetic */ FirebaseAuth zzlzi;

        zza(FirebaseAuth firebaseAuth) {
            this.zzlzi = firebaseAuth;
        }

        @Override
        public final void zza(@NonNull zzdwf zzdwf2, @NonNull FirebaseUser firebaseUser) {
            zzbq.checkNotNull((Object)((Object)zzdwf2));
            zzbq.checkNotNull((Object)firebaseUser);
            firebaseUser.zza(zzdwf2);
            this.zzlzi.zza(firebaseUser, zzdwf2, true);
        }
    }

    public static interface AuthStateListener {
        public void onAuthStateChanged(@NonNull FirebaseAuth var1);
    }

    public static interface IdTokenListener {
        public void onIdTokenChanged(@NonNull FirebaseAuth var1);
    }
}

