/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_auth;

import com.google.android.gms.internal.firebase_auth.zzbu;
import com.google.android.gms.internal.firebase_auth.zzcd;
import com.google.android.gms.internal.firebase_auth.zzce;
import com.google.android.gms.internal.firebase_auth.zzco;
import com.google.android.gms.internal.firebase_auth.zzdd;
import com.google.android.gms.internal.firebase_auth.zzdh;
import com.google.android.gms.internal.firebase_auth.zzeh;
import com.google.android.gms.internal.firebase_auth.zzer;
import com.google.android.gms.internal.firebase_auth.zzfz;
import java.io.IOException;
import java.util.Arrays;

final class zzcf
extends zzcd {
    private final byte[] buffer;
    private final boolean zzmq;
    private int limit;
    private int zzmr;
    private int pos;
    private int zzms;
    private int zzmt;
    private int zzmu = Integer.MAX_VALUE;

    private zzcf(byte[] byArray, int n, int n2, boolean bl) {
        super(null);
        this.buffer = byArray;
        this.limit = n + n2;
        this.zzms = this.pos = n;
        this.zzmq = bl;
    }

    @Override
    public final int zzbz() throws IOException {
        if (((zzcd)this).zzcp()) {
            this.zzmt = 0;
            return 0;
        }
        this.zzmt = this.zzcr();
        if (this.zzmt >>> 3 == 0) {
            throw new zzdh("Protocol message contained an invalid tag (zero).");
        }
        return this.zzmt;
    }

    @Override
    public final void zzl(int n) throws zzdh {
        if (this.zzmt != n) {
            throw zzdh.zzee();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean zzm(int n) throws IOException {
        switch (n & 7) {
            case 0: {
                zzcf zzcf2 = this;
                if (zzcf2.limit - zzcf2.pos >= 10) {
                    zzcf zzcf3 = zzcf2;
                    for (int i = 0; i < 10; ++i) {
                        if (zzcf3.buffer[zzcf3.pos++] >= 0) return true;
                    }
                    throw zzdh.zzed();
                }
                zzcf zzcf4 = zzcf2;
                for (int i = 0; i < 10; ++i) {
                    if (zzcf4.zzcw() >= 0) return true;
                }
                throw zzdh.zzed();
            }
            case 1: {
                ((zzcd)this).zzq(8);
                return true;
            }
            case 2: {
                ((zzcd)this).zzq(this.zzcr());
                return true;
            }
            case 3: {
                int n2;
                zzcf zzcf5 = this;
                while ((n2 = ((zzcd)zzcf5).zzbz()) != 0 && ((zzcd)zzcf5).zzm(n2)) {
                }
                ((zzcd)this).zzl(n >>> 3 << 3 | 4);
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                ((zzcd)this).zzq(4);
                return true;
            }
        }
        throw zzdh.zzef();
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.zzcu());
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.zzct());
    }

    @Override
    public final long zzca() throws IOException {
        return this.zzcs();
    }

    @Override
    public final long zzcb() throws IOException {
        return this.zzcs();
    }

    @Override
    public final int zzcc() throws IOException {
        return this.zzcr();
    }

    @Override
    public final long zzcd() throws IOException {
        return this.zzcu();
    }

    @Override
    public final int zzce() throws IOException {
        return this.zzct();
    }

    @Override
    public final boolean zzcf() throws IOException {
        return this.zzcs() != 0L;
    }

    @Override
    public final String readString() throws IOException {
        int n = this.zzcr();
        if (n > 0 && n <= this.limit - this.pos) {
            String string = new String(this.buffer, this.pos, n, zzdd.UTF_8);
            this.pos += n;
            return string;
        }
        if (n == 0) {
            return "";
        }
        if (n < 0) {
            throw zzdh.zzec();
        }
        throw zzdh.zzeb();
    }

    @Override
    public final String zzcg() throws IOException {
        int n = this.zzcr();
        if (n > 0 && n <= this.limit - this.pos) {
            if (!zzfz.zzf(this.buffer, this.pos, this.pos + n)) {
                throw new zzdh("Protocol message had invalid UTF-8.");
            }
            int n2 = this.pos;
            this.pos += n;
            return new String(this.buffer, n2, n, zzdd.UTF_8);
        }
        if (n == 0) {
            return "";
        }
        if (n <= 0) {
            throw zzdh.zzec();
        }
        throw zzdh.zzeb();
    }

    @Override
    public final <T extends zzeh> T zza(zzer<T> zzer2, zzco zzco2) throws IOException {
        int n = this.zzcr();
        if (this.zzmk >= this.zzml) {
            throw zzdh.zzeg();
        }
        int n2 = ((zzcd)this).zzo(n);
        ++this.zzmk;
        zzeh zzeh2 = (zzeh)zzer2.zza(this, zzco2);
        ((zzcd)this).zzl(0);
        --this.zzmk;
        ((zzcd)this).zzp(n2);
        return (T)zzeh2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final zzbu zzch() throws IOException {
        byte[] byArray;
        int n = this.zzcr();
        if (n > 0 && n <= this.limit - this.pos) {
            zzbu zzbu2 = zzbu.zzb(this.buffer, this.pos, n);
            this.pos += n;
            return zzbu2;
        }
        if (n == 0) {
            return zzbu.zzmc;
        }
        int n2 = n;
        zzcf zzcf2 = this;
        if (n2 > 0 && n2 <= zzcf2.limit - zzcf2.pos) {
            int n3 = zzcf2.pos;
            zzcf2.pos += n2;
            byArray = Arrays.copyOfRange(zzcf2.buffer, n3, zzcf2.pos);
            return zzbu.zza(byArray);
        } else {
            if (n2 > 0) throw zzdh.zzeb();
            if (n2 != 0) throw zzdh.zzec();
            byArray = zzdd.EMPTY_BYTE_ARRAY;
        }
        return zzbu.zza(byArray);
    }

    @Override
    public final int zzci() throws IOException {
        return this.zzcr();
    }

    @Override
    public final int zzcj() throws IOException {
        return this.zzcr();
    }

    @Override
    public final int zzck() throws IOException {
        return this.zzct();
    }

    @Override
    public final long zzcl() throws IOException {
        return this.zzcu();
    }

    @Override
    public final int zzcm() throws IOException {
        int n = this.zzcr();
        return n >>> 1 ^ -(n & 1);
    }

    @Override
    public final long zzcn() throws IOException {
        long l = this.zzcs();
        return l >>> 1 ^ -(l & 1L);
    }

    private final int zzcr() throws IOException {
        block4: {
            int n;
            int n2;
            block6: {
                byte[] byArray;
                block8: {
                    block7: {
                        block5: {
                            n2 = this.pos;
                            if (this.limit == n2) break block4;
                            byArray = this.buffer;
                            if ((n = this.buffer[n2++]) >= 0) {
                                this.pos = n2;
                                return n;
                            }
                            if (this.limit - n2 < 9) break block4;
                            if ((n ^= byArray[n2++] << 7) >= 0) break block5;
                            n ^= 0xFFFFFF80;
                            break block6;
                        }
                        if ((n ^= byArray[n2++] << 14) < 0) break block7;
                        n ^= 0x3F80;
                        break block6;
                    }
                    if ((n ^= byArray[n2++] << 21) >= 0) break block8;
                    n ^= 0xFFE03F80;
                    break block6;
                }
                byte by = byArray[n2++];
                n = n ^ by << 28 ^ 0xFE03F80;
                if (by < 0 && byArray[n2++] < 0 && byArray[n2++] < 0 && byArray[n2++] < 0 && byArray[n2++] < 0 && byArray[n2++] < 0) break block4;
            }
            this.pos = n2;
            return n;
        }
        return (int)((zzcd)this).zzco();
    }

    private final long zzcs() throws IOException {
        block4: {
            long l;
            int n;
            block6: {
                byte[] byArray;
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                int n2;
                                block8: {
                                    block7: {
                                        block5: {
                                            n = this.pos;
                                            if (this.limit == n) break block4;
                                            byArray = this.buffer;
                                            if ((n2 = this.buffer[n++]) >= 0) {
                                                this.pos = n;
                                                return n2;
                                            }
                                            if (this.limit - n < 9) break block4;
                                            if ((n2 ^= byArray[n++] << 7) >= 0) break block5;
                                            l = n2 ^ 0xFFFFFF80;
                                            break block6;
                                        }
                                        if ((n2 ^= byArray[n++] << 14) < 0) break block7;
                                        l = n2 ^ 0x3F80;
                                        break block6;
                                    }
                                    if ((n2 ^= byArray[n++] << 21) >= 0) break block8;
                                    l = n2 ^ 0xFFE03F80;
                                    break block6;
                                }
                                if ((l = (long)n2 ^ (long)byArray[n++] << 28) < 0L) break block9;
                                l ^= 0xFE03F80L;
                                break block6;
                            }
                            if ((l ^= (long)byArray[n++] << 35) >= 0L) break block10;
                            l ^= 0xFFFFFFF80FE03F80L;
                            break block6;
                        }
                        if ((l ^= (long)byArray[n++] << 42) < 0L) break block11;
                        l ^= 0x3F80FE03F80L;
                        break block6;
                    }
                    if ((l ^= (long)byArray[n++] << 49) >= 0L) break block12;
                    l ^= 0xFFFE03F80FE03F80L;
                    break block6;
                }
                if ((l = l ^ (long)byArray[n++] << 56 ^ 0xFE03F80FE03F80L) < 0L && (long)byArray[n++] < 0L) break block4;
            }
            this.pos = n;
            return l;
        }
        return ((zzcd)this).zzco();
    }

    @Override
    final long zzco() throws IOException {
        long l = 0L;
        for (int i = 0; i < 64; i += 7) {
            byte by = this.zzcw();
            l |= (long)(by & 0x7F) << i;
            if ((by & 0x80) != 0) continue;
            return l;
        }
        throw zzdh.zzed();
    }

    private final int zzct() throws IOException {
        int n = this.pos;
        if (this.limit - n < 4) {
            throw zzdh.zzeb();
        }
        byte[] byArray = this.buffer;
        this.pos = n + 4;
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    private final long zzcu() throws IOException {
        int n = this.pos;
        if (this.limit - n < 8) {
            throw zzdh.zzeb();
        }
        byte[] byArray = this.buffer;
        this.pos = n + 8;
        return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48 | ((long)byArray[n + 7] & 0xFFL) << 56;
    }

    @Override
    public final int zzo(int n) throws zzdh {
        int n2;
        if (n < 0) {
            throw zzdh.zzec();
        }
        if ((n += ((zzcd)this).zzcq()) > (n2 = this.zzmu)) {
            throw zzdh.zzeb();
        }
        this.zzmu = n;
        this.zzcv();
        return n2;
    }

    private final void zzcv() {
        this.limit += this.zzmr;
        int n = this.limit - this.zzms;
        if (n > this.zzmu) {
            this.zzmr = n - this.zzmu;
            this.limit -= this.zzmr;
            return;
        }
        this.zzmr = 0;
    }

    @Override
    public final void zzp(int n) {
        this.zzmu = n;
        this.zzcv();
    }

    @Override
    public final boolean zzcp() throws IOException {
        return this.pos == this.limit;
    }

    @Override
    public final int zzcq() {
        return this.pos - this.zzms;
    }

    private final byte zzcw() throws IOException {
        if (this.pos == this.limit) {
            throw zzdh.zzeb();
        }
        return this.buffer[this.pos++];
    }

    @Override
    public final void zzq(int n) throws IOException {
        if (n >= 0 && n <= this.limit - this.pos) {
            this.pos += n;
            return;
        }
        if (n < 0) {
            throw zzdh.zzec();
        }
        throw zzdh.zzeb();
    }

    /* synthetic */ zzcf(byte[] byArray, int n, int n2, boolean bl, zzce zzce2) {
        this(byArray, n, n2, bl);
    }
}

