/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_auth;

import com.google.android.gms.internal.firebase_auth.zzbn;
import com.google.android.gms.internal.firebase_auth.zzbt;
import com.google.android.gms.internal.firebase_auth.zzbu;
import com.google.android.gms.internal.firebase_auth.zzcj;
import com.google.android.gms.internal.firebase_auth.zzck;
import com.google.android.gms.internal.firebase_auth.zzdd;
import com.google.android.gms.internal.firebase_auth.zzdo;
import com.google.android.gms.internal.firebase_auth.zzeh;
import com.google.android.gms.internal.firebase_auth.zzex;
import com.google.android.gms.internal.firebase_auth.zzfx;
import com.google.android.gms.internal.firebase_auth.zzfz;
import com.google.android.gms.internal.firebase_auth.zzgc;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class zzci
extends zzbt {
    private static final Logger logger = Logger.getLogger(zzci.class.getName());
    private static final boolean zzmz = zzfx.zzgu();
    zzck zzna;

    public static zzci zzb(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        return new zza(byArray2, 0, n);
    }

    public static zzci zza(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            return new zzb(byteBuffer);
        }
        if (byteBuffer.isDirect() && !byteBuffer.isReadOnly()) {
            if (zzfx.zzgv()) {
                ByteBuffer byteBuffer2 = byteBuffer;
                return new zze(byteBuffer2);
            }
            ByteBuffer byteBuffer3 = byteBuffer;
            return new zzd(byteBuffer3);
        }
        throw new IllegalArgumentException("ByteBuffer is read-only");
    }

    private zzci() {
    }

    public abstract void zzb(int var1, int var2) throws IOException;

    public abstract void zzc(int var1, int var2) throws IOException;

    public abstract void zzd(int var1, int var2) throws IOException;

    public final void zze(int n, int n2) throws IOException {
        this.zzd(n, zzci.zzag(n2));
    }

    public abstract void zzf(int var1, int var2) throws IOException;

    public abstract void zza(int var1, long var2) throws IOException;

    public final void zzb(int n, long l) throws IOException {
        this.zza(n, zzci.zzi(l));
    }

    public abstract void zzc(int var1, long var2) throws IOException;

    public final void zza(int n, float f) throws IOException {
        this.zzf(n, Float.floatToRawIntBits(f));
    }

    public final void zza(int n, double d) throws IOException {
        this.zzc(n, Double.doubleToRawLongBits(d));
    }

    public abstract void zzb(int var1, boolean var2) throws IOException;

    public abstract void zza(int var1, String var2) throws IOException;

    public abstract void zza(int var1, zzbu var2) throws IOException;

    public abstract void zza(int var1, zzeh var2) throws IOException;

    abstract void zza(int var1, zzeh var2, zzex var3) throws IOException;

    public abstract void zzb(int var1, zzeh var2) throws IOException;

    public abstract void zzb(int var1, zzbu var2) throws IOException;

    public abstract void zzv(int var1) throws IOException;

    public abstract void zzw(int var1) throws IOException;

    public final void zzx(int n) throws IOException {
        this.zzw(zzci.zzag(n));
    }

    public abstract void zzy(int var1) throws IOException;

    public abstract void zza(long var1) throws IOException;

    public final void zzb(long l) throws IOException {
        this.zza(zzci.zzi(l));
    }

    public abstract void zzc(long var1) throws IOException;

    public final void zza(float f) throws IOException {
        this.zzy(Float.floatToRawIntBits(f));
    }

    public final void zza(double d) throws IOException {
        this.zzc(Double.doubleToRawLongBits(d));
    }

    public final void zzg(boolean bl) throws IOException {
        this.zza((byte)(bl ? 1 : 0));
    }

    public abstract void zzal(String var1) throws IOException;

    public abstract void zza(zzbu var1) throws IOException;

    public abstract void zzb(zzeh var1) throws IOException;

    abstract void zza(zzeh var1, zzex var2) throws IOException;

    public abstract void zza(byte var1) throws IOException;

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public static int zzg(int n, int n2) {
        return zzci.zzz(n) + zzci.zzaa(n2);
    }

    public static int zzh(int n, int n2) {
        return zzci.zzz(n) + zzci.zzab(n2);
    }

    public static int zzi(int n, int n2) {
        return zzci.zzz(n) + zzci.zzab(zzci.zzag(n2));
    }

    public static int zzj(int n, int n2) {
        return zzci.zzz(n) + 4;
    }

    public static int zzk(int n, int n2) {
        return zzci.zzz(n) + 4;
    }

    public static int zzd(int n, long l) {
        return zzci.zzz(n) + zzci.zze(l);
    }

    public static int zze(int n, long l) {
        return zzci.zzz(n) + zzci.zze(l);
    }

    public static int zzf(int n, long l) {
        return zzci.zzz(n) + zzci.zze(zzci.zzi(l));
    }

    public static int zzg(int n, long l) {
        return zzci.zzz(n) + 8;
    }

    public static int zzh(int n, long l) {
        return zzci.zzz(n) + 8;
    }

    public static int zzb(int n, float f) {
        return zzci.zzz(n) + 4;
    }

    public static int zzb(int n, double d) {
        return zzci.zzz(n) + 8;
    }

    public static int zzc(int n, boolean bl) {
        return zzci.zzz(n) + 1;
    }

    public static int zzl(int n, int n2) {
        return zzci.zzz(n) + zzci.zzaa(n2);
    }

    public static int zzb(int n, String string) {
        return zzci.zzz(n) + zzci.zzam(string);
    }

    public static int zzc(int n, zzbu zzbu2) {
        int n2 = zzbu2.size();
        return zzci.zzz(n) + (zzci.zzab(n2) + n2);
    }

    public static int zza(int n, zzdo zzdo2) {
        int n2 = zzdo2.zzdn();
        return zzci.zzz(n) + (zzci.zzab(n2) + n2);
    }

    public static int zzc(int n, zzeh zzeh2) {
        return zzci.zzz(n) + zzci.zzc(zzeh2);
    }

    static int zzb(int n, zzeh zzeh2, zzex zzex2) {
        return zzci.zzz(n) + zzci.zzb(zzeh2, zzex2);
    }

    public static int zzd(int n, zzeh zzeh2) {
        return (zzci.zzz(1) << 1) + zzci.zzh(2, n) + zzci.zzc(3, zzeh2);
    }

    public static int zzd(int n, zzbu zzbu2) {
        return (zzci.zzz(1) << 1) + zzci.zzh(2, n) + zzci.zzc(3, zzbu2);
    }

    public static int zzb(int n, zzdo zzdo2) {
        return (zzci.zzz(1) << 1) + zzci.zzh(2, n) + zzci.zza(3, zzdo2);
    }

    public static int zzz(int n) {
        return zzci.zzab(n << 3);
    }

    public static int zzaa(int n) {
        if (n >= 0) {
            return zzci.zzab(n);
        }
        return 10;
    }

    public static int zzab(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int zzac(int n) {
        return zzci.zzab(zzci.zzag(n));
    }

    public static int zzad(int n) {
        return 4;
    }

    public static int zzae(int n) {
        return 4;
    }

    public static int zzd(long l) {
        return zzci.zze(l);
    }

    public static int zze(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (l < 0L) {
            return 10;
        }
        int n = 2;
        if ((l & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            l >>>= 28;
        }
        if ((l & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            l >>>= 14;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    public static int zzf(long l) {
        return zzci.zze(zzci.zzi(l));
    }

    public static int zzg(long l) {
        return 8;
    }

    public static int zzh(long l) {
        return 8;
    }

    public static int zzb(float f) {
        return 4;
    }

    public static int zzb(double d) {
        return 8;
    }

    public static int zzh(boolean bl) {
        return 1;
    }

    public static int zzaf(int n) {
        return zzci.zzaa(n);
    }

    public static int zzam(String string) {
        int n;
        try {
            n = zzfz.zza(string);
        }
        catch (zzgc zzgc2) {
            n = string.getBytes(zzdd.UTF_8).length;
        }
        int n2 = n;
        return zzci.zzab(n2) + n2;
    }

    public static int zza(zzdo zzdo2) {
        int n = zzdo2.zzdn();
        return zzci.zzab(n) + n;
    }

    public static int zzb(zzbu zzbu2) {
        int n = zzbu2.size();
        return zzci.zzab(n) + n;
    }

    public static int zzc(byte[] byArray) {
        int n = byArray.length;
        return zzci.zzab(n) + n;
    }

    public static int zzc(zzeh zzeh2) {
        int n = zzeh2.zzdn();
        return zzci.zzab(n) + n;
    }

    static int zzb(zzeh zzeh2, zzex zzex2) {
        zzex zzex3 = zzex2;
        zzbn zzbn2 = (zzbn)zzeh2;
        int n = zzbn2.zzbm();
        if (n == -1) {
            n = zzex3.zzo(zzbn2);
            zzbn2.zzf(n);
        }
        int n2 = n;
        return zzci.zzab(n2) + n2;
    }

    private static int zzag(int n) {
        return n << 1 ^ n >> 31;
    }

    private static long zzi(long l) {
        return l << 1 ^ l >> 63;
    }

    public abstract void flush() throws IOException;

    public abstract int zzcz();

    abstract void zze(byte[] var1, int var2, int var3) throws IOException;

    final void zza(String string, zzgc zzgc2) throws IOException {
        logger.logp(Level.WARNING, "com.google.protobuf.CodedOutputStream", "inefficientWriteStringNoTag", "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", zzgc2);
        byte[] byArray = string.getBytes(zzdd.UTF_8);
        try {
            this.zzw(byArray.length);
            this.zza(byArray, 0, byArray.length);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new zzc(indexOutOfBoundsException);
        }
        catch (zzc zzc2) {
            throw zzc2;
        }
    }

    @Deprecated
    static int zzc(int n, zzeh zzeh2, zzex zzex2) {
        zzex zzex3;
        int n2 = zzci.zzz(n) << 1;
        zzex zzex4 = zzex3 = zzex2;
        zzbn zzbn2 = (zzbn)zzeh2;
        int n3 = zzbn2.zzbm();
        if (n3 == -1) {
            n3 = zzex4.zzo(zzbn2);
            zzbn2.zzf(n3);
        }
        return n2 + n3;
    }

    @Deprecated
    public static int zzd(zzeh zzeh2) {
        return zzeh2.zzdn();
    }

    @Deprecated
    public static int zzah(int n) {
        return zzci.zzab(n);
    }

    /* synthetic */ zzci(zzcj zzcj2) {
        this();
    }

    static final class zze
    extends zzci {
        private final ByteBuffer zznd;
        private final ByteBuffer zzne;
        private final long zznf;
        private final long zzng;
        private final long zznh;
        private final long zzni;
        private long zznj;

        zze(ByteBuffer byteBuffer) {
            super(null);
            this.zznd = byteBuffer;
            this.zzne = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zznf = zzfx.zzb(byteBuffer);
            this.zzng = this.zznf + (long)byteBuffer.position();
            this.zznh = this.zznf + (long)byteBuffer.limit();
            this.zzni = this.zznh - 10L;
            this.zznj = this.zzng;
        }

        @Override
        public final void zzb(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzci)this).zzw(n << 3 | n3);
        }

        @Override
        public final void zzc(int n, int n2) throws IOException {
            ((zzci)this).zzb(n, 0);
            ((zzci)this).zzv(n2);
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            ((zzci)this).zzb(n, 0);
            ((zzci)this).zzw(n2);
        }

        @Override
        public final void zzf(int n, int n2) throws IOException {
            ((zzci)this).zzb(n, 5);
            ((zzci)this).zzy(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzci)this).zzb(n, 0);
            ((zzci)this).zza(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzci)this).zzb(n, 1);
            ((zzci)this).zzc(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzci)this).zzb(n, 0);
            ((zzci)this).zza((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zza(int n, String string) throws IOException {
            ((zzci)this).zzb(n, 2);
            ((zzci)this).zzal(string);
        }

        @Override
        public final void zza(int n, zzbu zzbu2) throws IOException {
            ((zzci)this).zzb(n, 2);
            ((zzci)this).zza(zzbu2);
        }

        @Override
        public final void zza(int n, zzeh zzeh2) throws IOException {
            ((zzci)this).zzb(n, 2);
            ((zzci)this).zzb(zzeh2);
        }

        @Override
        final void zza(int n, zzeh zzeh2, zzex zzex2) throws IOException {
            ((zzci)this).zzb(n, 2);
            ((zzci)this).zza(zzeh2, zzex2);
        }

        @Override
        public final void zzb(int n, zzeh zzeh2) throws IOException {
            ((zzci)this).zzb(1, 3);
            ((zzci)this).zzd(2, n);
            ((zzci)this).zza(3, zzeh2);
            ((zzci)this).zzb(1, 4);
        }

        @Override
        public final void zzb(int n, zzbu zzbu2) throws IOException {
            ((zzci)this).zzb(1, 3);
            ((zzci)this).zzd(2, n);
            ((zzci)this).zza(3, zzbu2);
            ((zzci)this).zzb(1, 4);
        }

        @Override
        public final void zzb(zzeh zzeh2) throws IOException {
            ((zzci)this).zzw(zzeh2.zzdn());
            zzeh2.zzb(this);
        }

        @Override
        final void zza(zzeh zzeh2, zzex zzex2) throws IOException {
            zzex zzex3 = zzex2;
            zzbn zzbn2 = (zzbn)zzeh2;
            int n = zzbn2.zzbm();
            if (n == -1) {
                n = zzex3.zzo(zzbn2);
                zzbn2.zzf(n);
            }
            ((zzci)this).zzw(n);
            zzex2.zza(zzeh2, this.zzna);
        }

        @Override
        public final void zza(byte by) throws IOException {
            if (this.zznj >= this.zznh) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zznj, this.zznh, 1));
            }
            zzfx.zza(this.zznj++, by);
        }

        @Override
        public final void zza(zzbu zzbu2) throws IOException {
            ((zzci)this).zzw(zzbu2.size());
            zzbu2.zza(this);
        }

        @Override
        public final void zze(byte[] byArray, int n, int n2) throws IOException {
            ((zzci)this).zzw(n2);
            ((zzci)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzv(int n) throws IOException {
            if (n >= 0) {
                ((zzci)this).zzw(n);
                return;
            }
            ((zzci)this).zza(n);
        }

        @Override
        public final void zzw(int n) throws IOException {
            if (this.zznj <= this.zzni) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzfx.zza(this.zznj++, (byte)n);
                        return;
                    }
                    zzfx.zza(this.zznj++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            while (this.zznj < this.zznh) {
                if ((n & 0xFFFFFF80) == 0) {
                    zzfx.zza(this.zznj++, (byte)n);
                    return;
                }
                zzfx.zza(this.zznj++, (byte)(n & 0x7F | 0x80));
                n >>>= 7;
            }
            throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zznj, this.zznh, 1));
        }

        @Override
        public final void zzy(int n) throws IOException {
            long l = this.zznj;
            zze zze2 = this;
            this.zzne.putInt((int)(l - zze2.zznf), n);
            this.zznj += 4L;
        }

        @Override
        public final void zza(long l) throws IOException {
            if (this.zznj <= this.zzni) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzfx.zza(this.zznj++, (byte)l);
                        return;
                    }
                    zzfx.zza(this.zznj++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            while (this.zznj < this.zznh) {
                if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    zzfx.zza(this.zznj++, (byte)l);
                    return;
                }
                zzfx.zza(this.zznj++, (byte)((int)l & 0x7F | 0x80));
                l >>>= 7;
            }
            throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zznj, this.zznh, 1));
        }

        @Override
        public final void zzc(long l) throws IOException {
            long l2 = this.zznj;
            zze zze2 = this;
            this.zzne.putLong((int)(l2 - zze2.zznf), l);
            this.zznj += 8L;
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null || n < 0 || n2 < 0 || byArray.length - n2 < n || this.zznh - (long)n2 < this.zznj) {
                if (byArray == null) {
                    throw new NullPointerException("value");
                }
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zznj, this.zznh, n2));
            }
            zzfx.zza(byArray, n, this.zznj, n2);
            this.zznj += (long)n2;
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzci)this).write(byArray, n, n2);
        }

        @Override
        public final void zzal(String string) throws IOException {
            long l = this.zznj;
            try {
                int n = zze.zzab(string.length() * 3);
                int n2 = zze.zzab(string.length());
                if (n2 == n) {
                    long l2 = this.zznj;
                    zze zze2 = this;
                    int n3 = (int)(l2 - zze2.zznf) + n2;
                    this.zzne.position(n3);
                    zzfz.zza(string, this.zzne);
                    int n4 = this.zzne.position() - n3;
                    ((zzci)this).zzw(n4);
                    this.zznj += (long)n4;
                    return;
                }
                int n5 = zzfz.zza(string);
                ((zzci)this).zzw(n5);
                this.zzj(this.zznj);
                zzfz.zza(string, this.zzne);
                this.zznj += (long)n5;
                return;
            }
            catch (zzgc zzgc2) {
                this.zznj = l;
                this.zzj(this.zznj);
                this.zza(string, zzgc2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzc(illegalArgumentException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }

        @Override
        public final void flush() {
            long l = this.zznj;
            zze zze2 = this;
            this.zznd.position((int)(l - zze2.zznf));
        }

        @Override
        public final int zzcz() {
            return (int)(this.zznh - this.zznj);
        }

        private final void zzj(long l) {
            long l2 = l;
            zze zze2 = this;
            this.zzne.position((int)(l2 - zze2.zznf));
        }
    }

    static final class zzd
    extends zzci {
        private final ByteBuffer zznd;
        private final ByteBuffer zzne;
        private final int zznc;

        zzd(ByteBuffer byteBuffer) {
            super(null);
            this.zznd = byteBuffer;
            this.zzne = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zznc = byteBuffer.position();
        }

        @Override
        public final void zzb(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzci)this).zzw(n << 3 | n3);
        }

        @Override
        public final void zzc(int n, int n2) throws IOException {
            ((zzci)this).zzb(n, 0);
            ((zzci)this).zzv(n2);
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            ((zzci)this).zzb(n, 0);
            ((zzci)this).zzw(n2);
        }

        @Override
        public final void zzf(int n, int n2) throws IOException {
            ((zzci)this).zzb(n, 5);
            ((zzci)this).zzy(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzci)this).zzb(n, 0);
            ((zzci)this).zza(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzci)this).zzb(n, 1);
            ((zzci)this).zzc(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzci)this).zzb(n, 0);
            ((zzci)this).zza((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zza(int n, String string) throws IOException {
            ((zzci)this).zzb(n, 2);
            ((zzci)this).zzal(string);
        }

        @Override
        public final void zza(int n, zzbu zzbu2) throws IOException {
            ((zzci)this).zzb(n, 2);
            ((zzci)this).zza(zzbu2);
        }

        @Override
        public final void zza(int n, zzeh zzeh2) throws IOException {
            ((zzci)this).zzb(n, 2);
            ((zzci)this).zzb(zzeh2);
        }

        @Override
        final void zza(int n, zzeh zzeh2, zzex zzex2) throws IOException {
            ((zzci)this).zzb(n, 2);
            ((zzci)this).zza(zzeh2, zzex2);
        }

        @Override
        public final void zzb(int n, zzeh zzeh2) throws IOException {
            ((zzci)this).zzb(1, 3);
            ((zzci)this).zzd(2, n);
            ((zzci)this).zza(3, zzeh2);
            ((zzci)this).zzb(1, 4);
        }

        @Override
        public final void zzb(int n, zzbu zzbu2) throws IOException {
            ((zzci)this).zzb(1, 3);
            ((zzci)this).zzd(2, n);
            ((zzci)this).zza(3, zzbu2);
            ((zzci)this).zzb(1, 4);
        }

        @Override
        public final void zzb(zzeh zzeh2) throws IOException {
            ((zzci)this).zzw(zzeh2.zzdn());
            zzeh2.zzb(this);
        }

        @Override
        final void zza(zzeh zzeh2, zzex zzex2) throws IOException {
            zzex zzex3 = zzex2;
            zzbn zzbn2 = (zzbn)zzeh2;
            int n = zzbn2.zzbm();
            if (n == -1) {
                n = zzex3.zzo(zzbn2);
                zzbn2.zzf(n);
            }
            ((zzci)this).zzw(n);
            zzex2.zza(zzeh2, this.zzna);
        }

        @Override
        public final void zza(byte by) throws IOException {
            try {
                this.zzne.put(by);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zza(zzbu zzbu2) throws IOException {
            ((zzci)this).zzw(zzbu2.size());
            zzbu2.zza(this);
        }

        @Override
        public final void zze(byte[] byArray, int n, int n2) throws IOException {
            ((zzci)this).zzw(n2);
            ((zzci)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzv(int n) throws IOException {
            if (n >= 0) {
                ((zzci)this).zzw(n);
                return;
            }
            ((zzci)this).zza(n);
        }

        @Override
        public final void zzw(int n) throws IOException {
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.zzne.put((byte)n);
                        return;
                    }
                    this.zzne.put((byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzy(int n) throws IOException {
            try {
                this.zzne.putInt(n);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zza(long l) throws IOException {
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.zzne.put((byte)l);
                        return;
                    }
                    this.zzne.put((byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzc(long l) throws IOException {
            try {
                this.zzne.putLong(l);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.zzne.put(byArray, n, n2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzci)this).write(byArray, n, n2);
        }

        @Override
        public final void zzal(String string) throws IOException {
            int n = this.zzne.position();
            try {
                int n2 = zzd.zzab(string.length() * 3);
                int n3 = zzd.zzab(string.length());
                if (n3 == n2) {
                    int n4 = this.zzne.position() + n3;
                    this.zzne.position(n4);
                    this.zzan(string);
                    int n5 = this.zzne.position();
                    this.zzne.position(n);
                    ((zzci)this).zzw(n5 - n4);
                    this.zzne.position(n5);
                    return;
                }
                int n6 = zzfz.zza(string);
                ((zzci)this).zzw(n6);
                this.zzan(string);
                return;
            }
            catch (zzgc zzgc2) {
                this.zzne.position(n);
                this.zza(string, zzgc2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzc(illegalArgumentException);
            }
        }

        @Override
        public final void flush() {
            this.zznd.position(this.zzne.position());
        }

        @Override
        public final int zzcz() {
            return this.zzne.remaining();
        }

        private final void zzan(String string) throws IOException {
            try {
                zzfz.zza(string, this.zzne);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }
    }

    static final class zzb
    extends zza {
        private final ByteBuffer zznb;
        private int zznc;

        zzb(ByteBuffer byteBuffer) {
            super(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            this.zznb = byteBuffer;
            this.zznc = byteBuffer.position();
        }

        @Override
        public final void flush() {
            this.zznb.position(this.zznc + this.zzdb());
        }
    }

    static class zza
    extends zzci {
        private final byte[] buffer;
        private final int offset;
        private final int limit;
        private int position;

        zza(byte[] byArray, int n, int n2) {
            super(null);
            if (byArray == null) {
                throw new NullPointerException("buffer");
            }
            if ((n | n2 | byArray.length - (n + n2)) < 0) {
                throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", byArray.length, n, n2));
            }
            this.buffer = byArray;
            this.offset = n;
            this.position = n;
            this.limit = n + n2;
        }

        @Override
        public final void zzb(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzci)this).zzw(n << 3 | n3);
        }

        @Override
        public final void zzc(int n, int n2) throws IOException {
            ((zzci)this).zzb(n, 0);
            ((zzci)this).zzv(n2);
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            ((zzci)this).zzb(n, 0);
            ((zzci)this).zzw(n2);
        }

        @Override
        public final void zzf(int n, int n2) throws IOException {
            ((zzci)this).zzb(n, 5);
            ((zzci)this).zzy(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzci)this).zzb(n, 0);
            ((zzci)this).zza(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzci)this).zzb(n, 1);
            ((zzci)this).zzc(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzci)this).zzb(n, 0);
            ((zzci)this).zza((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zza(int n, String string) throws IOException {
            ((zzci)this).zzb(n, 2);
            ((zzci)this).zzal(string);
        }

        @Override
        public final void zza(int n, zzbu zzbu2) throws IOException {
            ((zzci)this).zzb(n, 2);
            ((zzci)this).zza(zzbu2);
        }

        @Override
        public final void zza(zzbu zzbu2) throws IOException {
            ((zzci)this).zzw(zzbu2.size());
            zzbu2.zza(this);
        }

        @Override
        public final void zze(byte[] byArray, int n, int n2) throws IOException {
            ((zzci)this).zzw(n2);
            ((zzci)this).write(byArray, 0, n2);
        }

        @Override
        public final void zza(int n, zzeh zzeh2) throws IOException {
            ((zzci)this).zzb(n, 2);
            ((zzci)this).zzb(zzeh2);
        }

        @Override
        final void zza(int n, zzeh zzeh2, zzex zzex2) throws IOException {
            ((zzci)this).zzb(n, 2);
            zzex zzex3 = zzex2;
            zzbn zzbn2 = (zzbn)zzeh2;
            int n2 = zzbn2.zzbm();
            if (n2 == -1) {
                n2 = zzex3.zzo(zzbn2);
                zzbn2.zzf(n2);
            }
            ((zzci)this).zzw(n2);
            zzex2.zza(zzeh2, this.zzna);
        }

        @Override
        public final void zzb(int n, zzeh zzeh2) throws IOException {
            ((zzci)this).zzb(1, 3);
            ((zzci)this).zzd(2, n);
            ((zzci)this).zza(3, zzeh2);
            ((zzci)this).zzb(1, 4);
        }

        @Override
        public final void zzb(int n, zzbu zzbu2) throws IOException {
            ((zzci)this).zzb(1, 3);
            ((zzci)this).zzd(2, n);
            ((zzci)this).zza(3, zzbu2);
            ((zzci)this).zzb(1, 4);
        }

        @Override
        public final void zzb(zzeh zzeh2) throws IOException {
            ((zzci)this).zzw(zzeh2.zzdn());
            zzeh2.zzb(this);
        }

        @Override
        final void zza(zzeh zzeh2, zzex zzex2) throws IOException {
            zzex zzex3 = zzex2;
            zzbn zzbn2 = (zzbn)zzeh2;
            int n = zzbn2.zzbm();
            if (n == -1) {
                n = zzex3.zzo(zzbn2);
                zzbn2.zzf(n);
            }
            ((zzci)this).zzw(n);
            zzex2.zza(zzeh2, this.zzna);
        }

        @Override
        public final void zza(byte by) throws IOException {
            try {
                this.buffer[this.position++] = by;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzv(int n) throws IOException {
            if (n >= 0) {
                ((zzci)this).zzw(n);
                return;
            }
            ((zzci)this).zza(n);
        }

        @Override
        public final void zzw(int n) throws IOException {
            if (zzmz && ((zzci)this).zzcz() >= 10) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzfx.zza(this.buffer, (long)this.position++, (byte)n);
                        return;
                    }
                    zzfx.zza(this.buffer, (long)this.position++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.buffer[this.position++] = (byte)n;
                        return;
                    }
                    this.buffer[this.position++] = (byte)(n & 0x7F | 0x80);
                    n >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzy(int n) throws IOException {
            try {
                this.buffer[this.position++] = (byte)n;
                this.buffer[this.position++] = (byte)(n >> 8);
                this.buffer[this.position++] = (byte)(n >> 16);
                this.buffer[this.position++] = n >> 24;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zza(long l) throws IOException {
            if (zzmz && ((zzci)this).zzcz() >= 10) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzfx.zza(this.buffer, (long)this.position++, (byte)l);
                        return;
                    }
                    zzfx.zza(this.buffer, (long)this.position++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)l;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)l & 0x7F | 0x80);
                    l >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzc(long l) throws IOException {
            try {
                this.buffer[this.position++] = (byte)l;
                this.buffer[this.position++] = (byte)(l >> 8);
                this.buffer[this.position++] = (byte)(l >> 16);
                this.buffer[this.position++] = (byte)(l >> 24);
                this.buffer[this.position++] = (byte)(l >> 32);
                this.buffer[this.position++] = (byte)(l >> 40);
                this.buffer[this.position++] = (byte)(l >> 48);
                this.buffer[this.position++] = (byte)(l >> 56);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                System.arraycopy(byArray, n, this.buffer, this.position, n2);
                this.position += n2;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, n2), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzci)this).write(byArray, n, n2);
        }

        @Override
        public final void zzal(String string) throws IOException {
            int n = this.position;
            try {
                int n2 = zza.zzab(string.length() * 3);
                int n3 = zza.zzab(string.length());
                if (n3 == n2) {
                    this.position = n + n3;
                    int n4 = zzfz.zza(string, this.buffer, this.position, ((zzci)this).zzcz());
                    this.position = n;
                    int n5 = n4 - n - n3;
                    ((zzci)this).zzw(n5);
                    this.position = n4;
                    return;
                }
                int n6 = zzfz.zza(string);
                ((zzci)this).zzw(n6);
                this.position = zzfz.zza(string, this.buffer, this.position, ((zzci)this).zzcz());
                return;
            }
            catch (zzgc zzgc2) {
                this.position = n;
                this.zza(string, zzgc2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public final int zzcz() {
            return this.limit - this.position;
        }

        public final int zzdb() {
            return this.position - this.offset;
        }
    }

    public static final class zzc
    extends IOException {
        zzc() {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.");
        }

        zzc(String string) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        }

        zzc(Throwable throwable) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.", throwable);
        }

        zzc(String string, Throwable throwable) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2), throwable);
        }
    }
}

