/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.firebase_auth.zzax;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.EmailAuthProvider;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.SignInMethodQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.api.internal.zzao;
import com.google.firebase.auth.api.internal.zzce;
import com.google.firebase.auth.api.internal.zzcn;
import com.google.firebase.auth.api.internal.zzcp;
import com.google.firebase.auth.api.internal.zzcq;
import com.google.firebase.auth.api.internal.zzcw;
import com.google.firebase.auth.internal.zzaa;
import com.google.firebase.auth.internal.zzac;
import com.google.firebase.auth.internal.zzad;
import com.google.firebase.auth.internal.zzf;
import com.google.firebase.auth.internal.zzk;
import com.google.firebase.auth.internal.zzv;
import com.google.firebase.auth.internal.zzx;
import com.google.firebase.auth.internal.zzz;
import com.google.firebase.auth.zzi;
import com.google.firebase.auth.zzj;
import com.google.firebase.auth.zzl;
import com.google.firebase.auth.zzm;
import com.google.firebase.auth.zzn;
import com.google.firebase.internal.InternalTokenProvider;
import com.google.firebase.internal.InternalTokenResult;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class FirebaseAuth
implements InternalTokenProvider {
    private FirebaseApp zzdz;
    private List<IdTokenListener> zzea;
    private List<AuthStateListener> zzeb;
    private zzao zzec;
    private FirebaseUser zzed;
    private final Object zzee;
    private String zzef;
    private zzz zzeg;
    private zzaa zzeh;
    private zzac zzei;
    private static Map<String, FirebaseAuth> zzej = new ArrayMap();
    private static FirebaseAuth zzek;

    @Keep
    public static FirebaseAuth getInstance() {
        return FirebaseAuth.zza(FirebaseApp.getInstance());
    }

    @Keep
    public static FirebaseAuth getInstance(@NonNull FirebaseApp firebaseApp) {
        return FirebaseAuth.zza(firebaseApp);
    }

    public FirebaseAuth(FirebaseApp firebaseApp) {
        FirebaseApp firebaseApp2 = firebaseApp;
        zzcp zzcp2 = new zzcq(firebaseApp2.getOptions().getApiKey()).zzaf();
        this(firebaseApp, zzcn.zza(firebaseApp2.getApplicationContext(), zzcp2), new zzz(firebaseApp.getApplicationContext(), firebaseApp.getPersistenceKey()));
    }

    @VisibleForTesting
    private FirebaseAuth(FirebaseApp firebaseApp, zzao zzao2, zzz zzz2) {
        com.google.android.gms.internal.firebase_auth.zzao zzao3;
        this.zzee = new Object();
        this.zzdz = (FirebaseApp)Preconditions.checkNotNull((Object)firebaseApp);
        this.zzec = (zzao)Preconditions.checkNotNull((Object)zzao2);
        this.zzeg = (zzz)Preconditions.checkNotNull((Object)zzz2);
        this.zzea = new CopyOnWriteArrayList<IdTokenListener>();
        this.zzeb = new CopyOnWriteArrayList<AuthStateListener>();
        this.zzei = zzac.zzbk();
        FirebaseAuth firebaseAuth = this;
        firebaseAuth.zzed = firebaseAuth.zzeg.zzbi();
        if (firebaseAuth.zzed != null && (zzao3 = firebaseAuth.zzeg.zzh(firebaseAuth.zzed)) != null) {
            firebaseAuth.zza(firebaseAuth.zzed, zzao3, false);
        }
    }

    @Nullable
    public FirebaseUser getCurrentUser() {
        return this.zzed;
    }

    @Nullable
    public String getUid() {
        if (this.zzed == null) {
            return null;
        }
        return this.zzed.getUid();
    }

    public final void zza(@NonNull FirebaseUser firebaseUser, @NonNull com.google.android.gms.internal.firebase_auth.zzao zzao2, boolean bl) {
        boolean bl2;
        boolean bl3;
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)zzao2);
        if (this.zzed == null) {
            bl3 = true;
            bl2 = true;
        } else {
            String string;
            String string2 = this.zzed.zzn().zzau();
            boolean bl4 = !string2.equals(string = zzao2.zzau());
            boolean bl5 = this.zzed.getUid().equals(firebaseUser.getUid());
            bl3 = !bl5 || bl4;
            bl2 = !bl5;
        }
        boolean bl6 = bl2;
        boolean bl7 = bl;
        FirebaseUser firebaseUser2 = firebaseUser;
        FirebaseAuth firebaseAuth = this;
        Preconditions.checkNotNull((Object)firebaseUser2);
        if (firebaseAuth.zzed == null) {
            firebaseAuth.zzed = firebaseUser2;
        } else {
            firebaseAuth.zzed.zza(firebaseUser2.isAnonymous());
            firebaseAuth.zzed.zza(firebaseUser2.getProviderData());
        }
        if (bl7) {
            firebaseAuth.zzeg.zzg(firebaseAuth.zzed);
        }
        if (bl3) {
            if (this.zzed != null) {
                this.zzed.zza(zzao2);
            }
            this.zzb(this.zzed);
        }
        if (bl6) {
            this.zzc(this.zzed);
        }
        if (bl) {
            this.zzeg.zza(firebaseUser, zzao2);
        }
        firebaseAuth = this;
        firebaseAuth.zzk().zzc(firebaseAuth.zzed.zzn());
    }

    public final void zzj() {
        if (this.zzed != null) {
            FirebaseUser firebaseUser = this.zzed;
            zzz zzz2 = this.zzeg;
            Preconditions.checkNotNull((Object)firebaseUser);
            zzz2.clear(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()));
            this.zzed = null;
        }
        this.zzeg.clear("com.google.firebase.auth.FIREBASE_USER");
        this.zzb(null);
        this.zzc(null);
    }

    @VisibleForTesting
    private final synchronized void zza(zzaa zzaa2) {
        this.zzeh = zzaa2;
        this.zzdz.setIdTokenListenersCountChangedListener((FirebaseApp.IdTokenListenersCountChangedListener)zzaa2);
    }

    @VisibleForTesting
    private final synchronized zzaa zzk() {
        if (this.zzeh == null) {
            this.zza(new zzaa(this.zzdz));
        }
        return this.zzeh;
    }

    public FirebaseApp getApp() {
        return this.zzdz;
    }

    private static synchronized FirebaseAuth zza(@NonNull FirebaseApp firebaseApp) {
        String string = firebaseApp.getPersistenceKey();
        FirebaseAuth firebaseAuth = zzej.get(string);
        if (firebaseAuth == null) {
            firebaseAuth = new com.google.firebase.auth.internal.zzj(firebaseApp);
            firebaseApp.setTokenProvider((InternalTokenProvider)firebaseAuth);
            if (zzek == null) {
                zzek = firebaseAuth;
            }
            zzej.put(string, firebaseAuth);
            return firebaseAuth;
        }
        return firebaseAuth;
    }

    public void addIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzea.add(idTokenListener);
        this.zzei.execute(new zzi(this, idTokenListener));
    }

    public void removeIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzea.remove(idTokenListener);
    }

    public void addAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzeb.add(authStateListener);
        this.zzei.execute(new zzj(this, authStateListener));
    }

    public void removeAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzeb.remove(authStateListener);
    }

    private final void zzb(@Nullable FirebaseUser firebaseUser) {
        String string;
        if (firebaseUser != null) {
            string = firebaseUser.getUid();
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(45 + String.valueOf(string).length()).append("Notifying id token listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying id token listeners about a sign-out event.");
        }
        string = firebaseUser != null ? firebaseUser.zzp() : null;
        InternalTokenResult internalTokenResult = new InternalTokenResult(string);
        this.zzei.execute(new com.google.firebase.auth.zzk(this, internalTokenResult));
    }

    private final void zzc(@Nullable FirebaseUser firebaseUser) {
        if (firebaseUser != null) {
            String string = firebaseUser.getUid();
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(47 + String.valueOf(string).length()).append("Notifying auth state listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying auth state listeners about a sign-out event.");
        }
        this.zzei.execute(new zzl(this));
    }

    @NonNull
    public Task<GetTokenResult> getAccessToken(boolean bl) {
        return this.zza(this.zzed, bl);
    }

    @NonNull
    public final Task<GetTokenResult> zza(@Nullable FirebaseUser firebaseUser, boolean bl) {
        if (firebaseUser == null) {
            return Tasks.forException((Exception)zzce.zzb(new Status(17495)));
        }
        com.google.android.gms.internal.firebase_auth.zzao zzao2 = this.zzed.zzn();
        if (zzao2.isValid() && !bl) {
            return Tasks.forResult((Object)zzx.zzag(zzao2.zzau()));
        }
        return this.zzec.zza(this.zzdz, firebaseUser, zzao2.zzan(), (zzad)((Object)new zzm(this)));
    }

    @NonNull
    public Task<AuthResult> signInWithCredential(@NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)((Object)authCredential));
        if (authCredential instanceof EmailAuthCredential) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            if (!emailAuthCredential.zzi()) {
                return this.zzec.zzb(this.zzdz, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), new zza());
            }
            return this.zzec.zza(this.zzdz, emailAuthCredential, (com.google.firebase.auth.internal.zza)new zza());
        }
        if (authCredential instanceof PhoneAuthCredential) {
            PhoneAuthCredential phoneAuthCredential = (PhoneAuthCredential)authCredential;
            return this.zzec.zza(this.zzdz, phoneAuthCredential, (com.google.firebase.auth.internal.zza)new zza());
        }
        return this.zzec.zza(this.zzdz, authCredential, (com.google.firebase.auth.internal.zza)new zza());
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)((Object)authCredential));
        if (EmailAuthCredential.class.isAssignableFrom(((Object)((Object)authCredential)).getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            if ("password".equals(((AuthCredential)emailAuthCredential).getSignInMethod())) {
                return this.zzec.zza(this.zzdz, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (zzad)((Object)new zzb()));
            }
            return this.zzec.zza(this.zzdz, firebaseUser, emailAuthCredential, (zzad)((Object)new zzb()));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zzec.zzb(this.zzdz, firebaseUser, (PhoneAuthCredential)authCredential, (zzad)((Object)new zzb()));
        }
        return this.zzec.zza(this.zzdz, firebaseUser, authCredential, (zzad)((Object)new zzb()));
    }

    public final Task<AuthResult> zzb(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)((Object)authCredential));
        if (EmailAuthCredential.class.isAssignableFrom(((Object)((Object)authCredential)).getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            if ("password".equals(((AuthCredential)emailAuthCredential).getSignInMethod())) {
                return this.zzec.zzb(this.zzdz, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (zzad)((Object)new zzb()));
            }
            return this.zzec.zzb(this.zzdz, firebaseUser, emailAuthCredential, (zzad)((Object)new zzb()));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zzec.zzc(this.zzdz, firebaseUser, authCredential, (zzad)((Object)new zzb()));
        }
        return this.zzec.zzb(this.zzdz, firebaseUser, authCredential, (zzad)((Object)new zzb()));
    }

    @NonNull
    public Task<AuthResult> signInWithCustomToken(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zzec.zza(this.zzdz, string, (com.google.firebase.auth.internal.zza)new zza());
    }

    @NonNull
    public Task<AuthResult> signInWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        return this.zzec.zzb(this.zzdz, string, string2, new zza());
    }

    @NonNull
    public Task<AuthResult> signInWithEmailLink(@NonNull String string, @NonNull String string2) {
        return this.signInWithCredential(EmailAuthProvider.getCredentialWithLink(string, string2));
    }

    @NonNull
    public Task<AuthResult> signInAnonymously() {
        if (this.zzed != null && this.zzed.isAnonymous()) {
            zzk zzk2 = (zzk)this.zzed;
            zzk2.zzf(false);
            return Tasks.forResult((Object)new zzf(zzk2));
        }
        return this.zzec.zza(this.zzdz, new zza());
    }

    @NonNull
    public final void zza(@NonNull String string, long l, TimeUnit timeUnit, @NonNull PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks, @Nullable Activity activity, @NonNull Executor executor, boolean bl) {
        long l2 = TimeUnit.SECONDS.convert(l, timeUnit);
        if (l2 < 0L || l2 > 120L) {
            throw new IllegalArgumentException("We only support 0-120 seconds for sms-auto-retrieval timeout");
        }
        zzax zzax2 = new zzax(string, l2, bl, this.zzef);
        this.zzec.zza(this.zzdz, zzax2, onVerificationStateChangedCallbacks, activity, executor);
    }

    public final Task<Void> zzd(@NonNull FirebaseUser firebaseUser) {
        zzb zzb2 = new zzb();
        FirebaseUser firebaseUser2 = firebaseUser;
        FirebaseAuth firebaseAuth = this;
        Preconditions.checkNotNull((Object)firebaseUser2);
        return firebaseAuth.zzec.zza(firebaseAuth.zzdz, firebaseUser2, (zzad)((Object)zzb2));
    }

    @NonNull
    public final Task<AuthResult> zzc(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)((Object)authCredential));
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zzec.zzd(this.zzdz, firebaseUser, authCredential, (zzad)((Object)new zzb()));
    }

    @NonNull
    public final Task<AuthResult> zza(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zzec.zzd(this.zzdz, firebaseUser, string, (zzad)((Object)new zzb()));
    }

    @NonNull
    public Task<AuthResult> createUserWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        return this.zzec.zza(this.zzdz, string, string2, new zza());
    }

    @Deprecated
    @NonNull
    public Task<ProviderQueryResult> fetchProvidersForEmail(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zzec.zza(this.zzdz, string);
    }

    @NonNull
    public Task<SignInMethodQueryResult> fetchSignInMethodsForEmail(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zzec.zzb(this.zzdz, string);
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)((Object)userProfileChangeRequest));
        return this.zzec.zza(this.zzdz, firebaseUser, userProfileChangeRequest, (zzad)((Object)new zzb()));
    }

    @NonNull
    public final Task<Void> zzb(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotEmpty((String)string);
        return this.zzec.zzb(this.zzdz, firebaseUser, string, (zzad)((Object)new zzb()));
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull PhoneAuthCredential phoneAuthCredential) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)phoneAuthCredential);
        return this.zzec.zza(this.zzdz, firebaseUser, phoneAuthCredential, (zzad)((Object)new zzb()));
    }

    @NonNull
    public final Task<Void> zzc(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotEmpty((String)string);
        return this.zzec.zzc(this.zzdz, firebaseUser, string, (zzad)((Object)new zzb()));
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.sendPasswordResetEmail(string, null);
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string, @Nullable ActionCodeSettings actionCodeSettings) {
        Preconditions.checkNotEmpty((String)string);
        if (actionCodeSettings == null) {
            actionCodeSettings = ActionCodeSettings.newBuilder().build();
        }
        if (this.zzef != null) {
            actionCodeSettings.zza(this.zzef);
        }
        actionCodeSettings.zzb(1);
        return this.zzec.zza(this.zzdz, string, actionCodeSettings);
    }

    public Task<Void> sendSignInLinkToEmail(@NonNull String string, @NonNull ActionCodeSettings actionCodeSettings) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)actionCodeSettings));
        if (!actionCodeSettings.canHandleCodeInApp()) {
            throw new IllegalArgumentException("You must set canHandleCodeInApp in your ActionCodeSettings to true for Email-Link Sign-in.");
        }
        if (this.zzef != null) {
            actionCodeSettings.zza(this.zzef);
        }
        return this.zzec.zzb(this.zzdz, string, actionCodeSettings);
    }

    public boolean isSignInWithEmailLink(@NonNull String string) {
        return EmailAuthCredential.isSignInWithEmailLink(string);
    }

    @NonNull
    public final Task<Void> zza(@Nullable ActionCodeSettings actionCodeSettings, @NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        if (this.zzef != null) {
            if (actionCodeSettings == null) {
                actionCodeSettings = ActionCodeSettings.newBuilder().build();
            }
            actionCodeSettings.zza(this.zzef);
        }
        return this.zzec.zza(this.zzdz, actionCodeSettings, string);
    }

    @NonNull
    public Task<ActionCodeResult> checkActionCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zzec.zzc(this.zzdz, string);
    }

    @NonNull
    public Task<Void> applyActionCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zzec.zzd(this.zzdz, string);
    }

    @NonNull
    public Task<String> verifyPasswordResetCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zzec.zze(this.zzdz, string);
    }

    @NonNull
    public Task<Void> confirmPasswordReset(@NonNull String string, @NonNull String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        return this.zzec.zza(this.zzdz, string, string2);
    }

    @NonNull
    public final Task<Void> zze(@NonNull FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zzec.zza(firebaseUser, new zzn(this, firebaseUser));
    }

    public void signOut() {
        this.zzj();
        if (this.zzeh != null) {
            this.zzeh.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLanguageCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        Object object = this.zzee;
        synchronized (object) {
            this.zzef = string;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getLanguageCode() {
        Object object = this.zzee;
        synchronized (object) {
            return this.zzef;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useAppLanguage() {
        Object object = this.zzee;
        synchronized (object) {
            this.zzef = zzcw.zzaj();
            return;
        }
    }

    public Task<Void> setFirebaseUIVersion(@Nullable String string) {
        return this.zzec.setFirebaseUIVersion(string);
    }

    static /* synthetic */ FirebaseApp zza(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzdz;
    }

    static /* synthetic */ List zzb(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzea;
    }

    static /* synthetic */ List zzc(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzeb;
    }

    static /* synthetic */ FirebaseUser zzd(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzed;
    }

    @VisibleForTesting
    final class zzb
    extends zza
    implements com.google.firebase.auth.internal.zza,
    zzv {
        zzb() {
        }

        @Override
        public final void zza(Status status) {
            if (status.getStatusCode() == 17011 || status.getStatusCode() == 17021 || status.getStatusCode() == 17005) {
                FirebaseAuth.this.signOut();
            }
        }
    }

    @VisibleForTesting
    class zza
    implements com.google.firebase.auth.internal.zza {
        zza() {
        }

        @Override
        public final void zza(@NonNull com.google.android.gms.internal.firebase_auth.zzao zzao2, @NonNull FirebaseUser firebaseUser) {
            Preconditions.checkNotNull((Object)zzao2);
            Preconditions.checkNotNull((Object)firebaseUser);
            firebaseUser.zza(zzao2);
            FirebaseAuth.this.zza(firebaseUser, zzao2, true);
        }
    }

    public static interface AuthStateListener {
        public void onAuthStateChanged(@NonNull FirebaseAuth var1);
    }

    public static interface IdTokenListener {
        public void onIdTokenChanged(@NonNull FirebaseAuth var1);
    }
}

