/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.api.internal;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.StatusExceptionMapper;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseExceptionMapper;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.SignInMethodQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.api.internal.zzah;
import com.google.firebase.auth.api.internal.zzai;
import com.google.firebase.auth.api.internal.zzaj;
import com.google.firebase.auth.api.internal.zzak;
import com.google.firebase.auth.api.internal.zzal;
import com.google.firebase.auth.api.internal.zzap;
import com.google.firebase.auth.api.internal.zzaq;
import com.google.firebase.auth.api.internal.zzar;
import com.google.firebase.auth.api.internal.zzas;
import com.google.firebase.auth.api.internal.zzat;
import com.google.firebase.auth.api.internal.zzau;
import com.google.firebase.auth.api.internal.zzav;
import com.google.firebase.auth.api.internal.zzaw;
import com.google.firebase.auth.api.internal.zzax;
import com.google.firebase.auth.api.internal.zzay;
import com.google.firebase.auth.api.internal.zzaz;
import com.google.firebase.auth.api.internal.zzba;
import com.google.firebase.auth.api.internal.zzbb;
import com.google.firebase.auth.api.internal.zzbc;
import com.google.firebase.auth.api.internal.zzbd;
import com.google.firebase.auth.api.internal.zzbe;
import com.google.firebase.auth.api.internal.zzbf;
import com.google.firebase.auth.api.internal.zzbg;
import com.google.firebase.auth.api.internal.zzbh;
import com.google.firebase.auth.api.internal.zzbi;
import com.google.firebase.auth.api.internal.zzbj;
import com.google.firebase.auth.api.internal.zzbk;
import com.google.firebase.auth.api.internal.zzbl;
import com.google.firebase.auth.api.internal.zzbm;
import com.google.firebase.auth.api.internal.zzbn;
import com.google.firebase.auth.api.internal.zzbo;
import com.google.firebase.auth.api.internal.zzbp;
import com.google.firebase.auth.api.internal.zzbq;
import com.google.firebase.auth.api.internal.zzbr;
import com.google.firebase.auth.api.internal.zzbs;
import com.google.firebase.auth.api.internal.zzbt;
import com.google.firebase.auth.api.internal.zzbu;
import com.google.firebase.auth.api.internal.zzbv;
import com.google.firebase.auth.api.internal.zzbw;
import com.google.firebase.auth.api.internal.zzbx;
import com.google.firebase.auth.api.internal.zzby;
import com.google.firebase.auth.api.internal.zzbz;
import com.google.firebase.auth.api.internal.zzca;
import com.google.firebase.auth.api.internal.zzce;
import com.google.firebase.auth.api.internal.zzcn;
import com.google.firebase.auth.api.internal.zzcp;
import com.google.firebase.auth.api.internal.zzcy;
import com.google.firebase.auth.internal.zza;
import com.google.firebase.auth.internal.zzad;
import com.google.firebase.auth.internal.zzh;
import com.google.firebase.auth.internal.zzk;
import com.google.firebase.auth.internal.zzm;
import com.google.firebase.auth.internal.zzu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;

public final class zzao
extends zzah {
    @NonNull
    private final Context zzgo;
    @NonNull
    private final zzcp zzgp;

    zzao(@NonNull Context context, @NonNull zzcp zzcp2) {
        this.zzgo = context;
        this.zzgp = zzcp2;
    }

    @Override
    final zzai zzu() {
        int n = DynamiteModule.getRemoteVersion((Context)this.zzgo, (String)"com.google.android.gms.firebase_auth");
        GoogleApi<zzcp> googleApi = this.zzc(false);
        int n2 = DynamiteModule.getLocalVersion((Context)this.zzgo, (String)"com.google.firebase.auth");
        GoogleApi<zzcp> googleApi2 = n2 != 0 ? this.zzc(true) : null;
        zzak zzak2 = new zzak(n, n2, Collections.emptyMap(), true);
        return new zzai<zzcp>(googleApi, googleApi2, zzak2);
    }

    @NonNull
    private final GoogleApi<zzcp> zzc(boolean bl) {
        boolean bl2;
        zzcp zzcp2 = (zzcp)((zzaj)this.zzgp).clone();
        ((zzcp)((zzaj)this.zzgp).clone()).zzgj = bl2 = bl;
        return new zzal<zzcp>(this.zzgo, zzcn.zzhi, zzcp2, (StatusExceptionMapper)new FirebaseExceptionMapper());
    }

    public final Task<GetTokenResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzad zzad2) {
        return this.zza(zzao.zza(new zzaw(string).zzb(firebaseApp).zzf(firebaseUser).zza(zzad2).zza(zzad2), "getAccessToken"));
    }

    public final Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull zza zza2) {
        return this.zzb(zzao.zza(new zzbp(string).zzb(firebaseApp).zza(zza2), "signInWithCustomToken"));
    }

    public final Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull AuthCredential authCredential, @NonNull zza zza2) {
        return this.zzb(zzao.zza(new zzbo(authCredential).zzb(firebaseApp).zza(zza2), "signInWithCredential"));
    }

    public final Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential, @NonNull zzad zzad2) {
        return this.zzb(zzao.zza(new zzbc(authCredential).zzb(firebaseApp).zzf(firebaseUser).zza(zzad2).zza(zzad2), "reauthenticateWithCredential"));
    }

    public final Task<AuthResult> zzb(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential, @NonNull zzad zzad2) {
        return this.zzb(zzao.zza(new zzbd(authCredential).zzb(firebaseApp).zzf(firebaseUser).zza(zzad2).zza(zzad2), "reauthenticateWithCredentialWithData"));
    }

    public final Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull zza zza2) {
        return this.zzb(zzao.zza(new zzbn().zzb(firebaseApp).zza(zza2), "signInAnonymously"));
    }

    public final void zza(@NonNull FirebaseApp firebaseApp, @NonNull com.google.android.gms.internal.firebase_auth.zzax zzax2, @NonNull PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks, @Nullable Activity activity, @NonNull Executor executor) {
        this.zzb(zzao.zza(new zzca(zzax2).zzb(firebaseApp).zza(onVerificationStateChangedCallbacks, activity, executor), "verifyPhoneNumber"));
    }

    public final Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest, @NonNull zzad zzad2) {
        return this.zzb(zzao.zza(new zzby(userProfileChangeRequest).zzb(firebaseApp).zzf(firebaseUser).zza(zzad2).zza(zzad2), "updateProfile"));
    }

    public final Task<Void> zzb(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzad zzad2) {
        return this.zzb(zzao.zza(new zzbv(string).zzb(firebaseApp).zzf(firebaseUser).zza(zzad2).zza(zzad2), "updateEmail"));
    }

    public final Task<Void> zzc(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzad zzad2) {
        return this.zzb(zzao.zza(new zzbw(string).zzb(firebaseApp).zzf(firebaseUser).zza(zzad2).zza(zzad2), "updatePassword"));
    }

    public final Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull PhoneAuthCredential phoneAuthCredential, @NonNull zzad zzad2) {
        return this.zzb(zzao.zza(new zzbx(phoneAuthCredential).zzb(firebaseApp).zzf(firebaseUser).zza(zzad2).zza(zzad2), "updatePhoneNumber"));
    }

    public final Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull String string2, @NonNull zza zza2) {
        return this.zzb(zzao.zza(new zzas(string, string2).zzb(firebaseApp).zza(zza2), "createUserWithEmailAndPassword"));
    }

    public final Task<AuthResult> zzb(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull String string2, @NonNull zza zza2) {
        return this.zzb(zzao.zza(new zzbq(string, string2).zzb(firebaseApp).zza(zza2), "signInWithEmailAndPassword"));
    }

    public final Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull EmailAuthCredential emailAuthCredential, @NonNull zza zza2) {
        return this.zzb(zzao.zza(new zzbr(emailAuthCredential).zzb(firebaseApp).zza(zza2), "sendSignInLinkToEmail"));
    }

    public final Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull String string2, @NonNull zzad zzad2) {
        return this.zzb(zzao.zza(new zzbg(string, string2).zzb(firebaseApp).zzf(firebaseUser).zza(zzad2).zza(zzad2), "reauthenticateWithEmailPassword"));
    }

    public final Task<AuthResult> zzb(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull String string2, @NonNull zzad zzad2) {
        return this.zzb(zzao.zza(new zzbh(string, string2).zzb(firebaseApp).zzf(firebaseUser).zza(zzad2).zza(zzad2), "reauthenticateWithEmailPasswordWithData"));
    }

    public final Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull EmailAuthCredential emailAuthCredential, @NonNull zzad zzad2) {
        return this.zzb(zzao.zza(new zzbe(emailAuthCredential).zzb(firebaseApp).zzf(firebaseUser).zza(zzad2).zza(zzad2), "reauthenticateWithEmailLink"));
    }

    public final Task<AuthResult> zzb(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull EmailAuthCredential emailAuthCredential, @NonNull zzad zzad2) {
        return this.zzb(zzao.zza(new zzbf(emailAuthCredential).zzb(firebaseApp).zzf(firebaseUser).zza(zzad2).zza(zzad2), "reauthenticateWithEmailLinkWithData"));
    }

    public final Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull PhoneAuthCredential phoneAuthCredential, @NonNull zza zza2) {
        return this.zzb(zzao.zza(new zzbs(phoneAuthCredential).zzb(firebaseApp).zza(zza2), "signInWithPhoneNumber"));
    }

    public final Task<Void> zzb(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull PhoneAuthCredential phoneAuthCredential, @NonNull zzad zzad2) {
        return this.zzb(zzao.zza(new zzbi(phoneAuthCredential).zzb(firebaseApp).zzf(firebaseUser).zza(zzad2).zza(zzad2), "reauthenticateWithPhoneCredential"));
    }

    public final Task<AuthResult> zzc(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential, @NonNull zzad zzad2) {
        return this.zzb(zzao.zza(new zzbd(authCredential).zzb(firebaseApp).zzf(firebaseUser).zza(zzad2).zza(zzad2), "reauthenticateWithPhoneCredentialWithData"));
    }

    public final Task<ProviderQueryResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.zza(zzao.zza(new zzau(string).zzb(firebaseApp), "fetchProvidersForEmail"));
    }

    public final Task<SignInMethodQueryResult> zzb(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.zza(zzao.zza(new zzav(string).zzb(firebaseApp), "fetchSignInMethodsForEmail"));
    }

    public final Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull ActionCodeSettings actionCodeSettings) {
        actionCodeSettings.zzb(1);
        return this.zzb(zzao.zza(new zzbl(string, actionCodeSettings).zzb(firebaseApp), "sendPasswordResetEmail"));
    }

    public final Task<Void> zzb(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull ActionCodeSettings actionCodeSettings) {
        actionCodeSettings.zzb(6);
        return this.zzb(zzao.zza(new zzbl(string, actionCodeSettings).zzb(firebaseApp), "sendSignInLinkToEmail"));
    }

    public final Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull ActionCodeSettings actionCodeSettings, @NonNull String string) {
        return this.zzb(zzao.zza(new zzbk(string, actionCodeSettings).zzb(firebaseApp), "sendEmailVerification"));
    }

    public final Task<ActionCodeResult> zzc(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.zzb(zzao.zza(new zzaq(string).zzb(firebaseApp), "checkActionCode"));
    }

    public final Task<Void> zzd(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.zzb(zzao.zza(new zzap(string).zzb(firebaseApp), "applyActionCode"));
    }

    public final Task<String> zze(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.zzb(zzao.zza(new zzbz(string).zzb(firebaseApp), "verifyPasswordResetCode"));
    }

    public final Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull String string2) {
        return this.zzb(zzao.zza(new zzar(string, string2).zzb(firebaseApp), "confirmPasswordReset"));
    }

    public final Task<AuthResult> zzd(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential, @NonNull zzad zzad2) {
        Preconditions.checkNotNull((Object)firebaseApp);
        Preconditions.checkNotNull((Object)((Object)authCredential));
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)zzad2);
        List<String> list = firebaseUser.getProviders();
        if (list != null && list.contains(authCredential.getProvider())) {
            return Tasks.forException((Exception)zzce.zzb(new Status(17015)));
        }
        if (authCredential instanceof EmailAuthCredential) {
            if (!((EmailAuthCredential)authCredential).zzi()) {
                zzad zzad3 = zzad2;
                FirebaseUser firebaseUser2 = firebaseUser;
                EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
                FirebaseApp firebaseApp2 = firebaseApp;
                return this.zzb(zzao.zza(new zzax(emailAuthCredential).zzb(firebaseApp2).zzf(firebaseUser2).zza(zzad3).zza(zzad3), "linkEmailAuthCredential"));
            }
            zzad zzad4 = zzad2;
            FirebaseUser firebaseUser3 = firebaseUser;
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            FirebaseApp firebaseApp3 = firebaseApp;
            return this.zzb(zzao.zza(new zzba(emailAuthCredential).zzb(firebaseApp3).zzf(firebaseUser3).zza(zzad4).zza(zzad4), "linkEmailAuthCredential"));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            zzad zzad5 = zzad2;
            FirebaseUser firebaseUser4 = firebaseUser;
            PhoneAuthCredential phoneAuthCredential = (PhoneAuthCredential)authCredential;
            FirebaseApp firebaseApp4 = firebaseApp;
            return this.zzb(zzao.zza(new zzaz(phoneAuthCredential).zzb(firebaseApp4).zzf(firebaseUser4).zza(zzad5).zza(zzad5), "linkPhoneAuthCredential"));
        }
        zzad zzad6 = zzad2;
        FirebaseUser firebaseUser5 = firebaseUser;
        AuthCredential authCredential2 = authCredential;
        FirebaseApp firebaseApp5 = firebaseApp;
        zzao zzao2 = this;
        Preconditions.checkNotNull((Object)firebaseApp5);
        Preconditions.checkNotNull((Object)((Object)authCredential2));
        Preconditions.checkNotNull((Object)firebaseUser5);
        Preconditions.checkNotNull((Object)zzad6);
        return zzao2.zzb(zzao.zza(new zzay(authCredential2).zzb(firebaseApp5).zzf(firebaseUser5).zza(zzad6).zza(zzad6), "linkFederatedCredential"));
    }

    public final Task<AuthResult> zzd(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzad zzad2) {
        Preconditions.checkNotNull((Object)firebaseApp);
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)zzad2);
        List<String> list = firebaseUser.getProviders();
        if (list != null && !list.contains(string) || firebaseUser.isAnonymous()) {
            return Tasks.forException((Exception)zzce.zzb(new Status(17016, string)));
        }
        switch (string) {
            case "password": {
                zzad zzad3 = zzad2;
                FirebaseUser firebaseUser2 = firebaseUser;
                FirebaseApp firebaseApp2 = firebaseApp;
                return this.zzb(zzao.zza(new zzbt().zzb(firebaseApp2).zzf(firebaseUser2).zza(zzad3).zza(zzad3), "unlinkEmailCredential"));
            }
        }
        zzad zzad4 = zzad2;
        FirebaseUser firebaseUser3 = firebaseUser;
        String string2 = string;
        FirebaseApp firebaseApp3 = firebaseApp;
        return this.zzb(zzao.zza(new zzbu(string2).zzb(firebaseApp3).zzf(firebaseUser3).zza(zzad4).zza(zzad4), "unlinkFederatedCredential"));
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull zzad zzad2) {
        return this.zza(zzao.zza(new zzbj().zzb(firebaseApp).zzf(firebaseUser).zza(zzad2).zza(zzad2), "reload"));
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull zzu zzu2) {
        return this.zzb(zzao.zza(new zzat().zzf(firebaseUser).zza(zzu2).zza(zzu2), "delete"));
    }

    @NonNull
    public final Task<Void> setFirebaseUIVersion(@NonNull String string) {
        return this.zzb(zzao.zza(new zzbm(string), "setFirebaseUIVersion"));
    }

    @NonNull
    private static zzk zza(@NonNull FirebaseApp firebaseApp, @NonNull com.google.android.gms.internal.firebase_auth.zzaj zzaj2) {
        return zzao.zza(firebaseApp, zzaj2, false);
    }

    @NonNull
    private static zzk zza(@NonNull FirebaseApp firebaseApp, @NonNull com.google.android.gms.internal.firebase_auth.zzaj zzaj2, boolean bl) {
        Preconditions.checkNotNull((Object)firebaseApp);
        Preconditions.checkNotNull((Object)((Object)zzaj2));
        ArrayList<zzh> arrayList = new ArrayList<zzh>();
        zzh zzh2 = new zzh(zzaj2, "firebase");
        arrayList.add(zzh2);
        List<com.google.android.gms.internal.firebase_auth.zzaq> list = zzaj2.zzar();
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add(new zzh(list.get(i)));
            }
        }
        zzk zzk2 = new zzk(firebaseApp, arrayList);
        ((FirebaseUser)zzk2).zza(bl);
        zzm zzm2 = new zzm(zzaj2.getLastSignInTimestamp(), zzaj2.getCreationTimestamp());
        zzk2.zza(zzm2);
        zzk2.zzf(zzaj2.isNewUser());
        zzk2.zzc(zzaj2.zzat());
        return zzk2;
    }

    private static <ResultT, CallbackT> zzbb<ResultT, CallbackT> zza(zzcy<ResultT, CallbackT> zzcy2, String string) {
        return new zzbb<ResultT, CallbackT>(zzcy2, string);
    }

    static /* synthetic */ zzk zzb(FirebaseApp firebaseApp, com.google.android.gms.internal.firebase_auth.zzaj zzaj2) {
        return zzao.zza(firebaseApp, zzaj2);
    }

    static /* synthetic */ zzk zzb(FirebaseApp firebaseApp, com.google.android.gms.internal.firebase_auth.zzaj zzaj2, boolean bl) {
        return zzao.zza(firebaseApp, zzaj2, bl);
    }
}

