/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.firebase_auth.zzaj;
import com.google.android.gms.internal.firebase_auth.zzaq;
import com.google.android.gms.internal.firebase_auth.zzv;
import com.google.firebase.auth.UserInfo;
import com.google.firebase.auth.internal.zzi;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Class(creator="DefaultAuthUserInfoCreator")
public final class zzh
extends AbstractSafeParcelable
implements UserInfo {
    public static final Parcelable.Creator<zzh> CREATOR = new zzi();
    @SafeParcelable.Field(id=1, getter="getUid")
    @NonNull
    private String zzkq;
    @SafeParcelable.Field(id=2, getter="getProviderId")
    @NonNull
    private String zzj;
    @SafeParcelable.Field(id=3, getter="getDisplayName")
    @Nullable
    private String zzbf;
    @SafeParcelable.Field(id=4, getter="getPhotoUrlString")
    @Nullable
    private String zzbp;
    @Nullable
    private Uri zzfd;
    @SafeParcelable.Field(id=5, getter="getEmail")
    @Nullable
    private String zzaf;
    @SafeParcelable.Field(id=6, getter="getPhoneNumber")
    @Nullable
    private String zzbb;
    @SafeParcelable.Field(id=7, getter="isEmailVerified")
    private boolean zzjl;
    @SafeParcelable.Field(id=8, getter="getRawUserInfo")
    @Nullable
    private String zzdd;

    @VisibleForTesting
    @SafeParcelable.Constructor
    public zzh(@SafeParcelable.Param(id=1) @NonNull String string, @SafeParcelable.Param(id=2) @NonNull String string2, @SafeParcelable.Param(id=3) @Nullable String string3, @SafeParcelable.Param(id=4) @Nullable String string4, @SafeParcelable.Param(id=5) @Nullable String string5, @SafeParcelable.Param(id=6) @Nullable String string6, @SafeParcelable.Param(id=7) boolean bl, @SafeParcelable.Param(id=8) @Nullable String string7) {
        this.zzkq = string;
        this.zzj = string2;
        this.zzaf = string3;
        this.zzbb = string4;
        this.zzbf = string5;
        this.zzbp = string6;
        if (!TextUtils.isEmpty((CharSequence)this.zzbp)) {
            this.zzfd = Uri.parse((String)this.zzbp);
        }
        this.zzjl = bl;
        this.zzdd = string7;
    }

    public zzh(@NonNull zzaj zzaj2, @NonNull String string) {
        Preconditions.checkNotNull((Object)((Object)zzaj2));
        Preconditions.checkNotEmpty((String)string);
        this.zzkq = Preconditions.checkNotEmpty((String)zzaj2.getLocalId());
        this.zzj = string;
        this.zzaf = zzaj2.getEmail();
        this.zzbf = zzaj2.getDisplayName();
        Uri uri = zzaj2.getPhotoUri();
        if (uri != null) {
            this.zzbp = uri.toString();
            this.zzfd = uri;
        }
        this.zzjl = zzaj2.isEmailVerified();
        this.zzdd = null;
        this.zzbb = zzaj2.getPhoneNumber();
    }

    public zzh(@NonNull zzaq zzaq2) {
        Preconditions.checkNotNull((Object)((Object)zzaq2));
        this.zzkq = zzaq2.zzax();
        this.zzj = Preconditions.checkNotEmpty((String)zzaq2.getProviderId());
        this.zzbf = zzaq2.getDisplayName();
        Uri uri = zzaq2.getPhotoUri();
        if (uri != null) {
            this.zzbp = uri.toString();
            this.zzfd = uri;
        }
        this.zzaf = zzaq2.getEmail();
        this.zzbb = zzaq2.getPhoneNumber();
        this.zzjl = false;
        this.zzdd = zzaq2.getRawUserInfo();
    }

    @Override
    @NonNull
    public final String getUid() {
        return this.zzkq;
    }

    @Override
    @NonNull
    public final String getProviderId() {
        return this.zzj;
    }

    @Override
    @Nullable
    public final String getDisplayName() {
        return this.zzbf;
    }

    @Override
    @Nullable
    public final Uri getPhotoUrl() {
        if (!TextUtils.isEmpty((CharSequence)this.zzbp) && this.zzfd == null) {
            this.zzfd = Uri.parse((String)this.zzbp);
        }
        return this.zzfd;
    }

    @Override
    @Nullable
    public final String getEmail() {
        return this.zzaf;
    }

    @Override
    @Nullable
    public final String getPhoneNumber() {
        return this.zzbb;
    }

    @Override
    public final boolean isEmailVerified() {
        return this.zzjl;
    }

    @Nullable
    public final String getRawUserInfo() {
        return this.zzdd;
    }

    @Nullable
    public final String toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.putOpt("userId", (Object)this.zzkq);
            jSONObject.putOpt("providerId", (Object)this.zzj);
            jSONObject.putOpt("displayName", (Object)this.zzbf);
            jSONObject.putOpt("photoUrl", (Object)this.zzbp);
            jSONObject.putOpt("email", (Object)this.zzaf);
            jSONObject.putOpt("phoneNumber", (Object)this.zzbb);
            jSONObject.putOpt("isEmailVerified", (Object)this.zzjl);
            jSONObject.putOpt("rawUserInfo", (Object)this.zzdd);
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            Log.d((String)"DefaultAuthUserInfo", (String)"Failed to jsonify this object");
            throw new zzv(jSONException);
        }
    }

    @Nullable
    public static zzh zzad(@NonNull String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            String string2 = jSONObject.optString("userId");
            String string3 = jSONObject.optString("providerId");
            String string4 = jSONObject.optString("email");
            String string5 = jSONObject.optString("phoneNumber");
            String string6 = jSONObject.optString("displayName");
            String string7 = jSONObject.optString("photoUrl");
            boolean bl = jSONObject.optBoolean("isEmailVerified");
            String string8 = jSONObject.optString("rawUserInfo");
            return new zzh(string2, string3, string4, string5, string6, string7, bl, string8);
        }
        catch (JSONException jSONException) {
            Log.d((String)"DefaultAuthUserInfo", (String)"Failed to unpack UserInfo from JSON");
            throw new zzv(jSONException);
        }
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzh zzh2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)1, (String)zzh2.getUid(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)zzh2.getProviderId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)zzh2.getDisplayName(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)zzh2.zzbp, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)zzh2.getEmail(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)6, (String)zzh2.getPhoneNumber(), (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)7, (boolean)zzh2.isEmailVerified());
        SafeParcelWriter.writeString((Parcel)parcel2, (int)8, (String)zzh2.zzdd, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }
}

