/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_auth;

import com.google.android.gms.internal.firebase_auth.zzbn;
import com.google.android.gms.internal.firebase_auth.zzbt;
import com.google.android.gms.internal.firebase_auth.zzbu;
import com.google.android.gms.internal.firebase_auth.zzcj;
import com.google.android.gms.internal.firebase_auth.zzck;
import com.google.android.gms.internal.firebase_auth.zzdd;
import com.google.android.gms.internal.firebase_auth.zzdo;
import com.google.android.gms.internal.firebase_auth.zzeh;
import com.google.android.gms.internal.firebase_auth.zzev;
import com.google.android.gms.internal.firebase_auth.zzfv;
import com.google.android.gms.internal.firebase_auth.zzfx;
import com.google.android.gms.internal.firebase_auth.zzga;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class zzci
extends zzbt {
    private static final Logger logger = Logger.getLogger(zzci.class.getName());
    private static final boolean zznf = zzfv.zzgc();
    zzck zzng;

    public static zzci zzb(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        return new zza(byArray2, 0, n);
    }

    public static zzci zza(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            return new zzb(byteBuffer);
        }
        if (byteBuffer.isDirect() && !byteBuffer.isReadOnly()) {
            if (zzfv.zzgd()) {
                ByteBuffer byteBuffer2 = byteBuffer;
                return new zze(byteBuffer2);
            }
            ByteBuffer byteBuffer3 = byteBuffer;
            return new zzd(byteBuffer3);
        }
        throw new IllegalArgumentException("ByteBuffer is read-only");
    }

    private zzci() {
    }

    public abstract void zzb(int var1, int var2) throws IOException;

    public abstract void zzc(int var1, int var2) throws IOException;

    public abstract void zzd(int var1, int var2) throws IOException;

    public final void zze(int n, int n2) throws IOException {
        this.zzd(n, zzci.zzah(n2));
    }

    public abstract void zzf(int var1, int var2) throws IOException;

    public abstract void zza(int var1, long var2) throws IOException;

    public final void zzb(int n, long l) throws IOException {
        this.zza(n, zzci.zzi(l));
    }

    public abstract void zzc(int var1, long var2) throws IOException;

    public final void zza(int n, float f) throws IOException {
        this.zzf(n, Float.floatToRawIntBits(f));
    }

    public final void zza(int n, double d) throws IOException {
        this.zzc(n, Double.doubleToRawLongBits(d));
    }

    public abstract void zzb(int var1, boolean var2) throws IOException;

    public abstract void zza(int var1, String var2) throws IOException;

    public abstract void zza(int var1, zzbu var2) throws IOException;

    public abstract void zza(int var1, zzeh var2) throws IOException;

    abstract void zza(int var1, zzeh var2, zzev var3) throws IOException;

    public abstract void zzb(int var1, zzeh var2) throws IOException;

    public abstract void zzb(int var1, zzbu var2) throws IOException;

    public abstract void zzw(int var1) throws IOException;

    public abstract void zzx(int var1) throws IOException;

    public final void zzy(int n) throws IOException {
        this.zzx(zzci.zzah(n));
    }

    public abstract void zzz(int var1) throws IOException;

    public abstract void zza(long var1) throws IOException;

    public final void zzb(long l) throws IOException {
        this.zza(zzci.zzi(l));
    }

    public abstract void zzc(long var1) throws IOException;

    public final void zza(float f) throws IOException {
        this.zzz(Float.floatToRawIntBits(f));
    }

    public final void zza(double d) throws IOException {
        this.zzc(Double.doubleToRawLongBits(d));
    }

    public final void zzf(boolean bl) throws IOException {
        this.zza((byte)(bl ? 1 : 0));
    }

    public abstract void zzal(String var1) throws IOException;

    public abstract void zza(zzbu var1) throws IOException;

    public abstract void zzb(zzeh var1) throws IOException;

    abstract void zza(zzeh var1, zzev var2) throws IOException;

    public abstract void zza(byte var1) throws IOException;

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public static int zzg(int n, int n2) {
        return zzci.zzaa(n) + zzci.zzab(n2);
    }

    public static int zzh(int n, int n2) {
        return zzci.zzaa(n) + zzci.zzac(n2);
    }

    public static int zzi(int n, int n2) {
        return zzci.zzaa(n) + zzci.zzac(zzci.zzah(n2));
    }

    public static int zzj(int n, int n2) {
        return zzci.zzaa(n) + 4;
    }

    public static int zzk(int n, int n2) {
        return zzci.zzaa(n) + 4;
    }

    public static int zzd(int n, long l) {
        return zzci.zzaa(n) + zzci.zze(l);
    }

    public static int zze(int n, long l) {
        return zzci.zzaa(n) + zzci.zze(l);
    }

    public static int zzf(int n, long l) {
        return zzci.zzaa(n) + zzci.zze(zzci.zzi(l));
    }

    public static int zzg(int n, long l) {
        return zzci.zzaa(n) + 8;
    }

    public static int zzh(int n, long l) {
        return zzci.zzaa(n) + 8;
    }

    public static int zzb(int n, float f) {
        return zzci.zzaa(n) + 4;
    }

    public static int zzb(int n, double d) {
        return zzci.zzaa(n) + 8;
    }

    public static int zzc(int n, boolean bl) {
        return zzci.zzaa(n) + 1;
    }

    public static int zzl(int n, int n2) {
        return zzci.zzaa(n) + zzci.zzab(n2);
    }

    public static int zzb(int n, String string) {
        return zzci.zzaa(n) + zzci.zzam(string);
    }

    public static int zzc(int n, zzbu zzbu2) {
        int n2 = zzbu2.size();
        return zzci.zzaa(n) + (zzci.zzac(n2) + n2);
    }

    public static int zza(int n, zzdo zzdo2) {
        int n2 = zzdo2.zzdq();
        return zzci.zzaa(n) + (zzci.zzac(n2) + n2);
    }

    public static int zzc(int n, zzeh zzeh2) {
        return zzci.zzaa(n) + zzci.zzc(zzeh2);
    }

    static int zzb(int n, zzeh zzeh2, zzev zzev2) {
        return zzci.zzaa(n) + zzci.zzb(zzeh2, zzev2);
    }

    public static int zzd(int n, zzeh zzeh2) {
        return (zzci.zzaa(1) << 1) + zzci.zzh(2, n) + zzci.zzc(3, zzeh2);
    }

    public static int zzd(int n, zzbu zzbu2) {
        return (zzci.zzaa(1) << 1) + zzci.zzh(2, n) + zzci.zzc(3, zzbu2);
    }

    public static int zzb(int n, zzdo zzdo2) {
        return (zzci.zzaa(1) << 1) + zzci.zzh(2, n) + zzci.zza(3, zzdo2);
    }

    public static int zzaa(int n) {
        return zzci.zzac(n << 3);
    }

    public static int zzab(int n) {
        if (n >= 0) {
            return zzci.zzac(n);
        }
        return 10;
    }

    public static int zzac(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int zzad(int n) {
        return zzci.zzac(zzci.zzah(n));
    }

    public static int zzae(int n) {
        return 4;
    }

    public static int zzaf(int n) {
        return 4;
    }

    public static int zzd(long l) {
        return zzci.zze(l);
    }

    public static int zze(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (l < 0L) {
            return 10;
        }
        int n = 2;
        if ((l & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            l >>>= 28;
        }
        if ((l & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            l >>>= 14;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    public static int zzf(long l) {
        return zzci.zze(zzci.zzi(l));
    }

    public static int zzg(long l) {
        return 8;
    }

    public static int zzh(long l) {
        return 8;
    }

    public static int zzb(float f) {
        return 4;
    }

    public static int zzb(double d) {
        return 8;
    }

    public static int zzg(boolean bl) {
        return 1;
    }

    public static int zzag(int n) {
        return zzci.zzab(n);
    }

    public static int zzam(String string) {
        int n;
        try {
            n = zzfx.zza(string);
        }
        catch (zzga zzga2) {
            n = string.getBytes(zzdd.UTF_8).length;
        }
        int n2 = n;
        return zzci.zzac(n2) + n2;
    }

    public static int zza(zzdo zzdo2) {
        int n = zzdo2.zzdq();
        return zzci.zzac(n) + n;
    }

    public static int zzb(zzbu zzbu2) {
        int n = zzbu2.size();
        return zzci.zzac(n) + n;
    }

    public static int zzc(byte[] byArray) {
        int n = byArray.length;
        return zzci.zzac(n) + n;
    }

    public static int zzc(zzeh zzeh2) {
        int n = zzeh2.zzdq();
        return zzci.zzac(n) + n;
    }

    static int zzb(zzeh zzeh2, zzev zzev2) {
        zzev zzev3 = zzev2;
        zzbn zzbn2 = (zzbn)zzeh2;
        int n = zzbn2.zzbp();
        if (n == -1) {
            n = zzev3.zzo(zzbn2);
            zzbn2.zzg(n);
        }
        int n2 = n;
        return zzci.zzac(n2) + n2;
    }

    private static int zzah(int n) {
        return n << 1 ^ n >> 31;
    }

    private static long zzi(long l) {
        return l << 1 ^ l >> 63;
    }

    public abstract void flush() throws IOException;

    public abstract int zzdc();

    abstract void zze(byte[] var1, int var2, int var3) throws IOException;

    final void zza(String string, zzga zzga2) throws IOException {
        logger.logp(Level.WARNING, "com.google.protobuf.CodedOutputStream", "inefficientWriteStringNoTag", "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", zzga2);
        byte[] byArray = string.getBytes(zzdd.UTF_8);
        try {
            this.zzx(byArray.length);
            this.zza(byArray, 0, byArray.length);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new zzc(indexOutOfBoundsException);
        }
        catch (zzc zzc2) {
            throw zzc2;
        }
    }

    @Deprecated
    static int zzc(int n, zzeh zzeh2, zzev zzev2) {
        zzev zzev3;
        int n2 = zzci.zzaa(n) << 1;
        zzev zzev4 = zzev3 = zzev2;
        zzbn zzbn2 = (zzbn)zzeh2;
        int n3 = zzbn2.zzbp();
        if (n3 == -1) {
            n3 = zzev4.zzo(zzbn2);
            zzbn2.zzg(n3);
        }
        return n2 + n3;
    }

    @Deprecated
    public static int zzd(zzeh zzeh2) {
        return zzeh2.zzdq();
    }

    @Deprecated
    public static int zzai(int n) {
        return zzci.zzac(n);
    }

    /* synthetic */ zzci(zzcj zzcj2) {
        this();
    }

    static final class zze
    extends zzci {
        private final ByteBuffer zznj;
        private final ByteBuffer zznk;
        private final long zznl;
        private final long zznm;
        private final long zznn;
        private final long zzno;
        private long zznp;

        zze(ByteBuffer byteBuffer) {
            super(null);
            this.zznj = byteBuffer;
            this.zznk = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zznl = zzfv.zzb(byteBuffer);
            this.zznm = this.zznl + (long)byteBuffer.position();
            this.zznn = this.zznl + (long)byteBuffer.limit();
            this.zzno = this.zznn - 10L;
            this.zznp = this.zznm;
        }

        @Override
        public final void zzb(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzci)this).zzx(n << 3 | n3);
        }

        @Override
        public final void zzc(int n, int n2) throws IOException {
            ((zzci)this).zzb(n, 0);
            ((zzci)this).zzw(n2);
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            ((zzci)this).zzb(n, 0);
            ((zzci)this).zzx(n2);
        }

        @Override
        public final void zzf(int n, int n2) throws IOException {
            ((zzci)this).zzb(n, 5);
            ((zzci)this).zzz(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzci)this).zzb(n, 0);
            ((zzci)this).zza(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzci)this).zzb(n, 1);
            ((zzci)this).zzc(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzci)this).zzb(n, 0);
            ((zzci)this).zza((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zza(int n, String string) throws IOException {
            ((zzci)this).zzb(n, 2);
            ((zzci)this).zzal(string);
        }

        @Override
        public final void zza(int n, zzbu zzbu2) throws IOException {
            ((zzci)this).zzb(n, 2);
            ((zzci)this).zza(zzbu2);
        }

        @Override
        public final void zza(int n, zzeh zzeh2) throws IOException {
            ((zzci)this).zzb(n, 2);
            ((zzci)this).zzb(zzeh2);
        }

        @Override
        final void zza(int n, zzeh zzeh2, zzev zzev2) throws IOException {
            ((zzci)this).zzb(n, 2);
            ((zzci)this).zza(zzeh2, zzev2);
        }

        @Override
        public final void zzb(int n, zzeh zzeh2) throws IOException {
            ((zzci)this).zzb(1, 3);
            ((zzci)this).zzd(2, n);
            ((zzci)this).zza(3, zzeh2);
            ((zzci)this).zzb(1, 4);
        }

        @Override
        public final void zzb(int n, zzbu zzbu2) throws IOException {
            ((zzci)this).zzb(1, 3);
            ((zzci)this).zzd(2, n);
            ((zzci)this).zza(3, zzbu2);
            ((zzci)this).zzb(1, 4);
        }

        @Override
        public final void zzb(zzeh zzeh2) throws IOException {
            ((zzci)this).zzx(zzeh2.zzdq());
            zzeh2.zzb(this);
        }

        @Override
        final void zza(zzeh zzeh2, zzev zzev2) throws IOException {
            zzev zzev3 = zzev2;
            zzbn zzbn2 = (zzbn)zzeh2;
            int n = zzbn2.zzbp();
            if (n == -1) {
                n = zzev3.zzo(zzbn2);
                zzbn2.zzg(n);
            }
            ((zzci)this).zzx(n);
            zzev2.zza(zzeh2, this.zzng);
        }

        @Override
        public final void zza(byte by) throws IOException {
            if (this.zznp >= this.zznn) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zznp, this.zznn, 1));
            }
            zzfv.zza(this.zznp++, by);
        }

        @Override
        public final void zza(zzbu zzbu2) throws IOException {
            ((zzci)this).zzx(zzbu2.size());
            zzbu2.zza(this);
        }

        @Override
        public final void zze(byte[] byArray, int n, int n2) throws IOException {
            ((zzci)this).zzx(n2);
            ((zzci)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzw(int n) throws IOException {
            if (n >= 0) {
                ((zzci)this).zzx(n);
                return;
            }
            ((zzci)this).zza(n);
        }

        @Override
        public final void zzx(int n) throws IOException {
            if (this.zznp <= this.zzno) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzfv.zza(this.zznp++, (byte)n);
                        return;
                    }
                    zzfv.zza(this.zznp++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            while (this.zznp < this.zznn) {
                if ((n & 0xFFFFFF80) == 0) {
                    zzfv.zza(this.zznp++, (byte)n);
                    return;
                }
                zzfv.zza(this.zznp++, (byte)(n & 0x7F | 0x80));
                n >>>= 7;
            }
            throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zznp, this.zznn, 1));
        }

        @Override
        public final void zzz(int n) throws IOException {
            long l = this.zznp;
            zze zze2 = this;
            this.zznk.putInt((int)(l - zze2.zznl), n);
            this.zznp += 4L;
        }

        @Override
        public final void zza(long l) throws IOException {
            if (this.zznp <= this.zzno) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzfv.zza(this.zznp++, (byte)l);
                        return;
                    }
                    zzfv.zza(this.zznp++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            while (this.zznp < this.zznn) {
                if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    zzfv.zza(this.zznp++, (byte)l);
                    return;
                }
                zzfv.zza(this.zznp++, (byte)((int)l & 0x7F | 0x80));
                l >>>= 7;
            }
            throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zznp, this.zznn, 1));
        }

        @Override
        public final void zzc(long l) throws IOException {
            long l2 = this.zznp;
            zze zze2 = this;
            this.zznk.putLong((int)(l2 - zze2.zznl), l);
            this.zznp += 8L;
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null || n < 0 || n2 < 0 || byArray.length - n2 < n || this.zznn - (long)n2 < this.zznp) {
                if (byArray == null) {
                    throw new NullPointerException("value");
                }
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zznp, this.zznn, n2));
            }
            zzfv.zza(byArray, n, this.zznp, n2);
            this.zznp += (long)n2;
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzci)this).write(byArray, n, n2);
        }

        @Override
        public final void zzal(String string) throws IOException {
            long l = this.zznp;
            try {
                int n = zze.zzac(string.length() * 3);
                int n2 = zze.zzac(string.length());
                if (n2 == n) {
                    long l2 = this.zznp;
                    zze zze2 = this;
                    int n3 = (int)(l2 - zze2.zznl) + n2;
                    this.zznk.position(n3);
                    zzfx.zza(string, this.zznk);
                    int n4 = this.zznk.position() - n3;
                    ((zzci)this).zzx(n4);
                    this.zznp += (long)n4;
                    return;
                }
                int n5 = zzfx.zza(string);
                ((zzci)this).zzx(n5);
                this.zzj(this.zznp);
                zzfx.zza(string, this.zznk);
                this.zznp += (long)n5;
                return;
            }
            catch (zzga zzga2) {
                this.zznp = l;
                this.zzj(this.zznp);
                this.zza(string, zzga2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzc(illegalArgumentException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }

        @Override
        public final void flush() {
            long l = this.zznp;
            zze zze2 = this;
            this.zznj.position((int)(l - zze2.zznl));
        }

        @Override
        public final int zzdc() {
            return (int)(this.zznn - this.zznp);
        }

        private final void zzj(long l) {
            long l2 = l;
            zze zze2 = this;
            this.zznk.position((int)(l2 - zze2.zznl));
        }
    }

    static final class zzd
    extends zzci {
        private final ByteBuffer zznj;
        private final ByteBuffer zznk;
        private final int zzni;

        zzd(ByteBuffer byteBuffer) {
            super(null);
            this.zznj = byteBuffer;
            this.zznk = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzni = byteBuffer.position();
        }

        @Override
        public final void zzb(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzci)this).zzx(n << 3 | n3);
        }

        @Override
        public final void zzc(int n, int n2) throws IOException {
            ((zzci)this).zzb(n, 0);
            ((zzci)this).zzw(n2);
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            ((zzci)this).zzb(n, 0);
            ((zzci)this).zzx(n2);
        }

        @Override
        public final void zzf(int n, int n2) throws IOException {
            ((zzci)this).zzb(n, 5);
            ((zzci)this).zzz(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzci)this).zzb(n, 0);
            ((zzci)this).zza(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzci)this).zzb(n, 1);
            ((zzci)this).zzc(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzci)this).zzb(n, 0);
            ((zzci)this).zza((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zza(int n, String string) throws IOException {
            ((zzci)this).zzb(n, 2);
            ((zzci)this).zzal(string);
        }

        @Override
        public final void zza(int n, zzbu zzbu2) throws IOException {
            ((zzci)this).zzb(n, 2);
            ((zzci)this).zza(zzbu2);
        }

        @Override
        public final void zza(int n, zzeh zzeh2) throws IOException {
            ((zzci)this).zzb(n, 2);
            ((zzci)this).zzb(zzeh2);
        }

        @Override
        final void zza(int n, zzeh zzeh2, zzev zzev2) throws IOException {
            ((zzci)this).zzb(n, 2);
            ((zzci)this).zza(zzeh2, zzev2);
        }

        @Override
        public final void zzb(int n, zzeh zzeh2) throws IOException {
            ((zzci)this).zzb(1, 3);
            ((zzci)this).zzd(2, n);
            ((zzci)this).zza(3, zzeh2);
            ((zzci)this).zzb(1, 4);
        }

        @Override
        public final void zzb(int n, zzbu zzbu2) throws IOException {
            ((zzci)this).zzb(1, 3);
            ((zzci)this).zzd(2, n);
            ((zzci)this).zza(3, zzbu2);
            ((zzci)this).zzb(1, 4);
        }

        @Override
        public final void zzb(zzeh zzeh2) throws IOException {
            ((zzci)this).zzx(zzeh2.zzdq());
            zzeh2.zzb(this);
        }

        @Override
        final void zza(zzeh zzeh2, zzev zzev2) throws IOException {
            zzev zzev3 = zzev2;
            zzbn zzbn2 = (zzbn)zzeh2;
            int n = zzbn2.zzbp();
            if (n == -1) {
                n = zzev3.zzo(zzbn2);
                zzbn2.zzg(n);
            }
            ((zzci)this).zzx(n);
            zzev2.zza(zzeh2, this.zzng);
        }

        @Override
        public final void zza(byte by) throws IOException {
            try {
                this.zznk.put(by);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zza(zzbu zzbu2) throws IOException {
            ((zzci)this).zzx(zzbu2.size());
            zzbu2.zza(this);
        }

        @Override
        public final void zze(byte[] byArray, int n, int n2) throws IOException {
            ((zzci)this).zzx(n2);
            ((zzci)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzw(int n) throws IOException {
            if (n >= 0) {
                ((zzci)this).zzx(n);
                return;
            }
            ((zzci)this).zza(n);
        }

        @Override
        public final void zzx(int n) throws IOException {
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.zznk.put((byte)n);
                        return;
                    }
                    this.zznk.put((byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzz(int n) throws IOException {
            try {
                this.zznk.putInt(n);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zza(long l) throws IOException {
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.zznk.put((byte)l);
                        return;
                    }
                    this.zznk.put((byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzc(long l) throws IOException {
            try {
                this.zznk.putLong(l);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.zznk.put(byArray, n, n2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzci)this).write(byArray, n, n2);
        }

        @Override
        public final void zzal(String string) throws IOException {
            int n = this.zznk.position();
            try {
                int n2 = zzd.zzac(string.length() * 3);
                int n3 = zzd.zzac(string.length());
                if (n3 == n2) {
                    int n4 = this.zznk.position() + n3;
                    this.zznk.position(n4);
                    this.zzan(string);
                    int n5 = this.zznk.position();
                    this.zznk.position(n);
                    ((zzci)this).zzx(n5 - n4);
                    this.zznk.position(n5);
                    return;
                }
                int n6 = zzfx.zza(string);
                ((zzci)this).zzx(n6);
                this.zzan(string);
                return;
            }
            catch (zzga zzga2) {
                this.zznk.position(n);
                this.zza(string, zzga2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzc(illegalArgumentException);
            }
        }

        @Override
        public final void flush() {
            this.zznj.position(this.zznk.position());
        }

        @Override
        public final int zzdc() {
            return this.zznk.remaining();
        }

        private final void zzan(String string) throws IOException {
            try {
                zzfx.zza(string, this.zznk);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }
    }

    static final class zzb
    extends zza {
        private final ByteBuffer zznh;
        private int zzni;

        zzb(ByteBuffer byteBuffer) {
            super(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            this.zznh = byteBuffer;
            this.zzni = byteBuffer.position();
        }

        @Override
        public final void flush() {
            this.zznh.position(this.zzni + this.zzde());
        }
    }

    static class zza
    extends zzci {
        private final byte[] buffer;
        private final int offset;
        private final int limit;
        private int position;

        zza(byte[] byArray, int n, int n2) {
            super(null);
            if (byArray == null) {
                throw new NullPointerException("buffer");
            }
            if ((n | n2 | byArray.length - (n + n2)) < 0) {
                throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", byArray.length, n, n2));
            }
            this.buffer = byArray;
            this.offset = n;
            this.position = n;
            this.limit = n + n2;
        }

        @Override
        public final void zzb(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzci)this).zzx(n << 3 | n3);
        }

        @Override
        public final void zzc(int n, int n2) throws IOException {
            ((zzci)this).zzb(n, 0);
            ((zzci)this).zzw(n2);
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            ((zzci)this).zzb(n, 0);
            ((zzci)this).zzx(n2);
        }

        @Override
        public final void zzf(int n, int n2) throws IOException {
            ((zzci)this).zzb(n, 5);
            ((zzci)this).zzz(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzci)this).zzb(n, 0);
            ((zzci)this).zza(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzci)this).zzb(n, 1);
            ((zzci)this).zzc(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzci)this).zzb(n, 0);
            ((zzci)this).zza((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zza(int n, String string) throws IOException {
            ((zzci)this).zzb(n, 2);
            ((zzci)this).zzal(string);
        }

        @Override
        public final void zza(int n, zzbu zzbu2) throws IOException {
            ((zzci)this).zzb(n, 2);
            ((zzci)this).zza(zzbu2);
        }

        @Override
        public final void zza(zzbu zzbu2) throws IOException {
            ((zzci)this).zzx(zzbu2.size());
            zzbu2.zza(this);
        }

        @Override
        public final void zze(byte[] byArray, int n, int n2) throws IOException {
            ((zzci)this).zzx(n2);
            ((zzci)this).write(byArray, 0, n2);
        }

        @Override
        public final void zza(int n, zzeh zzeh2) throws IOException {
            ((zzci)this).zzb(n, 2);
            ((zzci)this).zzb(zzeh2);
        }

        @Override
        final void zza(int n, zzeh zzeh2, zzev zzev2) throws IOException {
            ((zzci)this).zzb(n, 2);
            zzev zzev3 = zzev2;
            zzbn zzbn2 = (zzbn)zzeh2;
            int n2 = zzbn2.zzbp();
            if (n2 == -1) {
                n2 = zzev3.zzo(zzbn2);
                zzbn2.zzg(n2);
            }
            ((zzci)this).zzx(n2);
            zzev2.zza(zzeh2, this.zzng);
        }

        @Override
        public final void zzb(int n, zzeh zzeh2) throws IOException {
            ((zzci)this).zzb(1, 3);
            ((zzci)this).zzd(2, n);
            ((zzci)this).zza(3, zzeh2);
            ((zzci)this).zzb(1, 4);
        }

        @Override
        public final void zzb(int n, zzbu zzbu2) throws IOException {
            ((zzci)this).zzb(1, 3);
            ((zzci)this).zzd(2, n);
            ((zzci)this).zza(3, zzbu2);
            ((zzci)this).zzb(1, 4);
        }

        @Override
        public final void zzb(zzeh zzeh2) throws IOException {
            ((zzci)this).zzx(zzeh2.zzdq());
            zzeh2.zzb(this);
        }

        @Override
        final void zza(zzeh zzeh2, zzev zzev2) throws IOException {
            zzev zzev3 = zzev2;
            zzbn zzbn2 = (zzbn)zzeh2;
            int n = zzbn2.zzbp();
            if (n == -1) {
                n = zzev3.zzo(zzbn2);
                zzbn2.zzg(n);
            }
            ((zzci)this).zzx(n);
            zzev2.zza(zzeh2, this.zzng);
        }

        @Override
        public final void zza(byte by) throws IOException {
            try {
                this.buffer[this.position++] = by;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzw(int n) throws IOException {
            if (n >= 0) {
                ((zzci)this).zzx(n);
                return;
            }
            ((zzci)this).zza(n);
        }

        @Override
        public final void zzx(int n) throws IOException {
            if (zznf && ((zzci)this).zzdc() >= 10) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzfv.zza(this.buffer, (long)this.position++, (byte)n);
                        return;
                    }
                    zzfv.zza(this.buffer, (long)this.position++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.buffer[this.position++] = (byte)n;
                        return;
                    }
                    this.buffer[this.position++] = (byte)(n & 0x7F | 0x80);
                    n >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzz(int n) throws IOException {
            try {
                this.buffer[this.position++] = (byte)n;
                this.buffer[this.position++] = (byte)(n >> 8);
                this.buffer[this.position++] = (byte)(n >> 16);
                this.buffer[this.position++] = n >> 24;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zza(long l) throws IOException {
            if (zznf && ((zzci)this).zzdc() >= 10) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzfv.zza(this.buffer, (long)this.position++, (byte)l);
                        return;
                    }
                    zzfv.zza(this.buffer, (long)this.position++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)l;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)l & 0x7F | 0x80);
                    l >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzc(long l) throws IOException {
            try {
                this.buffer[this.position++] = (byte)l;
                this.buffer[this.position++] = (byte)(l >> 8);
                this.buffer[this.position++] = (byte)(l >> 16);
                this.buffer[this.position++] = (byte)(l >> 24);
                this.buffer[this.position++] = (byte)(l >> 32);
                this.buffer[this.position++] = (byte)(l >> 40);
                this.buffer[this.position++] = (byte)(l >> 48);
                this.buffer[this.position++] = (byte)(l >> 56);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                System.arraycopy(byArray, n, this.buffer, this.position, n2);
                this.position += n2;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, n2), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzci)this).write(byArray, n, n2);
        }

        @Override
        public final void zzal(String string) throws IOException {
            int n = this.position;
            try {
                int n2 = zza.zzac(string.length() * 3);
                int n3 = zza.zzac(string.length());
                if (n3 == n2) {
                    this.position = n + n3;
                    int n4 = zzfx.zza(string, this.buffer, this.position, ((zzci)this).zzdc());
                    this.position = n;
                    int n5 = n4 - n - n3;
                    ((zzci)this).zzx(n5);
                    this.position = n4;
                    return;
                }
                int n6 = zzfx.zza(string);
                ((zzci)this).zzx(n6);
                this.position = zzfx.zza(string, this.buffer, this.position, ((zzci)this).zzdc());
                return;
            }
            catch (zzga zzga2) {
                this.position = n;
                this.zza(string, zzga2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public final int zzdc() {
            return this.limit - this.position;
        }

        public final int zzde() {
            return this.position - this.offset;
        }
    }

    public static final class zzc
    extends IOException {
        zzc() {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.");
        }

        zzc(String string) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        }

        zzc(Throwable throwable) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.", throwable);
        }

        zzc(String string, Throwable throwable) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2), throwable);
        }
    }
}

