/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_auth;

import com.google.android.gms.internal.firebase_auth.zzbq;
import com.google.android.gms.internal.firebase_auth.zzdd;
import com.google.android.gms.internal.firebase_auth.zzdg;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzdc
extends zzbq<Integer>
implements zzdg<Integer>,
RandomAccess {
    private static final zzdc zzrs = new zzdc();
    private int[] zzrt;
    private int size;

    zzdc() {
        this(new int[10], 0);
    }

    private zzdc(int[] nArray, int n) {
        this.zzrt = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzbt();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzrt, n2, this.zzrt, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzdc)) {
            return super.equals(object);
        }
        zzdc zzdc2 = (zzdc)object;
        if (this.size != zzdc2.size) {
            return false;
        }
        int[] nArray = zzdc2.zzrt;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzrt[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzrt[i];
        }
        return n;
    }

    public final int getInt(int n) {
        this.zzh(n);
        return this.zzrt[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzal(int n) {
        this.zzo(this.size, n);
    }

    private final void zzo(int n, int n2) {
        this.zzbt();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
        if (this.size < this.zzrt.length) {
            System.arraycopy(this.zzrt, n, this.zzrt, n + 1, this.size - n);
        } else {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzrt, 0, nArray, 0, n);
            System.arraycopy(this.zzrt, n, nArray, n + 1, this.size - n);
            this.zzrt = nArray;
        }
        this.zzrt[n] = n2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzbt();
        zzdd.checkNotNull(collection);
        if (!(collection instanceof zzdc)) {
            return super.addAll(collection);
        }
        zzdc zzdc2 = (zzdc)collection;
        if (zzdc2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzdc2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzdc2.size;
        if (n > this.zzrt.length) {
            this.zzrt = Arrays.copyOf(this.zzrt, n);
        }
        System.arraycopy(zzdc2.zzrt, 0, this.zzrt, this.size, zzdc2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzbt();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzrt[i])) continue;
            System.arraycopy(this.zzrt, i + 1, this.zzrt, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzh(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
    }

    private final String zzi(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzdc zzdc2 = this;
        zzdc2.zzbt();
        zzdc2.zzh(n);
        int n4 = zzdc2.zzrt[n];
        zzdc2.zzrt[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzdc zzdc2 = this;
        zzdc2.zzbt();
        zzdc2.zzh(n);
        int n2 = zzdc2.zzrt[n];
        if (n < zzdc2.size - 1) {
            System.arraycopy(zzdc2.zzrt, n + 1, zzdc2.zzrt, n, zzdc2.size - n);
        }
        --zzdc2.size;
        ++zzdc2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        this.zzo(n, n2);
    }

    @Override
    public final /* synthetic */ zzdg zzj(int n) {
        int n2 = n;
        zzdc zzdc2 = this;
        if (n2 < zzdc2.size) {
            throw new IllegalArgumentException();
        }
        return new zzdc(Arrays.copyOf(zzdc2.zzrt, n2), zzdc2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzrs.zzbs();
    }
}

