/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_auth;

import com.google.android.gms.internal.firebase_auth.zzci;
import com.google.android.gms.internal.firebase_auth.zzeh;
import com.google.android.gms.internal.firebase_auth.zzgm;
import com.google.android.gms.internal.firebase_auth.zzgt;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public final class zzgl {
    private final ByteBuffer zznk;
    private zzci zzxp;
    private int zzxq;

    private zzgl(byte[] byArray, int n, int n2) {
        this(ByteBuffer.wrap(byArray, n, n2));
    }

    private zzgl(ByteBuffer byteBuffer) {
        this.zznk = byteBuffer;
        this.zznk.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static zzgl zzf(byte[] byArray) {
        return zzgl.zzj(byArray, 0, byArray.length);
    }

    public static zzgl zzj(byte[] byArray, int n, int n2) {
        return new zzgl(byArray, 0, n2);
    }

    public final void zza(int n, long l) throws IOException {
        this.zzb(n, 0);
        long l2 = l;
        this.zzm(l2);
    }

    public final void zzi(int n, long l) throws IOException {
        this.zzb(n, 0);
        long l2 = l;
        this.zzm(l2);
    }

    public final void zzc(int n, int n2) throws IOException {
        this.zzb(n, 0);
        int n3 = n2;
        zzgl zzgl2 = this;
        if (n3 >= 0) {
            zzgl2.zzba(n3);
            return;
        }
        zzgl2.zzm(n3);
    }

    public final void zzb(int n, boolean bl) throws IOException {
        this.zzb(n, 0);
        boolean bl2 = bl;
        boolean bl3 = bl2;
        byte by = (byte)(bl3 ? 1 : 0);
        zzgl zzgl2 = this;
        if (!zzgl2.zznk.hasRemaining()) {
            throw new zzgm(zzgl2.zznk.position(), zzgl2.zznk.limit());
        }
        zzgl2.zznk.put(by);
    }

    public final void zza(int n, String string) throws IOException {
        this.zzb(n, 2);
        String string2 = string;
        zzgl zzgl2 = this;
        try {
            int n2 = zzgl.zzai(string2.length());
            int n3 = zzgl.zzai(string2.length() * 3);
            if (n2 == n3) {
                int n4 = zzgl2.zznk.position();
                if (zzgl2.zznk.remaining() < n2) {
                    throw new zzgm(n4 + n2, zzgl2.zznk.limit());
                }
                zzgl2.zznk.position(n4 + n2);
                zzgl.zzd(string2, zzgl2.zznk);
                int n5 = zzgl2.zznk.position();
                zzgl2.zznk.position(n4);
                zzgl2.zzba(n5 - n4 - n2);
                zzgl2.zznk.position(n5);
                return;
            }
            zzgl2.zzba(zzgl.zza(string2));
            zzgl.zzd(string2, zzgl2.zznk);
            return;
        }
        catch (BufferOverflowException bufferOverflowException) {
            zzgm zzgm2 = new zzgm(zzgl2.zznk.position(), zzgl2.zznk.limit());
            zzgm2.initCause(bufferOverflowException);
            throw zzgm2;
        }
    }

    public final void zza(int n, zzgt zzgt2) throws IOException {
        this.zzb(n, 2);
        zzgt zzgt3 = zzgt2;
        zzgl zzgl2 = this;
        zzgt zzgt4 = zzgt3;
        if (zzgt4.zzya < 0) {
            zzgt4.zzdq();
        }
        zzgl2.zzba(zzgt4.zzya);
        zzgt3.zza(zzgl2);
    }

    public final void zze(int n, zzeh zzeh2) throws IOException {
        zzgl zzgl2 = this;
        if (zzgl2.zzxp == null) {
            zzgl2.zzxp = zzci.zza(zzgl2.zznk);
            zzgl2.zzxq = zzgl2.zznk.position();
        } else if (zzgl2.zzxq != zzgl2.zznk.position()) {
            zzgl2.zzxp.write(zzgl2.zznk.array(), zzgl2.zzxq, zzgl2.zznk.position() - zzgl2.zzxq);
            zzgl2.zzxq = zzgl2.zznk.position();
        }
        zzci zzci2 = zzgl2.zzxp;
        zzci2.zza(13, zzeh2);
        zzci2.flush();
        this.zzxq = this.zznk.position();
    }

    public final void zza(int n, byte[] byArray) throws IOException {
        this.zzb(n, 2);
        byte[] byArray2 = byArray;
        zzgl zzgl2 = this;
        zzgl2.zzba(byArray2.length);
        zzgl2.zzg(byArray2);
    }

    private static int zza(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
            } else {
                int n4 = n;
                CharSequence charSequence2 = charSequence;
                int n5 = charSequence2.length();
                int n6 = 0;
                for (int i = n4; i < n5; ++i) {
                    char c2 = charSequence2.charAt(i);
                    if (c2 < '\u0800') {
                        n6 += 127 - c2 >>> 31;
                        continue;
                    }
                    n6 += 2;
                    if ('\ud800' > c2 || c2 > '\udfff') continue;
                    if (Character.codePointAt(charSequence2, i) < 65536) {
                        int n7 = i;
                        throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n7).toString());
                    }
                    ++i;
                }
                n3 += n6;
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            long l = (long)n3 + 0x100000000L;
            throw new IllegalArgumentException(new StringBuilder(54).append("UTF-8 length does not fit in int: ").append(l).toString());
        }
        return n3;
    }

    private static void zzd(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (byteBuffer.hasArray()) {
            try {
                int n;
                char c;
                int n2;
                int n3 = byteBuffer.remaining();
                int n4 = byteBuffer.arrayOffset() + byteBuffer.position();
                byte[] byArray = byteBuffer.array();
                CharSequence charSequence2 = charSequence;
                int n5 = charSequence2.length();
                int n6 = n4 + n3;
                for (n2 = 0; n2 < n5 && n2 + n4 < n6 && (c = charSequence2.charAt(n2)) < '\u0080'; ++n2) {
                    byArray[n4 + n2] = (byte)c;
                }
                if (n2 == n5) {
                    n = n4 + n5;
                } else {
                    int n7 = n4 + n2;
                    while (n2 < n5) {
                        int n8;
                        char c2;
                        c = charSequence2.charAt(n2);
                        if (c < '\u0080' && n7 < n6) {
                            byArray[n7++] = (byte)c;
                        } else if (c < '\u0800' && n7 <= n6 - 2) {
                            byArray[n7++] = (byte)(0x3C0 | c >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c);
                        } else if ((c < '\ud800' || '\udfff' < c) && n7 <= n6 - 3) {
                            byArray[n7++] = (byte)(0x1E0 | c >>> 12);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c);
                        } else if (n7 <= n6 - 4) {
                            if (n2 + 1 == charSequence2.length() || !Character.isSurrogatePair(c, c2 = charSequence2.charAt(++n2))) {
                                n8 = n2 - 1;
                                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n8).toString());
                            }
                            n8 = Character.toCodePoint(c, c2);
                            byArray[n7++] = (byte)(0xF0 | n8 >>> 18);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8 >>> 12);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8 >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8);
                        } else {
                            c2 = c;
                            n8 = n7;
                            throw new ArrayIndexOutOfBoundsException(new StringBuilder(37).append("Failed writing ").append(c2).append(" at index ").append(n8).toString());
                        }
                        ++n2;
                    }
                    n = n7;
                }
                int n9 = n;
                byteBuffer.position(n9 - byteBuffer.arrayOffset());
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                BufferOverflowException bufferOverflowException = new BufferOverflowException();
                bufferOverflowException.initCause(arrayIndexOutOfBoundsException);
                throw bufferOverflowException;
            }
        }
        ByteBuffer byteBuffer2 = byteBuffer;
        CharSequence charSequence3 = charSequence;
        int n = charSequence3.length();
        for (int i = 0; i < n; ++i) {
            int n10;
            char c;
            char c3 = charSequence3.charAt(i);
            if (c3 < '\u0080') {
                byteBuffer2.put((byte)c3);
                continue;
            }
            if (c3 < '\u0800') {
                byteBuffer2.put((byte)(0x3C0 | c3 >>> 6));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3));
                continue;
            }
            if (c3 < '\ud800' || '\udfff' < c3) {
                byteBuffer2.put((byte)(0x1E0 | c3 >>> 12));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3 >>> 6));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3));
                continue;
            }
            if (i + 1 == charSequence3.length() || !Character.isSurrogatePair(c3, c = charSequence3.charAt(++i))) {
                n10 = i - 1;
                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n10).toString());
            }
            n10 = Character.toCodePoint(c3, c);
            byteBuffer2.put((byte)(0xF0 | n10 >>> 18));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10 >>> 12));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10 >>> 6));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10));
        }
    }

    public static int zze(int n, long l) {
        return zzgl.zzaa(n) + zzgl.zzn(l);
    }

    public static int zzd(int n, long l) {
        return zzgl.zzaa(n) + zzgl.zzn(l);
    }

    public static int zzg(int n, int n2) {
        return zzgl.zzaa(n) + zzgl.zzab(n2);
    }

    public static int zzb(int n, String string) {
        return zzgl.zzaa(n) + zzgl.zzam(string);
    }

    public static int zzb(int n, zzgt zzgt2) {
        int n2 = zzgt2.zzdq();
        return zzgl.zzaa(n) + (zzgl.zzai(n2) + n2);
    }

    public static int zzb(int n, byte[] byArray) {
        byte[] byArray2 = byArray;
        return zzgl.zzaa(n) + (zzgl.zzai(byArray.length) + byArray2.length);
    }

    public static int zzab(int n) {
        if (n >= 0) {
            return zzgl.zzai(n);
        }
        return 10;
    }

    public static int zzam(String string) {
        int n = zzgl.zza(string);
        return zzgl.zzai(n) + n;
    }

    public final void zzgm() {
        if (this.zznk.remaining() != 0) {
            throw new IllegalStateException(String.format("Did not write as much data as expected, %s bytes remaining.", this.zznk.remaining()));
        }
    }

    private final void zzaz(int n) throws IOException {
        byte by = (byte)n;
        zzgl zzgl2 = this;
        if (!zzgl2.zznk.hasRemaining()) {
            throw new zzgm(zzgl2.zznk.position(), zzgl2.zznk.limit());
        }
        zzgl2.zznk.put(by);
    }

    public final void zzg(byte[] byArray) throws IOException {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        zzgl zzgl2 = this;
        if (zzgl2.zznk.remaining() >= n) {
            zzgl2.zznk.put(byArray2, 0, n);
            return;
        }
        throw new zzgm(zzgl2.zznk.position(), zzgl2.zznk.limit());
    }

    private final void zzb(int n, int n2) throws IOException {
        int n3 = n2;
        this.zzba(n << 3 | n3);
    }

    public static int zzaa(int n) {
        return zzgl.zzai(n << 3);
    }

    public final void zzba(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.zzaz(n);
                return;
            }
            this.zzaz(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public static int zzai(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    private final void zzm(long l) throws IOException {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.zzaz((int)l);
                return;
            }
            this.zzaz((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }

    private static int zzn(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }
}

