/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.logging.Logger;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.zzf;

@SafeParcelable.Class(creator="EmailAuthCredentialCreator")
public class EmailAuthCredential
extends AuthCredential {
    public static final Parcelable.Creator<EmailAuthCredential> CREATOR = new zzf();
    private static final Logger zzdx = new Logger("EmailAuthCredential", new String[0]);
    @SafeParcelable.Field(id=1, getter="getEmail")
    private String zzah;
    @SafeParcelable.Field(id=2, getter="getPassword")
    private String zzbi;
    @SafeParcelable.Field(id=3, getter="getSignInLink")
    private final String zzdy;
    @SafeParcelable.Field(id=4, getter="getCachedState")
    private String zzdz;
    @SafeParcelable.Field(id=5, getter="isForLinking")
    private boolean zzea;

    @SafeParcelable.Constructor
    EmailAuthCredential(@SafeParcelable.Param(id=1) @NonNull String string, @SafeParcelable.Param(id=2) @NonNull String string2, @SafeParcelable.Param(id=3) @NonNull String string3, @SafeParcelable.Param(id=4) @NonNull String string4, @SafeParcelable.Param(id=5) @NonNull boolean bl) {
        this.zzah = Preconditions.checkNotEmpty((String)string);
        if (TextUtils.isEmpty((CharSequence)string2) && TextUtils.isEmpty((CharSequence)string3)) {
            throw new IllegalArgumentException("Cannot create an EmailAuthCredential without a password or emailLink.");
        }
        this.zzbi = string2;
        this.zzdy = string3;
        this.zzdz = string4;
        this.zzea = bl;
    }

    EmailAuthCredential(String string, String string2) {
        this(string, string2, null, null, false);
    }

    @NonNull
    public final String getEmail() {
        return this.zzah;
    }

    @NonNull
    public final String getPassword() {
        return this.zzbi;
    }

    @NonNull
    public final String zzg() {
        return this.zzdy;
    }

    @Nullable
    public final String zzh() {
        return this.zzdz;
    }

    public final boolean zzi() {
        return this.zzea;
    }

    public final EmailAuthCredential zza(@Nullable FirebaseUser firebaseUser) {
        this.zzdz = firebaseUser.zzq();
        this.zzea = true;
        return this;
    }

    @Override
    @NonNull
    public String getProvider() {
        return "password";
    }

    @Override
    public String getSignInMethod() {
        if (!TextUtils.isEmpty((CharSequence)this.zzbi)) {
            return "password";
        }
        return "emailLink";
    }

    public final boolean zzj() {
        return !TextUtils.isEmpty((CharSequence)this.zzdy);
    }

    public static boolean isSignInWithEmailLink(@NonNull String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        try {
            if (EmailAuthCredential.zzb(string)) {
                return true;
            }
            return EmailAuthCredential.zzb(Uri.parse((String)string).getQueryParameter("link"));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Object[] objectArray = new Object[1];
            String string2 = String.valueOf(unsupportedOperationException.getMessage());
            objectArray[0] = string2.length() != 0 ? "isSignInWithEmailLink returned an UnsupportedOperationException: ".concat(string2) : new String("isSignInWithEmailLink returned an UnsupportedOperationException: ");
            zzdx.v("EmailAuthCredential", objectArray);
            return false;
        }
    }

    private static boolean zzb(@NonNull String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        Uri uri = Uri.parse((String)string);
        String string2 = uri.getQueryParameter("oobCode");
        String string3 = uri.getQueryParameter("mode");
        return !TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3) && string3.equals("signIn");
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        EmailAuthCredential emailAuthCredential = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)1, (String)emailAuthCredential.zzah, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)emailAuthCredential.zzbi, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)emailAuthCredential.zzdy, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)emailAuthCredential.zzdz, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)5, (boolean)emailAuthCredential.zzea);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }
}

