/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.firebase_auth.zzao;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.FirebaseUserMetadata;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.UserInfo;
import com.google.firebase.auth.internal.zzh;
import com.google.firebase.auth.internal.zzm;
import com.google.firebase.auth.internal.zzn;
import com.google.firebase.auth.internal.zzy;
import com.google.firebase.auth.zzd;
import java.util.ArrayList;
import java.util.List;

@SafeParcelable.Class(creator="DefaultFirebaseUserCreator")
public class zzl
extends FirebaseUser {
    public static final Parcelable.Creator<zzl> CREATOR = new zzm();
    @SafeParcelable.Field(id=1, getter="getCachedTokenState")
    private zzao zzkw;
    @SafeParcelable.Field(id=2, getter="getDefaultAuthUserInfo")
    private zzh zzkx;
    @SafeParcelable.Field(id=3, getter="getFirebaseAppName")
    private String zzky;
    @SafeParcelable.Field(id=4, getter="getUserType")
    private String zzkz;
    @SafeParcelable.Field(id=5, getter="getUserInfos")
    private List<zzh> zzla;
    @SafeParcelable.Field(id=6, getter="getProviders")
    private List<String> zzlb;
    @SafeParcelable.Field(id=7, getter="getCurrentVersion")
    private String zzlc;
    @SafeParcelable.Field(id=8, getter="isAnonymous")
    private Boolean zzld;
    @SafeParcelable.Field(id=9, getter="getMetadata")
    private zzn zzle;
    @SafeParcelable.Field(id=10, getter="isNewUser")
    private boolean zzak;
    @SafeParcelable.Field(id=11, getter="getDefaultOAuthCredential")
    private zzd zzju;

    @SafeParcelable.Constructor
    zzl(@SafeParcelable.Param(id=1) zzao zzao2, @SafeParcelable.Param(id=2) zzh zzh2, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) String string2, @SafeParcelable.Param(id=5) List<zzh> list, @SafeParcelable.Param(id=6) List<String> list2, @SafeParcelable.Param(id=7) String string3, @SafeParcelable.Param(id=8) Boolean bl, @SafeParcelable.Param(id=9) zzn zzn2, @SafeParcelable.Param(id=10) boolean bl2, @SafeParcelable.Param(id=11) zzd zzd2) {
        this.zzkw = zzao2;
        this.zzkx = zzh2;
        this.zzky = string;
        this.zzkz = string2;
        this.zzla = list;
        this.zzlb = list2;
        this.zzlc = string3;
        this.zzld = bl;
        this.zzle = zzn2;
        this.zzak = bl2;
        this.zzju = zzd2;
    }

    public zzl(@NonNull FirebaseApp firebaseApp, @NonNull List<? extends UserInfo> list) {
        Preconditions.checkNotNull((Object)firebaseApp);
        this.zzky = firebaseApp.getName();
        this.zzkz = "com.google.firebase.auth.internal.DefaultFirebaseUser";
        this.zzlc = "2";
        ((FirebaseUser)this).zza(list);
    }

    @Override
    @Nullable
    public String getDisplayName() {
        return this.zzkx.getDisplayName();
    }

    @Override
    @Nullable
    public Uri getPhotoUrl() {
        return this.zzkx.getPhotoUrl();
    }

    @Override
    @Nullable
    public String getEmail() {
        return this.zzkx.getEmail();
    }

    @Override
    @Nullable
    public String getPhoneNumber() {
        return this.zzkx.getPhoneNumber();
    }

    public final zzl zzae(@NonNull String string) {
        this.zzlc = string;
        return this;
    }

    @Override
    @NonNull
    public String getProviderId() {
        return this.zzkx.getProviderId();
    }

    @Override
    @NonNull
    public final FirebaseApp zzo() {
        return FirebaseApp.getInstance((String)this.zzky);
    }

    public final List<zzh> zzbg() {
        return this.zzla;
    }

    @Override
    @NonNull
    public String getUid() {
        return this.zzkx.getUid();
    }

    @Override
    public boolean isAnonymous() {
        if (this.zzld == null || this.zzld.booleanValue()) {
            String string = "";
            if (this.zzkw != null) {
                GetTokenResult getTokenResult = zzy.zzag(this.zzkw.zzaw());
                string = getTokenResult != null ? getTokenResult.getSignInProvider() : "";
            }
            this.zzld = ((FirebaseUser)this).getProviderData().size() <= 1 && (string == null || !string.equals("custom"));
        }
        return this.zzld;
    }

    @Override
    @Nullable
    public final List<String> getProviders() {
        return this.zzlb;
    }

    @Override
    @NonNull
    public final FirebaseUser zza(@NonNull List<? extends UserInfo> list) {
        Preconditions.checkNotNull(list);
        this.zzla = new ArrayList<zzh>(list.size());
        this.zzlb = new ArrayList<String>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            UserInfo userInfo = list.get(i);
            if (userInfo.getProviderId().equals("firebase")) {
                this.zzkx = (zzh)userInfo;
            } else {
                this.zzlb.add(userInfo.getProviderId());
            }
            this.zzla.add((zzh)userInfo);
        }
        if (this.zzkx == null) {
            this.zzkx = this.zzla.get(0);
        }
        return this;
    }

    @Override
    @NonNull
    public List<? extends UserInfo> getProviderData() {
        return this.zzla;
    }

    @Override
    @NonNull
    public final zzao zzp() {
        return this.zzkw;
    }

    @Override
    @NonNull
    public final String zzr() {
        return ((FirebaseUser)this).zzp().zzaw();
    }

    @Override
    @NonNull
    public final String zzq() {
        return this.zzkw.toJson();
    }

    @Override
    public final void zza(@NonNull zzao zzao2) {
        this.zzkw = (zzao)Preconditions.checkNotNull((Object)zzao2);
    }

    @Override
    public boolean isEmailVerified() {
        return this.zzkx.isEmailVerified();
    }

    public final void zza(zzn zzn2) {
        this.zzle = zzn2;
    }

    @Override
    public FirebaseUserMetadata getMetadata() {
        return this.zzle;
    }

    public final void zze(boolean bl) {
        this.zzak = bl;
    }

    public final boolean isNewUser() {
        return this.zzak;
    }

    public final void zzc(zzd zzd2) {
        this.zzju = zzd2;
    }

    @Nullable
    public final zzd zzav() {
        return this.zzju;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzl zzl2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)1, (Parcelable)((FirebaseUser)zzl2).zzp(), (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)zzl2.zzkx, (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)zzl2.zzky, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)zzl2.zzkz, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)5, zzl2.zzla, (boolean)false);
        SafeParcelWriter.writeStringList((Parcel)parcel2, (int)6, ((FirebaseUser)zzl2).getProviders(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)zzl2.zzlc, (boolean)false);
        SafeParcelWriter.writeBooleanObject((Parcel)parcel2, (int)8, (Boolean)((FirebaseUser)zzl2).isAnonymous(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)9, (Parcelable)((FirebaseUser)zzl2).getMetadata(), (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)10, (boolean)zzl2.zzak);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)11, (Parcelable)zzl2.zzju, (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public static FirebaseUser zza(FirebaseApp firebaseApp, FirebaseUser firebaseUser) {
        zzl zzl2 = new zzl(firebaseApp, firebaseUser.getProviderData());
        if (firebaseUser instanceof zzl) {
            zzl zzl3 = (zzl)firebaseUser;
            Object object = zzl3.zzlc;
            zzl2.zzlc = object;
            object = zzl3.zzkz;
            zzl2.zzkz = object;
            object = (zzn)((FirebaseUser)zzl3).getMetadata();
            zzl2.zzle = object;
        } else {
            zzl2.zzle = null;
        }
        if (firebaseUser.zzp() != null) {
            ((FirebaseUser)zzl2).zza(firebaseUser.zzp());
        }
        if (!firebaseUser.isAnonymous()) {
            ((FirebaseUser)zzl2).zzn();
        }
        return zzl2;
    }

    @Override
    public final /* synthetic */ FirebaseUser zzn() {
        zzl zzl2 = this;
        this.zzld = false;
        return zzl2;
    }
}

