/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.logging.Logger;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.firebase_auth.zzv;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class zzz {
    private static final Logger zzdx = new Logger("JSONParser", new String[0]);

    @NonNull
    public static Map<String, Object> zzah(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        String[] stringArray = string.split("\\.");
        if (stringArray.length < 2) {
            String string2 = String.valueOf(string);
            zzdx.e(string2.length() != 0 ? "Invalid idToken ".concat(string2) : new String("Invalid idToken "), new Object[0]);
            return Collections.EMPTY_MAP;
        }
        String string3 = stringArray[1];
        try {
            Map<String, Object> map = zzz.zzai(new String(Base64Utils.decodeUrlSafeNoPadding((String)string3), "UTF-8"));
            if (map == null) {
                return Collections.EMPTY_MAP;
            }
            return map;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            zzdx.e("Unable to decode token", (Throwable)unsupportedEncodingException, new Object[0]);
            return Collections.EMPTY_MAP;
        }
    }

    @Nullable
    public static Map<String, Object> zzai(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            if (jSONObject != JSONObject.NULL) {
                return zzz.zzb(jSONObject);
            }
            return null;
        }
        catch (Exception exception) {
            Log.d((String)"JSONParser", (String)"Failed to parse JSONObject into Map.");
            throw new zzv(exception);
        }
    }

    @VisibleForTesting
    private static Map<String, Object> zzb(JSONObject jSONObject) throws JSONException {
        ArrayMap arrayMap = new ArrayMap();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            List<Object> list = jSONObject.get(string);
            if (list instanceof JSONArray) {
                list = zzz.zza((JSONArray)list);
            } else if (list instanceof JSONObject) {
                list = zzz.zzb((JSONObject)list);
            }
            arrayMap.put(string, list);
        }
        return arrayMap;
    }

    @VisibleForTesting
    private static List<Object> zza(JSONArray jSONArray) throws JSONException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            List<Object> list = jSONArray.get(i);
            if (list instanceof JSONArray) {
                list = zzz.zza((JSONArray)list);
            } else if (list instanceof JSONObject) {
                list = zzz.zzb((JSONObject)list);
            }
            arrayList.add(list);
        }
        return arrayList;
    }
}

