/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_auth;

import com.google.android.gms.internal.firebase_auth.zzbo;
import com.google.android.gms.internal.firebase_auth.zzbu;
import com.google.android.gms.internal.firebase_auth.zzbv;
import com.google.android.gms.internal.firebase_auth.zzcm;
import com.google.android.gms.internal.firebase_auth.zzcn;
import com.google.android.gms.internal.firebase_auth.zzdg;
import com.google.android.gms.internal.firebase_auth.zzdr;
import com.google.android.gms.internal.firebase_auth.zzek;
import com.google.android.gms.internal.firebase_auth.zzez;
import com.google.android.gms.internal.firebase_auth.zzfz;
import com.google.android.gms.internal.firebase_auth.zzgb;
import com.google.android.gms.internal.firebase_auth.zzgf;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class zzcl
extends zzbu {
    private static final Logger logger = Logger.getLogger(zzcl.class.getName());
    private static final boolean zznj = zzfz.zzgh();
    zzcn zznk;

    public static zzcl zzb(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        return new zza(byArray2, 0, n);
    }

    public static zzcl zza(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            return new zzb(byteBuffer);
        }
        if (byteBuffer.isDirect() && !byteBuffer.isReadOnly()) {
            if (zzfz.zzgi()) {
                ByteBuffer byteBuffer2 = byteBuffer;
                return new zze(byteBuffer2);
            }
            ByteBuffer byteBuffer3 = byteBuffer;
            return new zzd(byteBuffer3);
        }
        throw new IllegalArgumentException("ByteBuffer is read-only");
    }

    private zzcl() {
    }

    public abstract void zzb(int var1, int var2) throws IOException;

    public abstract void zzc(int var1, int var2) throws IOException;

    public abstract void zzd(int var1, int var2) throws IOException;

    public final void zze(int n, int n2) throws IOException {
        this.zzd(n, zzcl.zzah(n2));
    }

    public abstract void zzf(int var1, int var2) throws IOException;

    public abstract void zza(int var1, long var2) throws IOException;

    public final void zzb(int n, long l) throws IOException {
        this.zza(n, zzcl.zzi(l));
    }

    public abstract void zzc(int var1, long var2) throws IOException;

    public final void zza(int n, float f) throws IOException {
        this.zzf(n, Float.floatToRawIntBits(f));
    }

    public final void zza(int n, double d) throws IOException {
        this.zzc(n, Double.doubleToRawLongBits(d));
    }

    public abstract void zzb(int var1, boolean var2) throws IOException;

    public abstract void zza(int var1, String var2) throws IOException;

    public abstract void zza(int var1, zzbv var2) throws IOException;

    public abstract void zza(int var1, zzek var2) throws IOException;

    abstract void zza(int var1, zzek var2, zzez var3) throws IOException;

    public abstract void zzb(int var1, zzek var2) throws IOException;

    public abstract void zzb(int var1, zzbv var2) throws IOException;

    public abstract void zzw(int var1) throws IOException;

    public abstract void zzx(int var1) throws IOException;

    public final void zzy(int n) throws IOException {
        this.zzx(zzcl.zzah(n));
    }

    public abstract void zzz(int var1) throws IOException;

    public abstract void zza(long var1) throws IOException;

    public final void zzb(long l) throws IOException {
        this.zza(zzcl.zzi(l));
    }

    public abstract void zzc(long var1) throws IOException;

    public final void zza(float f) throws IOException {
        this.zzz(Float.floatToRawIntBits(f));
    }

    public final void zza(double d) throws IOException {
        this.zzc(Double.doubleToRawLongBits(d));
    }

    public final void zze(boolean bl) throws IOException {
        this.zzc((byte)(bl ? 1 : 0));
    }

    public abstract void zzal(String var1) throws IOException;

    public abstract void zza(zzbv var1) throws IOException;

    public abstract void zzb(zzek var1) throws IOException;

    abstract void zza(zzek var1, zzez var2) throws IOException;

    public abstract void zzc(byte var1) throws IOException;

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public static int zzg(int n, int n2) {
        return zzcl.zzaa(n) + zzcl.zzab(n2);
    }

    public static int zzh(int n, int n2) {
        return zzcl.zzaa(n) + zzcl.zzac(n2);
    }

    public static int zzi(int n, int n2) {
        return zzcl.zzaa(n) + zzcl.zzac(zzcl.zzah(n2));
    }

    public static int zzj(int n, int n2) {
        return zzcl.zzaa(n) + 4;
    }

    public static int zzk(int n, int n2) {
        return zzcl.zzaa(n) + 4;
    }

    public static int zzd(int n, long l) {
        return zzcl.zzaa(n) + zzcl.zze(l);
    }

    public static int zze(int n, long l) {
        return zzcl.zzaa(n) + zzcl.zze(l);
    }

    public static int zzf(int n, long l) {
        return zzcl.zzaa(n) + zzcl.zze(zzcl.zzi(l));
    }

    public static int zzg(int n, long l) {
        return zzcl.zzaa(n) + 8;
    }

    public static int zzh(int n, long l) {
        return zzcl.zzaa(n) + 8;
    }

    public static int zzb(int n, float f) {
        return zzcl.zzaa(n) + 4;
    }

    public static int zzb(int n, double d) {
        return zzcl.zzaa(n) + 8;
    }

    public static int zzc(int n, boolean bl) {
        return zzcl.zzaa(n) + 1;
    }

    public static int zzl(int n, int n2) {
        return zzcl.zzaa(n) + zzcl.zzab(n2);
    }

    public static int zzb(int n, String string) {
        return zzcl.zzaa(n) + zzcl.zzam(string);
    }

    public static int zzc(int n, zzbv zzbv2) {
        int n2 = zzbv2.size();
        return zzcl.zzaa(n) + (zzcl.zzac(n2) + n2);
    }

    public static int zza(int n, zzdr zzdr2) {
        int n2 = zzdr2.zzdt();
        return zzcl.zzaa(n) + (zzcl.zzac(n2) + n2);
    }

    public static int zzc(int n, zzek zzek2) {
        return zzcl.zzaa(n) + zzcl.zzc(zzek2);
    }

    static int zzb(int n, zzek zzek2, zzez zzez2) {
        return zzcl.zzaa(n) + zzcl.zzb(zzek2, zzez2);
    }

    public static int zzd(int n, zzek zzek2) {
        return (zzcl.zzaa(1) << 1) + zzcl.zzh(2, n) + zzcl.zzc(3, zzek2);
    }

    public static int zzd(int n, zzbv zzbv2) {
        return (zzcl.zzaa(1) << 1) + zzcl.zzh(2, n) + zzcl.zzc(3, zzbv2);
    }

    public static int zzb(int n, zzdr zzdr2) {
        return (zzcl.zzaa(1) << 1) + zzcl.zzh(2, n) + zzcl.zza(3, zzdr2);
    }

    public static int zzaa(int n) {
        return zzcl.zzac(n << 3);
    }

    public static int zzab(int n) {
        if (n >= 0) {
            return zzcl.zzac(n);
        }
        return 10;
    }

    public static int zzac(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int zzad(int n) {
        return zzcl.zzac(zzcl.zzah(n));
    }

    public static int zzae(int n) {
        return 4;
    }

    public static int zzaf(int n) {
        return 4;
    }

    public static int zzd(long l) {
        return zzcl.zze(l);
    }

    public static int zze(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (l < 0L) {
            return 10;
        }
        int n = 2;
        if ((l & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            l >>>= 28;
        }
        if ((l & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            l >>>= 14;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    public static int zzf(long l) {
        return zzcl.zze(zzcl.zzi(l));
    }

    public static int zzg(long l) {
        return 8;
    }

    public static int zzh(long l) {
        return 8;
    }

    public static int zzb(float f) {
        return 4;
    }

    public static int zzb(double d) {
        return 8;
    }

    public static int zzf(boolean bl) {
        return 1;
    }

    public static int zzag(int n) {
        return zzcl.zzab(n);
    }

    public static int zzam(String string) {
        int n;
        try {
            n = zzgb.zza(string);
        }
        catch (zzgf zzgf2) {
            n = string.getBytes(zzdg.UTF_8).length;
        }
        int n2 = n;
        return zzcl.zzac(n2) + n2;
    }

    public static int zza(zzdr zzdr2) {
        int n = zzdr2.zzdt();
        return zzcl.zzac(n) + n;
    }

    public static int zzb(zzbv zzbv2) {
        int n = zzbv2.size();
        return zzcl.zzac(n) + n;
    }

    public static int zzc(byte[] byArray) {
        int n = byArray.length;
        return zzcl.zzac(n) + n;
    }

    public static int zzc(zzek zzek2) {
        int n = zzek2.zzdt();
        return zzcl.zzac(n) + n;
    }

    static int zzb(zzek zzek2, zzez zzez2) {
        zzez zzez3 = zzez2;
        zzbo zzbo2 = (zzbo)zzek2;
        int n = zzbo2.zzbs();
        if (n == -1) {
            n = zzez3.zzo(zzbo2);
            zzbo2.zzg(n);
        }
        int n2 = n;
        return zzcl.zzac(n2) + n2;
    }

    private static int zzah(int n) {
        return n << 1 ^ n >> 31;
    }

    private static long zzi(long l) {
        return l << 1 ^ l >> 63;
    }

    public abstract void flush() throws IOException;

    public abstract int zzdf();

    abstract void zze(byte[] var1, int var2, int var3) throws IOException;

    final void zza(String string, zzgf zzgf2) throws IOException {
        logger.logp(Level.WARNING, "com.google.protobuf.CodedOutputStream", "inefficientWriteStringNoTag", "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", zzgf2);
        byte[] byArray = string.getBytes(zzdg.UTF_8);
        try {
            this.zzx(byArray.length);
            this.zza(byArray, 0, byArray.length);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new zzc(indexOutOfBoundsException);
        }
        catch (zzc zzc2) {
            throw zzc2;
        }
    }

    @Deprecated
    static int zzc(int n, zzek zzek2, zzez zzez2) {
        zzez zzez3;
        int n2 = zzcl.zzaa(n) << 1;
        zzez zzez4 = zzez3 = zzez2;
        zzbo zzbo2 = (zzbo)zzek2;
        int n3 = zzbo2.zzbs();
        if (n3 == -1) {
            n3 = zzez4.zzo(zzbo2);
            zzbo2.zzg(n3);
        }
        return n2 + n3;
    }

    @Deprecated
    public static int zzd(zzek zzek2) {
        return zzek2.zzdt();
    }

    @Deprecated
    public static int zzai(int n) {
        return zzcl.zzac(n);
    }

    /* synthetic */ zzcl(zzcm zzcm2) {
        this();
    }

    static final class zze
    extends zzcl {
        private final ByteBuffer zznn;
        private final ByteBuffer zzno;
        private final long zznp;
        private final long zznq;
        private final long zznr;
        private final long zzns;
        private long zznt;

        zze(ByteBuffer byteBuffer) {
            super(null);
            this.zznn = byteBuffer;
            this.zzno = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zznp = zzfz.zzb(byteBuffer);
            this.zznq = this.zznp + (long)byteBuffer.position();
            this.zznr = this.zznp + (long)byteBuffer.limit();
            this.zzns = this.zznr - 10L;
            this.zznt = this.zznq;
        }

        @Override
        public final void zzb(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzcl)this).zzx(n << 3 | n3);
        }

        @Override
        public final void zzc(int n, int n2) throws IOException {
            ((zzcl)this).zzb(n, 0);
            ((zzcl)this).zzw(n2);
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            ((zzcl)this).zzb(n, 0);
            ((zzcl)this).zzx(n2);
        }

        @Override
        public final void zzf(int n, int n2) throws IOException {
            ((zzcl)this).zzb(n, 5);
            ((zzcl)this).zzz(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzcl)this).zzb(n, 0);
            ((zzcl)this).zza(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzcl)this).zzb(n, 1);
            ((zzcl)this).zzc(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzcl)this).zzb(n, 0);
            ((zzcl)this).zzc((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zza(int n, String string) throws IOException {
            ((zzcl)this).zzb(n, 2);
            ((zzcl)this).zzal(string);
        }

        @Override
        public final void zza(int n, zzbv zzbv2) throws IOException {
            ((zzcl)this).zzb(n, 2);
            ((zzcl)this).zza(zzbv2);
        }

        @Override
        public final void zza(int n, zzek zzek2) throws IOException {
            ((zzcl)this).zzb(n, 2);
            ((zzcl)this).zzb(zzek2);
        }

        @Override
        final void zza(int n, zzek zzek2, zzez zzez2) throws IOException {
            ((zzcl)this).zzb(n, 2);
            ((zzcl)this).zza(zzek2, zzez2);
        }

        @Override
        public final void zzb(int n, zzek zzek2) throws IOException {
            ((zzcl)this).zzb(1, 3);
            ((zzcl)this).zzd(2, n);
            ((zzcl)this).zza(3, zzek2);
            ((zzcl)this).zzb(1, 4);
        }

        @Override
        public final void zzb(int n, zzbv zzbv2) throws IOException {
            ((zzcl)this).zzb(1, 3);
            ((zzcl)this).zzd(2, n);
            ((zzcl)this).zza(3, zzbv2);
            ((zzcl)this).zzb(1, 4);
        }

        @Override
        public final void zzb(zzek zzek2) throws IOException {
            ((zzcl)this).zzx(zzek2.zzdt());
            zzek2.zzb(this);
        }

        @Override
        final void zza(zzek zzek2, zzez zzez2) throws IOException {
            zzez zzez3 = zzez2;
            zzbo zzbo2 = (zzbo)zzek2;
            int n = zzbo2.zzbs();
            if (n == -1) {
                n = zzez3.zzo(zzbo2);
                zzbo2.zzg(n);
            }
            ((zzcl)this).zzx(n);
            zzez2.zza(zzek2, this.zznk);
        }

        @Override
        public final void zzc(byte by) throws IOException {
            if (this.zznt >= this.zznr) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zznt, this.zznr, 1));
            }
            zzfz.zza(this.zznt++, by);
        }

        @Override
        public final void zza(zzbv zzbv2) throws IOException {
            ((zzcl)this).zzx(zzbv2.size());
            zzbv2.zza(this);
        }

        @Override
        public final void zze(byte[] byArray, int n, int n2) throws IOException {
            ((zzcl)this).zzx(n2);
            ((zzcl)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzw(int n) throws IOException {
            if (n >= 0) {
                ((zzcl)this).zzx(n);
                return;
            }
            ((zzcl)this).zza(n);
        }

        @Override
        public final void zzx(int n) throws IOException {
            if (this.zznt <= this.zzns) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzfz.zza(this.zznt++, (byte)n);
                        return;
                    }
                    zzfz.zza(this.zznt++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            while (this.zznt < this.zznr) {
                if ((n & 0xFFFFFF80) == 0) {
                    zzfz.zza(this.zznt++, (byte)n);
                    return;
                }
                zzfz.zza(this.zznt++, (byte)(n & 0x7F | 0x80));
                n >>>= 7;
            }
            throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zznt, this.zznr, 1));
        }

        @Override
        public final void zzz(int n) throws IOException {
            long l = this.zznt;
            zze zze2 = this;
            this.zzno.putInt((int)(l - zze2.zznp), n);
            this.zznt += 4L;
        }

        @Override
        public final void zza(long l) throws IOException {
            if (this.zznt <= this.zzns) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzfz.zza(this.zznt++, (byte)l);
                        return;
                    }
                    zzfz.zza(this.zznt++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            while (this.zznt < this.zznr) {
                if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    zzfz.zza(this.zznt++, (byte)l);
                    return;
                }
                zzfz.zza(this.zznt++, (byte)((int)l & 0x7F | 0x80));
                l >>>= 7;
            }
            throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zznt, this.zznr, 1));
        }

        @Override
        public final void zzc(long l) throws IOException {
            long l2 = this.zznt;
            zze zze2 = this;
            this.zzno.putLong((int)(l2 - zze2.zznp), l);
            this.zznt += 8L;
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null || n < 0 || n2 < 0 || byArray.length - n2 < n || this.zznr - (long)n2 < this.zznt) {
                if (byArray == null) {
                    throw new NullPointerException("value");
                }
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zznt, this.zznr, n2));
            }
            zzfz.zza(byArray, n, this.zznt, n2);
            this.zznt += (long)n2;
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzcl)this).write(byArray, n, n2);
        }

        @Override
        public final void zzal(String string) throws IOException {
            long l = this.zznt;
            try {
                int n = zze.zzac(string.length() * 3);
                int n2 = zze.zzac(string.length());
                if (n2 == n) {
                    long l2 = this.zznt;
                    zze zze2 = this;
                    int n3 = (int)(l2 - zze2.zznp) + n2;
                    this.zzno.position(n3);
                    zzgb.zza(string, this.zzno);
                    int n4 = this.zzno.position() - n3;
                    ((zzcl)this).zzx(n4);
                    this.zznt += (long)n4;
                    return;
                }
                int n5 = zzgb.zza(string);
                ((zzcl)this).zzx(n5);
                this.zzj(this.zznt);
                zzgb.zza(string, this.zzno);
                this.zznt += (long)n5;
                return;
            }
            catch (zzgf zzgf2) {
                this.zznt = l;
                this.zzj(this.zznt);
                this.zza(string, zzgf2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzc(illegalArgumentException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }

        @Override
        public final void flush() {
            long l = this.zznt;
            zze zze2 = this;
            this.zznn.position((int)(l - zze2.zznp));
        }

        @Override
        public final int zzdf() {
            return (int)(this.zznr - this.zznt);
        }

        private final void zzj(long l) {
            long l2 = l;
            zze zze2 = this;
            this.zzno.position((int)(l2 - zze2.zznp));
        }
    }

    static final class zzd
    extends zzcl {
        private final ByteBuffer zznn;
        private final ByteBuffer zzno;
        private final int zznm;

        zzd(ByteBuffer byteBuffer) {
            super(null);
            this.zznn = byteBuffer;
            this.zzno = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zznm = byteBuffer.position();
        }

        @Override
        public final void zzb(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzcl)this).zzx(n << 3 | n3);
        }

        @Override
        public final void zzc(int n, int n2) throws IOException {
            ((zzcl)this).zzb(n, 0);
            ((zzcl)this).zzw(n2);
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            ((zzcl)this).zzb(n, 0);
            ((zzcl)this).zzx(n2);
        }

        @Override
        public final void zzf(int n, int n2) throws IOException {
            ((zzcl)this).zzb(n, 5);
            ((zzcl)this).zzz(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzcl)this).zzb(n, 0);
            ((zzcl)this).zza(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzcl)this).zzb(n, 1);
            ((zzcl)this).zzc(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzcl)this).zzb(n, 0);
            ((zzcl)this).zzc((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zza(int n, String string) throws IOException {
            ((zzcl)this).zzb(n, 2);
            ((zzcl)this).zzal(string);
        }

        @Override
        public final void zza(int n, zzbv zzbv2) throws IOException {
            ((zzcl)this).zzb(n, 2);
            ((zzcl)this).zza(zzbv2);
        }

        @Override
        public final void zza(int n, zzek zzek2) throws IOException {
            ((zzcl)this).zzb(n, 2);
            ((zzcl)this).zzb(zzek2);
        }

        @Override
        final void zza(int n, zzek zzek2, zzez zzez2) throws IOException {
            ((zzcl)this).zzb(n, 2);
            ((zzcl)this).zza(zzek2, zzez2);
        }

        @Override
        public final void zzb(int n, zzek zzek2) throws IOException {
            ((zzcl)this).zzb(1, 3);
            ((zzcl)this).zzd(2, n);
            ((zzcl)this).zza(3, zzek2);
            ((zzcl)this).zzb(1, 4);
        }

        @Override
        public final void zzb(int n, zzbv zzbv2) throws IOException {
            ((zzcl)this).zzb(1, 3);
            ((zzcl)this).zzd(2, n);
            ((zzcl)this).zza(3, zzbv2);
            ((zzcl)this).zzb(1, 4);
        }

        @Override
        public final void zzb(zzek zzek2) throws IOException {
            ((zzcl)this).zzx(zzek2.zzdt());
            zzek2.zzb(this);
        }

        @Override
        final void zza(zzek zzek2, zzez zzez2) throws IOException {
            zzez zzez3 = zzez2;
            zzbo zzbo2 = (zzbo)zzek2;
            int n = zzbo2.zzbs();
            if (n == -1) {
                n = zzez3.zzo(zzbo2);
                zzbo2.zzg(n);
            }
            ((zzcl)this).zzx(n);
            zzez2.zza(zzek2, this.zznk);
        }

        @Override
        public final void zzc(byte by) throws IOException {
            try {
                this.zzno.put(by);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zza(zzbv zzbv2) throws IOException {
            ((zzcl)this).zzx(zzbv2.size());
            zzbv2.zza(this);
        }

        @Override
        public final void zze(byte[] byArray, int n, int n2) throws IOException {
            ((zzcl)this).zzx(n2);
            ((zzcl)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzw(int n) throws IOException {
            if (n >= 0) {
                ((zzcl)this).zzx(n);
                return;
            }
            ((zzcl)this).zza(n);
        }

        @Override
        public final void zzx(int n) throws IOException {
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.zzno.put((byte)n);
                        return;
                    }
                    this.zzno.put((byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzz(int n) throws IOException {
            try {
                this.zzno.putInt(n);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zza(long l) throws IOException {
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.zzno.put((byte)l);
                        return;
                    }
                    this.zzno.put((byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzc(long l) throws IOException {
            try {
                this.zzno.putLong(l);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.zzno.put(byArray, n, n2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzcl)this).write(byArray, n, n2);
        }

        @Override
        public final void zzal(String string) throws IOException {
            int n = this.zzno.position();
            try {
                int n2 = zzd.zzac(string.length() * 3);
                int n3 = zzd.zzac(string.length());
                if (n3 == n2) {
                    int n4 = this.zzno.position() + n3;
                    this.zzno.position(n4);
                    this.zzan(string);
                    int n5 = this.zzno.position();
                    this.zzno.position(n);
                    ((zzcl)this).zzx(n5 - n4);
                    this.zzno.position(n5);
                    return;
                }
                int n6 = zzgb.zza(string);
                ((zzcl)this).zzx(n6);
                this.zzan(string);
                return;
            }
            catch (zzgf zzgf2) {
                this.zzno.position(n);
                this.zza(string, zzgf2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzc(illegalArgumentException);
            }
        }

        @Override
        public final void flush() {
            this.zznn.position(this.zzno.position());
        }

        @Override
        public final int zzdf() {
            return this.zzno.remaining();
        }

        private final void zzan(String string) throws IOException {
            try {
                zzgb.zza(string, this.zzno);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }
    }

    static final class zzb
    extends zza {
        private final ByteBuffer zznl;
        private int zznm;

        zzb(ByteBuffer byteBuffer) {
            super(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            this.zznl = byteBuffer;
            this.zznm = byteBuffer.position();
        }

        @Override
        public final void flush() {
            this.zznl.position(this.zznm + this.zzdh());
        }
    }

    static class zza
    extends zzcl {
        private final byte[] buffer;
        private final int offset;
        private final int limit;
        private int position;

        zza(byte[] byArray, int n, int n2) {
            super(null);
            if (byArray == null) {
                throw new NullPointerException("buffer");
            }
            if ((n | n2 | byArray.length - (n + n2)) < 0) {
                throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", byArray.length, n, n2));
            }
            this.buffer = byArray;
            this.offset = n;
            this.position = n;
            this.limit = n + n2;
        }

        @Override
        public final void zzb(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzcl)this).zzx(n << 3 | n3);
        }

        @Override
        public final void zzc(int n, int n2) throws IOException {
            ((zzcl)this).zzb(n, 0);
            ((zzcl)this).zzw(n2);
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            ((zzcl)this).zzb(n, 0);
            ((zzcl)this).zzx(n2);
        }

        @Override
        public final void zzf(int n, int n2) throws IOException {
            ((zzcl)this).zzb(n, 5);
            ((zzcl)this).zzz(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzcl)this).zzb(n, 0);
            ((zzcl)this).zza(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzcl)this).zzb(n, 1);
            ((zzcl)this).zzc(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzcl)this).zzb(n, 0);
            ((zzcl)this).zzc((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zza(int n, String string) throws IOException {
            ((zzcl)this).zzb(n, 2);
            ((zzcl)this).zzal(string);
        }

        @Override
        public final void zza(int n, zzbv zzbv2) throws IOException {
            ((zzcl)this).zzb(n, 2);
            ((zzcl)this).zza(zzbv2);
        }

        @Override
        public final void zza(zzbv zzbv2) throws IOException {
            ((zzcl)this).zzx(zzbv2.size());
            zzbv2.zza(this);
        }

        @Override
        public final void zze(byte[] byArray, int n, int n2) throws IOException {
            ((zzcl)this).zzx(n2);
            ((zzcl)this).write(byArray, 0, n2);
        }

        @Override
        public final void zza(int n, zzek zzek2) throws IOException {
            ((zzcl)this).zzb(n, 2);
            ((zzcl)this).zzb(zzek2);
        }

        @Override
        final void zza(int n, zzek zzek2, zzez zzez2) throws IOException {
            ((zzcl)this).zzb(n, 2);
            zzez zzez3 = zzez2;
            zzbo zzbo2 = (zzbo)zzek2;
            int n2 = zzbo2.zzbs();
            if (n2 == -1) {
                n2 = zzez3.zzo(zzbo2);
                zzbo2.zzg(n2);
            }
            ((zzcl)this).zzx(n2);
            zzez2.zza(zzek2, this.zznk);
        }

        @Override
        public final void zzb(int n, zzek zzek2) throws IOException {
            ((zzcl)this).zzb(1, 3);
            ((zzcl)this).zzd(2, n);
            ((zzcl)this).zza(3, zzek2);
            ((zzcl)this).zzb(1, 4);
        }

        @Override
        public final void zzb(int n, zzbv zzbv2) throws IOException {
            ((zzcl)this).zzb(1, 3);
            ((zzcl)this).zzd(2, n);
            ((zzcl)this).zza(3, zzbv2);
            ((zzcl)this).zzb(1, 4);
        }

        @Override
        public final void zzb(zzek zzek2) throws IOException {
            ((zzcl)this).zzx(zzek2.zzdt());
            zzek2.zzb(this);
        }

        @Override
        final void zza(zzek zzek2, zzez zzez2) throws IOException {
            zzez zzez3 = zzez2;
            zzbo zzbo2 = (zzbo)zzek2;
            int n = zzbo2.zzbs();
            if (n == -1) {
                n = zzez3.zzo(zzbo2);
                zzbo2.zzg(n);
            }
            ((zzcl)this).zzx(n);
            zzez2.zza(zzek2, this.zznk);
        }

        @Override
        public final void zzc(byte by) throws IOException {
            try {
                this.buffer[this.position++] = by;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzw(int n) throws IOException {
            if (n >= 0) {
                ((zzcl)this).zzx(n);
                return;
            }
            ((zzcl)this).zza(n);
        }

        @Override
        public final void zzx(int n) throws IOException {
            if (zznj && ((zzcl)this).zzdf() >= 10) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzfz.zza(this.buffer, (long)this.position++, (byte)n);
                        return;
                    }
                    zzfz.zza(this.buffer, (long)this.position++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.buffer[this.position++] = (byte)n;
                        return;
                    }
                    this.buffer[this.position++] = (byte)(n & 0x7F | 0x80);
                    n >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzz(int n) throws IOException {
            try {
                this.buffer[this.position++] = (byte)n;
                this.buffer[this.position++] = (byte)(n >> 8);
                this.buffer[this.position++] = (byte)(n >> 16);
                this.buffer[this.position++] = n >> 24;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zza(long l) throws IOException {
            if (zznj && ((zzcl)this).zzdf() >= 10) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzfz.zza(this.buffer, (long)this.position++, (byte)l);
                        return;
                    }
                    zzfz.zza(this.buffer, (long)this.position++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)l;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)l & 0x7F | 0x80);
                    l >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzc(long l) throws IOException {
            try {
                this.buffer[this.position++] = (byte)l;
                this.buffer[this.position++] = (byte)(l >> 8);
                this.buffer[this.position++] = (byte)(l >> 16);
                this.buffer[this.position++] = (byte)(l >> 24);
                this.buffer[this.position++] = (byte)(l >> 32);
                this.buffer[this.position++] = (byte)(l >> 40);
                this.buffer[this.position++] = (byte)(l >> 48);
                this.buffer[this.position++] = (byte)(l >> 56);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                System.arraycopy(byArray, n, this.buffer, this.position, n2);
                this.position += n2;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, n2), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzcl)this).write(byArray, n, n2);
        }

        @Override
        public final void zzal(String string) throws IOException {
            int n = this.position;
            try {
                int n2 = zza.zzac(string.length() * 3);
                int n3 = zza.zzac(string.length());
                if (n3 == n2) {
                    this.position = n + n3;
                    int n4 = zzgb.zza(string, this.buffer, this.position, ((zzcl)this).zzdf());
                    this.position = n;
                    int n5 = n4 - n - n3;
                    ((zzcl)this).zzx(n5);
                    this.position = n4;
                    return;
                }
                int n6 = zzgb.zza(string);
                ((zzcl)this).zzx(n6);
                this.position = zzgb.zza(string, this.buffer, this.position, ((zzcl)this).zzdf());
                return;
            }
            catch (zzgf zzgf2) {
                this.position = n;
                this.zza(string, zzgf2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public final int zzdf() {
            return this.limit - this.position;
        }

        public final int zzdh() {
            return this.position - this.offset;
        }
    }

    public static final class zzc
    extends IOException {
        zzc() {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.");
        }

        zzc(String string) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        }

        zzc(Throwable throwable) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.", throwable);
        }

        zzc(String string, Throwable throwable) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2), throwable);
        }
    }
}

