/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_auth;

import com.google.android.gms.internal.firebase_auth.zzbr;
import com.google.android.gms.internal.firebase_auth.zzdg;
import com.google.android.gms.internal.firebase_auth.zzdj;
import com.google.android.gms.internal.firebase_auth.zzev;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzco
extends zzbr<Double>
implements zzdj<Double>,
zzev,
RandomAccess {
    private static final zzco zznu = new zzco();
    private double[] zznv;
    private int size;

    zzco() {
        this(new double[10], 0);
    }

    private zzco(double[] dArray, int n) {
        this.zznv = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzbw();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zznv, n2, this.zznv, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzco)) {
            return super.equals(object);
        }
        zzco zzco2 = (zzco)object;
        if (this.size != zzco2.size) {
            return false;
        }
        double[] dArray = zzco2.zznv;
        for (int i = 0; i < this.size; ++i) {
            if (this.zznv[i] == dArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zznv[i]);
            n = n * 31 + zzdg.zzk(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzc(double d) {
        this.zzc(this.size, d);
    }

    private final void zzc(int n, double d) {
        this.zzbw();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
        if (this.size < this.zznv.length) {
            System.arraycopy(this.zznv, n, this.zznv, n + 1, this.size - n);
        } else {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zznv, 0, dArray, 0, n);
            System.arraycopy(this.zznv, n, dArray, n + 1, this.size - n);
            this.zznv = dArray;
        }
        this.zznv[n] = d;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzbw();
        zzdg.checkNotNull(collection);
        if (!(collection instanceof zzco)) {
            return super.addAll(collection);
        }
        zzco zzco2 = (zzco)collection;
        if (zzco2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzco2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzco2.size;
        if (n > this.zznv.length) {
            this.zznv = Arrays.copyOf(this.zznv, n);
        }
        System.arraycopy(zzco2.zznv, 0, this.zznv, this.size, zzco2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzbw();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zznv[i])) continue;
            System.arraycopy(this.zznv, i + 1, this.zznv, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzh(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
    }

    private final String zzi(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzco zzco2 = this;
        zzco2.zzbw();
        zzco2.zzh(n);
        double d3 = zzco2.zznv[n];
        zzco2.zznv[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzco zzco2 = this;
        zzco2.zzbw();
        zzco2.zzh(n);
        double d = zzco2.zznv[n];
        if (n < zzco2.size - 1) {
            System.arraycopy(zzco2.zznv, n + 1, zzco2.zznv, n, zzco2.size - n);
        }
        --zzco2.size;
        ++zzco2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        this.zzc(n, d);
    }

    @Override
    public final /* synthetic */ zzdj zzj(int n) {
        int n2 = n;
        zzco zzco2 = this;
        if (n2 < zzco2.size) {
            throw new IllegalArgumentException();
        }
        return new zzco(Arrays.copyOf(zzco2.zznv, n2), zzco2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzco zzco2 = this;
        zzco2.zzh(n);
        return zzco2.zznv[n];
    }

    static {
        zznu.zzbv();
    }
}

