/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.internal.firebase_auth.zzap;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUserMetadata;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.UserInfo;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.zzq;
import com.google.firebase.auth.zzr;
import java.util.List;

public abstract class FirebaseUser
extends AbstractSafeParcelable
implements UserInfo {
    public FirebaseUser() {
    }

    @Override
    @NonNull
    public abstract String getUid();

    @Override
    @NonNull
    public abstract String getProviderId();

    public abstract boolean isAnonymous();

    @Nullable
    public abstract List<String> getProviders();

    @NonNull
    public abstract List<? extends UserInfo> getProviderData();

    @NonNull
    public abstract FirebaseUser zza(@NonNull List<? extends UserInfo> var1);

    public abstract FirebaseUser zzp();

    @NonNull
    public abstract FirebaseApp zzq();

    @Override
    @Nullable
    public abstract String getDisplayName();

    @Override
    @Nullable
    public abstract Uri getPhotoUrl();

    @Override
    @Nullable
    public abstract String getEmail();

    @Override
    @Nullable
    public abstract String getPhoneNumber();

    @NonNull
    public Task<GetTokenResult> getIdToken(boolean bl) {
        return FirebaseAuth.getInstance(this.zzq()).zza(this, bl);
    }

    @NonNull
    public Task<Void> reload() {
        return FirebaseAuth.getInstance(this.zzq()).zzd(this);
    }

    public Task<Void> reauthenticate(@NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)((Object)authCredential));
        return FirebaseAuth.getInstance(this.zzq()).zza(this, authCredential);
    }

    public Task<AuthResult> reauthenticateAndRetrieveData(@NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)((Object)authCredential));
        return FirebaseAuth.getInstance(this.zzq()).zzb(this, authCredential);
    }

    @NonNull
    public Task<AuthResult> linkWithCredential(@NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)((Object)authCredential));
        return FirebaseAuth.getInstance(this.zzq()).zzc(this, authCredential);
    }

    public Task<AuthResult> unlink(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return FirebaseAuth.getInstance(this.zzq()).zza(this, string);
    }

    @NonNull
    public Task<Void> updateProfile(@NonNull UserProfileChangeRequest userProfileChangeRequest) {
        Preconditions.checkNotNull((Object)((Object)userProfileChangeRequest));
        return FirebaseAuth.getInstance(this.zzq()).zza(this, userProfileChangeRequest);
    }

    @NonNull
    public Task<Void> updateEmail(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return FirebaseAuth.getInstance(this.zzq()).zzb(this, string);
    }

    public Task<Void> updatePhoneNumber(@NonNull PhoneAuthCredential phoneAuthCredential) {
        return FirebaseAuth.getInstance(this.zzq()).zza(this, phoneAuthCredential);
    }

    @NonNull
    public Task<Void> updatePassword(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return FirebaseAuth.getInstance(this.zzq()).zzc(this, string);
    }

    @NonNull
    public Task<Void> delete() {
        return FirebaseAuth.getInstance(this.zzq()).zze(this);
    }

    @NonNull
    public Task<Void> sendEmailVerification() {
        return FirebaseAuth.getInstance(this.zzq()).zza(this, false).continueWithTask((Continuation)new zzq(this));
    }

    @NonNull
    public Task<Void> sendEmailVerification(ActionCodeSettings actionCodeSettings) {
        return FirebaseAuth.getInstance(this.zzq()).zza(this, false).continueWithTask((Continuation)new zzr(this, actionCodeSettings));
    }

    @NonNull
    public abstract zzap zzr();

    public abstract void zza(@NonNull zzap var1);

    @NonNull
    public abstract String zzs();

    @NonNull
    public abstract String zzt();

    @Nullable
    public abstract FirebaseUserMetadata getMetadata();
}

