/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.api.internal;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Pair;
import android.util.SparseArray;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.FirebaseException;
import com.google.firebase.FirebaseNetworkException;
import com.google.firebase.FirebaseTooManyRequestsException;
import com.google.firebase.auth.FirebaseAuthActionCodeException;
import com.google.firebase.auth.FirebaseAuthEmailException;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.FirebaseAuthInvalidCredentialsException;
import com.google.firebase.auth.FirebaseAuthInvalidUserException;
import com.google.firebase.auth.FirebaseAuthRecentLoginRequiredException;
import com.google.firebase.auth.FirebaseAuthUserCollisionException;
import com.google.firebase.auth.FirebaseAuthWeakPasswordException;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.internal.api.FirebaseNoSignedInUserException;

public final class zzcf {
    @VisibleForTesting
    private static final SparseArray<Pair<String, String>> zzhn = new SparseArray();

    public static FirebaseException zzb(Status status) {
        int n = status.getStatusCode();
        String string = zzcf.zza(zzcf.zzd(n), status);
        switch (n) {
            case 17014: {
                return new FirebaseAuthRecentLoginRequiredException(zzcf.zzc(n), string);
            }
            case 17007: 
            case 17012: 
            case 17025: {
                return new FirebaseAuthUserCollisionException(zzcf.zzc(n), string);
            }
            case 17005: 
            case 17011: 
            case 17017: 
            case 17021: {
                return new FirebaseAuthInvalidUserException(zzcf.zzc(n), string);
            }
            case 17026: {
                return new FirebaseAuthWeakPasswordException(zzcf.zzc(n), string, status.getStatusMessage());
            }
            case 17010: {
                String string2 = zzcf.zza("We have blocked all requests from this device due to unusual activity. Try again later.", status);
                return new FirebaseTooManyRequestsException(string2);
            }
            case 17020: {
                String string3 = zzcf.zza("A network error (such as timeout, interrupted connection or unreachable host) has occurred.", status);
                return new FirebaseNetworkException(string3);
            }
            case 17499: {
                String string4 = zzcf.zza("An internal error has occurred.", status);
                return new FirebaseException(string4);
            }
            case 17016: {
                String string5 = zzcf.zza("User was not linked to an account with the given provider.", status);
                return new FirebaseException(string5);
            }
            case 17015: {
                String string6 = zzcf.zza("User has already been linked to the given provider.", status);
                return new FirebaseException(string6);
            }
            case 17495: {
                String string7 = zzcf.zza("Please sign in before trying to get a token.", status);
                return new FirebaseNoSignedInUserException(string7);
            }
            case 17029: 
            case 17030: {
                return new FirebaseAuthActionCodeException(zzcf.zzc(n), string);
            }
            case 17031: 
            case 17032: 
            case 17033: {
                return new FirebaseAuthEmailException(zzcf.zzc(n), string);
            }
            case 17000: 
            case 17002: 
            case 17004: 
            case 17008: 
            case 17009: 
            case 17024: 
            case 17034: 
            case 17035: 
            case 17041: 
            case 17042: 
            case 17043: 
            case 17044: 
            case 17045: 
            case 17046: 
            case 17049: 
            case 17051: {
                return new FirebaseAuthInvalidCredentialsException(zzcf.zzc(n), string);
            }
            case 17052: {
                return new FirebaseTooManyRequestsException(string);
            }
            case 17063: {
                return new FirebaseApiNotAvailableException(string);
            }
            case 17061: {
                String string8 = zzcf.zza("There was a failure in the connection between the web widget and the Firebase Auth backend.", status);
                return new FirebaseNetworkException(string8);
            }
            case 17006: 
            case 17028: 
            case 17040: 
            case 17062: 
            case 17064: 
            case 17065: 
            case 17068: {
                return new FirebaseAuthException(zzcf.zzc(n), string);
            }
        }
        return new FirebaseException("An internal error has occurred.");
    }

    public static FirebaseAuthUserCollisionException zzb(Status status, @NonNull PhoneAuthCredential phoneAuthCredential) {
        int n = status.getStatusCode();
        String string = zzcf.zza(zzcf.zzd(n), status);
        return new FirebaseAuthUserCollisionException(zzcf.zzc(n), string, phoneAuthCredential);
    }

    private static String zza(String string, Status status) {
        if (TextUtils.isEmpty((CharSequence)status.getStatusMessage())) {
            return string;
        }
        return String.format(String.valueOf(string).concat(" [ %s ]"), status.getStatusMessage());
    }

    private static String zzc(int n) {
        Pair pair = (Pair)zzhn.get(n);
        if (pair != null) {
            return (String)pair.first;
        }
        return "INTERNAL_ERROR";
    }

    private static String zzd(int n) {
        Pair pair = (Pair)zzhn.get(n);
        if (pair != null) {
            return (String)pair.second;
        }
        return "An internal error happened";
    }

    static {
        zzhn.put(17000, (Object)new Pair((Object)"ERROR_INVALID_CUSTOM_TOKEN", (Object)"The custom token format is incorrect. Please check the documentation."));
        zzhn.put(17002, (Object)new Pair((Object)"ERROR_CUSTOM_TOKEN_MISMATCH", (Object)"The custom token corresponds to a different audience."));
        zzhn.put(17004, (Object)new Pair((Object)"ERROR_INVALID_CREDENTIAL", (Object)"The supplied auth credential is malformed or has expired."));
        zzhn.put(17008, (Object)new Pair((Object)"ERROR_INVALID_EMAIL", (Object)"The email address is badly formatted."));
        zzhn.put(17009, (Object)new Pair((Object)"ERROR_WRONG_PASSWORD", (Object)"The password is invalid or the user does not have a password."));
        zzhn.put(17024, (Object)new Pair((Object)"ERROR_USER_MISMATCH", (Object)"The supplied credentials do not correspond to the previously signed in user."));
        zzhn.put(17014, (Object)new Pair((Object)"ERROR_REQUIRES_RECENT_LOGIN", (Object)"This operation is sensitive and requires recent authentication. Log in again before retrying this request."));
        zzhn.put(17012, (Object)new Pair((Object)"ERROR_ACCOUNT_EXISTS_WITH_DIFFERENT_CREDENTIAL", (Object)"An account already exists with the same email address but different sign-in credentials. Sign in using a provider associated with this email address."));
        zzhn.put(17007, (Object)new Pair((Object)"ERROR_EMAIL_ALREADY_IN_USE", (Object)"The email address is already in use by another account."));
        zzhn.put(17025, (Object)new Pair((Object)"ERROR_CREDENTIAL_ALREADY_IN_USE", (Object)"This credential is already associated with a different user account."));
        zzhn.put(17005, (Object)new Pair((Object)"ERROR_USER_DISABLED", (Object)"The user account has been disabled by an administrator."));
        zzhn.put(17021, (Object)new Pair((Object)"ERROR_USER_TOKEN_EXPIRED", (Object)"The user's credential is no longer valid. The user must sign in again."));
        zzhn.put(17011, (Object)new Pair((Object)"ERROR_USER_NOT_FOUND", (Object)"There is no user record corresponding to this identifier. The user may have been deleted."));
        zzhn.put(17017, (Object)new Pair((Object)"ERROR_INVALID_USER_TOKEN", (Object)"This user's credential isn't valid for this project. This can happen if the user's token has been tampered with, or if the user isn't for the project associated with this API key."));
        zzhn.put(17006, (Object)new Pair((Object)"ERROR_OPERATION_NOT_ALLOWED", (Object)"The given sign-in provider is disabled for this Firebase project. Enable it in the Firebase console, under the sign-in method tab of the Auth section."));
        zzhn.put(17026, (Object)new Pair((Object)"ERROR_WEAK_PASSWORD", (Object)"The given password is invalid."));
        zzhn.put(17029, (Object)new Pair((Object)"ERROR_EXPIRED_ACTION_CODE", (Object)"The out of band code has expired."));
        zzhn.put(17030, (Object)new Pair((Object)"ERROR_INVALID_ACTION_CODE", (Object)"The out of band code is invalid. This can happen if the code is malformed, expired, or has already been used."));
        zzhn.put(17031, (Object)new Pair((Object)"ERROR_INVALID_MESSAGE_PAYLOAD", (Object)"The email template corresponding to this action contains invalid characters in its message. Please fix by going to the Auth email templates section in the Firebase Console."));
        zzhn.put(17033, (Object)new Pair((Object)"ERROR_INVALID_RECIPIENT_EMAIL", (Object)"The email corresponding to this action failed to send as the provided recipient email address is invalid."));
        zzhn.put(17032, (Object)new Pair((Object)"ERROR_INVALID_SENDER", (Object)"The email template corresponding to this action contains an invalid sender email or name. Please fix by going to the Auth email templates section in the Firebase Console."));
        zzhn.put(17034, (Object)new Pair((Object)"ERROR_MISSING_EMAIL", (Object)"An email address must be provided."));
        zzhn.put(17035, (Object)new Pair((Object)"ERROR_MISSING_PASSWORD", (Object)"A password must be provided."));
        zzhn.put(17041, (Object)new Pair((Object)"ERROR_MISSING_PHONE_NUMBER", (Object)"To send verification codes, provide a phone number for the recipient."));
        zzhn.put(17042, (Object)new Pair((Object)"ERROR_INVALID_PHONE_NUMBER", (Object)"The format of the phone number provided is incorrect. Please enter the phone number in a format that can be parsed into E.164 format. E.164 phone numbers are written in the format [+][country code][subscriber number including area code]."));
        zzhn.put(17043, (Object)new Pair((Object)"ERROR_MISSING_VERIFICATION_CODE", (Object)"The Phone Auth Credential was created with an empty sms verification Code"));
        zzhn.put(17044, (Object)new Pair((Object)"ERROR_INVALID_VERIFICATION_CODE", (Object)"The sms verification code used to create the phone auth credential is invalid. Please resend the verification code sms and be sure use the verification code provided by the user."));
        zzhn.put(17045, (Object)new Pair((Object)"ERROR_MISSING_VERIFICATION_ID", (Object)"The Phone Auth Credential was created with an empty verification ID"));
        zzhn.put(17046, (Object)new Pair((Object)"ERROR_INVALID_VERIFICATION_ID", (Object)"The verification ID used to create the phone auth credential is invalid."));
        zzhn.put(17049, (Object)new Pair((Object)"ERROR_RETRY_PHONE_AUTH", (Object)"An error occurred during authentication using the PhoneAuthCredential. Please retry authentication."));
        zzhn.put(17051, (Object)new Pair((Object)"ERROR_SESSION_EXPIRED", (Object)"The sms code has expired. Please re-send the verification code to try again."));
        zzhn.put(17052, (Object)new Pair((Object)"ERROR_QUOTA_EXCEEDED", (Object)"The sms quota for this project has been exceeded."));
        zzhn.put(17028, (Object)new Pair((Object)"ERROR_APP_NOT_AUTHORIZED", (Object)"This app is not authorized to use Firebase Authentication. Please verifythat the correct package name and SHA-1 are configured in the Firebase Console."));
        zzhn.put(17063, (Object)new Pair((Object)"ERROR_API_NOT_AVAILABLE", (Object)"The API that you are calling is not available on devices without Google Play Services."));
        zzhn.put(17062, (Object)new Pair((Object)"ERROR_WEB_INTERNAL_ERROR", (Object)"There was an internal error in the web widget."));
        zzhn.put(17064, (Object)new Pair((Object)"ERROR_INVALID_CERT_HASH", (Object)"There was an error while trying to get your package certificate hash."));
        zzhn.put(17065, (Object)new Pair((Object)"ERROR_WEB_STORAGE_UNSUPPORTED", (Object)"This browser is not supported or 3rd party cookies and data may be disabled."));
        zzhn.put(17040, (Object)new Pair((Object)"ERROR_MISSING_CONTINUE_URI", (Object)"A continue URL must be provided in the request."));
        zzhn.put(17068, (Object)new Pair((Object)"ERROR_DYNAMIC_LINK_NOT_ACTIVATED", (Object)"Please activate Dynamic Links in the Firebase Console and agree to the terms and conditions."));
    }
}

