/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.firebase_auth.zzak;
import com.google.android.gms.internal.firebase_auth.zzar;
import com.google.android.gms.internal.firebase_auth.zzw;
import com.google.firebase.auth.UserInfo;
import com.google.firebase.auth.internal.zzi;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Class(creator="DefaultAuthUserInfoCreator")
public final class zzh
extends AbstractSafeParcelable
implements UserInfo {
    public static final Parcelable.Creator<zzh> CREATOR = new zzi();
    @SafeParcelable.Field(id=1, getter="getUid")
    @NonNull
    private String zzkz;
    @SafeParcelable.Field(id=2, getter="getProviderId")
    @NonNull
    private String zzn;
    @SafeParcelable.Field(id=3, getter="getDisplayName")
    @Nullable
    private String zzbl;
    @SafeParcelable.Field(id=4, getter="getPhotoUrlString")
    @Nullable
    private String zzbv;
    @Nullable
    private Uri zzfl;
    @SafeParcelable.Field(id=5, getter="getEmail")
    @Nullable
    private String zzal;
    @SafeParcelable.Field(id=6, getter="getPhoneNumber")
    @Nullable
    private String zzbh;
    @SafeParcelable.Field(id=7, getter="isEmailVerified")
    private boolean zzju;
    @SafeParcelable.Field(id=8, getter="getRawUserInfo")
    @Nullable
    private String zzdj;

    @VisibleForTesting
    @SafeParcelable.Constructor
    public zzh(@SafeParcelable.Param(id=1) @NonNull String string, @SafeParcelable.Param(id=2) @NonNull String string2, @SafeParcelable.Param(id=5) @Nullable String string3, @SafeParcelable.Param(id=4) @Nullable String string4, @SafeParcelable.Param(id=3) @Nullable String string5, @SafeParcelable.Param(id=6) @Nullable String string6, @SafeParcelable.Param(id=7) boolean bl, @SafeParcelable.Param(id=8) @Nullable String string7) {
        this.zzkz = string;
        this.zzn = string2;
        this.zzal = string3;
        this.zzbh = string4;
        this.zzbl = string5;
        this.zzbv = string6;
        if (!TextUtils.isEmpty((CharSequence)this.zzbv)) {
            this.zzfl = Uri.parse((String)this.zzbv);
        }
        this.zzju = bl;
        this.zzdj = string7;
    }

    public zzh(@NonNull zzak zzak2, @NonNull String string) {
        Preconditions.checkNotNull((Object)((Object)zzak2));
        Preconditions.checkNotEmpty((String)string);
        this.zzkz = Preconditions.checkNotEmpty((String)zzak2.getLocalId());
        this.zzn = string;
        this.zzal = zzak2.getEmail();
        this.zzbl = zzak2.getDisplayName();
        Uri uri = zzak2.getPhotoUri();
        if (uri != null) {
            this.zzbv = uri.toString();
            this.zzfl = uri;
        }
        this.zzju = zzak2.isEmailVerified();
        this.zzdj = null;
        this.zzbh = zzak2.getPhoneNumber();
    }

    public zzh(@NonNull zzar zzar2) {
        Preconditions.checkNotNull((Object)((Object)zzar2));
        this.zzkz = zzar2.zzbc();
        this.zzn = Preconditions.checkNotEmpty((String)zzar2.getProviderId());
        this.zzbl = zzar2.getDisplayName();
        Uri uri = zzar2.getPhotoUri();
        if (uri != null) {
            this.zzbv = uri.toString();
            this.zzfl = uri;
        }
        this.zzal = zzar2.getEmail();
        this.zzbh = zzar2.getPhoneNumber();
        this.zzju = false;
        this.zzdj = zzar2.getRawUserInfo();
    }

    @Override
    @NonNull
    public final String getUid() {
        return this.zzkz;
    }

    @Override
    @NonNull
    public final String getProviderId() {
        return this.zzn;
    }

    @Override
    @Nullable
    public final String getDisplayName() {
        return this.zzbl;
    }

    @Override
    @Nullable
    public final Uri getPhotoUrl() {
        if (!TextUtils.isEmpty((CharSequence)this.zzbv) && this.zzfl == null) {
            this.zzfl = Uri.parse((String)this.zzbv);
        }
        return this.zzfl;
    }

    @Override
    @Nullable
    public final String getEmail() {
        return this.zzal;
    }

    @Override
    @Nullable
    public final String getPhoneNumber() {
        return this.zzbh;
    }

    @Override
    public final boolean isEmailVerified() {
        return this.zzju;
    }

    @Nullable
    public final String getRawUserInfo() {
        return this.zzdj;
    }

    @Nullable
    public final String toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.putOpt("userId", (Object)this.zzkz);
            jSONObject.putOpt("providerId", (Object)this.zzn);
            jSONObject.putOpt("displayName", (Object)this.zzbl);
            jSONObject.putOpt("photoUrl", (Object)this.zzbv);
            jSONObject.putOpt("email", (Object)this.zzal);
            jSONObject.putOpt("phoneNumber", (Object)this.zzbh);
            jSONObject.putOpt("isEmailVerified", (Object)this.zzju);
            jSONObject.putOpt("rawUserInfo", (Object)this.zzdj);
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            Log.d((String)"DefaultAuthUserInfo", (String)"Failed to jsonify this object");
            throw new zzw(jSONException);
        }
    }

    @Nullable
    public static zzh zzad(@NonNull String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            String string2 = jSONObject.optString("userId");
            String string3 = jSONObject.optString("providerId");
            String string4 = jSONObject.optString("email");
            String string5 = jSONObject.optString("phoneNumber");
            String string6 = jSONObject.optString("displayName");
            String string7 = jSONObject.optString("photoUrl");
            boolean bl = jSONObject.optBoolean("isEmailVerified");
            String string8 = jSONObject.optString("rawUserInfo");
            return new zzh(string2, string3, string4, string5, string6, string7, bl, string8);
        }
        catch (JSONException jSONException) {
            Log.d((String)"DefaultAuthUserInfo", (String)"Failed to unpack UserInfo from JSON");
            throw new zzw(jSONException);
        }
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzh zzh2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)1, (String)zzh2.getUid(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)zzh2.getProviderId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)zzh2.getDisplayName(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)zzh2.zzbv, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)zzh2.getEmail(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)6, (String)zzh2.getPhoneNumber(), (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)7, (boolean)zzh2.isEmailVerified());
        SafeParcelWriter.writeString((Parcel)parcel2, (int)8, (String)zzh2.zzdj, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }
}

