/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.firebase_auth.zzap;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.FirebaseUserMetadata;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.UserInfo;
import com.google.firebase.auth.internal.zzh;
import com.google.firebase.auth.internal.zzm;
import com.google.firebase.auth.internal.zzn;
import com.google.firebase.auth.internal.zzy;
import com.google.firebase.auth.zzd;
import java.util.ArrayList;
import java.util.List;

@SafeParcelable.Class(creator="DefaultFirebaseUserCreator")
public class zzl
extends FirebaseUser {
    public static final Parcelable.Creator<zzl> CREATOR = new zzm();
    @SafeParcelable.Field(id=1, getter="getCachedTokenState")
    private zzap zzla;
    @SafeParcelable.Field(id=2, getter="getDefaultAuthUserInfo")
    private zzh zzlb;
    @SafeParcelable.Field(id=3, getter="getFirebaseAppName")
    private String zzlc;
    @SafeParcelable.Field(id=4, getter="getUserType")
    private String zzld;
    @SafeParcelable.Field(id=5, getter="getUserInfos")
    private List<zzh> zzle;
    @SafeParcelable.Field(id=6, getter="getProviders")
    private List<String> zzlf;
    @SafeParcelable.Field(id=7, getter="getCurrentVersion")
    private String zzlg;
    @SafeParcelable.Field(id=8, getter="isAnonymous")
    private Boolean zzlh;
    @SafeParcelable.Field(id=9, getter="getMetadata")
    private zzn zzli;
    @SafeParcelable.Field(id=10, getter="isNewUser")
    private boolean zzao;
    @SafeParcelable.Field(id=11, getter="getDefaultOAuthCredential")
    private zzd zzjy;

    @SafeParcelable.Constructor
    zzl(@SafeParcelable.Param(id=1) zzap zzap2, @SafeParcelable.Param(id=2) zzh zzh2, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) String string2, @SafeParcelable.Param(id=5) List<zzh> list, @SafeParcelable.Param(id=6) List<String> list2, @SafeParcelable.Param(id=7) String string3, @SafeParcelable.Param(id=8) Boolean bl, @SafeParcelable.Param(id=9) zzn zzn2, @SafeParcelable.Param(id=10) boolean bl2, @SafeParcelable.Param(id=11) zzd zzd2) {
        this.zzla = zzap2;
        this.zzlb = zzh2;
        this.zzlc = string;
        this.zzld = string2;
        this.zzle = list;
        this.zzlf = list2;
        this.zzlg = string3;
        this.zzlh = bl;
        this.zzli = zzn2;
        this.zzao = bl2;
        this.zzjy = zzd2;
    }

    public zzl(@NonNull FirebaseApp firebaseApp, @NonNull List<? extends UserInfo> list) {
        Preconditions.checkNotNull((Object)firebaseApp);
        this.zzlc = firebaseApp.getName();
        this.zzld = "com.google.firebase.auth.internal.DefaultFirebaseUser";
        this.zzlg = "2";
        ((FirebaseUser)this).zza(list);
    }

    @Override
    @Nullable
    public String getDisplayName() {
        return this.zzlb.getDisplayName();
    }

    @Override
    @Nullable
    public Uri getPhotoUrl() {
        return this.zzlb.getPhotoUrl();
    }

    @Override
    @Nullable
    public String getEmail() {
        return this.zzlb.getEmail();
    }

    @Override
    @Nullable
    public String getPhoneNumber() {
        return this.zzlb.getPhoneNumber();
    }

    public final zzl zzae(@NonNull String string) {
        this.zzlg = string;
        return this;
    }

    @Override
    @NonNull
    public String getProviderId() {
        return this.zzlb.getProviderId();
    }

    @Override
    @NonNull
    public final FirebaseApp zzq() {
        return FirebaseApp.getInstance((String)this.zzlc);
    }

    public final List<zzh> zzbj() {
        return this.zzle;
    }

    @Override
    @NonNull
    public String getUid() {
        return this.zzlb.getUid();
    }

    @Override
    public boolean isAnonymous() {
        if (this.zzlh == null || this.zzlh.booleanValue()) {
            String string = "";
            if (this.zzla != null) {
                GetTokenResult getTokenResult = zzy.zzag(this.zzla.zzaz());
                string = getTokenResult != null ? getTokenResult.getSignInProvider() : "";
            }
            this.zzlh = ((FirebaseUser)this).getProviderData().size() <= 1 && (string == null || !string.equals("custom"));
        }
        return this.zzlh;
    }

    @Override
    @Nullable
    public final List<String> getProviders() {
        return this.zzlf;
    }

    @Override
    @NonNull
    public final FirebaseUser zza(@NonNull List<? extends UserInfo> list) {
        Preconditions.checkNotNull(list);
        this.zzle = new ArrayList<zzh>(list.size());
        this.zzlf = new ArrayList<String>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            UserInfo userInfo = list.get(i);
            if (userInfo.getProviderId().equals("firebase")) {
                this.zzlb = (zzh)userInfo;
            } else {
                this.zzlf.add(userInfo.getProviderId());
            }
            this.zzle.add((zzh)userInfo);
        }
        if (this.zzlb == null) {
            this.zzlb = this.zzle.get(0);
        }
        return this;
    }

    @Override
    @NonNull
    public List<? extends UserInfo> getProviderData() {
        return this.zzle;
    }

    @Override
    @NonNull
    public final zzap zzr() {
        return this.zzla;
    }

    @Override
    @NonNull
    public final String zzt() {
        return ((FirebaseUser)this).zzr().zzaz();
    }

    @Override
    @NonNull
    public final String zzs() {
        return this.zzla.toJson();
    }

    @Override
    public final void zza(@NonNull zzap zzap2) {
        this.zzla = (zzap)Preconditions.checkNotNull((Object)zzap2);
    }

    @Override
    public boolean isEmailVerified() {
        return this.zzlb.isEmailVerified();
    }

    public final void zza(zzn zzn2) {
        this.zzli = zzn2;
    }

    @Override
    public FirebaseUserMetadata getMetadata() {
        return this.zzli;
    }

    public final void zzd(boolean bl) {
        this.zzao = bl;
    }

    public final boolean isNewUser() {
        return this.zzao;
    }

    public final void zzc(zzd zzd2) {
        this.zzjy = zzd2;
    }

    @Nullable
    public final zzd zzax() {
        return this.zzjy;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzl zzl2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)1, (Parcelable)((FirebaseUser)zzl2).zzr(), (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)zzl2.zzlb, (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)zzl2.zzlc, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)zzl2.zzld, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)5, zzl2.zzle, (boolean)false);
        SafeParcelWriter.writeStringList((Parcel)parcel2, (int)6, ((FirebaseUser)zzl2).getProviders(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)zzl2.zzlg, (boolean)false);
        SafeParcelWriter.writeBooleanObject((Parcel)parcel2, (int)8, (Boolean)((FirebaseUser)zzl2).isAnonymous(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)9, (Parcelable)((FirebaseUser)zzl2).getMetadata(), (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)10, (boolean)zzl2.zzao);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)11, (Parcelable)zzl2.zzjy, (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public static FirebaseUser zza(FirebaseApp firebaseApp, FirebaseUser firebaseUser) {
        zzl zzl2 = new zzl(firebaseApp, firebaseUser.getProviderData());
        if (firebaseUser instanceof zzl) {
            zzl zzl3 = (zzl)firebaseUser;
            Object object = zzl3.zzlg;
            zzl2.zzlg = object;
            object = zzl3.zzld;
            zzl2.zzld = object;
            object = (zzn)((FirebaseUser)zzl3).getMetadata();
            zzl2.zzli = object;
        } else {
            zzl2.zzli = null;
        }
        if (firebaseUser.zzr() != null) {
            ((FirebaseUser)zzl2).zza(firebaseUser.zzr());
        }
        if (!firebaseUser.isAnonymous()) {
            ((FirebaseUser)zzl2).zzp();
        }
        return zzl2;
    }

    @Override
    public final /* synthetic */ FirebaseUser zzp() {
        zzl zzl2 = this;
        this.zzlh = false;
        return zzl2;
    }
}

