/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.firebase_auth.zzey;
import com.google.android.gms.internal.firebase_auth.zzfk;
import com.google.android.gms.internal.firebase_auth.zzgd;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.EmailAuthProvider;
import com.google.firebase.auth.FederatedAuthProvider;
import com.google.firebase.auth.FirebaseAuthSettings;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.SignInMethodQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.api.internal.zzdw;
import com.google.firebase.auth.api.internal.zzeh;
import com.google.firebase.auth.api.internal.zzei;
import com.google.firebase.auth.api.internal.zzej;
import com.google.firebase.auth.api.internal.zzer;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.auth.internal.zzae;
import com.google.firebase.auth.internal.zzam;
import com.google.firebase.auth.internal.zzap;
import com.google.firebase.auth.internal.zzas;
import com.google.firebase.auth.internal.zzau;
import com.google.firebase.auth.internal.zzav;
import com.google.firebase.auth.internal.zzaw;
import com.google.firebase.auth.internal.zzaz;
import com.google.firebase.auth.internal.zzh;
import com.google.firebase.auth.internal.zzn;
import com.google.firebase.auth.internal.zzo;
import com.google.firebase.auth.zzf;
import com.google.firebase.auth.zzl;
import com.google.firebase.auth.zzm;
import com.google.firebase.auth.zzp;
import com.google.firebase.auth.zzq;
import com.google.firebase.auth.zzr;
import com.google.firebase.auth.zzy;
import com.google.firebase.internal.InternalTokenResult;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class FirebaseAuth
implements InternalAuthProvider {
    private FirebaseApp zza;
    private final List<IdTokenListener> zzb;
    private final List<com.google.firebase.auth.internal.IdTokenListener> zzc;
    private List<AuthStateListener> zzd;
    private com.google.firebase.auth.api.internal.zzau zze;
    private FirebaseUser zzf;
    private zzo zzg;
    private final Object zzh;
    private String zzi;
    private final Object zzj;
    private String zzk;
    private final zzav zzl;
    private final zzam zzm;
    private zzau zzn;
    private zzaw zzo;

    @Keep
    public static FirebaseAuth getInstance() {
        return (FirebaseAuth)FirebaseApp.getInstance().get(FirebaseAuth.class);
    }

    @Keep
    public static FirebaseAuth getInstance(@NonNull FirebaseApp firebaseApp) {
        return (FirebaseAuth)firebaseApp.get(FirebaseAuth.class);
    }

    public FirebaseAuth(FirebaseApp firebaseApp) {
        FirebaseApp firebaseApp2 = firebaseApp;
        zzej zzej2 = new zzei(firebaseApp2.getOptions().getApiKey()).zza();
        this(firebaseApp, zzeh.zza(firebaseApp2.getApplicationContext(), zzej2), new zzav(firebaseApp.getApplicationContext(), firebaseApp.getPersistenceKey()), zzam.zza());
    }

    @VisibleForTesting
    private FirebaseAuth(FirebaseApp firebaseApp, com.google.firebase.auth.api.internal.zzau zzau2, zzav zzav2, zzam zzam2) {
        zzey zzey2;
        this.zzh = new Object();
        this.zzj = new Object();
        this.zza = (FirebaseApp)Preconditions.checkNotNull((Object)firebaseApp);
        this.zze = (com.google.firebase.auth.api.internal.zzau)Preconditions.checkNotNull((Object)zzau2);
        this.zzl = (zzav)Preconditions.checkNotNull((Object)zzav2);
        this.zzg = new zzo();
        this.zzm = (zzam)Preconditions.checkNotNull((Object)zzam2);
        this.zzb = new CopyOnWriteArrayList<IdTokenListener>();
        this.zzc = new CopyOnWriteArrayList<com.google.firebase.auth.internal.IdTokenListener>();
        this.zzd = new CopyOnWriteArrayList<AuthStateListener>();
        this.zzo = zzaw.zza();
        FirebaseAuth firebaseAuth = this;
        firebaseAuth.zzf = firebaseAuth.zzl.zza();
        if (firebaseAuth.zzf != null && (zzey2 = firebaseAuth.zzl.zzb(firebaseAuth.zzf)) != null) {
            firebaseAuth.zza(firebaseAuth.zzf, zzey2, false);
        }
        firebaseAuth.zzm.zza(firebaseAuth);
    }

    @Nullable
    public FirebaseUser getCurrentUser() {
        return this.zzf;
    }

    @Nullable
    public String getUid() {
        if (this.zzf == null) {
            return null;
        }
        return this.zzf.getUid();
    }

    public final void zza(@NonNull FirebaseUser firebaseUser, @NonNull zzey zzey2, boolean bl) {
        boolean bl2;
        boolean bl3;
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)zzey2);
        if (this.zzf == null) {
            bl3 = true;
            bl2 = true;
        } else {
            String string;
            String string2 = this.zzf.zze().zzd();
            boolean bl4 = !string2.equals(string = zzey2.zzd());
            boolean bl5 = this.zzf.getUid().equals(firebaseUser.getUid());
            bl3 = !bl5 || bl4;
            bl2 = !bl5;
        }
        boolean bl6 = bl2;
        boolean bl7 = bl;
        FirebaseUser firebaseUser2 = firebaseUser;
        FirebaseAuth firebaseAuth = this;
        Preconditions.checkNotNull((Object)firebaseUser2);
        if (firebaseAuth.zzf == null) {
            firebaseAuth.zzf = firebaseUser2;
        } else {
            firebaseAuth.zzf.zza(firebaseUser2.getProviderData());
            if (!firebaseUser2.isAnonymous()) {
                firebaseAuth.zzf.zzb();
            }
            List<zzy> list = firebaseUser2.zzh().zza();
            firebaseAuth.zzf.zzb(list);
        }
        if (bl7) {
            firebaseAuth.zzl.zza(firebaseAuth.zzf);
        }
        if (bl3) {
            if (this.zzf != null) {
                this.zzf.zza(zzey2);
            }
            this.zzc(this.zzf);
        }
        if (bl6) {
            this.zzd(this.zzf);
        }
        if (bl) {
            this.zzl.zza(firebaseUser, zzey2);
        }
        firebaseAuth = this;
        firebaseAuth.zzd().zza(firebaseAuth.zzf.zze());
    }

    public final void zza() {
        if (this.zzf != null) {
            FirebaseUser firebaseUser = this.zzf;
            zzav zzav2 = this.zzl;
            Preconditions.checkNotNull((Object)firebaseUser);
            zzav2.zza(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()));
            this.zzf = null;
        }
        this.zzl.zza("com.google.firebase.auth.FIREBASE_USER");
        this.zzc(null);
        this.zzd(null);
    }

    @VisibleForTesting
    private final synchronized void zza(zzau zzau2) {
        this.zzn = zzau2;
    }

    @VisibleForTesting
    private final synchronized zzau zzd() {
        if (this.zzn == null) {
            this.zza(new zzau(this.zza));
        }
        return this.zzn;
    }

    public FirebaseApp getApp() {
        return this.zza;
    }

    public final FirebaseApp zzb() {
        return this.zza;
    }

    public void addIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzb.add(idTokenListener);
        this.zzo.execute(new zzl(this, idTokenListener));
    }

    @KeepForSdk
    public void addIdTokenListener(@NonNull com.google.firebase.auth.internal.IdTokenListener idTokenListener) {
        Preconditions.checkNotNull((Object)idTokenListener);
        this.zzc.add(idTokenListener);
        this.zzd().zza(this.zzc.size());
    }

    public void removeIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzb.remove(idTokenListener);
    }

    @KeepForSdk
    public void removeIdTokenListener(@NonNull com.google.firebase.auth.internal.IdTokenListener idTokenListener) {
        Preconditions.checkNotNull((Object)idTokenListener);
        this.zzc.remove(idTokenListener);
        this.zzd().zza(this.zzc.size());
    }

    public void addAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzd.add(authStateListener);
        this.zzo.execute(new com.google.firebase.auth.zzn(this, authStateListener));
    }

    public void removeAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzd.remove(authStateListener);
    }

    private final void zzc(@Nullable FirebaseUser firebaseUser) {
        String string;
        if (firebaseUser != null) {
            string = firebaseUser.getUid();
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(45 + String.valueOf(string).length()).append("Notifying id token listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying id token listeners about a sign-out event.");
        }
        string = firebaseUser != null ? firebaseUser.zzg() : null;
        InternalTokenResult internalTokenResult = new InternalTokenResult(string);
        this.zzo.execute(new zzm(this, internalTokenResult));
    }

    private final void zzd(@Nullable FirebaseUser firebaseUser) {
        if (firebaseUser != null) {
            String string = firebaseUser.getUid();
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(47 + String.valueOf(string).length()).append("Notifying auth state listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying auth state listeners about a sign-out event.");
        }
        this.zzo.execute(new zzp(this));
    }

    @NonNull
    public Task<GetTokenResult> getAccessToken(boolean bl) {
        return this.zza(this.zzf, bl);
    }

    @NonNull
    public final Task<GetTokenResult> zza(@Nullable FirebaseUser firebaseUser, boolean bl) {
        if (firebaseUser == null) {
            return Tasks.forException((Exception)zzdw.zza(new Status(17495)));
        }
        zzey zzey2 = firebaseUser.zze();
        if (zzey2.zzb() && !bl) {
            return Tasks.forResult((Object)zzap.zza(zzey2.zzd()));
        }
        return this.zze.zza(this.zza, firebaseUser, zzey2.zzc(), (zzaz)((Object)new com.google.firebase.auth.zzo(this)));
    }

    @NonNull
    public Task<AuthResult> signInWithCredential(@NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)((Object)authCredential));
        if (authCredential instanceof EmailAuthCredential) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            if (!emailAuthCredential.zzf()) {
                return this.zze.zzb(this.zza, emailAuthCredential.zza(), emailAuthCredential.zzb(), this.zzk, new zza());
            }
            if (this.zzb(emailAuthCredential.zzc())) {
                return Tasks.forException((Exception)zzdw.zza(new Status(17072)));
            }
            return this.zze.zza(this.zza, emailAuthCredential, new zza());
        }
        if (authCredential instanceof PhoneAuthCredential) {
            PhoneAuthCredential phoneAuthCredential = (PhoneAuthCredential)authCredential;
            return this.zze.zza(this.zza, phoneAuthCredential, this.zzk, (com.google.firebase.auth.internal.zza)new zza());
        }
        return this.zze.zza(this.zza, authCredential, this.zzk, (com.google.firebase.auth.internal.zza)new zza());
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)((Object)authCredential));
        if (EmailAuthCredential.class.isAssignableFrom(((Object)((Object)authCredential)).getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            if ("password".equals(((AuthCredential)emailAuthCredential).getSignInMethod())) {
                return this.zze.zza(this.zza, firebaseUser, emailAuthCredential.zza(), emailAuthCredential.zzb(), firebaseUser.zzd(), (zzaz)((Object)new zzb()));
            }
            if (this.zzb(emailAuthCredential.zzc())) {
                return Tasks.forException((Exception)zzdw.zza(new Status(17072)));
            }
            return this.zze.zza(this.zza, firebaseUser, emailAuthCredential, (zzaz)((Object)new zzb()));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zze.zza(this.zza, firebaseUser, (PhoneAuthCredential)authCredential, this.zzk, (zzaz)((Object)new zzb()));
        }
        return this.zze.zza(this.zza, firebaseUser, authCredential, firebaseUser.zzd(), (zzaz)((Object)new zzb()));
    }

    public final Task<AuthResult> zzb(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)((Object)authCredential));
        if (EmailAuthCredential.class.isAssignableFrom(((Object)((Object)authCredential)).getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            if ("password".equals(((AuthCredential)emailAuthCredential).getSignInMethod())) {
                return this.zze.zzb(this.zza, firebaseUser, emailAuthCredential.zza(), emailAuthCredential.zzb(), firebaseUser.zzd(), (zzaz)((Object)new zzb()));
            }
            if (this.zzb(emailAuthCredential.zzc())) {
                return Tasks.forException((Exception)zzdw.zza(new Status(17072)));
            }
            return this.zze.zzb(this.zza, firebaseUser, emailAuthCredential, (zzaz)((Object)new zzb()));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zze.zzb(this.zza, firebaseUser, (PhoneAuthCredential)authCredential, this.zzk, (zzaz)((Object)new zzb()));
        }
        return this.zze.zzb(this.zza, firebaseUser, authCredential, firebaseUser.zzd(), (zzaz)((Object)new zzb()));
    }

    @NonNull
    public Task<AuthResult> signInWithCustomToken(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zze.zza(this.zza, string, this.zzk, (com.google.firebase.auth.internal.zza)new zza());
    }

    @NonNull
    public Task<AuthResult> signInWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        return this.zze.zzb(this.zza, string, string2, this.zzk, new zza());
    }

    @NonNull
    public Task<AuthResult> signInWithEmailLink(@NonNull String string, @NonNull String string2) {
        return this.signInWithCredential(EmailAuthProvider.getCredentialWithLink(string, string2));
    }

    @NonNull
    public Task<AuthResult> signInAnonymously() {
        if (this.zzf != null && this.zzf.isAnonymous()) {
            zzn zzn2 = (zzn)this.zzf;
            zzn2.zza(false);
            return Tasks.forResult((Object)new zzh(zzn2));
        }
        return this.zze.zza(this.zza, new zza(), this.zzk);
    }

    public final void zza(@NonNull String string, long l, TimeUnit timeUnit, @NonNull PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks, @Nullable Activity activity, @NonNull Executor executor, boolean bl, @Nullable String string2) {
        long l2 = TimeUnit.SECONDS.convert(l, timeUnit);
        if (l2 < 0L || l2 > 120L) {
            throw new IllegalArgumentException("We only support 0-120 seconds for sms-auto-retrieval timeout");
        }
        zzfk zzfk2 = new zzfk(string, l2, bl, this.zzi, this.zzk, null);
        PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks2 = onVerificationStateChangedCallbacks;
        String string3 = string;
        FirebaseAuth firebaseAuth = this;
        if (firebaseAuth.zzg.zzc() && string3.equals(firebaseAuth.zzg.zza())) {
            PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks3 = onVerificationStateChangedCallbacks2;
            FirebaseAuth firebaseAuth2 = firebaseAuth;
            onVerificationStateChangedCallbacks2 = new zzr(firebaseAuth2, onVerificationStateChangedCallbacks3);
        }
        onVerificationStateChangedCallbacks = onVerificationStateChangedCallbacks2;
        this.zze.zza(this.zza, zzfk2, onVerificationStateChangedCallbacks, activity, executor);
    }

    public Task<Void> updateCurrentUser(@NonNull FirebaseUser firebaseUser) {
        if (firebaseUser == null) {
            throw new IllegalArgumentException("Cannot update current user with null user!");
        }
        if (firebaseUser.zzd() != null && !firebaseUser.zzd().equals(this.zzk) || this.zzk != null && !this.zzk.equals(firebaseUser.zzd())) {
            return Tasks.forException((Exception)zzdw.zza(new Status(17072)));
        }
        String string = firebaseUser.zzc().getOptions().getApiKey();
        String string2 = this.zza.getOptions().getApiKey();
        if (firebaseUser.zze().zzb() && string2.equals(string)) {
            FirebaseUser firebaseUser2 = com.google.firebase.auth.internal.zzn.zza(this.zza, firebaseUser);
            this.zza(firebaseUser2, firebaseUser.zze(), true);
            return Tasks.forResult(null);
        }
        return this.zza(firebaseUser, (zzaz)((Object)new zzc(this)));
    }

    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser) {
        return this.zza(firebaseUser, (zzaz)((Object)new zzb()));
    }

    @NonNull
    private final Task<Void> zza(@NonNull FirebaseUser firebaseUser, zzaz zzaz2) {
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zze.zza(this.zza, firebaseUser, zzaz2);
    }

    @NonNull
    public final Task<AuthResult> zzc(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)((Object)authCredential));
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zze.zza(this.zza, firebaseUser, authCredential, (zzaz)((Object)new zzb()));
    }

    @NonNull
    public final Task<AuthResult> zza(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zze.zzd(this.zza, firebaseUser, string, (zzaz)((Object)new zzb()));
    }

    @NonNull
    public Task<AuthResult> createUserWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        return this.zze.zza(this.zza, string, string2, this.zzk, new zza());
    }

    @NonNull
    public Task<SignInMethodQueryResult> fetchSignInMethodsForEmail(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zze.zza(this.zza, string, this.zzk);
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)((Object)userProfileChangeRequest));
        return this.zze.zza(this.zza, firebaseUser, userProfileChangeRequest, (zzaz)((Object)new zzb()));
    }

    @NonNull
    public final Task<Void> zzb(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotEmpty((String)string);
        return this.zze.zzb(this.zza, firebaseUser, string, (zzaz)((Object)new zzb()));
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull PhoneAuthCredential phoneAuthCredential) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)phoneAuthCredential);
        return this.zze.zza(this.zza, firebaseUser, phoneAuthCredential, (zzaz)((Object)new zzb()));
    }

    @NonNull
    public final Task<Void> zzc(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotEmpty((String)string);
        return this.zze.zzc(this.zza, firebaseUser, string, (zzaz)((Object)new zzb()));
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.sendPasswordResetEmail(string, null);
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string, @Nullable ActionCodeSettings actionCodeSettings) {
        Preconditions.checkNotEmpty((String)string);
        if (actionCodeSettings == null) {
            actionCodeSettings = ActionCodeSettings.zza();
        }
        if (this.zzi != null) {
            actionCodeSettings.zza(this.zzi);
        }
        actionCodeSettings.zza(zzgd.zzb);
        return this.zze.zza(this.zza, string, actionCodeSettings, this.zzk);
    }

    public Task<Void> sendSignInLinkToEmail(@NonNull String string, @NonNull ActionCodeSettings actionCodeSettings) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)actionCodeSettings));
        if (!actionCodeSettings.canHandleCodeInApp()) {
            throw new IllegalArgumentException("You must set canHandleCodeInApp in your ActionCodeSettings to true for Email-Link Sign-in.");
        }
        if (this.zzi != null) {
            actionCodeSettings.zza(this.zzi);
        }
        return this.zze.zzb(this.zza, string, actionCodeSettings, this.zzk);
    }

    public boolean isSignInWithEmailLink(@NonNull String string) {
        return EmailAuthCredential.zza(string);
    }

    @NonNull
    public final Task<Void> zza(@Nullable ActionCodeSettings actionCodeSettings, @NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        if (this.zzi != null) {
            if (actionCodeSettings == null) {
                actionCodeSettings = ActionCodeSettings.zza();
            }
            actionCodeSettings.zza(this.zzi);
        }
        return this.zze.zza(this.zza, actionCodeSettings, string);
    }

    @NonNull
    public Task<ActionCodeResult> checkActionCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zze.zzb(this.zza, string, this.zzk);
    }

    @NonNull
    public Task<Void> applyActionCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zze.zzc(this.zza, string, this.zzk);
    }

    @NonNull
    public Task<String> verifyPasswordResetCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zze.zzd(this.zza, string, this.zzk);
    }

    @NonNull
    public Task<Void> confirmPasswordReset(@NonNull String string, @NonNull String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        return this.zze.zza(this.zza, string, string2, this.zzk);
    }

    public Task<AuthResult> startActivityForSignInWithProvider(@NonNull Activity activity, @NonNull FederatedAuthProvider federatedAuthProvider) {
        Preconditions.checkNotNull((Object)federatedAuthProvider);
        Preconditions.checkNotNull((Object)activity);
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        if (!this.zzm.zza(activity, (TaskCompletionSource<AuthResult>)taskCompletionSource, this)) {
            return Tasks.forException((Exception)zzdw.zza(new Status(17057)));
        }
        FirebaseAuth firebaseAuth = this;
        Context context = activity.getApplicationContext();
        zzas.zza(context, firebaseAuth);
        federatedAuthProvider.zza(activity);
        return taskCompletionSource.getTask();
    }

    public final Task<AuthResult> zza(@NonNull Activity activity, @NonNull FederatedAuthProvider federatedAuthProvider, @NonNull FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)activity);
        Preconditions.checkNotNull((Object)federatedAuthProvider);
        Preconditions.checkNotNull((Object)firebaseUser);
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        if (!this.zzm.zza(activity, (TaskCompletionSource<AuthResult>)taskCompletionSource, this, firebaseUser)) {
            return Tasks.forException((Exception)zzdw.zza(new Status(17057)));
        }
        FirebaseUser firebaseUser2 = firebaseUser;
        FirebaseAuth firebaseAuth = this;
        Context context = activity.getApplicationContext();
        zzas.zza(context, firebaseAuth, firebaseUser2);
        federatedAuthProvider.zzb(activity);
        return taskCompletionSource.getTask();
    }

    public final Task<AuthResult> zzb(@NonNull Activity activity, @NonNull FederatedAuthProvider federatedAuthProvider, @NonNull FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)activity);
        Preconditions.checkNotNull((Object)federatedAuthProvider);
        Preconditions.checkNotNull((Object)firebaseUser);
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        if (!this.zzm.zza(activity, (TaskCompletionSource<AuthResult>)taskCompletionSource, this, firebaseUser)) {
            return Tasks.forException((Exception)zzdw.zza(new Status(17057)));
        }
        FirebaseUser firebaseUser2 = firebaseUser;
        FirebaseAuth firebaseAuth = this;
        Context context = activity.getApplicationContext();
        zzas.zza(context, firebaseAuth, firebaseUser2);
        federatedAuthProvider.zzc(activity);
        return taskCompletionSource.getTask();
    }

    @Nullable
    public Task<AuthResult> getPendingAuthResult() {
        return this.zzm.zzb();
    }

    @NonNull
    public final Task<Void> zzb(@NonNull FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zze.zza(firebaseUser, new zzq(this, firebaseUser));
    }

    public void signOut() {
        this.zza();
        if (this.zzn != null) {
            this.zzn.zza();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLanguageCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        Object object = this.zzh;
        synchronized (object) {
            this.zzi = string;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getLanguageCode() {
        Object object = this.zzh;
        synchronized (object) {
            return this.zzi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        Object object = this.zzj;
        synchronized (object) {
            this.zzk = string;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String zzc() {
        Object object = this.zzj;
        synchronized (object) {
            return this.zzk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useAppLanguage() {
        Object object = this.zzh;
        synchronized (object) {
            this.zzi = zzer.zza();
            return;
        }
    }

    public FirebaseAuthSettings getFirebaseAuthSettings() {
        return this.zzg;
    }

    public Task<Void> setFirebaseUIVersion(@Nullable String string) {
        return this.zze.zza(string);
    }

    private final boolean zzb(String string) {
        zzf zzf2 = com.google.firebase.auth.zzf.zza(string);
        return zzf2 != null && !TextUtils.equals((CharSequence)this.zzk, (CharSequence)zzf2.zzc());
    }

    static /* synthetic */ List zza(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzc;
    }

    static /* synthetic */ List zzb(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzb;
    }

    static /* synthetic */ List zzc(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzd;
    }

    static /* synthetic */ zzo zzd(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzg;
    }

    static /* synthetic */ FirebaseUser zze(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzf;
    }

    final class zzc
    extends zza
    implements com.google.firebase.auth.internal.zza,
    zzae {
        zzc(FirebaseAuth firebaseAuth) {
        }

        @Override
        public final void zza(Status status) {
        }
    }

    @VisibleForTesting
    final class zzb
    extends zza
    implements com.google.firebase.auth.internal.zza,
    zzae {
        zzb() {
        }

        @Override
        public final void zza(Status status) {
            if (status.getStatusCode() == 17011 || status.getStatusCode() == 17021 || status.getStatusCode() == 17005 || status.getStatusCode() == 17091) {
                FirebaseAuth.this.signOut();
            }
        }
    }

    @VisibleForTesting
    class zza
    implements com.google.firebase.auth.internal.zza {
        zza() {
        }

        @Override
        public final void zza(@NonNull zzey zzey2, @NonNull FirebaseUser firebaseUser) {
            Preconditions.checkNotNull((Object)zzey2);
            Preconditions.checkNotNull((Object)firebaseUser);
            firebaseUser.zza(zzey2);
            FirebaseAuth.this.zza(firebaseUser, zzey2, true);
        }
    }

    public static interface AuthStateListener {
        public void onAuthStateChanged(@NonNull FirebaseAuth var1);
    }

    public static interface IdTokenListener {
        public void onIdTokenChanged(@NonNull FirebaseAuth var1);
    }
}

