/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.internal.firebase_auth.zzey;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FederatedAuthProvider;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUserMetadata;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.UserInfo;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.zzu;
import com.google.firebase.auth.zzv;
import com.google.firebase.auth.zzy;
import com.google.firebase.auth.zzz;
import java.util.List;

public abstract class FirebaseUser
extends AbstractSafeParcelable
implements UserInfo {
    @Override
    @NonNull
    public abstract String getUid();

    @Override
    @NonNull
    public abstract String getProviderId();

    public abstract boolean isAnonymous();

    @Nullable
    public abstract List<String> zza();

    @NonNull
    public abstract List<? extends UserInfo> getProviderData();

    @NonNull
    public abstract FirebaseUser zza(@NonNull List<? extends UserInfo> var1);

    public abstract FirebaseUser zzb();

    @NonNull
    public abstract FirebaseApp zzc();

    @Override
    @Nullable
    public abstract String getDisplayName();

    @Override
    @Nullable
    public abstract Uri getPhotoUrl();

    @Override
    @Nullable
    public abstract String getEmail();

    @Override
    @Nullable
    public abstract String getPhoneNumber();

    @Nullable
    public abstract String zzd();

    @NonNull
    public Task<GetTokenResult> getIdToken(boolean bl) {
        return FirebaseAuth.getInstance(this.zzc()).zza(this, bl);
    }

    @NonNull
    public Task<Void> reload() {
        return FirebaseAuth.getInstance(this.zzc()).zza(this);
    }

    public Task<Void> reauthenticate(@NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)((Object)authCredential));
        return FirebaseAuth.getInstance(this.zzc()).zza(this, authCredential);
    }

    public Task<AuthResult> reauthenticateAndRetrieveData(@NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)((Object)authCredential));
        return FirebaseAuth.getInstance(this.zzc()).zzb(this, authCredential);
    }

    @NonNull
    public Task<AuthResult> startActivityForReauthenticateWithProvider(@NonNull Activity activity, @NonNull FederatedAuthProvider federatedAuthProvider) {
        Preconditions.checkNotNull((Object)activity);
        Preconditions.checkNotNull((Object)federatedAuthProvider);
        return FirebaseAuth.getInstance(this.zzc()).zzb(activity, federatedAuthProvider, this);
    }

    @NonNull
    public Task<AuthResult> linkWithCredential(@NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)((Object)authCredential));
        return FirebaseAuth.getInstance(this.zzc()).zzc(this, authCredential);
    }

    @NonNull
    public Task<AuthResult> startActivityForLinkWithProvider(@NonNull Activity activity, @NonNull FederatedAuthProvider federatedAuthProvider) {
        Preconditions.checkNotNull((Object)activity);
        Preconditions.checkNotNull((Object)federatedAuthProvider);
        return FirebaseAuth.getInstance(this.zzc()).zza(activity, federatedAuthProvider, this);
    }

    public Task<AuthResult> unlink(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return FirebaseAuth.getInstance(this.zzc()).zza(this, string);
    }

    @NonNull
    public Task<Void> updateProfile(@NonNull UserProfileChangeRequest userProfileChangeRequest) {
        Preconditions.checkNotNull((Object)((Object)userProfileChangeRequest));
        return FirebaseAuth.getInstance(this.zzc()).zza(this, userProfileChangeRequest);
    }

    @NonNull
    public Task<Void> updateEmail(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return FirebaseAuth.getInstance(this.zzc()).zzb(this, string);
    }

    public Task<Void> updatePhoneNumber(@NonNull PhoneAuthCredential phoneAuthCredential) {
        return FirebaseAuth.getInstance(this.zzc()).zza(this, phoneAuthCredential);
    }

    @NonNull
    public Task<Void> updatePassword(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return FirebaseAuth.getInstance(this.zzc()).zzc(this, string);
    }

    @NonNull
    public Task<Void> delete() {
        return FirebaseAuth.getInstance(this.zzc()).zzb(this);
    }

    @NonNull
    public Task<Void> sendEmailVerification() {
        return FirebaseAuth.getInstance(this.zzc()).zza(this, false).continueWithTask((Continuation)new zzu(this));
    }

    @NonNull
    public Task<Void> sendEmailVerification(ActionCodeSettings actionCodeSettings) {
        return FirebaseAuth.getInstance(this.zzc()).zza(this, false).continueWithTask((Continuation)new zzv(this, actionCodeSettings));
    }

    @NonNull
    public abstract zzey zze();

    public abstract void zza(@NonNull zzey var1);

    @NonNull
    public abstract String zzf();

    @NonNull
    public abstract String zzg();

    @Nullable
    public abstract FirebaseUserMetadata getMetadata();

    @NonNull
    public abstract zzz zzh();

    public abstract void zzb(List<zzy> var1);
}

