/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.FederatedAuthProvider;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.internal.FederatedSignInActivity;
import com.google.firebase.auth.zzac;
import com.google.firebase.auth.zzg;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OAuthProvider
extends FederatedAuthProvider {
    private final Bundle zza;

    private OAuthProvider(Bundle bundle) {
        this.zza = bundle;
    }

    public static Builder newBuilder(@NonNull String string) {
        return OAuthProvider.newBuilder(string, FirebaseAuth.getInstance());
    }

    public static Builder newBuilder(@NonNull String string, @NonNull FirebaseAuth firebaseAuth) {
        GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
        FirebaseAuth firebaseAuth2 = firebaseAuth;
        String string2 = string;
        Preconditions.checkNotEmpty((String)string2);
        Preconditions.checkNotNull((Object)firebaseAuth2);
        if ("facebook.com".equals(string2)) {
            throw new IllegalArgumentException("Sign in with Facebook is not supported via this method; the Facebook TOS dictate that you must use the Facebook Android SDK for Facebook login.");
        }
        return new Builder(string2, firebaseAuth2, googleApiAvailability, null);
    }

    public String getProviderId() {
        if (this.zza == null) {
            return null;
        }
        return this.zza.getString("com.google.firebase.auth.KEY_PROVIDER_ID", null);
    }

    @Override
    public final void zza(Activity activity) {
        Intent intent = new Intent("com.google.firebase.auth.internal.SIGN_IN");
        intent.setPackage(activity.getPackageName());
        intent.setClass((Context)activity, FederatedSignInActivity.class);
        intent.putExtras(this.zza);
        activity.startActivity(intent);
    }

    @Override
    public final void zzb(Activity activity) {
        Intent intent = new Intent("com.google.firebase.auth.internal.LINK");
        intent.setPackage(activity.getPackageName());
        intent.setClass((Context)activity, FederatedSignInActivity.class);
        intent.putExtras(this.zza);
        activity.startActivity(intent);
    }

    @Override
    public final void zzc(Activity activity) {
        Intent intent = new Intent("com.google.firebase.auth.internal.REAUTHENTICATE");
        intent.setPackage(activity.getPackageName());
        intent.setClass((Context)activity, FederatedSignInActivity.class);
        intent.putExtras(this.zza);
        activity.startActivity(intent);
    }

    public static AuthCredential getCredential(@NonNull String string, String string2, String string3) {
        return zzg.zza(string, string2, string3);
    }

    /* synthetic */ OAuthProvider(Bundle bundle, zzac zzac2) {
        this(bundle);
    }

    public static class Builder {
        private final FirebaseAuth zza;
        @VisibleForTesting
        private final Bundle zzb = new Bundle();
        private final Bundle zzc = new Bundle();

        private Builder(String string, FirebaseAuth firebaseAuth, GoogleApiAvailability googleApiAvailability) {
            this.zza = firebaseAuth;
            this.zzb.putString("com.google.firebase.auth.KEY_API_KEY", this.zza.zzb().getOptions().getApiKey());
            this.zzb.putString("com.google.firebase.auth.KEY_PROVIDER_ID", string);
            this.zzb.putBundle("com.google.firebase.auth.KEY_PROVIDER_CUSTOM_PARAMS", this.zzc);
            this.zzb.putString("com.google.firebase.auth.internal.CLIENT_VERSION", Integer.toString(googleApiAvailability.getClientVersion(this.zza.zzb().getApplicationContext())));
            this.zzb.putString("com.google.firebase.auth.KEY_TENANT_ID", this.zza.zzc());
        }

        public Builder setScopes(List<String> list) {
            this.zzb.putStringArrayList("com.google.firebase.auth.KEY_PROVIDER_SCOPES", new ArrayList<String>(list));
            return this;
        }

        public Builder addCustomParameter(String string, String string2) {
            this.zzc.putString(string, string2);
            return this;
        }

        public Builder addCustomParameters(Map<String, String> map) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.zzc.putString(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public OAuthProvider build() {
            return new OAuthProvider(this.zzb, null);
        }

        /* synthetic */ Builder(String string, FirebaseAuth firebaseAuth, GoogleApiAvailability googleApiAvailability, zzac zzac2) {
            this(string, firebaseAuth, googleApiAvailability);
        }
    }
}

