/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.logging.Logger;
import com.google.android.gms.tasks.TaskExecutors;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseException;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.zzh;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class PhoneAuthProvider {
    public static final String PROVIDER_ID = "phone";
    public static final String PHONE_SIGN_IN_METHOD = "phone";
    private FirebaseAuth zza;

    private PhoneAuthProvider(FirebaseAuth firebaseAuth) {
        this.zza = firebaseAuth;
    }

    public static PhoneAuthProvider getInstance(FirebaseAuth firebaseAuth) {
        return new PhoneAuthProvider(firebaseAuth);
    }

    public static PhoneAuthProvider getInstance() {
        return new PhoneAuthProvider(FirebaseAuth.getInstance(FirebaseApp.getInstance()));
    }

    public void verifyPhoneNumber(@NonNull String string, long l, TimeUnit timeUnit, @NonNull Activity activity, @NonNull OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks) {
        this.zza(Preconditions.checkNotEmpty((String)string), l, timeUnit, (Activity)Preconditions.checkNotNull((Object)activity), TaskExecutors.MAIN_THREAD, (OnVerificationStateChangedCallbacks)Preconditions.checkNotNull((Object)onVerificationStateChangedCallbacks), null);
    }

    public void verifyPhoneNumber(@NonNull String string, long l, TimeUnit timeUnit, @NonNull Executor executor, @NonNull OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks) {
        this.zza(Preconditions.checkNotEmpty((String)string), l, timeUnit, null, (Executor)Preconditions.checkNotNull((Object)executor), (OnVerificationStateChangedCallbacks)Preconditions.checkNotNull((Object)onVerificationStateChangedCallbacks), null);
    }

    public void verifyPhoneNumber(@NonNull String string, long l, TimeUnit timeUnit, @NonNull Activity activity, @NonNull OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks, @Nullable ForceResendingToken forceResendingToken) {
        this.zza(Preconditions.checkNotEmpty((String)string), l, timeUnit, (Activity)Preconditions.checkNotNull((Object)activity), TaskExecutors.MAIN_THREAD, (OnVerificationStateChangedCallbacks)Preconditions.checkNotNull((Object)onVerificationStateChangedCallbacks), forceResendingToken);
    }

    public void verifyPhoneNumber(@NonNull String string, long l, TimeUnit timeUnit, @NonNull Executor executor, @NonNull OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks, @Nullable ForceResendingToken forceResendingToken) {
        this.zza(Preconditions.checkNotEmpty((String)string), l, timeUnit, null, (Executor)Preconditions.checkNotNull((Object)executor), (OnVerificationStateChangedCallbacks)Preconditions.checkNotNull((Object)onVerificationStateChangedCallbacks), forceResendingToken);
    }

    private final void zza(String string, long l, TimeUnit timeUnit, Activity activity, Executor executor, OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks, ForceResendingToken forceResendingToken) {
        this.zza.zza(string, l, timeUnit, onVerificationStateChangedCallbacks, activity, executor, forceResendingToken != null, null);
    }

    public static PhoneAuthCredential getCredential(@NonNull String string, @NonNull String string2) {
        String string3 = string2;
        String string4 = string;
        return new PhoneAuthCredential(string4, string3, false, null, true, null, null);
    }

    @SafeParcelable.Class(creator="DefaultForceResendingTokenCreator")
    public static class ForceResendingToken
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<ForceResendingToken> CREATOR = new zzh();

        @SafeParcelable.Constructor
        ForceResendingToken() {
        }

        public void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
            SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        }

        public static ForceResendingToken zza() {
            return new ForceResendingToken();
        }
    }

    public static abstract class OnVerificationStateChangedCallbacks {
        private static final Logger zza = new Logger("PhoneAuthProvider", new String[0]);

        public abstract void onVerificationCompleted(PhoneAuthCredential var1);

        public abstract void onVerificationFailed(FirebaseException var1);

        public void onCodeSent(String string, ForceResendingToken forceResendingToken) {
        }

        public void onCodeAutoRetrievalTimeOut(String string) {
            zza.i("Sms auto retrieval timed-out.", new Object[0]);
        }
    }
}

