/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.api.internal;

import android.text.TextUtils;
import android.util.Pair;
import android.util.SparseArray;
import androidx.annotation.Nullable;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.firebase_auth.zzao;
import com.google.android.gms.internal.firebase_auth.zzed;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.FirebaseException;
import com.google.firebase.FirebaseNetworkException;
import com.google.firebase.FirebaseTooManyRequestsException;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseAuthActionCodeException;
import com.google.firebase.auth.FirebaseAuthEmailException;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.FirebaseAuthInvalidCredentialsException;
import com.google.firebase.auth.FirebaseAuthInvalidUserException;
import com.google.firebase.auth.FirebaseAuthRecentLoginRequiredException;
import com.google.firebase.auth.FirebaseAuthUserCollisionException;
import com.google.firebase.auth.FirebaseAuthWeakPasswordException;
import com.google.firebase.auth.FirebaseAuthWebException;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.internal.zzu;
import com.google.firebase.auth.zzs;
import com.google.firebase.internal.api.FirebaseNoSignedInUserException;

public final class zzdw {
    @VisibleForTesting
    private static final SparseArray<Pair<String, String>> zza = new SparseArray();

    public static FirebaseException zza(Status status) {
        int n = status.getStatusCode();
        String string = zzdw.zza(zzdw.zzb(n), status);
        switch (n) {
            case 17014: {
                return new FirebaseAuthRecentLoginRequiredException(zzdw.zza(n), string);
            }
            case 17007: 
            case 17012: 
            case 17025: {
                return new FirebaseAuthUserCollisionException(zzdw.zza(n), string);
            }
            case 17005: 
            case 17011: 
            case 17017: 
            case 17021: {
                return new FirebaseAuthInvalidUserException(zzdw.zza(n), string);
            }
            case 17026: {
                return new FirebaseAuthWeakPasswordException(zzdw.zza(n), string, status.getStatusMessage());
            }
            case 17010: {
                String string2 = zzdw.zza("We have blocked all requests from this device due to unusual activity. Try again later.", status);
                return new FirebaseTooManyRequestsException(string2);
            }
            case 17020: {
                String string3 = zzdw.zza("A network error (such as timeout, interrupted connection or unreachable host) has occurred.", status);
                return new FirebaseNetworkException(string3);
            }
            case 17499: {
                String string4 = zzdw.zza("An internal error has occurred.", status);
                return new FirebaseException(string4);
            }
            case 17016: {
                String string5 = zzdw.zza("User was not linked to an account with the given provider.", status);
                return new FirebaseException(string5);
            }
            case 17015: {
                String string6 = zzdw.zza("User has already been linked to the given provider.", status);
                return new FirebaseException(string6);
            }
            case 17495: {
                String string7 = zzdw.zza("Please sign in before trying to get a token.", status);
                return new FirebaseNoSignedInUserException(string7);
            }
            case 17029: 
            case 17030: {
                return new FirebaseAuthActionCodeException(zzdw.zza(n), string);
            }
            case 17031: 
            case 17032: 
            case 17033: {
                return new FirebaseAuthEmailException(zzdw.zza(n), string);
            }
            case 17000: 
            case 17002: 
            case 17004: 
            case 17008: 
            case 17009: 
            case 17024: 
            case 17034: 
            case 17035: 
            case 17041: 
            case 17042: 
            case 17043: 
            case 17044: 
            case 17045: 
            case 17046: 
            case 17049: 
            case 17051: 
            case 17075: 
            case 17077: 
            case 17081: 
            case 17082: 
            case 17083: 
            case 17084: {
                return new FirebaseAuthInvalidCredentialsException(zzdw.zza(n), string);
            }
            case 17052: {
                return new FirebaseTooManyRequestsException(string);
            }
            case 17063: 
            case 17080: {
                return new FirebaseApiNotAvailableException(string);
            }
            case 17061: {
                String string8 = zzdw.zza("There was a failure in the connection between the web widget and the Firebase Auth backend.", status);
                return new FirebaseNetworkException(string8);
            }
            case 17057: 
            case 17058: 
            case 17062: 
            case 17065: {
                return new FirebaseAuthWebException(zzdw.zza(n), string);
            }
            case 17006: 
            case 17028: 
            case 17040: 
            case 17064: 
            case 17068: 
            case 17071: 
            case 17072: 
            case 17073: 
            case 17074: 
            case 17079: 
            case 17085: 
            case 17086: 
            case 17087: 
            case 17088: 
            case 17089: 
            case 17090: 
            case 17091: {
                return new FirebaseAuthException(zzdw.zza(n), string);
            }
        }
        return new FirebaseException("An internal error has occurred.");
    }

    public static FirebaseAuthUserCollisionException zza(Status status, AuthCredential authCredential, @Nullable String string, @Nullable String string2) {
        int n = status.getStatusCode();
        String string3 = zzdw.zza(zzdw.zzb(n), status);
        return new FirebaseAuthUserCollisionException(zzdw.zza(n), string3).zza(authCredential).zza(string).zzb(string2);
    }

    public static zzs zza(FirebaseAuth firebaseAuth, zzed zzed2, @Nullable FirebaseUser firebaseUser) {
        zzao.zza(firebaseAuth);
        zzao.zza(zzed2);
        Pair pair = (Pair)zza.get(17078);
        return new zzs((String)pair.first, (String)pair.second, zzu.zza(zzed2, firebaseAuth, firebaseUser));
    }

    private static String zza(String string, Status status) {
        if (TextUtils.isEmpty((CharSequence)status.getStatusMessage())) {
            return string;
        }
        return String.format(String.valueOf(string).concat(" [ %s ]"), status.getStatusMessage());
    }

    private static String zza(int n) {
        Pair pair = (Pair)zza.get(n);
        if (pair != null) {
            return (String)pair.first;
        }
        return "INTERNAL_ERROR";
    }

    private static String zzb(int n) {
        Pair pair = (Pair)zza.get(n);
        if (pair != null) {
            return (String)pair.second;
        }
        return "An internal error has occurred.";
    }

    static {
        zza.put(17000, (Object)new Pair((Object)"ERROR_INVALID_CUSTOM_TOKEN", (Object)"The custom token format is incorrect. Please check the documentation."));
        zza.put(17002, (Object)new Pair((Object)"ERROR_CUSTOM_TOKEN_MISMATCH", (Object)"The custom token corresponds to a different audience."));
        zza.put(17004, (Object)new Pair((Object)"ERROR_INVALID_CREDENTIAL", (Object)"The supplied auth credential is malformed or has expired."));
        zza.put(17008, (Object)new Pair((Object)"ERROR_INVALID_EMAIL", (Object)"The email address is badly formatted."));
        zza.put(17009, (Object)new Pair((Object)"ERROR_WRONG_PASSWORD", (Object)"The password is invalid or the user does not have a password."));
        zza.put(17024, (Object)new Pair((Object)"ERROR_USER_MISMATCH", (Object)"The supplied credentials do not correspond to the previously signed in user."));
        zza.put(17014, (Object)new Pair((Object)"ERROR_REQUIRES_RECENT_LOGIN", (Object)"This operation is sensitive and requires recent authentication. Log in again before retrying this request."));
        zza.put(17012, (Object)new Pair((Object)"ERROR_ACCOUNT_EXISTS_WITH_DIFFERENT_CREDENTIAL", (Object)"An account already exists with the same email address but different sign-in credentials. Sign in using a provider associated with this email address."));
        zza.put(17007, (Object)new Pair((Object)"ERROR_EMAIL_ALREADY_IN_USE", (Object)"The email address is already in use by another account."));
        zza.put(17025, (Object)new Pair((Object)"ERROR_CREDENTIAL_ALREADY_IN_USE", (Object)"This credential is already associated with a different user account."));
        zza.put(17005, (Object)new Pair((Object)"ERROR_USER_DISABLED", (Object)"The user account has been disabled by an administrator."));
        zza.put(17021, (Object)new Pair((Object)"ERROR_USER_TOKEN_EXPIRED", (Object)"The user's credential is no longer valid. The user must sign in again."));
        zza.put(17011, (Object)new Pair((Object)"ERROR_USER_NOT_FOUND", (Object)"There is no user record corresponding to this identifier. The user may have been deleted."));
        zza.put(17017, (Object)new Pair((Object)"ERROR_INVALID_USER_TOKEN", (Object)"This user's credential isn't valid for this project. This can happen if the user's token has been tampered with, or if the user isn't for the project associated with this API key."));
        zza.put(17006, (Object)new Pair((Object)"ERROR_OPERATION_NOT_ALLOWED", (Object)"The given sign-in provider is disabled for this Firebase project. Enable it in the Firebase console, under the sign-in method tab of the Auth section."));
        zza.put(17026, (Object)new Pair((Object)"ERROR_WEAK_PASSWORD", (Object)"The given password is invalid."));
        zza.put(17029, (Object)new Pair((Object)"ERROR_EXPIRED_ACTION_CODE", (Object)"The out of band code has expired."));
        zza.put(17030, (Object)new Pair((Object)"ERROR_INVALID_ACTION_CODE", (Object)"The out of band code is invalid. This can happen if the code is malformed, expired, or has already been used."));
        zza.put(17031, (Object)new Pair((Object)"ERROR_INVALID_MESSAGE_PAYLOAD", (Object)"The email template corresponding to this action contains invalid characters in its message. Please fix by going to the Auth email templates section in the Firebase Console."));
        zza.put(17033, (Object)new Pair((Object)"ERROR_INVALID_RECIPIENT_EMAIL", (Object)"The email corresponding to this action failed to send as the provided recipient email address is invalid."));
        zza.put(17032, (Object)new Pair((Object)"ERROR_INVALID_SENDER", (Object)"The email template corresponding to this action contains an invalid sender email or name. Please fix by going to the Auth email templates section in the Firebase Console."));
        zza.put(17034, (Object)new Pair((Object)"ERROR_MISSING_EMAIL", (Object)"An email address must be provided."));
        zza.put(17035, (Object)new Pair((Object)"ERROR_MISSING_PASSWORD", (Object)"A password must be provided."));
        zza.put(17041, (Object)new Pair((Object)"ERROR_MISSING_PHONE_NUMBER", (Object)"To send verification codes, provide a phone number for the recipient."));
        zza.put(17042, (Object)new Pair((Object)"ERROR_INVALID_PHONE_NUMBER", (Object)"The format of the phone number provided is incorrect. Please enter the phone number in a format that can be parsed into E.164 format. E.164 phone numbers are written in the format [+][country code][subscriber number including area code]."));
        zza.put(17043, (Object)new Pair((Object)"ERROR_MISSING_VERIFICATION_CODE", (Object)"The Phone Auth Credential was created with an empty sms verification Code"));
        zza.put(17044, (Object)new Pair((Object)"ERROR_INVALID_VERIFICATION_CODE", (Object)"The sms verification code used to create the phone auth credential is invalid. Please resend the verification code sms and be sure use the verification code provided by the user."));
        zza.put(17045, (Object)new Pair((Object)"ERROR_MISSING_VERIFICATION_ID", (Object)"The Phone Auth Credential was created with an empty verification ID"));
        zza.put(17046, (Object)new Pair((Object)"ERROR_INVALID_VERIFICATION_ID", (Object)"The verification ID used to create the phone auth credential is invalid."));
        zza.put(17049, (Object)new Pair((Object)"ERROR_RETRY_PHONE_AUTH", (Object)"An error occurred during authentication using the PhoneAuthCredential. Please retry authentication."));
        zza.put(17051, (Object)new Pair((Object)"ERROR_SESSION_EXPIRED", (Object)"The sms code has expired. Please re-send the verification code to try again."));
        zza.put(17052, (Object)new Pair((Object)"ERROR_QUOTA_EXCEEDED", (Object)"The sms quota for this project has been exceeded."));
        zza.put(17028, (Object)new Pair((Object)"ERROR_APP_NOT_AUTHORIZED", (Object)"This app is not authorized to use Firebase Authentication. Please verify that the correct package name and SHA-1 are configured in the Firebase Console."));
        zza.put(17063, (Object)new Pair((Object)"ERROR_API_NOT_AVAILABLE_WITHOUT_GPS", (Object)"The API that you are calling is not available on devices without Google Play Services."));
        zza.put(17062, (Object)new Pair((Object)"ERROR_WEB_INTERNAL_ERROR", (Object)"There was an internal error in the web widget."));
        zza.put(17064, (Object)new Pair((Object)"ERROR_INVALID_CERT_HASH", (Object)"There was an error while trying to get your package certificate hash."));
        zza.put(17065, (Object)new Pair((Object)"ERROR_WEB_STORAGE_UNSUPPORTED", (Object)"This browser is not supported or 3rd party cookies and data may be disabled."));
        zza.put(17040, (Object)new Pair((Object)"ERROR_MISSING_CONTINUE_URI", (Object)"A continue URL must be provided in the request."));
        zza.put(17068, (Object)new Pair((Object)"ERROR_DYNAMIC_LINK_NOT_ACTIVATED", (Object)"Please activate Dynamic Links in the Firebase Console and agree to the terms and conditions."));
        zza.put(17071, (Object)new Pair((Object)"ERROR_INVALID_PROVIDER_ID", (Object)"The provider ID provided for the attempted web operation is invalid."));
        zza.put(17057, (Object)new Pair((Object)"ERROR_WEB_CONTEXT_ALREADY_PRESENTED", (Object)"A headful operation is already in progress. Please wait for that to finish."));
        zza.put(17058, (Object)new Pair((Object)"ERROR_WEB_CONTEXT_CANCELED", (Object)"The web operation was canceled by the user."));
        zza.put(17072, (Object)new Pair((Object)"ERROR_TENANT_ID_MISMATCH", (Object)"The provided tenant ID does not match the Auth instance's tenant ID."));
        zza.put(17073, (Object)new Pair((Object)"ERROR_UNSUPPORTED_TENANT_OPERATION", (Object)"This operation is not supported in a multi-tenant context."));
        zza.put(17074, (Object)new Pair((Object)"ERROR_INVALID_DYNAMIC_LINK_DOMAIN", (Object)"The provided dynamic link domain is not configured or authorized for the current project."));
        zza.put(17075, (Object)new Pair((Object)"ERROR_REJECTED_CREDENTIAL", (Object)"The request contains malformed or mismatching credentials"));
        zza.put(17077, (Object)new Pair((Object)"ERROR_PHONE_NUMBER_NOT_FOUND", (Object)"The provided phone number does not match any of the second factor phone numbers associated with this user."));
        zza.put(17079, (Object)new Pair((Object)"ERROR_INVALID_TENANT_ID", (Object)"The Auth instance's tenant ID is invalid."));
        zza.put(17078, (Object)new Pair((Object)"ERROR_SECOND_FACTOR_REQUIRED", (Object)"Please complete a second factor challenge to finish signing into this account."));
        zza.put(17080, (Object)new Pair((Object)"ERROR_API_NOT_AVAILABLE", (Object)"The API that you are calling is not available."));
        zza.put(17081, (Object)new Pair((Object)"ERROR_MISSING_MULTI_FACTOR_SESSION", (Object)"The request is missing proof of first factor successful sign-in."));
        zza.put(17082, (Object)new Pair((Object)"ERROR_MISSING_MULTI_FACTOR_INFO", (Object)"No second factor identifier is provided."));
        zza.put(17083, (Object)new Pair((Object)"ERROR_INVALID_MULTI_FACTOR_SESSION", (Object)"The request does not contain a valid proof of first factor successful sign-in."));
        zza.put(17084, (Object)new Pair((Object)"ERROR_MULTI_FACTOR_INFO_NOT_FOUND", (Object)"The user does not have a second factor matching the identifier provided."));
        zza.put(17085, (Object)new Pair((Object)"ERROR_ADMIN_RESTRICTED_OPERATION", (Object)"This operation is restricted to administrators only."));
        zza.put(17086, (Object)new Pair((Object)"ERROR_UNVERIFIED_EMAIL", (Object)"This operation requires a verified email."));
        zza.put(17087, (Object)new Pair((Object)"ERROR_SECOND_FACTOR_ALREADY_ENROLLED", (Object)"The second factor is already enrolled on this account."));
        zza.put(17088, (Object)new Pair((Object)"ERROR_MAXIMUM_SECOND_FACTOR_COUNT_EXCEEDED", (Object)"The maximum allowed number of second factors on a user has been exceeded."));
        zza.put(17089, (Object)new Pair((Object)"ERROR_UNSUPPORTED_FIRST_FACTOR", (Object)"Enrolling a second factor or signing in with a multi-factor account requires sign-in with a supported first factor."));
        zza.put(17090, (Object)new Pair((Object)"ERROR_EMAIL_CHANGE_NEEDS_VERIFICATION", (Object)"Multi-factor users must always have a verified email."));
        zza.put(17091, (Object)new Pair((Object)"INTERNAL_SUCCESS_SIGN_OUT", (Object)"This is an internal error code indicating that the operation was successful but the user needs to be signed out."));
    }
}

