/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.firebase_auth.zzaz;
import com.google.android.gms.internal.firebase_auth.zzey;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.FirebaseUserMetadata;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.UserInfo;
import com.google.firebase.auth.internal.zzap;
import com.google.firebase.auth.internal.zzaq;
import com.google.firebase.auth.internal.zzj;
import com.google.firebase.auth.internal.zzp;
import com.google.firebase.auth.internal.zzq;
import com.google.firebase.auth.internal.zzr;
import com.google.firebase.auth.zzg;
import com.google.firebase.auth.zzy;
import com.google.firebase.auth.zzz;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@SafeParcelable.Class(creator="DefaultFirebaseUserCreator")
public class zzn
extends FirebaseUser {
    public static final Parcelable.Creator<zzn> CREATOR = new zzq();
    @SafeParcelable.Field(id=1, getter="getCachedTokenState")
    private zzey zza;
    @SafeParcelable.Field(id=2, getter="getDefaultAuthUserInfo")
    private zzj zzb;
    @SafeParcelable.Field(id=3, getter="getFirebaseAppName")
    private String zzc;
    @SafeParcelable.Field(id=4, getter="getUserType")
    private String zzd;
    @SafeParcelable.Field(id=5, getter="getUserInfos")
    private List<zzj> zze;
    @SafeParcelable.Field(id=6, getter="getProviders")
    private List<String> zzf;
    @SafeParcelable.Field(id=7, getter="getCurrentVersion")
    private String zzg;
    @SafeParcelable.Field(id=8, getter="isAnonymous")
    private Boolean zzh;
    @SafeParcelable.Field(id=9, getter="getMetadata")
    private zzp zzi;
    @SafeParcelable.Field(id=10, getter="isNewUser")
    private boolean zzj;
    @SafeParcelable.Field(id=11, getter="getDefaultOAuthCredential")
    private zzg zzk;
    @SafeParcelable.Field(id=12, getter="getMultiFactorInfoList")
    private zzaq zzl;

    @SafeParcelable.Constructor
    zzn(@SafeParcelable.Param(id=1) zzey zzey2, @SafeParcelable.Param(id=2) zzj zzj2, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) String string2, @SafeParcelable.Param(id=5) List<zzj> list, @SafeParcelable.Param(id=6) List<String> list2, @SafeParcelable.Param(id=7) String string3, @SafeParcelable.Param(id=8) Boolean bl, @SafeParcelable.Param(id=9) zzp zzp2, @SafeParcelable.Param(id=10) boolean bl2, @SafeParcelable.Param(id=11) zzg zzg2, @SafeParcelable.Param(id=12) zzaq zzaq2) {
        this.zza = zzey2;
        this.zzb = zzj2;
        this.zzc = string;
        this.zzd = string2;
        this.zze = list;
        this.zzf = list2;
        this.zzg = string3;
        this.zzh = bl;
        this.zzi = zzp2;
        this.zzj = bl2;
        this.zzk = zzg2;
        this.zzl = zzaq2;
    }

    public zzn(FirebaseApp firebaseApp, List<? extends UserInfo> list) {
        Preconditions.checkNotNull((Object)firebaseApp);
        this.zzc = firebaseApp.getName();
        this.zzd = "com.google.firebase.auth.internal.DefaultFirebaseUser";
        this.zzg = "2";
        ((FirebaseUser)this).zza(list);
    }

    @Override
    @Nullable
    public String getDisplayName() {
        return this.zzb.getDisplayName();
    }

    @Override
    @Nullable
    public Uri getPhotoUrl() {
        return this.zzb.getPhotoUrl();
    }

    @Override
    @Nullable
    public String getEmail() {
        return this.zzb.getEmail();
    }

    @Override
    @Nullable
    public String getPhoneNumber() {
        return this.zzb.getPhoneNumber();
    }

    @Override
    @Nullable
    public final String zzd() {
        String string = null;
        if (this.zza != null && this.zza.zzd() != null) {
            Map map = (Map)zzap.zza(this.zza.zzd()).getClaims().get("firebase");
            string = map != null ? (String)map.get("tenant") : null;
        }
        return string;
    }

    public final zzn zza(String string) {
        this.zzg = string;
        return this;
    }

    @Override
    @NonNull
    public String getProviderId() {
        return this.zzb.getProviderId();
    }

    @Override
    @NonNull
    public final FirebaseApp zzc() {
        return FirebaseApp.getInstance((String)this.zzc);
    }

    public final List<zzj> zzi() {
        return this.zze;
    }

    @Override
    @NonNull
    public String getUid() {
        return this.zzb.getUid();
    }

    @Override
    public boolean isAnonymous() {
        if (this.zzh == null || this.zzh.booleanValue()) {
            String string = "";
            if (this.zza != null) {
                GetTokenResult getTokenResult = zzap.zza(this.zza.zzd());
                string = getTokenResult != null ? getTokenResult.getSignInProvider() : "";
            }
            this.zzh = ((FirebaseUser)this).getProviderData().size() <= 1 && (string == null || !string.equals("custom"));
        }
        return this.zzh;
    }

    @Override
    @Nullable
    public final List<String> zza() {
        return this.zzf;
    }

    @Override
    @NonNull
    public final FirebaseUser zza(List<? extends UserInfo> list) {
        Preconditions.checkNotNull(list);
        this.zze = new ArrayList<zzj>(list.size());
        this.zzf = new ArrayList<String>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            UserInfo userInfo = list.get(i);
            if (userInfo.getProviderId().equals("firebase")) {
                this.zzb = (zzj)userInfo;
            } else {
                this.zzf.add(userInfo.getProviderId());
            }
            this.zze.add((zzj)userInfo);
        }
        if (this.zzb == null) {
            this.zzb = this.zze.get(0);
        }
        return this;
    }

    @Override
    @NonNull
    public List<? extends UserInfo> getProviderData() {
        return this.zze;
    }

    @Override
    @NonNull
    public final zzey zze() {
        return this.zza;
    }

    @Override
    @NonNull
    public final String zzg() {
        return ((FirebaseUser)this).zze().zzd();
    }

    @Override
    @NonNull
    public final String zzf() {
        return this.zza.zzh();
    }

    @Override
    public final void zza(zzey zzey2) {
        this.zza = (zzey)Preconditions.checkNotNull((Object)zzey2);
    }

    @Override
    public boolean isEmailVerified() {
        return this.zzb.isEmailVerified();
    }

    public final void zza(zzp zzp2) {
        this.zzi = zzp2;
    }

    @Override
    public FirebaseUserMetadata getMetadata() {
        return this.zzi;
    }

    public final void zza(boolean bl) {
        this.zzj = bl;
    }

    public final boolean zzj() {
        return this.zzj;
    }

    public final void zza(zzg zzg2) {
        this.zzk = zzg2;
    }

    @Nullable
    public final zzg zzk() {
        return this.zzk;
    }

    @Override
    public final void zzb(List<zzy> list) {
        this.zzl = zzaq.zza(list);
    }

    @Nullable
    public final List<zzy> zzl() {
        if (this.zzl != null) {
            return this.zzl.zza();
        }
        return zzaz.zza();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzn zzn2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)1, (Parcelable)((FirebaseUser)zzn2).zze(), (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)zzn2.zzb, (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)zzn2.zzc, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)zzn2.zzd, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)5, zzn2.zze, (boolean)false);
        SafeParcelWriter.writeStringList((Parcel)parcel2, (int)6, ((FirebaseUser)zzn2).zza(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)zzn2.zzg, (boolean)false);
        SafeParcelWriter.writeBooleanObject((Parcel)parcel2, (int)8, (Boolean)((FirebaseUser)zzn2).isAnonymous(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)9, (Parcelable)((FirebaseUser)zzn2).getMetadata(), (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)10, (boolean)zzn2.zzj);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)11, (Parcelable)zzn2.zzk, (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)12, (Parcelable)zzn2.zzl, (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public static FirebaseUser zza(FirebaseApp firebaseApp, FirebaseUser firebaseUser) {
        zzn zzn2 = new zzn(firebaseApp, firebaseUser.getProviderData());
        if (firebaseUser instanceof zzn) {
            zzn zzn3 = (zzn)firebaseUser;
            Object object = zzn3.zzg;
            zzn2.zzg = object;
            object = zzn3.zzd;
            zzn2.zzd = object;
            object = (zzp)((FirebaseUser)zzn3).getMetadata();
            zzn2.zzi = object;
        } else {
            zzn2.zzi = null;
        }
        if (firebaseUser.zze() != null) {
            ((FirebaseUser)zzn2).zza(firebaseUser.zze());
        }
        if (!firebaseUser.isAnonymous()) {
            ((FirebaseUser)zzn2).zzb();
        }
        return zzn2;
    }

    @Override
    public final /* synthetic */ zzz zzh() {
        zzn zzn2 = this;
        return new zzr(zzn2);
    }

    @Override
    public final /* synthetic */ FirebaseUser zzb() {
        zzn zzn2 = this;
        this.zzh = false;
        return zzn2;
    }
}

