/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_auth;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.internal.firebase_auth.zzfe;
import com.google.android.gms.internal.firebase_auth.zzjn;
import com.google.android.gms.internal.firebase_auth.zzjx;
import com.google.android.gms.internal.firebase_auth.zzlv;
import com.google.firebase.auth.api.internal.zzel;
import com.google.firebase.auth.api.zza;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="GetTokenResponseCreator")
public final class zzff
extends AbstractSafeParcelable
implements zzel<zzff, zzlv.zzb> {
    public static final Parcelable.Creator<zzff> CREATOR = new zzfe();
    @SafeParcelable.Field(id=2, getter="getRefreshToken")
    private String zza;
    @SafeParcelable.Field(id=3, getter="getAccessToken")
    private String zzb;
    @SafeParcelable.Field(id=4, getter="getExpiresIn")
    private Long zzc;
    @SafeParcelable.Field(id=5, getter="getTokenType")
    private String zzd;
    @SafeParcelable.Field(id=6, getter="getIssuedAt")
    private Long zze;

    public zzff() {
        this.zze = System.currentTimeMillis();
    }

    public zzff(String string, String string2, Long l, String string3) {
        this(string, string2, l, string3, System.currentTimeMillis());
    }

    @SafeParcelable.Constructor
    zzff(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) Long l, @SafeParcelable.Param(id=5) String string3, @SafeParcelable.Param(id=6) Long l2) {
        this.zza = string;
        this.zzb = string2;
        this.zzc = l;
        this.zzd = string3;
        this.zze = l2;
    }

    public final boolean zzb() {
        long l = this.zze + this.zzc * 1000L;
        return DefaultClock.getInstance().currentTimeMillis() + 300000L < l;
    }

    public final void zza(String string) {
        this.zza = Preconditions.checkNotEmpty((String)string);
    }

    public final String zzc() {
        return this.zza;
    }

    public final String zzd() {
        return this.zzb;
    }

    public final long zze() {
        if (this.zzc == null) {
            return 0L;
        }
        return this.zzc;
    }

    @Nullable
    public final String zzf() {
        return this.zzd;
    }

    public final long zzg() {
        return this.zze;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzff zzff2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)zzff2.zza, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)zzff2.zzb, (boolean)false);
        SafeParcelWriter.writeLongObject((Parcel)parcel2, (int)4, (Long)zzff2.zze(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)zzff2.zzd, (boolean)false);
        SafeParcelWriter.writeLongObject((Parcel)parcel2, (int)6, (Long)zzff2.zze, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @Override
    public final zzjx<zzlv.zzb> zza() {
        return zzlv.zzb.zzf();
    }

    public final String zzh() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("refresh_token", (Object)this.zza);
            jSONObject.put("access_token", (Object)this.zzb);
            jSONObject.put("expires_in", (Object)this.zzc);
            jSONObject.put("token_type", (Object)this.zzd);
            jSONObject.put("issued_at", (Object)this.zze);
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            Log.d((String)"GetTokenResponse", (String)"Failed to convert GetTokenResponse to JSON");
            throw new zza(jSONException);
        }
    }

    public static zzff zzb(String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            zzff zzff2 = new zzff();
            new zzff().zza = jSONObject.optString("refresh_token", null);
            zzff2.zzb = jSONObject.optString("access_token", null);
            zzff2.zzc = jSONObject.optLong("expires_in");
            zzff2.zzd = jSONObject.optString("token_type", null);
            zzff2.zze = jSONObject.optLong("issued_at");
            return zzff2;
        }
        catch (JSONException jSONException) {
            Log.d((String)"GetTokenResponse", (String)"Failed to read GetTokenResponse from JSONObject");
            throw new zza(jSONException);
        }
    }

    @Override
    public final /* synthetic */ zzel zza(zzjn zzjn2) {
        zzjn zzjn3 = zzjn2;
        zzff zzff2 = this;
        if (!(zzjn3 instanceof zzlv.zzb)) {
            throw new IllegalArgumentException("The passed proto must be an instance of GrantTokenResponse.");
        }
        zzlv.zzb zzb2 = (zzlv.zzb)zzjn3;
        zzff2.zza = Strings.emptyToNull((String)zzb2.zze());
        zzff2.zzb = Strings.emptyToNull((String)zzb2.zza());
        zzff2.zzc = zzb2.zzb();
        zzff2.zzd = Strings.emptyToNull((String)zzb2.zzd());
        zzff2.zze = System.currentTimeMillis();
        return zzff2;
    }
}

