/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase_auth.zzbk;
import com.google.android.gms.internal.firebase_auth.zzbl;
import java.util.Set;

public class ActionCodeUrl {
    private final String zza;
    private final String zzb;
    private final String zzc;
    @Nullable
    private final String zzd;
    @Nullable
    private final String zze;
    @Nullable
    private final String zzf;
    private static final zzbl<String, Integer> zzg = new zzbk<String, Integer>().zza("recoverEmail", 2).zza("resetPassword", 0).zza("signIn", 4).zza("verifyEmail", 1).zza("verifyBeforeChangeEmail", 5).zza("revertSecondFactorAddition", 6).zza();

    private ActionCodeUrl(String string) {
        this.zza = ActionCodeUrl.zza(string, "apiKey");
        this.zzb = ActionCodeUrl.zza(string, "oobCode");
        this.zzc = ActionCodeUrl.zza(string, "mode");
        if (this.zza == null || this.zzb == null || this.zzc == null) {
            throw new IllegalArgumentException(String.format("%s, %s and %s are required in a valid action code URL", "apiKey", "oobCode", "mode"));
        }
        this.zzd = ActionCodeUrl.zza(string, "continueUrl");
        this.zze = ActionCodeUrl.zza(string, "languageCode");
        this.zzf = ActionCodeUrl.zza(string, "tenantId");
    }

    @Nullable
    public static ActionCodeUrl parseLink(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        try {
            return new ActionCodeUrl(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @NonNull
    public String getApiKey() {
        return this.zza;
    }

    public int getOperation() {
        return zzg.getOrDefault(this.zzc, 3);
    }

    @NonNull
    public String getCode() {
        return this.zzb;
    }

    @Nullable
    public String getContinueUrl() {
        return this.zzd;
    }

    @Nullable
    public String getLanguageCode() {
        return this.zze;
    }

    @Nullable
    public final String zza() {
        return this.zzf;
    }

    private static String zza(String string, String string2) {
        Uri uri = Uri.parse((String)string);
        try {
            Set set = uri.getQueryParameterNames();
            if (set.contains(string2)) {
                return uri.getQueryParameter(string2);
            }
            if (set.contains("link")) {
                return Uri.parse((String)uri.getQueryParameter("link")).getQueryParameter(string2);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        return null;
    }
}

