/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.FederatedAuthProvider;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.internal.FederatedSignInActivity;
import com.google.firebase.auth.internal.zzax;
import com.google.firebase.auth.zzc;
import com.google.firebase.auth.zzv;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class OAuthProvider
extends FederatedAuthProvider {
    private final Bundle zza;

    private OAuthProvider(Bundle bundle) {
        this.zza = bundle;
    }

    @NonNull
    public static Builder newBuilder(@NonNull String string) {
        return OAuthProvider.newBuilder(string, FirebaseAuth.getInstance());
    }

    @NonNull
    public static Builder newBuilder(@NonNull String string, @NonNull FirebaseAuth firebaseAuth) {
        GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
        FirebaseAuth firebaseAuth2 = firebaseAuth;
        String string2 = string;
        Preconditions.checkNotEmpty((String)string2);
        Preconditions.checkNotNull((Object)firebaseAuth2);
        if ("facebook.com".equals(string2)) {
            throw new IllegalArgumentException("Sign in with Facebook is not supported via this method; the Facebook TOS dictate that you must use the Facebook Android SDK for Facebook login.");
        }
        return new Builder(string2, firebaseAuth2, googleApiAvailability, null);
    }

    @Nullable
    public String getProviderId() {
        if (this.zza == null) {
            return null;
        }
        return this.zza.getString("com.google.firebase.auth.KEY_PROVIDER_ID", null);
    }

    @Override
    public final void zza(Activity activity) {
        zzax.zza();
        zzax.zzb();
        Intent intent = new Intent("com.google.firebase.auth.internal.SIGN_IN");
        intent.setClass((Context)activity, FederatedSignInActivity.class);
        intent.setPackage(activity.getPackageName());
        intent.putExtras(this.zza);
        activity.startActivity(intent);
    }

    @Override
    public final void zzb(Activity activity) {
        zzax.zza();
        zzax.zzb();
        Intent intent = new Intent("com.google.firebase.auth.internal.LINK");
        intent.setClass((Context)activity, FederatedSignInActivity.class);
        intent.setPackage(activity.getPackageName());
        intent.putExtras(this.zza);
        activity.startActivity(intent);
    }

    @Override
    public final void zzc(Activity activity) {
        zzax.zza();
        zzax.zzb();
        Intent intent = new Intent("com.google.firebase.auth.internal.REAUTHENTICATE");
        intent.setClass((Context)activity, FederatedSignInActivity.class);
        intent.setPackage(activity.getPackageName());
        intent.putExtras(this.zza);
        activity.startActivity(intent);
    }

    @NonNull
    public static CredentialBuilder newCredentialBuilder(@NonNull String string) {
        return new CredentialBuilder(Preconditions.checkNotEmpty((String)string), null);
    }

    @Deprecated
    @NonNull
    public static AuthCredential getCredential(@NonNull String string, @NonNull String string2, @NonNull String string3) {
        return zzc.zza(string, string2, string3);
    }

    /* synthetic */ OAuthProvider(Bundle bundle, zzv zzv2) {
        this(bundle);
    }

    public static class CredentialBuilder {
        private final String zza;
        @Nullable
        private String zzb;
        @Nullable
        private String zzc;
        @Nullable
        private String zzd;

        private CredentialBuilder(String string) {
            this.zza = string;
        }

        @KeepForSdk
        public String getIdToken() {
            return this.zzb;
        }

        @NonNull
        public CredentialBuilder setIdToken(@NonNull String string) {
            this.zzb = string;
            return this;
        }

        @NonNull
        public CredentialBuilder setIdTokenWithRawNonce(@NonNull String string, @Nullable String string2) {
            this.zzb = string;
            this.zzd = string2;
            return this;
        }

        @KeepForSdk
        public String getAccessToken() {
            return this.zzc;
        }

        @NonNull
        public CredentialBuilder setAccessToken(@NonNull String string) {
            this.zzc = string;
            return this;
        }

        @NonNull
        public AuthCredential build() {
            return com.google.firebase.auth.zzc.zza(this.zza, this.zzb, this.zzc, this.zzd);
        }

        /* synthetic */ CredentialBuilder(String string, zzv zzv2) {
            this(string);
        }
    }

    public static class Builder {
        private final FirebaseAuth zza;
        @VisibleForTesting
        private final Bundle zzb = new Bundle();
        private final Bundle zzc = new Bundle();

        private Builder(String string, FirebaseAuth firebaseAuth, GoogleApiAvailability googleApiAvailability) {
            this.zza = firebaseAuth;
            this.zzb.putString("com.google.firebase.auth.KEY_API_KEY", this.zza.zzb().getOptions().getApiKey());
            this.zzb.putString("com.google.firebase.auth.KEY_PROVIDER_ID", string);
            this.zzb.putBundle("com.google.firebase.auth.KEY_PROVIDER_CUSTOM_PARAMS", this.zzc);
            zzax.zza();
            zzax.zzb();
            this.zzb.putString("com.google.firebase.auth.internal.CLIENT_VERSION", Integer.toString(googleApiAvailability.getClientVersion(this.zza.zzb().getApplicationContext())));
            this.zzb.putString("com.google.firebase.auth.KEY_TENANT_ID", this.zza.zzc());
        }

        @KeepForSdk
        @NonNull
        public List<String> getScopes() {
            ArrayList arrayList = this.zzb.getStringArrayList("com.google.firebase.auth.KEY_PROVIDER_SCOPES");
            if (arrayList != null) {
                return arrayList;
            }
            return Collections.emptyList();
        }

        @NonNull
        public Builder setScopes(@NonNull List<String> list) {
            this.zzb.putStringArrayList("com.google.firebase.auth.KEY_PROVIDER_SCOPES", new ArrayList<String>(list));
            return this;
        }

        @NonNull
        public Builder addCustomParameter(@NonNull String string, @NonNull String string2) {
            this.zzc.putString(string, string2);
            return this;
        }

        @NonNull
        public Builder addCustomParameters(@NonNull Map<String, String> map) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.zzc.putString(entry.getKey(), entry.getValue());
            }
            return this;
        }

        @NonNull
        public OAuthProvider build() {
            return new OAuthProvider(this.zzb, null);
        }

        /* synthetic */ Builder(String string, FirebaseAuth firebaseAuth, GoogleApiAvailability googleApiAvailability, zzv zzv2) {
            this(string, firebaseAuth, googleApiAvailability);
        }
    }
}

