/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.logging.Logger;
import com.google.android.gms.internal.firebase_auth.zzff;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.MultiFactor;
import com.google.firebase.auth.MultiFactorInfo;
import com.google.firebase.auth.PhoneMultiFactorInfo;
import com.google.firebase.auth.api.zza;
import com.google.firebase.auth.internal.zzj;
import com.google.firebase.auth.internal.zzn;
import com.google.firebase.auth.internal.zzp;
import com.google.firebase.auth.internal.zzr;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzaw {
    private Context zza;
    private String zzb;
    private SharedPreferences zzc;
    private Logger zzd;

    public zzaw(Context context, String string) {
        Preconditions.checkNotNull((Object)context);
        this.zzb = Preconditions.checkNotEmpty((String)string);
        this.zza = context.getApplicationContext();
        String string2 = String.format("com.google.firebase.auth.api.Store.%s", this.zzb);
        this.zzc = this.zza.getSharedPreferences(string2, 0);
        this.zzd = new Logger("StorageHelpers", new String[0]);
    }

    public final void zza(FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)firebaseUser);
        String string = this.zzc(firebaseUser);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            String string2 = string;
            String string3 = "com.google.firebase.auth.FIREBASE_USER";
            this.zzc.edit().putString(string3, string2).apply();
        }
    }

    @Nullable
    public final FirebaseUser zza() {
        String string = "com.google.firebase.auth.FIREBASE_USER";
        String string2 = this.zzc.getString(string, null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        try {
            String string3;
            JSONObject jSONObject = new JSONObject(string2);
            if (jSONObject.has("type") && "com.google.firebase.auth.internal.DefaultFirebaseUser".equalsIgnoreCase(string3 = jSONObject.optString("type"))) {
                return this.zza(jSONObject);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public final void zza(FirebaseUser firebaseUser, zzff zzff2) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)zzff2);
        this.zzc.edit().putString(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()), zzff2.zzh()).apply();
    }

    public final zzff zzb(FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)firebaseUser);
        String string = this.zzc.getString(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()), null);
        if (string != null) {
            return zzff.zzb(string);
        }
        return null;
    }

    public final void zza(String string) {
        this.zzc.edit().remove(string).apply();
    }

    @Nullable
    private final String zzc(FirebaseUser firebaseUser) {
        JSONObject jSONObject = new JSONObject();
        if (zzn.class.isAssignableFrom(firebaseUser.getClass())) {
            zzn zzn2 = (zzn)firebaseUser;
            try {
                int n;
                JSONArray jSONArray;
                Object object;
                jSONObject.put("cachedTokenState", (Object)((FirebaseUser)zzn2).zzf());
                jSONObject.put("applicationName", (Object)((FirebaseUser)zzn2).zzc().getName());
                jSONObject.put("type", (Object)"com.google.firebase.auth.internal.DefaultFirebaseUser");
                if (zzn2.zzh() != null) {
                    object = new JSONArray();
                    jSONArray = zzn2.zzh();
                    for (n = 0; n < jSONArray.size(); ++n) {
                        zzj zzj2 = jSONArray.get(n);
                        object.put((Object)zzj2.zzb());
                    }
                    jSONObject.put("userInfos", object);
                }
                jSONObject.put("anonymous", ((FirebaseUser)zzn2).isAnonymous());
                jSONObject.put("version", (Object)"2");
                if (((FirebaseUser)zzn2).getMetadata() != null) {
                    jSONObject.put("userMetadata", (Object)((zzp)((FirebaseUser)zzn2).getMetadata()).zza());
                }
                if ((object = ((MultiFactor)((zzr)((FirebaseUser)zzn2).getMultiFactor())).getEnrolledFactors()) != null && !object.isEmpty()) {
                    jSONArray = new JSONArray();
                    for (n = 0; n < object.size(); ++n) {
                        jSONArray.put((Object)((MultiFactorInfo)((Object)object.get(n))).toJson());
                    }
                    jSONObject.put("userMultiFactorInfo", (Object)jSONArray);
                }
                return jSONObject.toString();
            }
            catch (Exception exception) {
                this.zzd.wtf("Failed to turn object into JSON", (Throwable)exception, new Object[0]);
                throw new zza(exception);
            }
        }
        return null;
    }

    private final zzn zza(JSONObject jSONObject) {
        try {
            Object object;
            zzff zzff2;
            String string = jSONObject.getString("cachedTokenState");
            String string2 = jSONObject.getString("applicationName");
            boolean bl = jSONObject.getBoolean("anonymous");
            String string3 = "2";
            String string4 = jSONObject.getString("version");
            if (string4 != null) {
                string3 = string4;
            }
            JSONArray jSONArray = jSONObject.getJSONArray("userInfos");
            int n = jSONArray.length();
            ArrayList<zzj> arrayList = new ArrayList<zzj>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(zzj.zza(jSONArray.getString(i)));
            }
            FirebaseApp firebaseApp = FirebaseApp.getInstance((String)string2);
            zzn zzn2 = new zzn(firebaseApp, arrayList);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                zzff2 = zzff.zzb(string);
                ((FirebaseUser)zzn2).zza(zzff2);
            }
            if (!bl) {
                ((FirebaseUser)zzn2).zzb();
            }
            zzn2.zza(string3);
            if (jSONObject.has("userMetadata") && (object = zzp.zza(jSONObject.getJSONObject("userMetadata"))) != null) {
                zzn2.zza((zzp)object);
            }
            if (jSONObject.has("userMultiFactorInfo") && (zzff2 = jSONObject.getJSONArray("userMultiFactorInfo")) != null) {
                object = new ArrayList();
                for (int i = 0; i < zzff2.length(); ++i) {
                    String string5 = zzff2.getString(i);
                    JSONObject jSONObject2 = new JSONObject(string5);
                    String string6 = jSONObject2.optString("factorIdKey");
                    object.add("phone".equals(string6) ? PhoneMultiFactorInfo.zza(jSONObject2) : null);
                }
                ((FirebaseUser)zzn2).zzb((List<MultiFactorInfo>)object);
            }
            return zzn2;
        }
        catch (zza | ArrayIndexOutOfBoundsException | IllegalArgumentException | JSONException throwable) {
            this.zzd.wtf(throwable);
            return null;
        }
    }
}

