/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.firebase_auth.zzej;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.MultiFactorAssertion;
import com.google.firebase.auth.MultiFactorInfo;
import com.google.firebase.auth.MultiFactorResolver;
import com.google.firebase.auth.MultiFactorSession;
import com.google.firebase.auth.PhoneMultiFactorInfo;
import com.google.firebase.auth.internal.zzn;
import com.google.firebase.auth.internal.zzv;
import com.google.firebase.auth.internal.zzw;
import com.google.firebase.auth.internal.zzy;
import com.google.firebase.auth.zzc;
import java.util.ArrayList;
import java.util.List;

@SafeParcelable.Class(creator="DefaultMultiFactorResolverCreator")
public final class zzt
extends MultiFactorResolver {
    public static final Parcelable.Creator<zzt> CREATOR = new zzv();
    @SafeParcelable.Field(id=1, getter="getPhoneMultiFactorInfoList")
    private final List<PhoneMultiFactorInfo> zza = new ArrayList<PhoneMultiFactorInfo>();
    @SafeParcelable.Field(id=2, getter="getSession")
    private final zzy zzb;
    @SafeParcelable.Field(id=3, getter="getFirebaseAppName")
    private final String zzc;
    @SafeParcelable.Field(id=4, getter="getDefaultOAuthCredential")
    private final zzc zzd;
    @SafeParcelable.Field(id=5, getter="getReauthUser")
    private final zzn zze;

    @SafeParcelable.Constructor
    public zzt(@SafeParcelable.Param(id=1) List<PhoneMultiFactorInfo> list, @SafeParcelable.Param(id=2) zzy zzy2, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) @Nullable zzc zzc2, @SafeParcelable.Param(id=5) @Nullable zzn zzn2) {
        for (MultiFactorInfo multiFactorInfo : list) {
            if (!(multiFactorInfo instanceof PhoneMultiFactorInfo)) continue;
            this.zza.add((PhoneMultiFactorInfo)multiFactorInfo);
        }
        this.zzb = (zzy)((Object)Preconditions.checkNotNull((Object)((Object)zzy2)));
        this.zzc = Preconditions.checkNotEmpty((String)string);
        this.zzd = zzc2;
        this.zze = zzn2;
    }

    public static zzt zza(zzej zzej2, FirebaseAuth firebaseAuth, @Nullable FirebaseUser firebaseUser) {
        List<MultiFactorInfo> list = zzej2.zzc();
        ArrayList<PhoneMultiFactorInfo> arrayList = new ArrayList<PhoneMultiFactorInfo>();
        for (MultiFactorInfo multiFactorInfo : list) {
            if (!(multiFactorInfo instanceof PhoneMultiFactorInfo)) continue;
            arrayList.add((PhoneMultiFactorInfo)multiFactorInfo);
        }
        ArrayList<PhoneMultiFactorInfo> arrayList2 = arrayList;
        zzy zzy2 = zzy.zza(zzej2.zzc(), zzej2.zza());
        return new zzt(arrayList2, zzy2, firebaseAuth.zzb().getName(), zzej2.zzb(), (zzn)firebaseUser);
    }

    @Override
    public final MultiFactorSession getSession() {
        return this.zzb;
    }

    @Override
    public final List<MultiFactorInfo> getHints() {
        ArrayList<MultiFactorInfo> arrayList = new ArrayList<MultiFactorInfo>();
        for (PhoneMultiFactorInfo phoneMultiFactorInfo : this.zza) {
            arrayList.add(phoneMultiFactorInfo);
        }
        return arrayList;
    }

    @Override
    public final Task<AuthResult> resolveSignIn(MultiFactorAssertion multiFactorAssertion) {
        return ((MultiFactorResolver)this).getFirebaseAuth().zza(multiFactorAssertion, this.zzb, (FirebaseUser)this.zze).continueWithTask((Continuation)new zzw(this));
    }

    @Override
    public final FirebaseAuth getFirebaseAuth() {
        return FirebaseAuth.getInstance(FirebaseApp.getInstance((String)this.zzc));
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzt zzt2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)1, zzt2.zza, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)((MultiFactorResolver)zzt2).getSession(), (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)zzt2.zzc, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)4, (Parcelable)zzt2.zzd, (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)5, (Parcelable)zzt2.zze, (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    static /* synthetic */ zzc zza(zzt zzt2) {
        return zzt2.zzd;
    }
}

