/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.internal.firebase-auth-api.zzll;
import com.google.android.gms.internal.firebase-auth-api.zzuj;
import com.google.android.gms.internal.firebase-auth-api.zzwr;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="GetTokenResponseCreator")
public final class zzwq
extends AbstractSafeParcelable
implements zzuj<zzwq> {
    private static final String zza;
    public static final Parcelable.Creator<zzwq> CREATOR;
    @SafeParcelable.Field(id=2, getter="getRefreshToken")
    private String zzb;
    @SafeParcelable.Field(id=3, getter="getAccessToken")
    private String zzc;
    @SafeParcelable.Field(id=4, getter="getExpiresIn")
    private Long zzd;
    @SafeParcelable.Field(id=5, getter="getTokenType")
    private String zze;
    @SafeParcelable.Field(id=6, getter="getIssuedAt")
    private Long zzf;

    public final long zzb() {
        Long l = ((zzwq)((Object)l)).zzd;
        if (l == null) {
            return 0L;
        }
        return l;
    }

    public final long zzc() {
        return this.zzf;
    }

    public static zzwq zzd(String object) {
        try {
            JSONObject jSONObject = new JSONObject((String)object);
            object = new zzwq();
            ((zzwq)object).zzb = jSONObject.optString("refresh_token", null);
            ((zzwq)object).zzc = jSONObject.optString("access_token", null);
            ((zzwq)object).zzd = jSONObject.optLong("expires_in");
            ((zzwq)object).zze = jSONObject.optString("token_type", null);
            ((zzwq)object).zzf = jSONObject.optLong("issued_at");
        }
        catch (JSONException jSONException) {
            Log.d((String)zza, (String)"Failed to read GetTokenResponse from JSONObject");
            zzll zzll2 = new zzll(jSONException);
            throw zzll2;
        }
        return object;
    }

    public final String zze() {
        return this.zzc;
    }

    public final String zzf() {
        return this.zzb;
    }

    @Nullable
    public final String zzg() {
        return this.zze;
    }

    public final String zzh() {
        Object object = new JSONObject();
        try {
            object.put("refresh_token", (Object)((zzwq)((Object)string)).zzb);
            object.put("access_token", (Object)((zzwq)((Object)string)).zzc);
            object.put("expires_in", (Object)((zzwq)((Object)string)).zzd);
            object.put("token_type", (Object)((zzwq)((Object)string)).zze);
            object.put("issued_at", (Object)((zzwq)((Object)string)).zzf);
            String string = object.toString();
        }
        catch (JSONException jSONException) {
            Log.d((String)zza, (String)"Failed to convert GetTokenResponse to JSON");
            object = new zzll(jSONException);
            throw object;
        }
        return string;
    }

    static {
        zzwr zzwr2;
        zza = zzwq.class.getSimpleName();
        CREATOR = zzwr2 = new zzwr();
    }

    public zzwq() {
        this.zzf = System.currentTimeMillis();
    }

    public zzwq(String string, String string2, Long l, String string3) {
        this(string, string2, l, string3, System.currentTimeMillis());
    }

    @SafeParcelable.Constructor
    zzwq(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) Long l, @SafeParcelable.Param(id=5) String string3, @SafeParcelable.Param(id=6) Long l2) {
        this.zzb = string;
        this.zzc = string2;
        this.zzd = l;
        this.zze = string3;
        this.zzf = l2;
    }

    public final void zzi(String string) {
        this.zzb = Preconditions.checkNotEmpty((String)string);
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeString((Parcel)parcel, (int)2, (String)this.zzb, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)3, (String)this.zzc, (boolean)false);
        SafeParcelWriter.writeLongObject((Parcel)parcel, (int)4, (Long)this.zzb(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)5, (String)this.zze, (boolean)false);
        SafeParcelWriter.writeLongObject((Parcel)parcel, (int)6, (Long)this.zzf, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n);
    }

    public final boolean zzj() {
        Long l = ((zzwq)((Object)l3)).zzf;
        long l2 = l;
        Long l3 = ((zzwq)((Object)l3)).zzd;
        long l4 = l3;
        return DefaultClock.getInstance().currentTimeMillis() + 300000L < l2 + l4 * 1000L;
    }
}

