/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzdm;
import com.google.android.gms.internal.firebase-auth-api.zzdr;
import com.google.android.gms.internal.firebase-auth-api.zzdu;
import com.google.android.gms.internal.firebase-auth-api.zzmj;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import javax.crypto.AEADBadTagException;

abstract class zzdo {
    private final zzdm zza;
    private final zzdm zzb;

    abstract zzdm zza(byte[] var1, int var2) throws InvalidKeyException;

    public zzdo(byte[] byArray) throws GeneralSecurityException {
        if (!zzdu.zza(1)) {
            Object object = new GeneralSecurityException("Can not use ChaCha20Poly1305 in FIPS-mode.");
            throw object;
        }
        ((zzdo)object).zza = ((zzdo)object).zza(byArray, 1);
        ((zzdo)object).zzb = ((zzdo)object).zza(byArray, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final byte[] zzb(ByteBuffer object, byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        Object object2;
        if (((Buffer)object).remaining() < 16) {
            object2 = new GeneralSecurityException("ciphertext too short");
            throw object2;
        }
        int n = ((Buffer)object).position();
        byte[] byArray3 = new byte[16];
        ((ByteBuffer)object).position(((Buffer)object).limit() + -16);
        ((ByteBuffer)object).get(byArray3);
        ((ByteBuffer)object).position(n);
        ((ByteBuffer)object).limit(((Buffer)object).limit() + -16);
        try {
            Object object3 = ((zzdo)object2).zzb;
            object3 = ((zzdm)object3).zzc(byArray, 0);
            byte[] byArray4 = new byte[32];
            ((ByteBuffer)object3).get(byArray4);
            int n2 = ((Buffer)object).remaining();
            int n3 = n2 % 16;
            n3 = n3 == 0 ? n2 : n2 + 16 - n3;
            ByteBuffer byteBuffer = ByteBuffer.allocate(n3 + 16).order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.put(byArray2);
            byteBuffer.position(0);
            byteBuffer.put((ByteBuffer)object);
            byteBuffer.position(n3);
            byteBuffer.putLong(0L);
            byteBuffer.putLong(n2);
            byArray2 = byteBuffer.array();
            boolean bl = zzmj.zzb(zzdr.zza(byArray4, byArray2), byArray3);
            if (!bl) {
                object2 = new GeneralSecurityException("invalid MAC");
                throw object2;
            }
            ((ByteBuffer)object).position(n);
            return ((zzdo)object2).zza.zzd(byArray, (ByteBuffer)object);
        }
        catch (GeneralSecurityException generalSecurityException) {
            object = new AEADBadTagException(generalSecurityException.toString());
            throw object;
        }
    }

    public final byte[] zzc(byte[] byArray, byte[] byArray2, byte[] byArray3) throws GeneralSecurityException {
        return this.zzb(ByteBuffer.wrap(byArray2), byArray, byArray3);
    }
}

