/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.content.Context;
import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Log;
import com.google.android.gms.internal.firebase-auth-api.zzaaf;
import com.google.android.gms.internal.firebase-auth-api.zzap;
import com.google.android.gms.internal.firebase-auth-api.zzar;
import com.google.android.gms.internal.firebase-auth-api.zzbe;
import com.google.android.gms.internal.firebase-auth-api.zzbg;
import com.google.android.gms.internal.firebase-auth-api.zzbh;
import com.google.android.gms.internal.firebase-auth-api.zzbi;
import com.google.android.gms.internal.firebase-auth-api.zzfh;
import com.google.android.gms.internal.firebase-auth-api.zzfj;
import com.google.android.gms.internal.firebase-auth-api.zzfk;
import com.google.android.gms.internal.firebase-auth-api.zzfl;
import com.google.android.gms.internal.firebase-auth-api.zzkq;
import com.google.android.gms.internal.firebase-auth-api.zznm;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.annotation.concurrent.GuardedBy;
import javax.crypto.KeyGenerator;

public final class zzff {
    private zzbi zza = null;
    private String zzb = null;
    private zzap zzc = null;
    private zzbe zzd = null;
    @GuardedBy(value="this")
    private zzbh zze;
    private zzfk zzf = null;

    static /* bridge */ /* synthetic */ zzap zza(zzff zzff2) {
        return zzff2.zzc;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final zzap zzh() throws GeneralSecurityException {
        Object[] objectArray;
        if (Build.VERSION.SDK_INT < 23) {
            Log.w((String)zzfh.zzb(), (String)"Android Keystore requires at least Android M");
            return null;
        }
        Object[] objectArray2 = new zzfj();
        boolean bl = objectArray2.zzc(((zzff)object).zzb);
        if (!bl) {
            objectArray = ((zzff)object).zzb;
            zzfj zzfj2 = new zzfj();
            boolean bl2 = zzfj2.zzc((String)objectArray);
            if (bl2) {
                objectArray2 = new Object[]{objectArray};
                Object object = new IllegalArgumentException(String.format("cannot generate a new key %s because it already exists; please delete it with deleteKey() and try again", objectArray2));
                throw object;
            }
            objectArray = zznm.zza("android-keystore://", (String)objectArray);
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", "AndroidKeyStore");
            String[] stringArray = new KeyGenParameterSpec.Builder((String)objectArray, 3);
            objectArray = stringArray.setKeySize(256);
            stringArray = new String[]{"GCM"};
            objectArray = objectArray.setBlockModes(stringArray);
            stringArray = new String[]{"NoPadding"};
            keyGenerator.init((AlgorithmParameterSpec)objectArray.setEncryptionPaddings(stringArray).build());
            keyGenerator.generateKey();
        }
        return objectArray2.zza(((zzff)object).zzb);
        catch (GeneralSecurityException | ProviderException exception) {
            Log.w((String)zzfh.zzb(), (String)"cannot use Android Keystore, it'll be disabled", (Throwable)exception);
            return null;
        }
        catch (GeneralSecurityException | ProviderException exception) {
            if (bl) {
                objectArray = new Object[]{((zzff)object).zzb};
                KeyStoreException keyStoreException = new KeyStoreException(String.format("the master key %s exists but is unusable", objectArray), exception);
                throw keyStoreException;
            }
            Log.w((String)zzfh.zzb(), (String)"cannot use Android Keystore, it'll be disabled", (Throwable)exception);
            return null;
        }
    }

    static /* bridge */ /* synthetic */ zzbh zzb(zzff zzff2) {
        return zzff2.zze;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final zzbh zzi() throws GeneralSecurityException, IOException {
        zzap zzap2 = this.zzc;
        if (zzap2 == null) return zzbh.zzf(zzar.zzb(this.zzf));
        try {
            zzfk zzfk2 = this.zzf;
            return zzbh.zzf(zzbg.zzh(zzfk2, zzap2));
        }
        catch (zzaaf | GeneralSecurityException exception) {
            Log.w((String)zzfh.zzb(), (String)"cannot decrypt keyset: ", (Throwable)exception);
            return zzbh.zzf(zzar.zzb(this.zzf));
        }
    }

    static /* bridge */ /* synthetic */ zzbi zzc(zzff zzff2) {
        return zzff2.zza;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Deprecated
    public final zzff zzd(zzkq zzkq2) {
        String string = zzkq2.zze();
        byte[] byArray = zzkq2.zzd().zzt();
        int n = zzkq2.zzh();
        switch (n + -2) {
            case 1: {
                n = 1;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            default: {
                Object object = new IllegalArgumentException("Unknown output prefix type");
                throw object;
            }
            case 2: {
                n = 2;
            }
        }
        ((zzff)object).zzd = zzbe.zze(string, byArray, n);
        return object;
    }

    public final zzff zze(String string) {
        if (!string.startsWith("android-keystore://")) {
            Object object = new IllegalArgumentException("key URI must start with android-keystore://");
            throw object;
        }
        ((zzff)object).zzb = string;
        return object;
    }

    public final zzff zzf(Context context, String string, String string2) throws IOException {
        if (context == null) {
            Object object = new IllegalArgumentException("need an Android context");
            throw object;
        }
        string = "GenericIdpKeyset";
        Object object = new zzfk(context, string, string2);
        ((zzff)object).zzf = object;
        ((zzff)object).zza = object = new zzfl(context, string, string2);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final synchronized zzfh zzg() throws GeneralSecurityException, IOException {
        Object object;
        if (((zzff)object2).zzb != null) {
            ((zzff)object2).zzc = ((zzff)object2).zzh();
        }
        try {
            object = ((zzff)object2).zzi();
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Log.isLoggable((String)zzfh.zzb(), (int)4)) {
                String string = zzfh.zzb();
                Object[] objectArray = new Object[]{fileNotFoundException.getMessage()};
                Log.i((String)string, (String)String.format("keyset not found, will generate a new one. %s", objectArray));
            }
            if (((zzff)object2).zzd == null) {
                Object object2 = new GeneralSecurityException("cannot read or generate keyset");
                throw object2;
            }
            object = zzbh.zze();
            ((zzbh)object).zzc(((zzff)object2).zzd);
            ((zzbh)object).zzd(((zzbh)object).zzb().zzd().zzb(0).zza());
            if (((zzff)object2).zzc != null) {
                ((zzbh)object).zzb().zzf(((zzff)object2).zza, ((zzff)object2).zzc);
            }
            zzar.zza(((zzbh)object).zzb(), ((zzff)object2).zza);
        }
        ((zzff)object2).zze = object;
        return new zzfh((zzff)object2, null);
    }
}

