/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.util.Log;
import com.google.android.gms.internal.firebase-auth-api.zzap;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.ProviderException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;

public final class zzfi
implements zzap {
    private static final String zza = zzfi.class.getSimpleName();
    private final SecretKey zzb;

    zzfi(String string, KeyStore keyStore) throws GeneralSecurityException {
        ((zzfi)object).zzb = (SecretKey)keyStore.getKey(string, null);
        if (((zzfi)object).zzb == null) {
            Object object = new InvalidKeyException("Keystore cannot load the key with ID: ".concat(String.valueOf(string)));
            throw object;
        }
    }

    private static void zzc() {
        int n = (int)(Math.random() * 100.0);
        try {
            Thread.sleep(n);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    @Override
    public final byte[] zza(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        try {
            byte[] byArray3 = this.zzd(byArray, byArray2);
            return byArray3;
        }
        catch (GeneralSecurityException | ProviderException exception) {
            Log.w((String)zza, (String)"encountered a potentially transient KeyStore error, will wait and retry", (Throwable)exception);
            zzfi.zzc();
            return this.zzd(byArray, byArray2);
        }
    }

    private final byte[] zzd(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        int n = byArray.length;
        if (n < 28) {
            Object object = new GeneralSecurityException("ciphertext too short");
            throw object;
        }
        GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(128, byArray, 0, 12);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(2, (Key)((zzfi)object).zzb, gCMParameterSpec);
        cipher.updateAAD(byArray2);
        return cipher.doFinal(byArray, 12, n + -12);
    }

    @Override
    public final byte[] zzb(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        try {
            byte[] byArray3 = this.zze(byArray, byArray2);
            return byArray3;
        }
        catch (GeneralSecurityException | ProviderException exception) {
            Log.w((String)zza, (String)"encountered a potentially transient KeyStore error, will wait and retry", (Throwable)exception);
            zzfi.zzc();
            return this.zze(byArray, byArray2);
        }
    }

    private final byte[] zze(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        int n = byArray.length;
        if (n > 2147483619) {
            Object object = new GeneralSecurityException("plaintext too long");
            throw object;
        }
        byte[] byArray3 = new byte[n + 28];
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(1, ((zzfi)object).zzb);
        cipher.updateAAD(byArray2);
        cipher.doFinal(byArray, 0, n, byArray3, 12);
        System.arraycopy(cipher.getIV(), 0, byArray3, 0, 12);
        return byArray3;
    }
}

