/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzap;
import com.google.android.gms.internal.firebase-auth-api.zzdu;
import com.google.android.gms.internal.firebase-auth-api.zzmd;
import com.google.android.gms.internal.firebase-auth-api.zzme;
import com.google.android.gms.internal.firebase-auth-api.zznm;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class zzmf
implements zzap {
    private static final ThreadLocal zza;
    private static final ThreadLocal zzb;
    private final byte[] zzc;
    private final byte[] zzd;
    private final SecretKeySpec zze;
    private final int zzf;

    static {
        ThreadLocal threadLocal = new zzmd();
        zza = threadLocal;
        threadLocal = new zzme();
        zzb = threadLocal;
    }

    public zzmf(byte[] object, int n) throws GeneralSecurityException {
        SecretKeySpec secretKeySpec;
        Object object2;
        if (!zzdu.zza(1)) {
            object2 = new GeneralSecurityException("Can not use AES-EAX in FIPS-mode.");
            throw object2;
        }
        if (n != 12 && n != 16) {
            object2 = new IllegalArgumentException("IV size should be either 12 or 16 bytes");
            throw object2;
        }
        ((zzmf)object2).zzf = n;
        zznm.zzb(((byte[])object).length);
        ((zzmf)object2).zze = secretKeySpec = new SecretKeySpec((byte[])object, "AES");
        object = (Cipher)zza.get();
        ((Cipher)object).init(1, ((zzmf)object2).zze);
        ((zzmf)object2).zzc = zzmf.zzc(((Cipher)object).doFinal(new byte[16]));
        ((zzmf)object2).zzd = zzmf.zzc(((zzmf)object2).zzc);
    }

    @Override
    public final byte[] zza(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        Object object;
        int n = byArray.length;
        int n2 = n - ((zzmf)object).zzf + -16;
        if (n2 < 0) {
            object = new GeneralSecurityException("ciphertext too short");
            throw object;
        }
        Object object2 = (Cipher)zza.get();
        ((Cipher)object2).init(1, ((zzmf)object).zze);
        byte[] byArray3 = super.zzd((Cipher)object2, 0, byArray, 0, ((zzmf)object).zzf);
        byte[] byArray4 = super.zzd((Cipher)object2, 1, byArray2, 0, 0);
        object2 = super.zzd((Cipher)object2, 2, byArray, ((zzmf)object).zzf, n2);
        int n3 = n + -16;
        int n4 = 0;
        for (n = 0; n < 16; ++n) {
            n4 = (byte)(n4 | byArray[n3 + n] ^ byArray4[n] ^ byArray3[n] ^ object2[n]);
        }
        if (n4 != 0) {
            object = new AEADBadTagException("tag mismatch");
            throw object;
        }
        Cipher cipher = (Cipher)zzb.get();
        SecretKeySpec secretKeySpec = ((zzmf)object).zze;
        object2 = new IvParameterSpec(byArray3);
        cipher.init(1, (Key)secretKeySpec, (AlgorithmParameterSpec)object2);
        return cipher.doFinal(byArray, ((zzmf)object).zzf, n2);
    }

    @Override
    public final byte[] zzb(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        throw null;
    }

    private static byte[] zzc(byte[] byArray) {
        byte[] byArray2 = new byte[16];
        int n = 0;
        while (n < 15) {
            byte by = byArray[n];
            int n2 = n + 1;
            byArray2[n] = (byte)((by + by ^ (byArray[n2] & 0xFF) >>> 7) & 0xFF);
            n = n2;
        }
        n = byArray[15];
        byArray2[15] = (byte)(n + n ^ byArray[0] >> 7 & 0x87);
        return byArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final byte[] zzd(Cipher cipher, int n, byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        Object object;
        byte[] byArray2 = new byte[16];
        byArray2[15] = (byte)n;
        if (n3 == 0) {
            return cipher.doFinal(zzmf.zze(byArray2, ((zzmf)object).zzc));
        }
        byte[] byArray3 = cipher.doFinal(byArray2);
        int n4 = 0;
        while (n3 - n4 > 16) {
            for (int i = 0; i < 16; ++i) {
                byArray3[i] = (byte)(byArray3[i] ^ byArray[n2 + n4 + i]);
            }
            byArray3 = cipher.doFinal(byArray3);
            n4 += 16;
        }
        if ((byArray = Arrays.copyOfRange(byArray, n2 + n4, n2 + n3)).length == 16) {
            object = zzmf.zze(byArray, ((zzmf)object).zzc);
            return cipher.doFinal(zzmf.zze(byArray3, (byte[])object));
        }
        byte[] byArray4 = Arrays.copyOf(((zzmf)object).zzd, 16);
        for (int i = 0; i < (n3 = byArray.length); ++i) {
            byArray4[i] = (byte)(byArray4[i] ^ byArray[i]);
        }
        byArray4[n3] = (byte)(byArray4[n3] ^ 0x80);
        object = byArray4;
        return cipher.doFinal(zzmf.zze(byArray3, (byte[])object));
    }

    private static byte[] zze(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        byte[] byArray3 = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
        return byArray3;
    }
}

