/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.firebase-auth-api.zztq;
import com.google.android.gms.internal.firebase-auth-api.zztu;
import com.google.android.gms.internal.firebase-auth-api.zztz;
import com.google.android.gms.internal.firebase-auth-api.zzuj;
import com.google.android.gms.internal.firebase-auth-api.zzvh;
import com.google.android.gms.internal.firebase-auth-api.zzvr;
import com.google.android.gms.internal.firebase-auth-api.zzwq;
import com.google.android.gms.internal.firebase-auth-api.zzxd;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.ActionCodeUrl;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.EmailAuthProvider;
import com.google.firebase.auth.FederatedAuthProvider;
import com.google.firebase.auth.FirebaseAuthSettings;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.MultiFactor;
import com.google.firebase.auth.MultiFactorAssertion;
import com.google.firebase.auth.MultiFactorInfo;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.PhoneAuthOptions;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.PhoneMultiFactorAssertion;
import com.google.firebase.auth.PhoneMultiFactorInfo;
import com.google.firebase.auth.SignInMethodQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.auth.internal.zzag;
import com.google.firebase.auth.internal.zzay;
import com.google.firebase.auth.internal.zzbg;
import com.google.firebase.auth.internal.zzbi;
import com.google.firebase.auth.internal.zzbj;
import com.google.firebase.auth.internal.zzbk;
import com.google.firebase.auth.internal.zzbm;
import com.google.firebase.auth.internal.zzf;
import com.google.firebase.auth.internal.zzr;
import com.google.firebase.auth.internal.zzw;
import com.google.firebase.auth.internal.zzx;
import com.google.firebase.auth.zzi;
import com.google.firebase.auth.zzj;
import com.google.firebase.auth.zzk;
import com.google.firebase.auth.zzl;
import com.google.firebase.auth.zzm;
import com.google.firebase.auth.zzn;
import com.google.firebase.auth.zzo;
import com.google.firebase.auth.zzp;
import com.google.firebase.auth.zzq;
import com.google.firebase.auth.zzs;
import com.google.firebase.auth.zzt;
import com.google.firebase.auth.zzu;
import com.google.firebase.inject.Provider;
import com.google.firebase.internal.InternalTokenResult;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public abstract class FirebaseAuth
implements InternalAuthProvider {
    private FirebaseApp zza;
    private final List zzb;
    private final List zzc;
    private List zzd;
    private zztq zze;
    @Nullable
    private FirebaseUser zzf;
    private zzw zzg;
    private final Object zzh;
    private String zzi;
    private final Object zzj;
    private String zzk;
    private final zzbg zzl;
    private final zzbm zzm;
    private final zzf zzn;
    private final Provider zzo;
    private zzbi zzp;
    private zzbj zzq;

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> applyActionCode(@NonNull String code) {
        void var1_1;
        Preconditions.checkNotEmpty((String)code);
        return this.zze.zza(this.zza, (String)var1_1, this.zzk);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<ActionCodeResult> checkActionCode(@NonNull String code) {
        void var1_1;
        Preconditions.checkNotEmpty((String)code);
        return this.zze.zzb(this.zza, (String)var1_1, this.zzk);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> confirmPasswordReset(@NonNull String code, @NonNull String newPassword) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotEmpty((String)code);
        Preconditions.checkNotEmpty((String)var2_2);
        return this.zze.zzc(this.zza, (String)var1_1, (String)var2_2, this.zzk);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<AuthResult> createUserWithEmailAndPassword(@NonNull String email, @NonNull String password) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotEmpty((String)email);
        Preconditions.checkNotEmpty((String)var2_2);
        zztq zztq2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        String string = this.zzk;
        zzs zzs2 = new zzs(this);
        return zztq2.zzd(firebaseApp, (String)var1_1, (String)var2_2, string, zzs2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<SignInMethodQueryResult> fetchSignInMethodsForEmail(@NonNull String email) {
        void var1_1;
        Preconditions.checkNotEmpty((String)email);
        return this.zze.zzf(this.zza, (String)var1_1, this.zzk);
    }

    @NonNull
    public final Task getAccessToken(boolean bl) {
        return this.zzc(this.zzf, bl);
    }

    @Nullable
    public Task<AuthResult> getPendingAuthResult() {
        return this.zzm.zza();
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String email) {
        void var1_1;
        Preconditions.checkNotEmpty((String)email);
        return this.sendPasswordResetEmail((String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String email, @Nullable ActionCodeSettings actionCodeSettings) {
        void var1_1;
        String string;
        ActionCodeSettings actionCodeSettings2;
        Preconditions.checkNotEmpty((String)email);
        if (actionCodeSettings2 == null) {
            actionCodeSettings2 = ActionCodeSettings.zzb();
        }
        if ((string = this.zzi) != null) {
            actionCodeSettings2.zzf(string);
        }
        actionCodeSettings2.zzg(1);
        return this.zze.zzu(this.zza, (String)var1_1, actionCodeSettings2, this.zzk);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> sendSignInLinkToEmail(@NonNull String email, @NonNull ActionCodeSettings actionCodeSettings) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotEmpty((String)email);
        Preconditions.checkNotNull((Object)var2_2);
        if (!var2_2.canHandleCodeInApp()) {
            Object object = new IllegalArgumentException("You must set canHandleCodeInApp in your ActionCodeSettings to true for Email-Link Sign-in.");
            throw object;
        }
        String string = ((FirebaseAuth)object).zzi;
        if (string != null) {
            var2_2.zzf(string);
        }
        return ((FirebaseAuth)object).zze.zzv(((FirebaseAuth)object).zza, (String)var1_1, (ActionCodeSettings)var2_2, ((FirebaseAuth)object).zzk);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> setFirebaseUIVersion(@Nullable String firebaseUIVersion) {
        void var1_1;
        return this.zze.zzw((String)var1_1);
    }

    @NonNull
    public Task<AuthResult> signInAnonymously() {
        Object object = ((FirebaseAuth)((Object)this_)).zzf;
        if (object != null && ((FirebaseUser)object).isAnonymous()) {
            zzx this_ = (zzx)((FirebaseAuth)((Object)this_)).zzf;
            this_.zzq(false);
            object = new zzr(this_);
            return Tasks.forResult((Object)object);
        }
        object = ((FirebaseAuth)((Object)this_)).zze;
        FirebaseApp firebaseApp = ((FirebaseAuth)((Object)this_)).zza;
        zzs zzs2 = new zzs((FirebaseAuth)((Object)this_));
        return ((zztq)object).zzx(firebaseApp, zzs2, ((FirebaseAuth)((Object)this_)).zzk);
    }

    @NonNull
    public Task<AuthResult> signInWithCredential(@NonNull AuthCredential credential) {
        Object object;
        Preconditions.checkNotNull((Object)((Object)credential));
        object = object.zza();
        if (object instanceof EmailAuthCredential) {
            if (!((EmailAuthCredential)((Object)(object = (EmailAuthCredential)((Object)object)))).zzg()) {
                zztq zztq2 = firebaseAuth.zze;
                FirebaseApp firebaseApp = firebaseAuth.zza;
                String string = ((EmailAuthCredential)((Object)object)).zzd();
                object = ((EmailAuthCredential)((Object)object)).zze();
                object = Preconditions.checkNotEmpty((String)object);
                String string2 = firebaseAuth.zzk;
                zzs zzs2 = new zzs(firebaseAuth);
                return zztq2.zzA(firebaseApp, string, (String)object, string2, zzs2);
            }
            if (firebaseAuth.zzM(Preconditions.checkNotEmpty((String)((EmailAuthCredential)((Object)object)).zzf()))) {
                FirebaseAuth firebaseAuth = new Status(17072);
                return Tasks.forException((Exception)zztu.zza((Status)firebaseAuth));
            }
            zztq zztq3 = firebaseAuth.zze;
            FirebaseApp firebaseApp = firebaseAuth.zza;
            zzs zzs3 = new zzs(firebaseAuth);
            return zztq3.zzB(firebaseApp, (EmailAuthCredential)((Object)object), zzs3);
        }
        if (object instanceof PhoneAuthCredential) {
            object = (PhoneAuthCredential)object;
            zztq zztq4 = firebaseAuth.zze;
            FirebaseApp firebaseApp = firebaseAuth.zza;
            String string = firebaseAuth.zzk;
            zzs zzs4 = new zzs(firebaseAuth);
            return zztq4.zzC(firebaseApp, (PhoneAuthCredential)object, string, zzs4);
        }
        zztq zztq5 = firebaseAuth.zze;
        FirebaseApp firebaseApp = firebaseAuth.zza;
        String string = firebaseAuth.zzk;
        zzs zzs5 = new zzs(firebaseAuth);
        return zztq5.zzy(firebaseApp, (AuthCredential)((Object)object), string, zzs5);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<AuthResult> signInWithCustomToken(@NonNull String token) {
        void var1_1;
        Preconditions.checkNotEmpty((String)token);
        zztq zztq2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        String string = this.zzk;
        zzs zzs2 = new zzs(this);
        return zztq2.zzz(firebaseApp, (String)var1_1, string, zzs2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<AuthResult> signInWithEmailAndPassword(@NonNull String email, @NonNull String password) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotEmpty((String)email);
        Preconditions.checkNotEmpty((String)var2_2);
        zztq zztq2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        String string = this.zzk;
        zzs zzs2 = new zzs(this);
        return zztq2.zzA(firebaseApp, (String)var1_1, (String)var2_2, string, zzs2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<AuthResult> signInWithEmailLink(@NonNull String email, @NonNull String link) {
        void var2_2;
        void var1_1;
        return this.signInWithCredential(EmailAuthProvider.getCredentialWithLink((String)var1_1, (String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<AuthResult> startActivityForSignInWithProvider(@NonNull Activity activity, @NonNull FederatedAuthProvider federatedAuthProvider) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull((Object)federatedAuthProvider);
        Preconditions.checkNotNull((Object)var1_1);
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        if (!firebaseAuth.zzm.zzi((Activity)var1_1, taskCompletionSource, firebaseAuth)) {
            FirebaseAuth firebaseAuth = new Status(17057);
            return Tasks.forException((Exception)zztu.zza((Status)firebaseAuth));
        }
        firebaseAuth.zzm.zzg(var1_1.getApplicationContext(), firebaseAuth);
        var2_2.zzc((Activity)var1_1);
        return taskCompletionSource.getTask();
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> updateCurrentUser(@NonNull FirebaseUser user) {
        String string;
        void var1_1;
        Object object;
        if (user == null) {
            object = new IllegalArgumentException("Cannot update current user with null user!");
            throw object;
        }
        Object object2 = var1_1.getTenantId();
        if ((object2 == null || ((String)object2).equals(((FirebaseAuth)object).zzk)) && ((string = ((FirebaseAuth)object).zzk) == null || string.equals(object2))) {
            object2 = var1_1.zza().getOptions().getApiKey();
            string = ((FirebaseAuth)object).zza.getOptions().getApiKey();
            if (var1_1.zzd().zzj() && string.equals(object2)) {
                ((FirebaseAuth)object).zzE(zzx.zzk(((FirebaseAuth)object).zza, (FirebaseUser)var1_1), var1_1.zzd(), true);
                return Tasks.forResult(null);
            }
            object2 = new zzu((FirebaseAuth)object);
            return ((FirebaseAuth)object).zzg((FirebaseUser)var1_1, (zzbk)object2);
        }
        object = new Status(17072);
        return Tasks.forException((Exception)zztu.zza((Status)object));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<String> verifyPasswordResetCode(@NonNull String code) {
        void var1_1;
        Preconditions.checkNotEmpty((String)code);
        return this.zze.zzM(this.zza, (String)var1_1, this.zzk);
    }

    @NonNull
    public FirebaseApp getApp() {
        return this.zza;
    }

    @Keep
    @NonNull
    public static FirebaseAuth getInstance() {
        return (FirebaseAuth)FirebaseApp.getInstance().get(FirebaseAuth.class);
    }

    @Keep
    @NonNull
    public static FirebaseAuth getInstance(@NonNull FirebaseApp firebaseApp) {
        return (FirebaseAuth)firebaseApp.get(FirebaseAuth.class);
    }

    @NonNull
    public FirebaseAuthSettings getFirebaseAuthSettings() {
        return this.zzg;
    }

    @Nullable
    public FirebaseUser getCurrentUser() {
        return this.zzf;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public String getLanguageCode() {
        Object object = ((FirebaseAuth)this_).zzh;
        synchronized (object) {
            return ((FirebaseAuth)this_).zzi;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public String getTenantId() {
        Object object = ((FirebaseAuth)this_).zzj;
        synchronized (object) {
            return ((FirebaseAuth)this_).zzk;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @Nullable
    public final String getUid() {
        FirebaseUser firebaseUser = ((FirebaseAuth)((Object)firebaseUser)).zzf;
        if (firebaseUser == null) {
            return null;
        }
        return firebaseUser.getUid();
    }

    public FirebaseAuth(@NonNull FirebaseApp object, @NonNull Provider provider) {
        zztq zztq2 = new zztq((FirebaseApp)object);
        zzbg zzbg2 = new zzbg(object.getApplicationContext(), object.getPersistenceKey());
        zzbm zzbm2 = zzbm.zzc();
        zzf zzf2 = com.google.firebase.auth.internal.zzf.zzb();
        Object object2 = new CopyOnWriteArrayList();
        this.zzb = object2;
        object2 = new CopyOnWriteArrayList();
        this.zzc = object2;
        object2 = new CopyOnWriteArrayList();
        this.zzd = object2;
        this.zzh = object2 = new Object();
        this.zzj = object2 = new Object();
        this.zzq = zzbj.zza();
        this.zza = (FirebaseApp)Preconditions.checkNotNull((Object)object);
        this.zze = (zztq)Preconditions.checkNotNull((Object)zztq2);
        this.zzl = (zzbg)Preconditions.checkNotNull((Object)zzbg2);
        this.zzg = object;
        this.zzm = (zzbm)Preconditions.checkNotNull((Object)zzbm2);
        this.zzn = (zzf)Preconditions.checkNotNull((Object)zzf2);
        this.zzo = provider;
        this.zzf = this.zzl.zza();
        object = this.zzf;
        if (object != null && (object = this.zzl.zzb((FirebaseUser)object)) != null) {
            FirebaseAuth.zzH(this, this.zzf, (zzwq)object, false, false);
        }
        this.zzm.zze(this);
    }

    /*
     * WARNING - void declaration
     */
    public void addAuthStateListener(@NonNull AuthStateListener listener) {
        void var1_1;
        this.zzd.add(var1_1);
        zzbj zzbj2 = this.zzq;
        zzk zzk2 = new zzk(this, (AuthStateListener)var1_1);
        zzbj2.execute(zzk2);
    }

    /*
     * WARNING - void declaration
     */
    public void addIdTokenListener(@NonNull IdTokenListener listener) {
        void var1_1;
        this.zzb.add(var1_1);
        Object object = this.zzq;
        object = Preconditions.checkNotNull((Object)object);
        object = (zzbj)object;
        zzj zzj2 = new zzj(this, (IdTokenListener)var1_1);
        ((zzbj)object).execute(zzj2);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void addIdTokenListener(@NonNull com.google.firebase.auth.internal.IdTokenListener listener) {
        void var1_1;
        Preconditions.checkNotNull((Object)listener);
        this.zzc.add(var1_1);
        this.zzw().zzd(this.zzc.size());
    }

    /*
     * WARNING - void declaration
     */
    public void removeAuthStateListener(@NonNull AuthStateListener listener) {
        void var1_1;
        this.zzd.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void removeIdTokenListener(@NonNull IdTokenListener listener) {
        void var1_1;
        this.zzb.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void removeIdTokenListener(@NonNull com.google.firebase.auth.internal.IdTokenListener listenerToRemove) {
        void var1_1;
        Preconditions.checkNotNull((Object)listenerToRemove);
        this.zzc.remove(var1_1);
        this.zzw().zzd(this.zzc.size());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setLanguageCode(@NonNull String languageCode) {
        Preconditions.checkNotEmpty((String)languageCode);
        Object object = this.zzh;
        synchronized (object) {
            void var1_2;
            this.zzi = var1_2;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setTenantId(@NonNull String tenantId) {
        Preconditions.checkNotEmpty((String)tenantId);
        Object object = this.zzj;
        synchronized (object) {
            void var1_2;
            this.zzk = var1_2;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public void signOut() {
        ((FirebaseAuth)((Object)this_)).zzD();
        zzbi this_ = ((FirebaseAuth)((Object)this_)).zzp;
        if (this_ != null) {
            this_.zzc();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void useAppLanguage() {
        Object object = this.zzh;
        synchronized (object) {
            this.zzi = zzuj.zza();
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void useEmulator(@NonNull String host, int port) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotEmpty((String)host);
        boolean bl = var2_2 >= 0 ? var2_2 <= 65535 : false;
        Preconditions.checkArgument((boolean)bl, (Object)"Port number must be in the range 0-65535");
        zzvr.zzf(this.zza, (String)var1_1, (int)var2_2);
    }

    public boolean isSignInWithEmailLink(@NonNull String link) {
        return EmailAuthCredential.zzi(link);
    }

    @NonNull
    public final Task zza(@NonNull FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)firebaseUser);
        zztq zztq2 = this.zze;
        zzi zzi2 = new zzi(this, firebaseUser);
        return zztq2.zze(firebaseUser, zzi2);
    }

    @NonNull
    public final Task zzb(@NonNull FirebaseUser firebaseUser, @NonNull MultiFactorAssertion multiFactorAssertion, @Nullable String string) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)multiFactorAssertion);
        if (multiFactorAssertion instanceof PhoneMultiFactorAssertion) {
            zztq zztq2 = firebaseAuth.zze;
            FirebaseApp firebaseApp = firebaseAuth.zza;
            multiFactorAssertion = (PhoneMultiFactorAssertion)multiFactorAssertion;
            zzs zzs2 = new zzs(firebaseAuth);
            return zztq2.zzg(firebaseApp, (PhoneMultiFactorAssertion)multiFactorAssertion, firebaseUser, string, zzs2);
        }
        FirebaseAuth firebaseAuth = new Status(17499);
        return Tasks.forException((Exception)zztu.zza((Status)firebaseAuth));
    }

    @NonNull
    public final Task zzc(@Nullable FirebaseUser firebaseUser, boolean bl) {
        if (firebaseUser == null) {
            FirebaseAuth firebaseAuth = new Status(17495);
            return Tasks.forException((Exception)zztu.zza((Status)firebaseAuth));
        }
        Object object = firebaseUser.zzd();
        if (((zzwq)object).zzj() && !bl) {
            return Tasks.forResult((Object)zzay.zza(((zzwq)object).zze()));
        }
        zztq zztq2 = firebaseAuth.zze;
        FirebaseApp firebaseApp = firebaseAuth.zza;
        object = ((zzwq)object).zzf();
        zzn zzn2 = new zzn(firebaseAuth);
        return zztq2.zzi(firebaseApp, firebaseUser, (String)object, zzn2);
    }

    @NonNull
    public final Task zzd(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)((Object)authCredential));
        Preconditions.checkNotNull((Object)firebaseUser);
        zztq zztq2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        authCredential = authCredential.zza();
        zzt zzt2 = new zzt(this);
        return zztq2.zzj(firebaseApp, firebaseUser, authCredential, zzt2);
    }

    @NonNull
    public final Task zze(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential object) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)object);
        object = object.zza();
        if (object instanceof EmailAuthCredential) {
            if ("password".equals(((EmailAuthCredential)((Object)(object = (EmailAuthCredential)((Object)object)))).getSignInMethod())) {
                zztq zztq2 = firebaseAuth.zze;
                FirebaseApp firebaseApp = firebaseAuth.zza;
                String string = ((EmailAuthCredential)((Object)object)).zzd();
                object = ((EmailAuthCredential)((Object)object)).zze();
                object = Preconditions.checkNotEmpty((String)object);
                String string2 = firebaseUser.getTenantId();
                zzt zzt2 = new zzt(firebaseAuth);
                return zztq2.zzo(firebaseApp, firebaseUser, string, (String)object, string2, zzt2);
            }
            if (firebaseAuth.zzM(Preconditions.checkNotEmpty((String)((EmailAuthCredential)((Object)object)).zzf()))) {
                FirebaseAuth firebaseAuth = new Status(17072);
                return Tasks.forException((Exception)zztu.zza((Status)firebaseAuth));
            }
            zztq zztq3 = firebaseAuth.zze;
            FirebaseApp firebaseApp = firebaseAuth.zza;
            zzt zzt3 = new zzt(firebaseAuth);
            return zztq3.zzm(firebaseApp, firebaseUser, (EmailAuthCredential)((Object)object), zzt3);
        }
        if (object instanceof PhoneAuthCredential) {
            zztq zztq4 = firebaseAuth.zze;
            FirebaseApp firebaseApp = firebaseAuth.zza;
            object = (PhoneAuthCredential)object;
            String string = firebaseAuth.zzk;
            zzt zzt4 = new zzt(firebaseAuth);
            return zztq4.zzq(firebaseApp, firebaseUser, (PhoneAuthCredential)object, string, zzt4);
        }
        zztq zztq5 = firebaseAuth.zze;
        FirebaseApp firebaseApp = firebaseAuth.zza;
        String string = firebaseUser.getTenantId();
        zzt zzt5 = new zzt(firebaseAuth);
        return zztq5.zzk(firebaseApp, firebaseUser, (AuthCredential)((Object)object), string, zzt5);
    }

    @NonNull
    public final Task zzf(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential object) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)object);
        object = object.zza();
        if (object instanceof EmailAuthCredential) {
            if ("password".equals(((EmailAuthCredential)((Object)(object = (EmailAuthCredential)((Object)object)))).getSignInMethod())) {
                zztq zztq2 = firebaseAuth.zze;
                FirebaseApp firebaseApp = firebaseAuth.zza;
                String string = ((EmailAuthCredential)((Object)object)).zzd();
                object = ((EmailAuthCredential)((Object)object)).zze();
                object = Preconditions.checkNotEmpty((String)object);
                String string2 = firebaseUser.getTenantId();
                zzt zzt2 = new zzt(firebaseAuth);
                return zztq2.zzp(firebaseApp, firebaseUser, string, (String)object, string2, zzt2);
            }
            if (firebaseAuth.zzM(Preconditions.checkNotEmpty((String)((EmailAuthCredential)((Object)object)).zzf()))) {
                FirebaseAuth firebaseAuth = new Status(17072);
                return Tasks.forException((Exception)zztu.zza((Status)firebaseAuth));
            }
            zztq zztq3 = firebaseAuth.zze;
            FirebaseApp firebaseApp = firebaseAuth.zza;
            zzt zzt3 = new zzt(firebaseAuth);
            return zztq3.zzn(firebaseApp, firebaseUser, (EmailAuthCredential)((Object)object), zzt3);
        }
        if (object instanceof PhoneAuthCredential) {
            zztq zztq4 = firebaseAuth.zze;
            FirebaseApp firebaseApp = firebaseAuth.zza;
            object = (PhoneAuthCredential)object;
            String string = firebaseAuth.zzk;
            zzt zzt4 = new zzt(firebaseAuth);
            return zztq4.zzr(firebaseApp, firebaseUser, (PhoneAuthCredential)object, string, zzt4);
        }
        zztq zztq5 = firebaseAuth.zze;
        FirebaseApp firebaseApp = firebaseAuth.zza;
        String string = firebaseUser.getTenantId();
        zzt zzt5 = new zzt(firebaseAuth);
        return zztq5.zzl(firebaseApp, firebaseUser, (AuthCredential)((Object)object), string, zzt5);
    }

    public final Task zzg(FirebaseUser firebaseUser, zzbk zzbk2) {
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zze.zzs(this.zza, firebaseUser, zzbk2);
    }

    public final Task zzh(MultiFactorAssertion multiFactorAssertion, zzag object, @Nullable FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)multiFactorAssertion);
        Preconditions.checkNotNull((Object)object);
        zztq zztq2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        multiFactorAssertion = (PhoneMultiFactorAssertion)multiFactorAssertion;
        object = object.zzd();
        object = Preconditions.checkNotEmpty((String)object);
        zzs zzs2 = new zzs(this);
        return zztq2.zzh(firebaseApp, firebaseUser, (PhoneMultiFactorAssertion)multiFactorAssertion, (String)object, zzs2);
    }

    @NonNull
    public final Task zzi(@Nullable ActionCodeSettings actionCodeSettings, @NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        if (this.zzi != null) {
            if (actionCodeSettings == null) {
                actionCodeSettings = ActionCodeSettings.zzb();
            }
            actionCodeSettings.zzf(this.zzi);
        }
        return this.zze.zzt(this.zza, actionCodeSettings, string);
    }

    @NonNull
    public final Task zzj(@NonNull Activity activity, @NonNull FederatedAuthProvider federatedAuthProvider, @NonNull FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)activity);
        Preconditions.checkNotNull((Object)federatedAuthProvider);
        Preconditions.checkNotNull((Object)firebaseUser);
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        if (!firebaseAuth.zzm.zzj(activity, taskCompletionSource, firebaseAuth, firebaseUser)) {
            FirebaseAuth firebaseAuth = new Status(17057);
            return Tasks.forException((Exception)zztu.zza((Status)firebaseAuth));
        }
        firebaseAuth.zzm.zzh(activity.getApplicationContext(), firebaseAuth, firebaseUser);
        federatedAuthProvider.zza(activity);
        return taskCompletionSource.getTask();
    }

    @NonNull
    public final Task zzk(@NonNull Activity activity, @NonNull FederatedAuthProvider federatedAuthProvider, @NonNull FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)activity);
        Preconditions.checkNotNull((Object)federatedAuthProvider);
        Preconditions.checkNotNull((Object)firebaseUser);
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        if (!firebaseAuth.zzm.zzj(activity, taskCompletionSource, firebaseAuth, firebaseUser)) {
            FirebaseAuth firebaseAuth = new Status(17057);
            return Tasks.forException((Exception)zztu.zza((Status)firebaseAuth));
        }
        firebaseAuth.zzm.zzh(activity.getApplicationContext(), firebaseAuth, firebaseUser);
        federatedAuthProvider.zzb(activity);
        return taskCompletionSource.getTask();
    }

    @NonNull
    public final Task zzl(@NonNull FirebaseUser firebaseUser, @NonNull String object) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotEmpty((String)object);
        zztq zztq2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        zzt zzt2 = new zzt(this);
        firebaseUser = zztq2.zzF(firebaseApp, firebaseUser, (String)object, zzt2);
        object = new com.google.firebase.auth.zzr(this);
        return firebaseUser.continueWithTask((Continuation)object);
    }

    @NonNull
    public final Task zzm(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)firebaseUser);
        zztq zztq2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        zzt zzt2 = new zzt(this);
        return zztq2.zzG(firebaseApp, firebaseUser, string, zzt2);
    }

    @NonNull
    public final Task zzn(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotEmpty((String)string);
        zztq zztq2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        zzt zzt2 = new zzt(this);
        return zztq2.zzH(firebaseApp, firebaseUser, string, zzt2);
    }

    @NonNull
    public final Task zzo(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotEmpty((String)string);
        zztq zztq2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        zzt zzt2 = new zzt(this);
        return zztq2.zzI(firebaseApp, firebaseUser, string, zzt2);
    }

    @NonNull
    public final Task zzp(@NonNull FirebaseUser firebaseUser, @NonNull PhoneAuthCredential phoneAuthCredential) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)phoneAuthCredential);
        zztq zztq2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        phoneAuthCredential = phoneAuthCredential.zzb();
        zzt zzt2 = new zzt(this);
        return zztq2.zzJ(firebaseApp, firebaseUser, phoneAuthCredential, zzt2);
    }

    @NonNull
    public final Task zzq(@NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)((Object)userProfileChangeRequest));
        zztq zztq2 = this.zze;
        FirebaseApp firebaseApp = this.zza;
        zzt zzt2 = new zzt(this);
        return zztq2.zzK(firebaseApp, firebaseUser, userProfileChangeRequest, zzt2);
    }

    @NonNull
    public final Task zzr(@NonNull String string, @NonNull String string2, @Nullable ActionCodeSettings actionCodeSettings) {
        String string3;
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        if (actionCodeSettings == null) {
            actionCodeSettings = ActionCodeSettings.zzb();
        }
        if ((string3 = this.zzi) != null) {
            actionCodeSettings.zzf(string3);
        }
        return this.zze.zzL(string, string2, actionCodeSettings);
    }

    static /* bridge */ /* synthetic */ FirebaseUser zzs(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzf;
    }

    static /* bridge */ /* synthetic */ PhoneAuthProvider.OnVerificationStateChangedCallbacks zzt(FirebaseAuth firebaseAuth, String string, PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks) {
        return firebaseAuth.zzL(string, onVerificationStateChangedCallbacks);
    }

    private final PhoneAuthProvider.OnVerificationStateChangedCallbacks zzL(@Nullable String object, PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks) {
        if (this.zzg.zzd() && object != null && ((String)object).equals(this.zzg.zza())) {
            object = new zzq(this, onVerificationStateChangedCallbacks);
            return object;
        }
        return onVerificationStateChangedCallbacks;
    }

    static /* bridge */ /* synthetic */ zztq zzu(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zze;
    }

    static /* bridge */ /* synthetic */ zzw zzv(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzg;
    }

    @VisibleForTesting
    public final synchronized zzbi zzw() {
        return FirebaseAuth.zzx(this);
    }

    public static zzbi zzx(FirebaseAuth firebaseAuth) {
        if (firebaseAuth.zzp == null) {
            zzbi zzbi2;
            Object object = firebaseAuth.zza;
            object = Preconditions.checkNotNull((Object)object);
            firebaseAuth.zzp = zzbi2 = new zzbi((FirebaseApp)object);
        }
        return firebaseAuth.zzp;
    }

    @NonNull
    public final Provider zzy() {
        return this.zzo;
    }

    static /* bridge */ /* synthetic */ String zzz(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzi;
    }

    static /* bridge */ /* synthetic */ List zzA(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzd;
    }

    static /* bridge */ /* synthetic */ List zzB(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzb;
    }

    static /* bridge */ /* synthetic */ List zzC(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzc;
    }

    public final void zzD() {
        Preconditions.checkNotNull((Object)this.zzl);
        FirebaseUser firebaseUser = this.zzf;
        if (firebaseUser != null) {
            zzbg zzbg2 = this.zzl;
            Preconditions.checkNotNull((Object)firebaseUser);
            Object[] objectArray = new Object[]{firebaseUser.getUid()};
            zzbg2.zzc(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", objectArray));
            this.zzf = null;
        }
        this.zzl.zzc("com.google.firebase.auth.FIREBASE_USER");
        FirebaseAuth.zzG(this, null);
        FirebaseAuth.zzF(this, null);
    }

    public final void zzE(FirebaseUser firebaseUser, zzwq zzwq2, boolean bl) {
        FirebaseAuth.zzH(this, firebaseUser, zzwq2, true, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void zzF(@NonNull FirebaseAuth firebaseAuth, @Nullable FirebaseUser object) {
        Object object2;
        if (object != null) {
            object = ((FirebaseUser)object).getUid();
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Notifying auth state listeners about user ( ");
            ((StringBuilder)object2).append((String)object);
            ((StringBuilder)object2).append(" ).");
            Log.d((String)"FirebaseAuth", (String)((StringBuilder)object2).toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying auth state listeners about a sign-out event.");
        }
        object = firebaseAuth.zzq;
        object2 = new zzm(firebaseAuth);
        ((zzbj)object).execute((Runnable)object2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void zzG(@NonNull FirebaseAuth firebaseAuth, @Nullable FirebaseUser object) {
        Object object2;
        String string;
        if (object != null) {
            string = ((FirebaseUser)object).getUid();
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Notifying id token listeners about user ( ");
            ((StringBuilder)object2).append(string);
            ((StringBuilder)object2).append(" ).");
            Log.d((String)"FirebaseAuth", (String)((StringBuilder)object2).toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying id token listeners about a sign-out event.");
        }
        object = object != null ? ((FirebaseUser)object).zze() : null;
        string = new InternalTokenResult((String)object);
        object = firebaseAuth.zzq;
        object2 = new zzl(firebaseAuth, (InternalTokenResult)string);
        ((zzbj)object).execute((Runnable)object2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    static void zzH(FirebaseAuth firebaseAuth, FirebaseUser firebaseUser, zzwq zzwq2, boolean bl, boolean bl2) {
        boolean bl3;
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)zzwq2);
        boolean bl4 = firebaseAuth.zzf != null ? firebaseUser.getUid().equals(firebaseAuth.zzf.getUid()) : false;
        if (!bl4 && bl2) {
            return;
        }
        FirebaseUser firebaseUser2 = firebaseAuth.zzf;
        if (firebaseUser2 == null) {
            bl3 = true;
            bl4 = true;
        } else {
            bl3 = firebaseUser2.zzd().zze().equals(zzwq2.zze()) ^ true;
            bl3 = bl4 ? bl3 : true;
            bl4 ^= true;
        }
        Preconditions.checkNotNull((Object)firebaseUser);
        List<MultiFactorInfo> list = firebaseAuth.zzf;
        if (list == null) {
            firebaseAuth.zzf = firebaseUser;
        } else {
            ((FirebaseUser)((Object)list)).zzc(firebaseUser.getProviderData());
            if (!firebaseUser.isAnonymous()) {
                firebaseAuth.zzf.zzb();
            }
            list = firebaseUser.getMultiFactor();
            list = ((MultiFactor)((Object)list)).getEnrolledFactors();
            firebaseAuth.zzf.zzi(list);
        }
        if (bl) {
            firebaseAuth.zzl.zzd(firebaseAuth.zzf);
        }
        if (bl3) {
            FirebaseUser firebaseUser3 = firebaseAuth.zzf;
            if (firebaseUser3 != null) {
                firebaseUser3.zzh(zzwq2);
            }
            FirebaseAuth.zzG(firebaseAuth, firebaseAuth.zzf);
        }
        if (bl4) {
            FirebaseAuth.zzF(firebaseAuth, firebaseAuth.zzf);
        }
        if (bl) {
            firebaseAuth.zzl.zze(firebaseUser, zzwq2);
        }
        if ((firebaseUser = firebaseAuth.zzf) != null) {
            FirebaseAuth.zzx(firebaseAuth).zze(firebaseUser.zzd());
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzI(@NonNull PhoneAuthOptions object) {
        if (((PhoneAuthOptions)object).zzk()) {
            FirebaseAuth firebaseAuth = ((PhoneAuthOptions)object).zzb();
            Object object2 = ((zzag)((Object)Preconditions.checkNotNull((Object)((Object)((PhoneAuthOptions)object).zzc())))).zze() ? Preconditions.checkNotEmpty((String)((PhoneAuthOptions)object).zzh()) : Preconditions.checkNotEmpty((String)((PhoneMultiFactorInfo)((Object)Preconditions.checkNotNull((Object)((Object)((PhoneAuthOptions)object).zzf())))).getUid());
            if (((PhoneAuthOptions)object).zzd() != null && zzvh.zzd((String)object2, ((PhoneAuthOptions)object).zze(), (Activity)Preconditions.checkNotNull((Object)((PhoneAuthOptions)object).zza()), ((PhoneAuthOptions)object).zzi())) return;
            object2 = firebaseAuth.zzn;
            Object object3 = ((PhoneAuthOptions)object).zzh();
            Activity activity = ((PhoneAuthOptions)object).zza();
            Object object4 = Preconditions.checkNotNull((Object)activity);
            Activity activity2 = (Activity)object4;
            boolean bl = firebaseAuth.zzK();
            object2 = ((zzf)object2).zza(firebaseAuth, (String)object3, activity2, bl);
            object3 = new zzp(firebaseAuth, (PhoneAuthOptions)object);
            object2.addOnCompleteListener((OnCompleteListener)object3);
            return;
        }
        FirebaseAuth firebaseAuth = ((PhoneAuthOptions)object).zzb();
        String string = Preconditions.checkNotEmpty((String)((PhoneAuthOptions)object).zzh());
        long l = ((PhoneAuthOptions)object).zzg();
        TimeUnit timeUnit = TimeUnit.SECONDS;
        PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks = ((PhoneAuthOptions)object).zze();
        Activity activity = (Activity)Preconditions.checkNotNull((Object)((PhoneAuthOptions)object).zza());
        Executor executor = ((PhoneAuthOptions)object).zzi();
        boolean bl = ((PhoneAuthOptions)object).zzd() != null;
        if (!bl && zzvh.zzd(string, onVerificationStateChangedCallbacks, activity, executor)) {
            return;
        }
        object = firebaseAuth.zzn;
        boolean bl2 = firebaseAuth.zzK();
        object = ((zzf)object).zza(firebaseAuth, string, activity, bl2);
        zzo zzo2 = new zzo(firebaseAuth, string, l, timeUnit, onVerificationStateChangedCallbacks, activity, executor, bl);
        object.addOnCompleteListener((OnCompleteListener)zzo2);
    }

    public final void zzJ(@NonNull String object, long l, @NonNull TimeUnit object2, @NonNull PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks, @NonNull Activity activity, @NonNull Executor executor, boolean bl, @Nullable String string, @Nullable String string2) {
        long l2 = TimeUnit.SECONDS.convert(l, (TimeUnit)((Object)object2));
        if (l2 < 0L || l2 > 120L) {
            Object object3 = new IllegalArgumentException("We only support 0-120 seconds for sms-auto-retrieval timeout");
            throw object3;
        }
        object2 = new zzxd((String)object, l2, bl, ((FirebaseAuth)object3).zzi, ((FirebaseAuth)object3).zzk, string, ((FirebaseAuth)object3).zzK(), string2);
        object = super.zzL((String)object, onVerificationStateChangedCallbacks);
        ((FirebaseAuth)object3).zze.zzO(((FirebaseAuth)object3).zza, (zzxd)object2, (PhoneAuthProvider.OnVerificationStateChangedCallbacks)object, activity, executor);
    }

    @VisibleForTesting
    final boolean zzK() {
        return zztz.zza(this.getApp().getApplicationContext());
    }

    private final boolean zzM(String object) {
        return (object = ActionCodeUrl.parseLink((String)object)) != null && !TextUtils.equals((CharSequence)this.zzk, (CharSequence)((ActionCodeUrl)object).zza());
    }

    public static interface IdTokenListener {
        public void onIdTokenChanged(@NonNull FirebaseAuth var1);
    }

    public static interface AuthStateListener {
        public void onAuthStateChanged(@NonNull FirebaseAuth var1);
    }
}

