/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase-auth-api.zztu;
import com.google.android.gms.internal.firebase-auth-api.zzug;
import com.google.android.gms.internal.firebase-auth-api.zzvr;
import com.google.android.gms.safetynet.SafetyNet;
import com.google.android.gms.safetynet.SafetyNetClient;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.internal.RecaptchaActivity;
import com.google.firebase.auth.internal.zza;
import com.google.firebase.auth.internal.zzax;
import com.google.firebase.auth.internal.zzb;
import com.google.firebase.auth.internal.zzbm;
import com.google.firebase.auth.internal.zzc;
import com.google.firebase.auth.internal.zzd;
import com.google.firebase.auth.internal.zze;
import com.google.firebase.auth.internal.zzw;
import java.io.UnsupportedEncodingException;

public final class zzf {
    private static final String zza;
    private static final zzf zzb;

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Task zza(FirebaseAuth firebaseAuth, @Nullable String object, Activity activity, boolean bl) {
        byte[] byArray;
        void var4_7;
        Object object2;
        Object object3 = (zzw)firebaseAuth.getFirebaseAuthSettings();
        if (bl) {
            SafetyNetClient safetyNetClient = SafetyNet.getClient((Context)firebaseAuth.getApp().getApplicationContext());
        } else {
            Object var4_10 = null;
        }
        zzbm zzbm2 = zzbm.zzc();
        if (zzvr.zzg(firebaseAuth.getApp()) || ((zzw)object3).zze()) {
            object2 = new zze(null, null);
            return Tasks.forResult((Object)object2);
        }
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Task task = zzbm2.zzb();
        if (task != null) {
            if (task.isSuccessful()) {
                object2 = new zze(null, (String)task.getResult());
                return Tasks.forResult((Object)object2);
            }
            Log.e((String)zza, (String)"Error in previous reCAPTCHA flow: ".concat(String.valueOf(task.getException().getMessage())));
            Log.e((String)zza, (String)"Continuing with application verification as normal");
        }
        if (var4_7 != null && !((zzw)object3).zzc()) {
            object3 = firebaseAuth.getApp();
            byArray = new byte[]{};
            if (object != null) {
                object = ((String)object).getBytes("UTF-8");
            } else {
                object = byArray;
            }
        } else {
            super.zze(firebaseAuth, zzbm2, activity, taskCompletionSource);
            return taskCompletionSource.getTask();
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.e((String)zza, (String)"Failed to getBytes with exception: ".concat(String.valueOf(unsupportedEncodingException.getMessage())));
                object = byArray;
            }
        }
        object3 = object3.getOptions();
        object3 = object3.getApiKey();
        object = var4_7.attest((byte[])object, (String)object3);
        zzb zzb2 = new zzb((zzf)object2, taskCompletionSource, firebaseAuth, zzbm2, activity);
        object = object.addOnSuccessListener((OnSuccessListener)zzb2);
        zza zza2 = new zza((zzf)object2, firebaseAuth, zzbm2, activity, taskCompletionSource);
        object.addOnFailureListener((OnFailureListener)zza2);
        return taskCompletionSource.getTask();
    }

    public static zzf zzb() {
        return zzb;
    }

    static /* bridge */ /* synthetic */ String zzc() {
        return zza;
    }

    static /* bridge */ /* synthetic */ void zzd(zzf zzf2, FirebaseAuth firebaseAuth, zzbm zzbm2, Activity activity, TaskCompletionSource taskCompletionSource) {
        zzf2.zze(firebaseAuth, zzbm2, activity, taskCompletionSource);
    }

    static {
        zzf zzf2;
        zza = zzf.class.getSimpleName();
        zzb = zzf2 = new zzf();
    }

    private zzf() {
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zze(FirebaseAuth firebaseAuth, zzbm object, Activity activity, TaskCompletionSource taskCompletionSource) {
        ((zzbm)object).zzg(firebaseAuth.getApp().getApplicationContext(), firebaseAuth);
        Preconditions.checkNotNull((Object)activity);
        object = new TaskCompletionSource();
        if (!zzax.zza().zzg(activity, (TaskCompletionSource)object)) {
            firebaseAuth = new Status(17057, "reCAPTCHA flow already in progress");
            firebaseAuth = Tasks.forException((Exception)zztu.zza((Status)firebaseAuth));
        } else {
            Intent intent = new Intent("com.google.firebase.auth.internal.ACTION_SHOW_RECAPTCHA");
            intent.setClass((Context)activity, RecaptchaActivity.class);
            intent.setPackage(activity.getPackageName());
            intent.putExtra("com.google.firebase.auth.KEY_API_KEY", firebaseAuth.getApp().getOptions().getApiKey());
            if (!TextUtils.isEmpty((CharSequence)firebaseAuth.getTenantId())) {
                intent.putExtra("com.google.firebase.auth.KEY_TENANT_ID", firebaseAuth.getTenantId());
            }
            intent.putExtra("com.google.firebase.auth.internal.CLIENT_VERSION", zzug.zza().zzb());
            intent.putExtra("com.google.firebase.auth.internal.FIREBASE_APP_NAME", firebaseAuth.getApp().getName());
            activity.startActivity(intent);
            firebaseAuth = object.getTask();
        }
        object = new zzd(this, taskCompletionSource);
        firebaseAuth = firebaseAuth.addOnSuccessListener((OnSuccessListener)object);
        object = new zzc(this, taskCompletionSource);
        firebaseAuth.addOnFailureListener((OnFailureListener)object);
    }
}

