/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.firebase-auth-api.zzaad;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Class(creator="MfaInfoCreator")
public final class zzaac
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<zzaac> CREATOR;
    @SafeParcelable.Field(id=1, getter="getPhoneInfo")
    @Nullable
    private final String zza;
    @SafeParcelable.Field(id=2, getter="getMfaEnrollmentId")
    @NonNull
    private final String zzb;
    @SafeParcelable.Field(id=3, getter="getDisplayName")
    private final String zzc;
    @SafeParcelable.Field(id=4, getter="getEnrolledAtTimestampInSeconds")
    private final long zzd;
    @Nullable
    private String zze;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long zzg(String string) {
        string = string.replaceAll("\\.[0-9]{0,9}Z$|Z$", ".000Z");
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.getDefault());
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            long l = simpleDateFormat.parse(string).getTime();
            return l;
        }
        catch (ParseException parseException) {
            Log.w((String)"MfaInfo", (String)"Could not parse timestamp as ISOString", (Throwable)parseException);
            return 0L;
        }
    }

    public final long zza() {
        return this.zzd;
    }

    public static zzaac zzb(@NonNull JSONObject jSONObject) {
        zzaac zzaac2 = new zzaac(jSONObject.optString("phoneInfo", null), jSONObject.optString("mfaEnrollmentId", null), jSONObject.optString("displayName", null), zzaac.zzg(jSONObject.optString("enrolledAt", "")));
        zzaac2.zze = jSONObject.optString("unobfuscatedPhoneInfo");
        return zzaac2;
    }

    public final String zzc() {
        return this.zzc;
    }

    public final String zzd() {
        return this.zzb;
    }

    @Nullable
    public final String zze() {
        return this.zza;
    }

    public static List zzf(JSONArray object) throws JSONException {
        if (object == null || object.length() == 0) {
            object = new ArrayList();
            return object;
        }
        ArrayList<zzaac> arrayList = new ArrayList<zzaac>();
        for (int i = 0; i < object.length(); ++i) {
            arrayList.add(zzaac.zzb(object.getJSONObject(i)));
        }
        return arrayList;
    }

    static {
        zzaad zzaad2;
        CREATOR = zzaad2 = new zzaad();
    }

    @SafeParcelable.Constructor
    public zzaac(@SafeParcelable.Param(id=1) String string, @SafeParcelable.Param(id=2) String string2, @SafeParcelable.Param(id=3) String string3, @SafeParcelable.Param(id=4) long l) {
        this.zza = string;
        this.zzb = Preconditions.checkNotEmpty((String)string2);
        this.zzc = string3;
        this.zzd = l;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeString((Parcel)parcel, (int)1, (String)this.zza, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)2, (String)this.zzb, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)3, (String)this.zzc, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)parcel, (int)4, (long)this.zzd);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n);
    }
}

