/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.content.Context;
import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.internal.firebase-auth-api.zzadn;
import com.google.android.gms.internal.firebase-auth-api.zzap;
import com.google.android.gms.internal.firebase-auth-api.zzar;
import com.google.android.gms.internal.firebase-auth-api.zzbf;
import com.google.android.gms.internal.firebase-auth-api.zzbh;
import com.google.android.gms.internal.firebase-auth-api.zzbi;
import com.google.android.gms.internal.firebase-auth-api.zzbj;
import com.google.android.gms.internal.firebase-auth-api.zzfn;
import com.google.android.gms.internal.firebase-auth-api.zzfp;
import com.google.android.gms.internal.firebase-auth-api.zzfq;
import com.google.android.gms.internal.firebase-auth-api.zzfr;
import com.google.android.gms.internal.firebase-auth-api.zznx;
import com.google.android.gms.internal.firebase-auth-api.zzqs;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.annotation.concurrent.GuardedBy;
import javax.crypto.KeyGenerator;

public final class zzfl {
    private zzbj zza = null;
    private String zzb = null;
    private zzap zzc = null;
    private zzbf zzd = null;
    @GuardedBy(value="this")
    private zzbi zze;
    private zzfq zzf = null;

    static /* bridge */ /* synthetic */ zzap zza(zzfl zzfl2) {
        return zzfl2.zzc;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private final zzap zzh() throws GeneralSecurityException {
        Object[] objectArray;
        if (Build.VERSION.SDK_INT < 23) {
            Log.w((String)zzfn.zzb(), (String)"Android Keystore requires at least Android M");
            return null;
        }
        Object[] objectArray2 = new zzfp();
        boolean bl = objectArray2.zzc(((zzfl)object).zzb);
        if (!bl) {
            objectArray = ((zzfl)object).zzb;
            zzfp zzfp2 = new zzfp();
            boolean bl2 = zzfp2.zzc((String)objectArray);
            if (bl2) {
                objectArray2 = new Object[]{objectArray};
                Object object = new IllegalArgumentException(String.format("cannot generate a new key %s because it already exists; please delete it with deleteKey() and try again", objectArray2));
                throw object;
            }
            objectArray = zzqs.zza("android-keystore://", (String)objectArray);
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", "AndroidKeyStore");
            String[] stringArray = new KeyGenParameterSpec.Builder((String)objectArray, 3);
            objectArray = stringArray.setKeySize(256);
            stringArray = new String[]{"GCM"};
            objectArray = objectArray.setBlockModes(stringArray);
            stringArray = new String[]{"NoPadding"};
            keyGenerator.init((AlgorithmParameterSpec)objectArray.setEncryptionPaddings(stringArray).build());
            keyGenerator.generateKey();
        }
        return objectArray2.zza(((zzfl)object).zzb);
        catch (GeneralSecurityException | ProviderException exception) {
            Log.w((String)zzfn.zzb(), (String)"cannot use Android Keystore, it'll be disabled", (Throwable)exception);
            return null;
        }
        catch (GeneralSecurityException | ProviderException exception) {
            if (bl) {
                objectArray = new Object[]{((zzfl)object).zzb};
                KeyStoreException keyStoreException = new KeyStoreException(String.format("the master key %s exists but is unusable", objectArray), exception);
                throw keyStoreException;
            }
            Log.w((String)zzfn.zzb(), (String)"cannot use Android Keystore, it'll be disabled", (Throwable)exception);
            return null;
        }
    }

    static /* bridge */ /* synthetic */ zzbi zzb(zzfl zzfl2) {
        return zzfl2.zze;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final zzbi zzi() throws GeneralSecurityException, IOException {
        zzap zzap2 = this.zzc;
        if (zzap2 == null) return zzbi.zzf(zzar.zzb(this.zzf));
        try {
            zzfq zzfq2 = this.zzf;
            return zzbi.zzf(zzbh.zzh(zzfq2, zzap2));
        }
        catch (zzadn | GeneralSecurityException exception) {
            Log.w((String)zzfn.zzb(), (String)"cannot decrypt keyset: ", (Throwable)exception);
            return zzbi.zzf(zzar.zzb(this.zzf));
        }
    }

    static /* bridge */ /* synthetic */ zzbj zzc(zzfl zzfl2) {
        return zzfl2.zza;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Deprecated
    public final zzfl zzd(zznx object) {
        int n;
        String string = ((zznx)object).zzf();
        byte[] byArray = ((zznx)object).zze().zzt();
        object = ((zznx)object).zzd();
        switch (((Enum)object).ordinal()) {
            case 1: {
                n = 1;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            default: {
                Object object2 = new IllegalArgumentException("Unknown output prefix type");
                throw object2;
            }
            case 2: {
                n = 2;
            }
        }
        ((zzfl)object2).zzd = zzbf.zze(string, byArray, n);
        return object2;
    }

    public final zzfl zze(String string) {
        if (!string.startsWith("android-keystore://")) {
            Object object = new IllegalArgumentException("key URI must start with android-keystore://");
            throw object;
        }
        ((zzfl)object).zzb = string;
        return object;
    }

    public final zzfl zzf(Context context, String string, String string2) throws IOException {
        if (context == null) {
            Object object = new IllegalArgumentException("need an Android context");
            throw object;
        }
        string = "GenericIdpKeyset";
        Object object = new zzfq(context, string, string2);
        ((zzfl)object).zzf = object;
        ((zzfl)object).zza = object = new zzfr(context, string, string2);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final synchronized zzfn zzg() throws GeneralSecurityException, IOException {
        Object object;
        if (((zzfl)object2).zzb != null) {
            ((zzfl)object2).zzc = ((zzfl)object2).zzh();
        }
        try {
            object = ((zzfl)object2).zzi();
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Log.isLoggable((String)zzfn.zzb(), (int)4)) {
                String string = zzfn.zzb();
                Object[] objectArray = new Object[]{fileNotFoundException.getMessage()};
                Log.i((String)string, (String)String.format("keyset not found, will generate a new one. %s", objectArray));
            }
            if (((zzfl)object2).zzd == null) {
                Object object2 = new GeneralSecurityException("cannot read or generate keyset");
                throw object2;
            }
            object = zzbi.zze();
            ((zzbi)object).zzc(((zzfl)object2).zzd);
            ((zzbi)object).zzd(((zzbi)object).zzb().zzd().zzb(0).zza());
            if (((zzfl)object2).zzc != null) {
                ((zzbi)object).zzb().zzf(((zzfl)object2).zza, ((zzfl)object2).zzc);
            }
            zzar.zza(((zzbi)object).zzb(), ((zzfl)object2).zza);
        }
        ((zzfl)object2).zze = object;
        return new zzfn((zzfl)object2, null);
    }
}

