/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzpz;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.KeyAgreement;

public final class zzpx {
    public static int zza(EllipticCurve ellipticCurve) throws GeneralSecurityException {
        return (zzpx.zzb(ellipticCurve).subtract(BigInteger.ONE).bitLength() + 7) / 8;
    }

    public static BigInteger zzb(EllipticCurve object) throws GeneralSecurityException {
        if (!((object = ((EllipticCurve)object).getField()) instanceof ECFieldFp)) {
            object = new GeneralSecurityException("Only curves over prime order fields are supported");
            throw object;
        }
        return ((ECFieldFp)object).getP();
    }

    /*
     * Unable to fully structure code
     */
    public static BigInteger zzc(BigInteger var0, boolean var1_1, EllipticCurve var2_2) throws GeneralSecurityException {
        block10: {
            block8: {
                block13: {
                    block11: {
                        block9: {
                            var5_5 = zzpx.zzb((EllipticCurve)var2_2);
                            var3_6 = var2_2.getA();
                            var2_2 = var2_2.getB();
                            var0 = var0.multiply((BigInteger)var0).add(var3_6).multiply((BigInteger)var0).add((BigInteger)var2_2).mod(var5_5);
                            if (var5_5.signum() != 1) {
                                var0 = new InvalidAlgorithmParameterException("p must be positive");
                                throw var0;
                            }
                            var6_7 = var0.mod(var5_5);
                            if (var6_7.equals(BigInteger.ZERO)) {
                                var0 = BigInteger.ZERO;
lbl11:
                                // 3 sources

                                while (true) {
                                    if (var1_1 != var0.testBit(0)) {
                                        return var5_5.subtract((BigInteger)var0).mod(var5_5);
                                    }
                                    return var0;
                                }
                            }
                            if (!var5_5.testBit(0) || !var5_5.testBit(1)) break block9;
                            var0 = var6_7.modPow(var5_5.add(BigInteger.ONE).shiftRight(2), var5_5);
lbl17:
                            // 4 sources

                            while (true) {
                                if (var0 == null || var0.multiply((BigInteger)var0).mod(var5_5).compareTo(var6_7) == 0) ** GOTO lbl11
                                break block8;
                                break;
                            }
                        }
                        if (!var5_5.testBit(0)) break block10;
                        if (var5_5.testBit(1)) break block11;
                        var0 = BigInteger.ONE;
                        var3_6 = var5_5.subtract(BigInteger.ONE).shiftRight(1);
                        var2_3 = 0;
                        do {
                            block12: {
                                if (!(var7_10 = var0.multiply((BigInteger)var0).subtract(var6_7).mod(var5_5)).equals(BigInteger.ZERO)) ** break;
                                ** continue;
                                var4_8 = var7_10.modPow(var3_6, var5_5);
                                if (!var4_8.add(BigInteger.ONE).equals(var5_5)) break block12;
                                var8_11 = var5_5.add(BigInteger.ONE).shiftRight(1);
                                var3_6 = BigInteger.ONE;
                                var2_4 = var0;
                                for (var4_9 = var8_11.bitLength() + -2; var4_9 >= 0; --var4_9) {
                                    var9_12 = var2_4.multiply(var3_6);
                                    var2_4 = var2_4.multiply((BigInteger)var2_4).add(var3_6.multiply(var3_6).mod(var5_5).multiply(var7_10)).mod(var5_5);
                                    var3_6 = var9_12.add(var9_12).mod(var5_5);
                                    if (!var8_11.testBit(var4_9)) continue;
                                    var9_12 = var2_4.multiply((BigInteger)var0).add(var3_6.multiply(var7_10)).mod(var5_5);
                                    var3_6 = var0.multiply(var3_6).add((BigInteger)var2_4).mod(var5_5);
                                    var2_4 = var9_12;
                                }
                                var0 = var2_4;
                                ** GOTO lbl17
                            }
                            if (!var4_8.equals(BigInteger.ONE)) {
                                var0 = new InvalidAlgorithmParameterException("p is not prime");
                                throw var0;
                            }
                            var0 = var0.add(BigInteger.ONE);
                        } while (++var2_3 != 128 || var5_5.isProbablePrime(80));
                        break block13;
                    }
                    var0 = null;
                    ** GOTO lbl17
                }
                var0 = new InvalidAlgorithmParameterException("p is not prime");
                throw var0;
            }
            var0 = new GeneralSecurityException("Could not find a modular square root");
            throw var0;
        }
        var0 = null;
        ** while (true)
    }

    public static KeyPair zzd(ECParameterSpec eCParameterSpec) throws GeneralSecurityException {
        KeyPairGenerator keyPairGenerator = (KeyPairGenerator)zzpz.zzf.zza("EC");
        keyPairGenerator.initialize(eCParameterSpec);
        return keyPairGenerator.generateKeyPair();
    }

    private static ECParameterSpec zzn(String object, String object2, String object3, String object4, String object5) {
        Object object6 = new BigInteger((String)object);
        object = new BigInteger((String)object2);
        object2 = new BigInteger("3");
        object2 = ((BigInteger)object6).subtract((BigInteger)object2);
        BigInteger bigInteger = new BigInteger((String)object3, 16);
        object3 = new BigInteger((String)object4, 16);
        object4 = new BigInteger((String)object5, 16);
        object5 = new ECFieldFp((BigInteger)object6);
        object6 = new EllipticCurve((ECField)object5, (BigInteger)object2, bigInteger);
        object2 = new ECPoint((BigInteger)object3, (BigInteger)object4);
        object3 = new ECParameterSpec((EllipticCurve)object6, (ECPoint)object2, (BigInteger)object, 1);
        return object3;
    }

    static void zze(ECPoint object, EllipticCurve ellipticCurve) throws GeneralSecurityException {
        BigInteger bigInteger = zzpx.zzb(ellipticCurve);
        BigInteger bigInteger2 = ((ECPoint)object).getAffineX();
        object = ((ECPoint)object).getAffineY();
        if (bigInteger2 == null || object == null) {
            object = new GeneralSecurityException("point is at infinity");
            throw object;
        }
        if (bigInteger2.signum() == -1 || bigInteger2.compareTo(bigInteger) >= 0) {
            object = new GeneralSecurityException("x is out of range");
            throw object;
        }
        if (((BigInteger)object).signum() == -1 || ((BigInteger)object).compareTo(bigInteger) >= 0) {
            object = new GeneralSecurityException("y is out of range");
            throw object;
        }
        if (!((BigInteger)object).multiply((BigInteger)object).mod(bigInteger).equals(bigInteger2.multiply(bigInteger2).add(ellipticCurve.getA()).multiply(bigInteger2).add(ellipticCurve.getB()).mod(bigInteger))) {
            object = new GeneralSecurityException("Point is not on curve");
            throw object;
        }
    }

    public static void zzf(ECPublicKey eCPublicKey, ECPrivateKey eCPrivateKey) throws GeneralSecurityException {
        zzpx.zzg(eCPublicKey, eCPrivateKey);
        zzpx.zze(eCPublicKey.getW(), eCPrivateKey.getParams().getCurve());
    }

    static void zzg(ECPublicKey object, ECPrivateKey object2) throws GeneralSecurityException {
        block7: {
            block6: {
                object = object.getParams();
                object2 = object2.getParams();
                boolean bl = ((ECParameterSpec)object).getCurve().equals(((ECParameterSpec)object2).getCurve());
                if (!bl) break block6;
                bl = ((ECParameterSpec)object).getGenerator().equals(((ECParameterSpec)object2).getGenerator());
                if (!bl) break block6;
                bl = ((ECParameterSpec)object).getOrder().equals(((ECParameterSpec)object2).getOrder());
                if (!bl) break block6;
                int n = ((ECParameterSpec)object).getCofactor();
                int n2 = ((ECParameterSpec)object2).getCofactor();
                if (n == n2) break block7;
            }
            try {
                GeneralSecurityException generalSecurityException = new GeneralSecurityException("invalid public key spec");
                throw generalSecurityException;
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                GeneralSecurityException generalSecurityException = new GeneralSecurityException(runtimeException);
                throw generalSecurityException;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] zzh(ECPrivateKey object, ECPublicKey object2) throws GeneralSecurityException {
        zzpx.zzg((ECPublicKey)object2, (ECPrivateKey)object);
        object2 = object2.getW();
        zzpx.zze((ECPoint)object2, object.getParams().getCurve());
        Object object3 = object.getParams();
        ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec((ECPoint)object2, (ECParameterSpec)object3);
        object2 = ((KeyFactory)zzpz.zzg.zza("EC")).generatePublic(eCPublicKeySpec);
        object3 = (KeyAgreement)zzpz.zze.zza("ECDH");
        ((KeyAgreement)object3).init((Key)object);
        try {
            ((KeyAgreement)object3).doPhase((Key)object2, true);
            object2 = ((KeyAgreement)object3).generateSecret();
            object = object.getParams().getCurve();
            object3 = new BigInteger(1, (byte[])object2);
            int n = ((BigInteger)object3).signum();
            if (n != -1 && (n = ((BigInteger)object3).compareTo(zzpx.zzb((EllipticCurve)object))) < 0) {
                zzpx.zzc((BigInteger)object3, true, (EllipticCurve)object);
                return object2;
            }
            object = new GeneralSecurityException("shared secret is out of range");
            throw object;
        }
        catch (IllegalStateException illegalStateException) {
            object2 = new GeneralSecurityException(illegalStateException);
            throw object2;
        }
    }

    public static ECPrivateKey zzi(int n, byte[] object) throws GeneralSecurityException {
        ECParameterSpec eCParameterSpec = zzpx.zzl(n);
        BigInteger bigInteger = new BigInteger(1, (byte[])object);
        object = new ECPrivateKeySpec;
        object(bigInteger, eCParameterSpec);
        return (ECPrivateKey)((KeyFactory)zzpz.zzg.zza("EC")).generatePrivate((KeySpec)object);
    }

    public static ECPublicKey zzj(int n, byte[] object, byte[] object2) throws GeneralSecurityException {
        ECParameterSpec eCParameterSpec = zzpx.zzl(n);
        BigInteger bigInteger = new BigInteger(1, (byte[])object);
        object = new BigInteger;
        object(1, (byte[])object2);
        object2 = new ECPoint;
        object2(bigInteger, (BigInteger)object);
        zzpx.zze((ECPoint)object2, eCParameterSpec.getCurve());
        object = new ECPublicKeySpec;
        object((ECPoint)object2, eCParameterSpec);
        return (ECPublicKey)((KeyFactory)zzpz.zzg.zza("EC")).generatePublic((KeySpec)object);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ECPublicKey zzk(ECParameterSpec object, int n, byte[] object2) throws GeneralSecurityException {
        Object object3;
        block11: {
            int n2;
            EllipticCurve ellipticCurve;
            block12: {
                ellipticCurve = ((ECParameterSpec)object).getCurve();
                n2 = zzpx.zza(ellipticCurve);
                switch (n + -1) {
                    default: {
                        BigInteger bigInteger;
                        BigInteger bigInteger2 = zzpx.zzb(ellipticCurve);
                        int n3 = ((byte[])object2).length;
                        if (n3 != n2 + 1) {
                            object = new GeneralSecurityException("compressed point has wrong length");
                            throw object;
                        }
                        n = object2[0];
                        if (n == 2) {
                            n = 0;
                        } else {
                            if (n != 3) break;
                            n = 1;
                        }
                        if ((bigInteger = new BigInteger(1, Arrays.copyOfRange(object2, 1, n3))).signum() == -1 || bigInteger.compareTo(bigInteger2) >= 0) {
                            object = new GeneralSecurityException("x is out of range");
                            throw object;
                        }
                        object3 = zzpx.zzc(bigInteger, n != 0, ellipticCurve);
                        ECPoint eCPoint = new ECPoint(bigInteger, (BigInteger)object3);
                        object3 = eCPoint;
                        break block11;
                    }
                    case 2: {
                        n = ((byte[])object2).length;
                        if (n != n2 + n2) {
                            object = new GeneralSecurityException("invalid point size");
                            throw object;
                        }
                        BigInteger bigInteger = new BigInteger(1, Arrays.copyOfRange(object2, 0, n2));
                        BigInteger bigInteger3 = new BigInteger(1, Arrays.copyOfRange(object2, n2, n));
                        object3 = new ECPoint(bigInteger, bigInteger3);
                        zzpx.zze((ECPoint)object3, ellipticCurve);
                        break block11;
                    }
                    case 0: {
                        n = ((byte[])object2).length;
                        if (n != n2 + n2 + 1) {
                            object = new GeneralSecurityException("invalid point size");
                            throw object;
                        }
                        if (object2[0] != 4) {
                            object = new GeneralSecurityException("invalid point format");
                            throw object;
                        }
                        break block12;
                    }
                }
                object = new GeneralSecurityException("invalid format");
                throw object;
            }
            BigInteger bigInteger = new BigInteger(1, Arrays.copyOfRange(object2, 1, ++n2));
            BigInteger bigInteger4 = new BigInteger(1, Arrays.copyOfRange(object2, n2, n));
            object3 = new ECPoint(bigInteger, bigInteger4);
            zzpx.zze((ECPoint)object3, ellipticCurve);
        }
        ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec((ECPoint)object3, (ECParameterSpec)object);
        return (ECPublicKey)((KeyFactory)zzpz.zzg.zza("EC")).generatePublic(eCPublicKeySpec);
    }

    public static ECParameterSpec zzl(int n) throws NoSuchAlgorithmException {
        switch (n + -1) {
            default: {
                return zzpx.zzn("6864797660130609714981900799081393217269435300143305409394463459185543183397656052122559640661454554977296311391480858037121987999716643812574028291115057151", "6864797660130609714981900799081393217269435300143305409394463459185543183397655394245057746333217197532963996371363321113864768612440380340372808892707005449", "051953eb9618e1c9a1f929a21a0b68540eea2da725b99b315f3b8b489918ef109e156193951ec7e937b1652c0bd3bb1bf073573df883d2c34f1ef451fd46b503f00", "c6858e06b70404e9cd9e3ecb662395b4429c648139053fb521f828af606b4d3dbaa14b5e77efe75928fe1dc127a2ffa8de3348b3c1856a429bf97e7e31c2e5bd66", "11839296a789a3bc0045c8a5fb42c7d1bd998f54449579b446817afbd17273e662c97ee72995ef42640c550b9013fad0761353c7086a272c24088be94769fd16650");
            }
            case 0: {
                return zzpx.zzn("115792089210356248762697446949407573530086143415290314195533631308867097853951", "115792089210356248762697446949407573529996955224135760342422259061068512044369", "5ac635d8aa3a93e7b3ebbd55769886bc651d06b0cc53b0f63bce3c3e27d2604b", "6b17d1f2e12c4247f8bce6e563a440f277037d812deb33a0f4a13945d898c296", "4fe342e2fe1a7f9b8ee7eb4a7c0f9e162bce33576b315ececbb6406837bf51f5");
            }
            case 1: 
        }
        return zzpx.zzn("39402006196394479212279040100143613805079739270465446667948293404245721771496870329047266088258938001861606973112319", "39402006196394479212279040100143613805079739270465446667946905279627659399113263569398956308152294913554433653942643", "b3312fa7e23ee7e4988e056be3f82d19181d9c6efe8141120314088f5013875ac656398d8a2ed19d2a85c8edd3ec2aef", "aa87ca22be8b05378eb1c71ef320ad746e1d3b628ba79b9859f741e082542a385502f25dbf55296c3a545e3872760ab7", "3617de4a96262c6f5d9e98bf9292dc29f8f41dbd289a147ce9da3113b5f0b8c00a60b1ce1d7e819d7a431d7c90ea0e5f");
    }

    public static byte[] zzm(int n, int n2, ECPoint object) throws GeneralSecurityException {
        EllipticCurve ellipticCurve = zzpx.zzl(n).getCurve();
        zzpx.zze((ECPoint)object, ellipticCurve);
        int n3 = zzpx.zza(ellipticCurve);
        n2 = n3 + n3 + 1;
        byte[] byArray = new byte[n2];
        byte[] byArray2 = ((ECPoint)object).getAffineX().toByteArray();
        object = ((ECPoint)object).getAffineY().toByteArray();
        int n4 = ((Object)object).length;
        System.arraycopy(object, 0, byArray, n2 - n4, n4);
        n2 = byArray2.length;
        System.arraycopy(byArray2, 0, byArray, n3 + 1 - n2, n2);
        byArray[0] = 4;
        return byArray;
    }
}

