/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ActionCodeUrl {
    private static final Map zza;
    private final String zzb;
    private final String zzc;
    private final String zzd;
    @Nullable
    private final String zze;
    @Nullable
    private final String zzf;
    @Nullable
    private final String zzg;

    public int getOperation() {
        if (zza.containsKey(this.zzd)) {
            return (Integer)zza.get(this.zzd);
        }
        return 3;
    }

    @Nullable
    public static ActionCodeUrl parseLink(@Nullable String link) {
        Preconditions.checkNotEmpty((String)link);
        try {
            String string;
            ActionCodeUrl actionCodeUrl = new ActionCodeUrl(string);
            return actionCodeUrl;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @NonNull
    public String getApiKey() {
        return this.zzb;
    }

    @Nullable
    public String getCode() {
        return this.zzc;
    }

    @Nullable
    public String getContinueUrl() {
        return this.zze;
    }

    @Nullable
    public String getLanguageCode() {
        return this.zzf;
    }

    static {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("recoverEmail", 2);
        hashMap.put("resetPassword", 0);
        hashMap.put("signIn", 4);
        hashMap.put("verifyEmail", 1);
        hashMap.put("verifyBeforeChangeEmail", 5);
        hashMap.put("revertSecondFactorAddition", 6);
        zza = Collections.unmodifiableMap(hashMap);
    }

    private ActionCodeUrl(String objectArray) {
        String string = ActionCodeUrl.zzb((String)objectArray, "apiKey");
        String string2 = ActionCodeUrl.zzb((String)objectArray, "oobCode");
        String string3 = ActionCodeUrl.zzb((String)objectArray, "mode");
        if (string == null || string2 == null || string3 == null) {
            objectArray = new Object[]{"apiKey", "oobCode", "mode"};
            Object object = new IllegalArgumentException(String.format("%s, %s and %s are required in a valid action code URL", objectArray));
            throw object;
        }
        ((ActionCodeUrl)object).zzb = Preconditions.checkNotEmpty((String)string);
        ((ActionCodeUrl)object).zzc = Preconditions.checkNotEmpty((String)string2);
        ((ActionCodeUrl)object).zzd = Preconditions.checkNotEmpty((String)string3);
        ((ActionCodeUrl)object).zze = ActionCodeUrl.zzb((String)objectArray, "continueUrl");
        ((ActionCodeUrl)object).zzf = ActionCodeUrl.zzb((String)objectArray, "languageCode");
        ((ActionCodeUrl)object).zzg = ActionCodeUrl.zzb((String)objectArray, "tenantId");
    }

    @Nullable
    public final String zza() {
        return this.zzg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static String zzb(String string, String string2) {
        Set set;
        block6: {
            string = Uri.parse((String)string);
            set = string.getQueryParameterNames();
            boolean bl = set.contains(string2);
            if (!bl) break block6;
            return string.getQueryParameter(string2);
        }
        boolean bl = set.contains("link");
        if (!bl) return null;
        try {
            return Uri.parse((String)Preconditions.checkNotEmpty((String)string.getQueryParameter("link"))).getQueryParameter(string2);
        }
        catch (NullPointerException | UnsupportedOperationException runtimeException) {
            return null;
        }
    }
}

