/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.TaskExecutors;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.MultiFactorSession;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.PhoneMultiFactorInfo;
import com.google.firebase.auth.internal.zzag;
import com.google.firebase.auth.zzah;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public final class PhoneAuthOptions {
    private final FirebaseAuth zza;
    private Long zzb;
    private PhoneAuthProvider.OnVerificationStateChangedCallbacks zzc;
    private Executor zzd;
    @Nullable
    private String zze;
    private Activity zzf;
    @Nullable
    private PhoneAuthProvider.ForceResendingToken zzg;
    @Nullable
    private MultiFactorSession zzh;
    @Nullable
    private PhoneMultiFactorInfo zzi;
    private boolean zzj;

    @NonNull
    public static Builder newBuilder() {
        Builder builder = new Builder(FirebaseAuth.getInstance());
        return builder;
    }

    @NonNull
    public static Builder newBuilder(@NonNull FirebaseAuth auth) {
        FirebaseAuth firebaseAuth;
        Builder builder = new Builder(firebaseAuth);
        return builder;
    }

    @Nullable
    public final Activity zza() {
        return this.zzf;
    }

    @NonNull
    public final FirebaseAuth zzb() {
        return this.zza;
    }

    @Nullable
    public final MultiFactorSession zzc() {
        return this.zzh;
    }

    @Nullable
    public final PhoneAuthProvider.ForceResendingToken zzd() {
        return this.zzg;
    }

    @NonNull
    public final PhoneAuthProvider.OnVerificationStateChangedCallbacks zze() {
        return this.zzc;
    }

    @Nullable
    public final PhoneMultiFactorInfo zzf() {
        return this.zzi;
    }

    @NonNull
    public final Long zzg() {
        return this.zzb;
    }

    @Nullable
    public final String zzh() {
        return this.zze;
    }

    @NonNull
    public final Executor zzi() {
        return this.zzd;
    }

    /* synthetic */ PhoneAuthOptions(FirebaseAuth firebaseAuth, Long l, PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks, Executor executor, String string, Activity activity, PhoneAuthProvider.ForceResendingToken forceResendingToken, MultiFactorSession multiFactorSession, PhoneMultiFactorInfo phoneMultiFactorInfo, boolean bl, zzah zzah2) {
        this.zza = firebaseAuth;
        this.zze = string;
        this.zzb = l;
        this.zzc = onVerificationStateChangedCallbacks;
        this.zzf = activity;
        this.zzd = executor;
        this.zzg = forceResendingToken;
        this.zzh = multiFactorSession;
        this.zzi = phoneMultiFactorInfo;
        this.zzj = bl;
    }

    public final boolean zzj() {
        return this.zzj;
    }

    public final boolean zzk() {
        return this.zzh != null;
    }

    public static final class Builder {
        private final FirebaseAuth zza;
        private String zzb;
        private Long zzc;
        private PhoneAuthProvider.OnVerificationStateChangedCallbacks zzd;
        private Executor zze;
        private Activity zzf;
        @Nullable
        private PhoneAuthProvider.ForceResendingToken zzg;
        private MultiFactorSession zzh;
        private PhoneMultiFactorInfo zzi;
        private boolean zzj;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder requireSmsValidation(boolean requireSmsValidation) {
            void var1_1;
            this.zzj = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setActivity(@NonNull Activity activity) {
            void var1_1;
            this.zzf = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCallbacks(@NonNull PhoneAuthProvider.OnVerificationStateChangedCallbacks callbacks) {
            void var1_1;
            this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setForceResendingToken(@NonNull PhoneAuthProvider.ForceResendingToken forceResendingToken) {
            void var1_1;
            this.zzg = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setMultiFactorHint(@NonNull PhoneMultiFactorInfo phoneMultiFactorInfo) {
            void var1_1;
            this.zzi = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setMultiFactorSession(@NonNull MultiFactorSession multiFactorSession) {
            void var1_1;
            this.zzh = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setPhoneNumber(@NonNull String phoneNumber) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setTimeout(@NonNull Long timeout, @NonNull TimeUnit unit) {
            void var2_2;
            void var1_1;
            this.zzc = TimeUnit.SECONDS.convert(var1_1.longValue(), (TimeUnit)var2_2);
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NonNull
        public PhoneAuthOptions build() {
            boolean bl;
            Preconditions.checkNotNull((Object)((Builder)this_).zza, (Object)"FirebaseAuth instance cannot be null");
            Preconditions.checkNotNull((Object)((Builder)this_).zzc, (Object)"You must specify an auto-retrieval timeout; please call #setTimeout()");
            Preconditions.checkNotNull((Object)((Builder)this_).zzd, (Object)"You must specify callbacks on your PhoneAuthOptions. Please call #setCallbacks()");
            Preconditions.checkNotNull((Object)((Builder)this_).zzf, (Object)"You must specify an Activity on your PhoneAuthOptions. Please call #setActivity()");
            ((Builder)this_).zze = TaskExecutors.MAIN_THREAD;
            if (((Builder)this_).zzc < 0L || ((Builder)this_).zzc > 120L) {
                Object this_ = new IllegalArgumentException("We only support 0-120 seconds for sms-auto-retrieval timeout");
                throw this_;
            }
            MultiFactorSession multiFactorSession = ((Builder)this_).zzh;
            if (multiFactorSession == null) {
                Preconditions.checkNotEmpty((String)((Builder)this_).zzb, (Object)"The given phoneNumber is empty. Please set a non-empty phone number with #setPhoneNumber()");
                Preconditions.checkArgument((boolean)(((Builder)this_).zzj ^ true), (Object)"You cannot require sms validation without setting a multi-factor session.");
                bl = ((Builder)this_).zzi == null;
                Preconditions.checkArgument((boolean)bl, (Object)"A phoneMultiFactorInfo must be set for second factor sign-in.");
                return new PhoneAuthOptions(((Builder)this_).zza, ((Builder)this_).zzc, ((Builder)this_).zzd, ((Builder)this_).zze, ((Builder)this_).zzb, ((Builder)this_).zzf, ((Builder)this_).zzg, ((Builder)this_).zzh, ((Builder)this_).zzi, ((Builder)this_).zzj, null);
            } else if (((zzag)multiFactorSession).zze()) {
                Preconditions.checkNotEmpty((String)((Builder)this_).zzb);
                bl = ((Builder)this_).zzi == null;
                Preconditions.checkArgument((boolean)bl, (Object)"Invalid MultiFactorSession - use the getSession method in MultiFactorResolver to get a valid sign-in session.");
                return new PhoneAuthOptions(((Builder)this_).zza, ((Builder)this_).zzc, ((Builder)this_).zzd, ((Builder)this_).zze, ((Builder)this_).zzb, ((Builder)this_).zzf, ((Builder)this_).zzg, ((Builder)this_).zzh, ((Builder)this_).zzi, ((Builder)this_).zzj, null);
            } else {
                bl = ((Builder)this_).zzi != null;
                Preconditions.checkArgument((boolean)bl, (Object)"A phoneMultiFactorInfo must be set for second factor sign-in.");
                bl = ((Builder)this_).zzb == null;
                Preconditions.checkArgument((boolean)bl, (Object)"A phone number must not be set for MFA sign-in. A PhoneMultiFactorInfo should be set instead.");
            }
            return new PhoneAuthOptions(((Builder)this_).zza, ((Builder)this_).zzc, ((Builder)this_).zzd, ((Builder)this_).zze, ((Builder)this_).zzb, ((Builder)this_).zzf, ((Builder)this_).zzg, ((Builder)this_).zzh, ((Builder)this_).zzi, ((Builder)this_).zzj, null);
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull FirebaseAuth auth) {
            void var1_1;
            this.zza = (FirebaseAuth)Preconditions.checkNotNull((Object)var1_1);
        }
    }
}

