/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase-auth-api.zzaas;
import com.google.android.gms.internal.firebase-auth-api.zzaat;
import com.google.android.gms.internal.firebase-auth-api.zzaau;
import com.google.android.gms.internal.firebase-auth-api.zzaax;
import com.google.android.gms.internal.firebase-auth-api.zzabo;
import com.google.android.gms.internal.firebase-auth-api.zzabq;
import com.google.android.gms.internal.firebase-auth-api.zzyl;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import org.json.JSONException;

public final class zzabr {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void zzc(HttpURLConnection httpURLConnection, zzabo zzabo2, Type type) {
        int n = httpURLConnection.getResponseCode();
        boolean bl = zzabr.zzd(n);
        Object object = bl ? httpURLConnection.getInputStream() : httpURLConnection.getErrorStream();
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object, "UTF-8"));
        while ((object = bufferedReader.readLine()) != null) {
            stringBuilder.append((String)object);
        }
        catch (Throwable throwable) {
            bufferedReader.close();
            try {
                throw throwable;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                zzabo2.zza("TIMEOUT");
                httpURLConnection.disconnect();
                return;
                {
                    catch (Throwable throwable2) {
                        httpURLConnection.disconnect();
                        throw throwable2;
                    }
                }
                catch (zzyl | IOException exception) {
                    zzabo2.zza(exception.getMessage());
                    httpURLConnection.disconnect();
                    return;
                }
            }
            catch (Throwable throwable3) {
                zzabq.zza(throwable, throwable3);
                throw throwable;
            }
        }
        {
            block15: {
                bufferedReader.close();
                object = stringBuilder.toString();
                n = zzabr.zzd(n) ? 1 : 0;
                if (n == 0) {
                    zzabo2.zza((String)zzaas.zza((String)object, String.class));
                    break block15;
                }
                zzabo2.zzb((zzaau)zzaas.zza((String)object, type));
            }
            httpURLConnection.disconnect();
            return;
        }
    }

    public static void zza(String string, zzabo zzabo2, Type type, zzaax zzaax2) {
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
            httpURLConnection.setConnectTimeout(60000);
            zzaax2.zza(httpURLConnection);
            zzabr.zzc(httpURLConnection, zzabo2, type);
            return;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            zzabo2.zza("TIMEOUT");
            return;
        }
        catch (UnknownHostException unknownHostException) {
            zzabo2.zza("<<Network Error>>");
            return;
        }
        catch (IOException iOException) {
            zzabo2.zza(iOException.getMessage());
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void zzb(String object, zzaat object2, zzabo zzabo2, Type type, zzaax object3) {
        Preconditions.checkNotNull((Object)object2);
        object = (HttpURLConnection)new URL((String)object).openConnection();
        ((URLConnection)object).setDoOutput(true);
        object2 = object2.zza().getBytes(Charset.defaultCharset());
        int n = ((Object)object2).length;
        ((HttpURLConnection)object).setFixedLengthStreamingMode(n);
        ((URLConnection)object).setRequestProperty("Content-Type", "application/json");
        ((URLConnection)object).setConnectTimeout(60000);
        ((zzaax)object3).zza((URLConnection)object);
        OutputStream outputStream = ((URLConnection)object).getOutputStream();
        object3 = new BufferedOutputStream(outputStream, n);
        try {
            ((OutputStream)object3).write((byte[])object2, 0, n);
        }
        catch (Throwable throwable) {
            try {
                ((OutputStream)object3).close();
            }
            catch (Throwable throwable2) {
                zzabq.zza(throwable, throwable2);
                throw throwable;
            }
            try {
                throw throwable;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                zzabo2.zza("TIMEOUT");
                return;
            }
            catch (UnknownHostException unknownHostException) {
                zzabo2.zza("<<Network Error>>");
                return;
            }
            catch (IOException | NullPointerException | JSONException throwable3) {
                zzabo2.zza(throwable3.getMessage());
                return;
            }
        }
        ((OutputStream)object3).close();
        zzabr.zzc((HttpURLConnection)object, zzabo2, type);
    }

    private static final boolean zzd(int n) {
        return n >= 200 && n < 300;
    }
}

