/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import android.util.Base64;
import androidx.annotation.NonNull;
import com.google.android.gms.auth.api.phone.SmsRetriever;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.logging.Logger;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.firebase-auth-api.zzaah;
import com.google.android.gms.internal.firebase-auth-api.zzaby;
import com.google.android.gms.internal.firebase-auth-api.zzabz;
import com.google.android.gms.internal.firebase-auth-api.zzacb;
import com.google.android.gms.internal.firebase-auth-api.zzacc;
import com.google.android.gms.internal.firebase-auth-api.zzag;
import com.google.android.gms.internal.firebase-auth-api.zzb;
import com.google.android.gms.internal.firebase-auth-api.zzf;
import com.google.android.gms.internal.firebase-auth-api.zzo;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.firebase.auth.PhoneAuthCredential;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

final class zzacd {
    private static final Logger zza;
    private final Context zzb;
    private final ScheduledExecutorService zzc;
    private final HashMap zzd = new HashMap();

    static /* bridge */ /* synthetic */ Logger zza() {
        return zza;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final String zzb() {
        try {
            void var0_2;
            String string;
            String string2 = this.zzb.getPackageName();
            int n = Build.VERSION.SDK_INT;
            if (n < 28) {
                Signature[] signatureArray = Wrappers.packageManager((Context)this.zzb).getPackageInfo((String)string2, (int)64).signatures;
            } else {
                Signature[] signatureArray = Wrappers.packageManager((Context)this.zzb).getPackageInfo((String)string2, (int)0x8000000).signingInfo.getApkContentsSigners();
            }
            if ((string = zzacd.zzl(string2, var0_2[0].toCharsString())) != null) {
                return string;
            }
            zza.e("Hash generation failed.", new Object[0]);
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Object[] objectArray = new Object[]{};
            zza.e("Unable to find package to obtain hash.", objectArray);
            return null;
        }
    }

    private static String zzl(String string, String object) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(" ");
        stringBuilder.append((String)object);
        object = stringBuilder.toString();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(object.getBytes(zzo.zzc));
            object = Base64.encodeToString((byte[])Arrays.copyOf(messageDigest.digest(), 9), (int)3).substring(0, 11);
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append("Package: ");
            stringBuilder2.append(string);
            stringBuilder2.append(" -- Hash: ");
            stringBuilder2.append((String)object);
            zza.d(stringBuilder2.toString(), new Object[0]);
            return object;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            String string2 = String.valueOf(noSuchAlgorithmException.getMessage());
            object = new Object[]{};
            zza.e("NoSuchAlgorithm: ".concat(string2), object);
            return null;
        }
    }

    static /* bridge */ /* synthetic */ HashMap zzc(zzacd zzacd2) {
        return zzacd2.zzd;
    }

    static /* bridge */ /* synthetic */ void zzd(zzacd object, String object2) {
        object = (zzacc)((zzacd)object).zzd.get(object2);
        if (object == null || zzag.zzd(((zzacc)object).zzd) || zzag.zzd(((zzacc)object).zze) || ((zzacc)object).zzb.isEmpty()) {
            return;
        }
        object2 = ((zzacc)object).zzb.iterator();
        while (object2.hasNext()) {
            ((zzaah)object2.next()).zzq(PhoneAuthCredential.zzc(((zzacc)object).zzd, ((zzacc)object).zze));
        }
        ((zzacc)object).zzh = true;
    }

    static /* bridge */ /* synthetic */ void zze(zzacd zzacd2, String string) {
        zzacd2.zzm(string);
    }

    static /* bridge */ /* synthetic */ void zzf(zzacd zzacd2, String string) {
        zzacd2.zzn(string);
    }

    static {
        String string = "SmsRetrieverHelper";
        String[] stringArray = new String[]{string};
        zza = new Logger("FirebaseAuth", stringArray);
    }

    @SuppressLint(value={"ThreadPoolCreation"})
    zzacd(@NonNull Context context) {
        this.zzb = (Context)Preconditions.checkNotNull((Object)context);
        zzf.zza();
        this.zzc = Executors.unconfigurableScheduledExecutorService(Executors.newScheduledThreadPool(1));
    }

    final /* synthetic */ void zzg(String string) {
        this.zzn(string);
    }

    private final void zzm(String object) {
        zzacc zzacc2 = (zzacc)((zzacd)((Object)zzacc2)).zzd.get(object);
        if (zzacc2 == null) {
            return;
        }
        if (!zzacc2.zzh && !zzag.zzd(zzacc2.zzd)) {
            zza.w("Timed out waiting for SMS.", new Object[0]);
            object = zzacc2.zzb.iterator();
            while (object.hasNext()) {
                ((zzaah)object.next()).zza(zzacc2.zzd);
            }
            zzacc2.zzi = true;
            return;
        }
    }

    private final void zzn(String string) {
        zzacc zzacc2 = (zzacc)this.zzd.get(string);
        if (zzacc2 == null) {
            return;
        }
        if (!zzacc2.zzi) {
            this.zzm(string);
        }
        this.zzi(string);
    }

    final void zzh(zzaah zzaah2, String string) {
        zzacc zzacc2 = (zzacc)((zzacd)((Object)zzacc2)).zzd.get(string);
        if (zzacc2 == null) {
            return;
        }
        zzacc2.zzb.add(zzaah2);
        if (zzacc2.zzg) {
            zzaah2.zzb(zzacc2.zzd);
        }
        if (zzacc2.zzh) {
            zzaah2.zzq(PhoneAuthCredential.zzc(zzacc2.zzd, zzacc2.zze));
        }
        if (zzacc2.zzi) {
            zzaah2.zza(zzacc2.zzd);
            return;
        }
    }

    final void zzi(String string) {
        zzacc zzacc2 = (zzacc)this.zzd.get(string);
        if (zzacc2 == null) {
            return;
        }
        ScheduledFuture scheduledFuture = zzacc2.zzf;
        if (scheduledFuture != null && !scheduledFuture.isDone()) {
            zzacc2.zzf.cancel(false);
        }
        zzacc2.zzb.clear();
        this.zzd.remove(string);
    }

    final void zzj(String string, zzaah object, long l, boolean bl) {
        Object[] objectArray;
        objectArray.zzd.put(string, new zzacc(l, bl));
        objectArray.zzh((zzaah)object, string);
        object = (zzacc)objectArray.zzd.get(string);
        long l2 = ((zzacc)object).zza;
        if (l2 <= 0L) {
            objectArray = new Object[]{};
            zza.w("Timeout of 0 specified; SmsRetriever will not start.", objectArray);
            return;
        }
        ((zzacc)object).zzf = objectArray.zzc.schedule(new zzaby((zzacd)objectArray, string), l2, TimeUnit.SECONDS);
        if (!((zzacc)object).zzc) {
            objectArray = new Object[]{};
            zza.w("SMS auto-retrieval unavailable; SmsRetriever will not start.", objectArray);
            return;
        }
        object = new zzacb((zzacd)objectArray, string);
        string = new IntentFilter();
        string.addAction("com.google.android.gms.auth.api.phone.SMS_RETRIEVED");
        com.google.android.gms.internal.firebase-auth-api.zzb.zza(objectArray.zzb.getApplicationContext(), (BroadcastReceiver)object, (IntentFilter)string);
        SmsRetriever.getClient((Context)objectArray.zzb).startSmsRetriever().addOnFailureListener((OnFailureListener)new zzabz((zzacd)objectArray));
    }

    final boolean zzk(String string) {
        return this.zzd.get(string) != null;
    }
}

