/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase-auth-api.zzaea;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzadk {
    @Nullable
    private final String zza;
    @NonNull
    private final String zzb;
    private final String zzc;
    private final long zzd;
    @Nullable
    private final zzaea zze;
    @Nullable
    private String zzf;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long zzh(String string) {
        string = string.replaceAll("\\.[0-9]{0,9}Z$|Z$", ".000Z");
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.getDefault());
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            long l = simpleDateFormat.parse(string).getTime();
            return l;
        }
        catch (ParseException parseException) {
            Log.w((String)"MfaInfo", (String)"Could not parse timestamp as ISOString", (Throwable)parseException);
            return 0L;
        }
    }

    public final long zza() {
        return this.zzd;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static zzadk zzb(@NonNull JSONObject jSONObject) {
        void var1_3;
        String string = "displayName";
        String string2 = "mfaEnrollmentId";
        String string3 = "phoneInfo";
        JSONObject jSONObject2 = jSONObject;
        string3 = jSONObject2.optString(string3, null);
        string2 = jSONObject2.optString(string2, null);
        String string4 = jSONObject2.optString(string, null);
        long l = zzadk.zzh(jSONObject.optString("enrolledAt", ""));
        if (jSONObject.opt("totpInfo") != null) {
            zzaea zzaea2 = new zzaea();
        } else {
            Object var1_4 = null;
        }
        zzadk zzadk2 = new zzadk(string3, string2, string4, l, (zzaea)var1_3);
        zzadk2.zzf = jSONObject.optString("unobfuscatedPhoneInfo");
        return zzadk2;
    }

    @Nullable
    public final zzaea zzc() {
        return this.zze;
    }

    public final String zzd() {
        return this.zzc;
    }

    public final String zze() {
        return this.zzb;
    }

    @Nullable
    public final String zzf() {
        return this.zza;
    }

    public static List zzg(JSONArray jSONArray) throws JSONException {
        if (jSONArray == null || jSONArray.length() == 0) {
            return new ArrayList();
        }
        ArrayList<zzadk> arrayList = new ArrayList<zzadk>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            arrayList.add(zzadk.zzb(jSONArray.getJSONObject(i)));
        }
        return arrayList;
    }

    public zzadk(String string, String string2, String string3, long l, zzaea zzaea2) {
        if (!TextUtils.isEmpty((CharSequence)string) && zzaea2 != null) {
            Log.e((String)"MfaInfo", (String)"Cannot have both MFA phone_info and totp_info");
            throw new IllegalArgumentException("Cannot have both MFA phone_info and totp_info");
        }
        this.zza = string;
        this.zzb = Preconditions.checkNotEmpty((String)string2);
        this.zzc = string3;
        this.zzd = l;
        this.zze = zzaea2;
    }
}

