/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.content.Context;
import android.preference.PreferenceManager;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.internal.firebase-auth-api.zzbb;
import com.google.android.gms.internal.firebase-auth-api.zzbc;
import com.google.android.gms.internal.firebase-auth-api.zzbe;
import com.google.android.gms.internal.firebase-auth-api.zzbs;
import com.google.android.gms.internal.firebase-auth-api.zzbw;
import com.google.android.gms.internal.firebase-auth-api.zzbx;
import com.google.android.gms.internal.firebase-auth-api.zzby;
import com.google.android.gms.internal.firebase-auth-api.zziz;
import com.google.android.gms.internal.firebase-auth-api.zzjb;
import com.google.android.gms.internal.firebase-auth-api.zzjc;
import com.google.android.gms.internal.firebase-auth-api.zzsa;
import java.io.CharConversionException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.ProviderException;
import javax.annotation.concurrent.GuardedBy;

public final class zzix {
    private Context zza = null;
    private String zzb = null;
    private String zzc = null;
    private String zzd = null;
    private zzbb zze = null;
    private zzbs zzf = null;
    @GuardedBy(value="this")
    private zzbx zzg;

    static /* bridge */ /* synthetic */ Context zza(zzix zzix2) {
        return zzix2.zza;
    }

    static /* bridge */ /* synthetic */ zzbb zzb(zzix zzix2) {
        return zzix2.zze;
    }

    /*
     * Loose catch block
     */
    @Nullable
    private final zzbb zzj() throws GeneralSecurityException {
        if (!zziz.zzd()) {
            Log.w((String)zziz.zzc(), (String)"Android Keystore requires at least Android M");
            return null;
        }
        zzjb zzjb2 = new zzjb();
        boolean bl = zzjb.zzc(((zzix)((Object)zzbb2)).zzd);
        zzbb zzbb2 = zzjb2.zza(((zzix)((Object)zzbb2)).zzd);
        return zzbb2;
        catch (GeneralSecurityException | ProviderException exception) {
            Log.w((String)zziz.zzc(), (String)"cannot use Android Keystore, it'll be disabled", (Throwable)exception);
            return null;
        }
        catch (GeneralSecurityException | ProviderException exception) {
            if (!bl) {
                Object[] objectArray = new Object[]{((zzix)((Object)zzbb2)).zzd};
                throw new KeyStoreException(String.format("the master key %s exists but is unusable", objectArray), exception);
            }
            Log.w((String)zziz.zzc(), (String)"cannot use Android Keystore, it'll be disabled", (Throwable)exception);
            return null;
        }
    }

    static /* bridge */ /* synthetic */ zzbx zzc(zzix zzix2) {
        return zzix2.zzg;
    }

    /*
     * Loose catch block
     */
    private final zzbx zzk(byte[] object) throws GeneralSecurityException, IOException {
        zzbx zzbx2;
        block8: {
            ((zzix)((Object)zzbx3)).zze = new zzjb().zza(((zzix)((Object)zzbx3)).zzd);
            zzbx zzbx3 = zzbx.zzf(zzbw.zzh(zzbc.zzc(object), ((zzix)((Object)zzbx3)).zze));
            return zzbx3;
            catch (GeneralSecurityException | ProviderException exception) {
                object = zzix.zzl(object);
                Log.w((String)zziz.zzc(), (String)"cannot use Android Keystore, it'll be disabled", (Throwable)exception);
                return object;
            }
            catch (IOException | GeneralSecurityException exception2) {
                try {
                    zzbx2 = zzix.zzl(object);
                    break block8;
                }
                catch (IOException iOException) {
                    throw exception2;
                }
            }
            {
                catch (IOException iOException) {
                    throw exception;
                }
            }
        }
        return zzbx2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final zzix zzd(zzsa zzsa2) {
        int n;
        String string = zzsa2.zzf();
        byte[] byArray = zzsa2.zze().zzq();
        switch (zzsa2.zzd().ordinal()) {
            case 1: {
                n = 1;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown output prefix type");
            }
            case 2: {
                n = 2;
            }
        }
        this.zzf = zzbs.zze(string, byArray, n);
        return this;
    }

    public final zzix zze(String string) {
        if (!string.startsWith("android-keystore://")) {
            throw new IllegalArgumentException("key URI must start with android-keystore://");
        }
        this.zzd = string;
        return this;
    }

    public final zzix zzf(Context context, String string, String string2) throws IOException {
        if (context == null) {
            throw new IllegalArgumentException("need an Android context");
        }
        this.zza = context;
        this.zzb = "GenericIdpKeyset";
        this.zzc = string2;
        return this;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final synchronized zziz zzg() throws GeneralSecurityException, IOException {
        if (this.zzb == null) {
            throw new IllegalArgumentException("keysetName cannot be null");
        }
        var2_2 = zziz.zzb();
        synchronized (var2_2) {
            block23: {
                block22: {
                    try {
                        block21: {
                            var1_3 = this.zza;
                            var3_5 = this.zzb;
                            var4_7 = this.zzc;
                            if (var3_5 == null) {
                                throw new IllegalArgumentException("keysetName cannot be null");
                            }
                            var1_3 = var1_3.getApplicationContext();
                            var1_3 = var4_7 == null ? PreferenceManager.getDefaultSharedPreferences((Context)var1_3) : var1_3.getSharedPreferences((String)var4_7, 0);
                            var4_7 = var1_3.getString((String)var3_5, null);
                            if (var4_7 != null) break block21;
                            var1_3 = null;
                        }
                        var1_4 = var4_7.length() % 2;
                        if (var1_4 != 0) {
                            throw new IllegalArgumentException("Expected a string of even length");
                        }
                        var5_8 = var4_7.length() / 2;
                        var6_9 = new byte[var5_8];
                        break block22;
lbl26:
                        // 2 sources

                        while (true) {
                            if (var1_3 == null) {
                                var1_3 = this.zzd;
                                if (var1_3 != null) {
                                    this.zze = this.zzj();
                                }
                                if ((var1_3 = this.zzf) == null) {
                                    throw new GeneralSecurityException("cannot read or generate keyset");
                                }
                                var1_3 = zzbx.zze();
                                var1_3.zzc(this.zzf);
                                v0 = var1_3;
                                v0.zzd(v0.zzb().zzd().zzb(0).zza());
                                var3_5 = new zzjc(this.zza, this.zzb, this.zzc);
                                var4_7 = this.zze;
                                if (var4_7 != null) {
                                    var1_3.zzb().zzf((zzby)var3_5, this.zze);
                                } else {
                                    zzbe.zza(var1_3.zzb(), (zzby)var3_5);
                                }
                                this.zzg = var1_3;
                                return new zziz(this, null);
                            } else {
                                var3_5 = this.zzd;
                                this.zzg = var3_5 == null || (var3_6 = zziz.zzd()) == false ? zzix.zzl((byte[])var1_3) : this.zzk((byte[])var1_3);
                            }
                            return new zziz(this, null);
                        }
                    }
                    catch (Throwable var0_1) {
                        break block23;
                    }
                }
                for (var1_4 = 0; var1_4 < var5_8; ++var1_4) {
                    v1 = var1_4;
                    var7_10 = v1 + v1;
                    var8_11 = Character.digit(var4_7.charAt(var7_10), 16);
                    var7_10 = Character.digit(var4_7.charAt(var7_10 + 1), 16);
                    if (var8_11 == -1) throw new IllegalArgumentException("input is not hexadecimal");
                    if (var7_10 == -1) {
                        throw new IllegalArgumentException("input is not hexadecimal");
                    }
                    var6_9[var1_4] = (byte)(var8_11 * 16 + var7_10);
                    continue;
                }
                var1_3 = var6_9;
                ** continue;
                catch (ClassCastException | IllegalArgumentException v2) {
                    throw new CharConversionException(String.format("can't read keyset; the pref value %s is not a valid hex string", new Object[]{var3_5}));
                }
            }
            throw var0_1;
        }
    }

    static /* bridge */ /* synthetic */ String zzh(zzix zzix2) {
        return zzix2.zzb;
    }

    static /* bridge */ /* synthetic */ String zzi(zzix zzix2) {
        return zzix2.zzc;
    }

    private static final zzbx zzl(byte[] byArray) throws GeneralSecurityException, IOException {
        return zzbx.zzf(zzbe.zzb(zzbc.zzc(byArray)));
    }
}

